/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemapping;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class StandardSourceFileRemapping
implements ISourceFileRemapping {
    public String remapSourceFile(String filePath) {
        try {
            Object[] foundElements = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().findSourceElements(filePath);
            if (foundElements.length == 0) {
                ILaunch[] launches;
                Object foundElement = null;
                ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
                ILaunch[] iLaunchArray = launches = launchMgr.getLaunches();
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch launch = iLaunchArray[n2];
                    ISourceLocator locator = launch.getSourceLocator();
                    if (locator instanceof ICSourceLocator || locator instanceof CSourceLookupDirector) {
                        foundElement = locator instanceof ICSourceLocator ? ((ICSourceLocator)locator).findSourceElement(filePath) : ((CSourceLookupDirector)locator).getSourceElement(filePath);
                    }
                    ++n2;
                }
                if (foundElement != null) {
                    foundElements = new Object[]{foundElement};
                }
            }
            if (foundElements.length == 1 && foundElements[0] instanceof LocalFileStorage) {
                LocalFileStorage newLocation = (LocalFileStorage)foundElements[0];
                filePath = newLocation.getFullPath().toOSString();
            }
        }
        catch (CoreException coreException) {}
        return filePath;
    }
}

