/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.cdt.debug.internal.core.ListenerList;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public class CSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private static final NoSourceElement gfNoSource = new NoSourceElement();
    private ListenerList fListeners = new ListenerList(1);

    public String getSourceName(Object object) throws CoreException {
        ICStackFrame frame;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IAdaptable && (frame = (ICStackFrame)((IAdaptable)object).getAdapter(ICStackFrame.class)) != null) {
            String name = frame.getFile();
            return name != null && name.trim().length() > 0 ? name : null;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] foundElements;
        String name = null;
        if (object instanceof IAdaptable) {
            ICStackFrame frame = (ICStackFrame)((IAdaptable)object).getAdapter(ICStackFrame.class);
            if (frame != null && ((name = frame.getFile().trim()) == null || name.length() == 0)) {
                if (object instanceof IDebugElement) {
                    return new Object[]{new CSourceNotFoundElement((IDebugElement)object)};
                }
                return new Object[]{gfNoSource};
            }
        } else if (object instanceof String) {
            name = (String)object;
        }
        if ((foundElements = super.findSourceElements(object)).length == 0 && object instanceof IDebugElement) {
            foundElements = new File(name).exists() ? new AbsolutePathSourceContainer().findSourceElements(name) : new Object[]{new CSourceNotFoundElement((IDebugElement)object)};
        }
        return foundElements;
    }

    public void dispose() {
        this.fListeners.removeAll();
        super.dispose();
    }

    public void addSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISourceLookupChangeListener)listeners[i]).sourceContainersChanged(director);
            ++i;
        }
        super.sourceContainersChanged(director);
    }

    static class NoSourceElement {
        NoSourceElement() {
        }
    }
}

