/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command.factories.win32;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CygwinMIEnvironmentDirectory
extends MIEnvironmentDirectory {
    private static final int BUFFER_SIZE = 1000;

    CygwinMIEnvironmentDirectory(String miVersion, boolean reset, String[] paths) {
        super(miVersion, reset, paths);
        String[] newpaths = new String[paths.length];
        int index = 0;
        block0: while (index < paths.length) {
            int length = 0;
            StringBuffer sb = new StringBuffer(1000);
            int i = index;
            while (i < paths.length) {
                if (length + paths[i].length() < 1000) {
                    length += paths[i].length();
                    newpaths[i] = paths[i];
                    sb.append(paths[i]).append(';');
                    ++length;
                } else {
                    this.convertPath(sb, newpaths, index);
                    index = i;
                    continue block0;
                }
                if (i == paths.length - 1) {
                    this.convertPath(sb, newpaths, index);
                    index = paths.length;
                    continue block0;
                }
                ++i;
            }
        }
        this.setParameters(newpaths);
    }

    private void convertPath(StringBuffer sb, String[] paths, int index) {
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        String result = this.convertPath0(sb.toString());
        StringTokenizer st = new StringTokenizer(result, ":");
        int j = index;
        while (st.hasMoreTokens()) {
            if (j >= paths.length) break;
            paths[j++] = st.nextToken();
        }
    }

    private String convertPath0(String path) {
        String result = path;
        CommandLauncher launcher = new CommandLauncher();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        launcher.execute((IPath)new Path("cygpath"), new String[]{"-p", "-u", path}, new String[0], (IPath)new Path("."));
        if (launcher.waitAndRead((OutputStream)out, (OutputStream)out) == 0) {
            result = out.toString().trim();
        }
        return result;
    }
}

