/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpoints;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.CBreakpointUIContributionFactory;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.model.elements.DebugElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;

public class CEventBreakpointsLabelProviderFactory
implements IAdapterFactory {
    public static final String IMG_OBJS_EVENTBREAKPOINT_ENABLED = "icons/obj16/eventbreakpoint_obj.gif";
    public static final String IMG_OBJS_EVENTBREAKPOINT_DISABLED = "icons/obj16/eventbreakpointd_obj.gif";
    private static ILabelProvider fLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof ICEventBreakpoint) {
                ICBreakpointsUIContribution[] bscs;
                ICEventBreakpoint breakpoint;
                block10: {
                    breakpoint = (ICEventBreakpoint)element;
                    bscs = CBreakpointUIContributionFactory.getInstance().getBreakpointUIContributions((IBreakpoint)breakpoint);
                    if (bscs.length != 0) break block10;
                    return null;
                }
                try {
                    StringBuffer buffer = new StringBuffer("");
                    ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = bscs;
                    int n = bscs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICBreakpointsUIContribution con = iCBreakpointsUIContributionArray[n2];
                        Object attValue = breakpoint.getMarker().getAttribute(con.getId());
                        if (con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id")) {
                            buffer.append(con.getLabelForValue((String)attValue));
                        } else if (attValue != null && attValue.toString().length() > 0) {
                            buffer.append(" [");
                            buffer.append(con.getLabel());
                            buffer.append(": ");
                            if (attValue instanceof String) {
                                buffer.append(con.getLabelForValue((String)attValue));
                            } else {
                                buffer.append(attValue);
                            }
                            buffer.append("]");
                        }
                        ++n2;
                    }
                    CEventBreakpointsLabelProviderFactory.appendIgnoreCount((ICBreakpoint)breakpoint, buffer);
                    CEventBreakpointsLabelProviderFactory.appendCondition((ICBreakpoint)breakpoint, buffer);
                    return buffer.toString();
                }
                catch (CoreException e) {
                    CDebugUIPlugin.log(e);
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            try {
                if (element instanceof ICEventBreakpoint) {
                    ICEventBreakpoint eventBkpt = (ICEventBreakpoint)element;
                    if (eventBkpt.isEnabled()) {
                        return CDebugUIPlugin.getDefault().getImage(CEventBreakpointsLabelProviderFactory.IMG_OBJS_EVENTBREAKPOINT_ENABLED);
                    }
                    return CDebugUIPlugin.getDefault().getImage(CEventBreakpointsLabelProviderFactory.IMG_OBJS_EVENTBREAKPOINT_DISABLED);
                }
            }
            catch (CoreException e) {
                CDebugUIPlugin.log(e);
            }
            return null;
        }
    };
    private static IElementLabelProvider fElementLabelProvider = new DebugElementLabelProvider(){

        protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
            ICEventBreakpoint cp = (ICEventBreakpoint)elementPath.getLastSegment();
            return fLabelProvider.getText((Object)cp);
        }
    };

    protected static StringBuffer appendIgnoreCount(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int ignoreCount = breakpoint.getIgnoreCount();
        if (ignoreCount > 0) {
            label.append(' ');
            label.append(MessageFormat.format(DebugCoreMessages.getString((String)"CDebugUtils.3"), Integer.toString(ignoreCount)));
        }
        return label;
    }

    protected static void appendCondition(ICBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        String condition = breakpoint.getCondition();
        if (condition != null && condition.length() > 0) {
            buffer.append(' ');
            buffer.append(MessageFormat.format(DebugCoreMessages.getString((String)"CDebugUtils.4"), condition));
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType.equals(IElementLabelProvider.class) && adaptableObject instanceof ICEventBreakpoint) {
            return fElementLabelProvider;
        }
        if (adapterType.equals(ILabelProvider.class) && adaptableObject instanceof ICEventBreakpoint) {
            return fLabelProvider;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementLabelProvider.class, ILabelProvider.class};
    }
}

