/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchUtils {
    public static String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.parseArguments(LaunchUtils.getProgramArguments(config));
    }

    public static String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = LaunchUtils.getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    public static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    private static String[] parseArguments(String args) {
        return LaunchUtils.argumentsToArray(args);
    }

    private static String[] argumentsToArray(String line) {
        boolean osWin;
        try {
            osWin = Platform.getOS().equals("win32");
        }
        catch (Exception exception) {
            osWin = false;
        }
        if (osWin) {
            return LaunchUtils.argumentsToArrayWindowsStyle(line);
        }
        return LaunchUtils.argumentsToArrayUnixStyle(line);
    }

    private static String[] argumentsToArrayUnixStyle(String line) {
        if (line == null) {
            line = "";
        }
        char[] array = line.trim().toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            block0 : switch (state) {
                case 0: 
                case 5: {
                    if (Character.isWhitespace(c)) {
                        if (state == 0) break;
                        state = 0;
                        String arg = buffer.toString();
                        buffer = new StringBuilder();
                        aList.add(arg);
                        break;
                    }
                    switch (c) {
                        case '\\': {
                            state = 3;
                            break block0;
                        }
                        case '\'': {
                            state = 4;
                            break block0;
                        }
                        case '\"': {
                            state = 1;
                            break block0;
                        }
                    }
                    state = 5;
                    buffer.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            state = 2;
                            break block0;
                        }
                        case '\"': {
                            state = 5;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 4: {
                    switch (c) {
                        case '\'': {
                            state = 5;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            buffer.append(c);
                            break;
                        }
                        case 'n': {
                            buffer.append("\n");
                            break;
                        }
                        default: {
                            buffer.append('\\');
                            buffer.append(c);
                        }
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    buffer.append(c);
                    state = 5;
                }
            }
            ++i;
        }
        if (state != 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    private static String[] argumentsToArrayWindowsStyle(String line) {
        if (line == null) {
            line = "";
        }
        char[] array = line.trim().toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            block0 : switch (state) {
                case 0: 
                case 5: {
                    if (Character.isWhitespace(c)) {
                        if (state == 0) break;
                        state = 0;
                        String arg = buffer.toString();
                        buffer = new StringBuilder();
                        aList.add(arg);
                        break;
                    }
                    switch (c) {
                        case '\\': {
                            state = 3;
                            break block0;
                        }
                        case '\"': {
                            state = 1;
                            break block0;
                        }
                    }
                    state = 5;
                    buffer.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            state = 2;
                            break block0;
                        }
                        case '\"': {
                            state = 5;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\"': {
                            buffer.append(c);
                            break;
                        }
                        default: {
                            buffer.append('\\');
                            buffer.append(c);
                        }
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    state = 5;
                    switch (c) {
                        case ' ': 
                        case '\"': {
                            buffer.append(c);
                            break block0;
                        }
                    }
                    buffer.append('\\');
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (state != 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }
}

