/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CDataDiscoveredInfoCalculator {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static CDataDiscoveredInfoCalculator fInstance;

    private static HashMap calcExtToExtSetSettingsMap(Map extsSetMap) {
        HashMap result = null;
        for (ExtsSetSettings setting : extsSetMap.values()) {
            result = CDataDiscoveredInfoCalculator.addExtsInfoToMap(setting, result);
        }
        return result;
    }

    private static HashMap addExtsInfoToMap(ExtsSetSettings setting, HashMap map) {
        boolean forceAdd = false;
        String[] exts = setting.fExtsSet.fExts;
        if (map == null) {
            map = new HashMap<String, ExtsSetSettings>();
            forceAdd = true;
        }
        int i = 0;
        while (i < exts.length) {
            String ext = exts[i];
            if (forceAdd || !map.containsKey(ext)) {
                map.put(ext, setting);
            }
            ++i;
        }
        return map;
    }

    private RcSetSettings createRcSetInfo(CConfigurationData data) {
        CFolderData rootData = data.getRootFolderData();
        PathSettingsContainer container = PathSettingsContainer.createRootContainer();
        RcSetSettings rcSet = new RcSetSettings(container, (CResourceData)rootData, false);
        rcSet.internalSetSettingsMap(CDataDiscoveredInfoCalculator.createExtsSetSettingsMap(rootData));
        CResourceData[] rcDatas = data.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            CResourceData rcData = rcDatas[i];
            if (rcData != rootData && this.includeRcDataInCalculation(data, rcData)) {
                IPath path = rcData.getPath();
                RcSetSettings curRcSet = rcSet.createChild(path, rcData, false);
                if (rcData.getType() == 8) {
                    HashMap<ExtsSet, ExtsSetSettings> fileMap = new HashMap<ExtsSet, ExtsSetSettings>(1);
                    ExtsSetSettings fileSetting = CDataDiscoveredInfoCalculator.createExtsSetSettings(path, (CFileData)rcData);
                    fileMap.put(fileSetting.fExtsSet, fileSetting);
                    curRcSet.internalSetSettingsMap(fileMap);
                } else {
                    curRcSet.internalSetSettingsMap(CDataDiscoveredInfoCalculator.createExtsSetSettingsMap((CFolderData)rcData));
                }
            }
            ++i;
        }
        return rcSet;
    }

    protected boolean includeRcDataInCalculation(CConfigurationData cfgData, CResourceData rcData) {
        return true;
    }

    protected CFileData createFileData(CConfigurationData cfgData, IPath path, CFileData base) throws CoreException {
        return cfgData.createFileData(path, base);
    }

    protected CFileData createFileData(CConfigurationData cfgData, IPath path, CFolderData base, CLanguageData langBase) throws CoreException {
        return cfgData.createFileData(path, base, langBase);
    }

    protected CFolderData createFolderData(CConfigurationData cfgData, IPath path, CFolderData base) throws CoreException {
        return cfgData.createFolderData(path, base);
    }

    private RcSetSettings createRcSetSettings(CConfigurationData data, IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 discoveredInfo) {
        RcSetSettings rcSet = this.createRcSetInfo(data);
        Map map = discoveredInfo.getPathInfoMap();
        PathFilePathInfo[] pInfos = CDataDiscoveredInfoCalculator.createOrderedInfo(map);
        CDataDiscoveredInfoCalculator.mapDiscoveredInfo(rcSet, pInfos);
        CDataDiscoveredInfoCalculator.checkRemoveDups(rcSet);
        return rcSet;
    }

    public static IRcSettingInfo createEmptyRcSettingInfo(CFolderData data) {
        return CDataDiscoveredInfoCalculator.createRcSettingInfo(data, PathInfo.EMPTY_INFO);
    }

    public static IRcSettingInfo createRcSettingInfo(CFolderData data, PathInfo info) {
        RcSettingInfo rcInfo = new RcSettingInfo((CResourceData)data);
        CLanguageData[] lDatas = data.getLanguageDatas();
        CDataDiscoveredInfoCalculator.addLanguageInfos(rcInfo, lDatas, info);
        return rcInfo;
    }

    public static IRcSettingInfo createEmptyRcSettingInfo(CFileData data) {
        return CDataDiscoveredInfoCalculator.createRcSettingInfo(data, PathInfo.EMPTY_INFO);
    }

    public static IRcSettingInfo createRcSettingInfo(CFileData data, PathInfo info) {
        RcSettingInfo rcInfo = new RcSettingInfo((CResourceData)data);
        CLanguageData lData = data.getLanguageData();
        if (lData != null) {
            CDataDiscoveredInfoCalculator.addLanguageInfos(rcInfo, new CLanguageData[]{lData}, info);
        }
        return rcInfo;
    }

    private static void addLanguageInfos(RcSettingInfo rcInfo, CLanguageData[] lDatas, PathInfo info) {
        ArrayList<LangSettingInfo> list = rcInfo.fLangInfoList;
        if (list == null) {
            list = new ArrayList<LangSettingInfo>(lDatas.length);
            rcInfo.fLangInfoList = list;
        } else {
            list.ensureCapacity(lDatas.length);
        }
        int i = 0;
        while (i < lDatas.length) {
            list.add(new LangSettingInfo(lDatas[i], info));
            ++i;
        }
    }

    private IRcSettingInfo[] mapFileDiscoveredInfo(IProject project, CConfigurationData data, RcSetSettings rcSet, PathFilePathInfo[] pfpis) {
        ArrayList<RcSettingInfo> list = new ArrayList<RcSettingInfo>(pfpis.length);
        int i = 0;
        while (i < pfpis.length) {
            PathFilePathInfo pfpi = pfpis[i];
            IPath projRelPath = pfpi.fPath;
            PathInfo pInfo = pfpi.fInfo;
            if (!pInfo.isEmpty()) {
                LangSettingInfo lInfo;
                ArrayList<LangSettingInfo> tmpList;
                CLanguageData lData;
                RcSettingInfo rcInfo;
                if (projRelPath.segmentCount() == 0) {
                    CFolderData rootData = (CFolderData)rcSet.fRcData;
                    CLanguageData[] lDatas = rootData.getLanguageDatas();
                    IPath[] incPaths = pInfo.getIncludePaths();
                    IPath[] quotedIncPaths = pInfo.getQuoteIncludePaths();
                    IPath[] incFiles = pInfo.getIncludeFiles();
                    IPath[] macroFiles = pInfo.getMacroFiles();
                    Map symbolMap = pInfo.getSymbols();
                    int kinds = 0;
                    if (incPaths.length != 0 || quotedIncPaths.length != 0) {
                        kinds |= 1;
                    }
                    if (incFiles.length != 0) {
                        kinds |= 2;
                    }
                    if (macroFiles.length != 0) {
                        kinds |= 8;
                    }
                    if (symbolMap.size() != 0) {
                        kinds |= 4;
                    }
                    rcInfo = null;
                    int k = 0;
                    while (k < lDatas.length) {
                        lData = lDatas[k];
                        if ((lData.getSupportedEntryKinds() & kinds) != 0) {
                            if (rcInfo == null) {
                                rcInfo = new RcSettingInfo((CResourceData)rootData);
                                tmpList = new ArrayList(lDatas.length - k);
                                rcInfo.fLangInfoList = tmpList;
                            }
                            lInfo = new LangSettingInfo(lData, pInfo);
                            rcInfo.add(lInfo);
                        }
                        ++k;
                    }
                    if (rcInfo != null) {
                        list.add(rcInfo);
                    }
                } else {
                    CResourceData rcData = rcSet.getChild(projRelPath, false).fRcData;
                    if (!rcData.getPath().equals((Object)projRelPath)) {
                        if (rcData.getType() == 4) {
                            CFolderData foData = (CFolderData)rcData;
                            lData = CDataUtil.findLanguagDataForFile((String)projRelPath.lastSegment(), (IProject)project, (CFolderData)((CFolderData)rcData));
                            try {
                                rcData = this.createFileData(data, projRelPath, foData, lData);
                            }
                            catch (CoreException e) {
                                rcData = null;
                                MakeCorePlugin.log(e);
                            }
                        } else {
                            try {
                                rcData = this.createFileData(data, projRelPath, (CFileData)rcData);
                            }
                            catch (CoreException e) {
                                rcData = null;
                                MakeCorePlugin.log(e);
                            }
                        }
                    }
                    if (rcData != null && (lData = rcData.getType() == 8 ? ((CFileData)rcData).getLanguageData() : CDataUtil.findLanguagDataForFile((String)projRelPath.lastSegment(), (IProject)project, (CFolderData)((CFolderData)rcData))) != null) {
                        rcInfo = new RcSettingInfo(rcData);
                        lInfo = new LangSettingInfo(lData, pInfo);
                        tmpList = new ArrayList<LangSettingInfo>(1);
                        tmpList.add(lInfo);
                        rcInfo.fLangInfoList = tmpList;
                        list.add(rcInfo);
                    }
                }
            }
            ++i;
        }
        return list.toArray(new RcSettingInfo[list.size()]);
    }

    public IRcSettingInfo[] getSettingInfos(IProject project, CConfigurationData data, IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 discoveredInfo, boolean fileDataMode) {
        if (fileDataMode) {
            RcSetSettings rcSettings = this.createRcSetInfo(data);
            PathFilePathInfo[] pInfos = CDataDiscoveredInfoCalculator.createOrderedInfo(discoveredInfo.getPathInfoMap());
            return this.mapFileDiscoveredInfo(project, data, rcSettings, pInfos);
        }
        RcSetSettings settings = this.createRcSetSettings(data, discoveredInfo);
        return this.createInfos(data, settings);
    }

    private IRcSettingInfo[] createInfos(CConfigurationData data, RcSetSettings rootSetting) {
        RcSetSettings[] settings = rootSetting.getChildren(true);
        ArrayList<RcSettingInfo> resultList = new ArrayList<RcSettingInfo>();
        int i = 0;
        while (i < settings.length) {
            block16: {
                RcSettingInfo rcInfo;
                CResourceData rcData;
                RcSetSettings setting;
                block17: {
                    setting = settings[i];
                    rcData = setting.fRcData;
                    if (rcData == null) break block16;
                    if (!setting.fIsDerived) break block17;
                    try {
                        rcData = this.createFolderData(data, rcData, setting);
                    }
                    catch (CoreException e) {
                        rcData = null;
                        MakeCorePlugin.log(e);
                    }
                    if (rcData == null) break block16;
                    setting.updateRcData(rcData, false);
                }
                if (rcData.getType() == 8) {
                    PathInfo pathInfo;
                    ExtsSetSettings extSetting = (ExtsSetSettings)setting.fExtToExtsSetMap.get(CDataDiscoveredInfoCalculator.getFileExt(rcData.getPath()));
                    if (extSetting != null && (pathInfo = extSetting.fMaxMatchInfo) != null) {
                        LangSettingInfo langInfo = new LangSettingInfo(extSetting.fBaseLangData, pathInfo);
                        rcInfo = new RcSettingInfo(rcData);
                        rcInfo.fLangInfoList = new ArrayList(1);
                        rcInfo.fLangInfoList.add(langInfo);
                        resultList.add(rcInfo);
                    }
                } else if (setting.fExtsSetToExtsSetSettingsMap.size() != 0) {
                    rcInfo = new RcSettingInfo(rcData);
                    rcInfo.fLangInfoList = new ArrayList(setting.fExtsSetToExtsSetSettingsMap.size());
                    resultList.add(rcInfo);
                    for (ExtsSetSettings extSetting : setting.fExtsSetToExtsSetSettingsMap.values()) {
                        if (extSetting.fMaxMatchInfo == null || extSetting.fBaseLangData == null) continue;
                        if (extSetting.fIsDerived) {
                            throw new IllegalStateException();
                        }
                        rcInfo.add(new LangSettingInfo(extSetting.fBaseLangData, extSetting.fMaxMatchInfo));
                        if (!extSetting.isMultiple()) continue;
                        for (Map.Entry entry : extSetting.fPathFilePathInfoMap.entrySet()) {
                            if (entry.getKey().equals(extSetting.fMaxMatchInfo)) continue;
                            List piList = (List)entry.getValue();
                            int sz = piList.size();
                            int k = 0;
                            while (k < sz) {
                                PathFilePathInfo pi = (PathFilePathInfo)piList.get(k);
                                try {
                                    CFileData fiData = this.createFileData(data, pi.fPath, (CFolderData)rcData, extSetting.fBaseLangData);
                                    CLanguageData fiLangData = fiData.getLanguageData();
                                    if (fiLangData != null) {
                                        RcSettingInfo fiInfo = new RcSettingInfo((CResourceData)fiData);
                                        fiInfo.add(new LangSettingInfo(fiLangData, pi.fInfo));
                                        resultList.add(fiInfo);
                                    }
                                }
                                catch (CoreException e) {
                                    MakeCorePlugin.log(e);
                                }
                                ++k;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return resultList.toArray(new RcSettingInfo[resultList.size()]);
    }

    private CFolderData createFolderData(CConfigurationData cfg, CResourceData base, RcSetSettings setting) throws CoreException {
        if (base.getType() == 4) {
            return this.createFolderData(cfg, setting.getPath(), (CFolderData)base);
        }
        throw new IllegalStateException();
    }

    private static void checkRemoveDups(RcSetSettings rcSet) {
        RcSetSettings[] settings = rcSet.getChildren(true);
        int i = 0;
        while (i < settings.length) {
            RcSetSettings parent;
            RcSetSettings setting = settings[i];
            if (setting.fIsDerived && (parent = setting.getParent()) != null && parent.containsEqualMaxMatches(setting, true)) {
                CDataDiscoveredInfoCalculator.removeChildAddingChildSettings(parent, setting);
            }
            ++i;
        }
    }

    private static void removeChildAddingChildSettings(RcSetSettings parent, RcSetSettings child) {
        parent.internalAddSettingsMap(child.fExtsSetToExtsSetSettingsMap);
        parent.removeChild(child);
    }

    private static void mapDiscoveredInfo(RcSetSettings rcSet, PathFilePathInfo[] pInfos) {
        int i = 0;
        while (i < pInfos.length) {
            IPath dirPath;
            PathFilePathInfo pInfo = pInfos[i];
            RcSetSettings child = rcSet.getChild(pInfo.fPath);
            if (child == null && (child = rcSet.getChild(dirPath = pInfo.fPath.removeLastSegments(1))) == null && (child = rcSet.createChild(dirPath, null, true)).fExtToExtsSetMap == null) {
                RcSetSettings parent = child.getParent();
                child.fRcData = parent.fRcData;
                child.internalSetSettingsMap(CDataDiscoveredInfoCalculator.createEmptyExtSetMapCopy(parent.fExtsSetToExtsSetSettingsMap));
            }
            if (pInfo.fPath.segmentCount() == 0) {
                CDataDiscoveredInfoCalculator.processProjectPaths(child, pInfo);
            } else {
                String ext = CDataDiscoveredInfoCalculator.getFileExt(pInfo.fPath);
                ExtsSetSettings extsSet = (ExtsSetSettings)child.fExtToExtsSetMap.get(ext);
                if (extsSet == null) {
                    extsSet = new ExtsSetSettings(null, new ExtsSet(new String[]{ext}), false);
                    child.internalAdd(extsSet);
                }
                extsSet.add(pInfo);
            }
            ++i;
        }
    }

    private static void processProjectPaths(RcSetSettings rcSet, PathFilePathInfo pfpi) {
        for (ExtsSetSettings setting : rcSet.fExtsSetToExtsSetSettingsMap.values()) {
            setting.add(pfpi);
        }
    }

    private static String getFileExt(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null) {
            return ext;
        }
        return "";
    }

    private static HashMap createEmptyExtSetMapCopy(HashMap base) {
        HashMap map = (HashMap)base.clone();
        for (Map.Entry entry : map.entrySet()) {
            ExtsSetSettings extsSet = (ExtsSetSettings)entry.getValue();
            extsSet = new ExtsSetSettings(extsSet.fBaseLangData, extsSet.fExtsSet, true);
            entry.setValue(extsSet);
        }
        return map;
    }

    private static ExtsSetSettings createExtsSetSettings(IPath path, CFileData data) {
        CLanguageData lData = data.getLanguageData();
        if (lData != null) {
            String ext = CDataDiscoveredInfoCalculator.getFileExt(path);
            return CDataDiscoveredInfoCalculator.createExtsSetSettings(lData, new String[]{ext});
        }
        return new ExtsSetSettings(null, new ExtsSet(EMPTY_STRING_ARRAY), false);
    }

    private static ExtsSetSettings createExtsSetSettings(CLanguageData lData, String[] exts) {
        return new ExtsSetSettings(lData, new ExtsSet(exts), false);
    }

    private static HashMap createExtsSetSettingsMap(CFolderData data) {
        CLanguageData[] lDatas = data.getLanguageDatas();
        HashMap<ExtsSet, ExtsSetSettings> map = new HashMap<ExtsSet, ExtsSetSettings>(lDatas.length);
        if (lDatas.length != 0) {
            int i = 0;
            while (i < lDatas.length) {
                CLanguageData lData = lDatas[i];
                ExtsSetSettings settings = CDataDiscoveredInfoCalculator.createExtsSetSettings(lData, lData.getSourceExtensions());
                map.put(settings.fExtsSet, settings);
                ++i;
            }
        }
        return map;
    }

    private static PathFilePathInfo[] createOrderedInfo(Map map) {
        ListIndexStore store = new ListIndexStore(10);
        HashMap<PathInfo, PathInfo> infoMap = new HashMap<PathInfo, PathInfo>();
        for (Map.Entry entry : map.entrySet()) {
            IResource rc = (IResource)entry.getKey();
            IPath path = rc.getProjectRelativePath();
            int segCount = path.segmentCount();
            PathInfo info = (PathInfo)entry.getValue();
            PathInfo storedInfo = (PathInfo)infoMap.get(info);
            if (storedInfo == null) {
                storedInfo = info;
                infoMap.put(storedInfo, storedInfo);
            }
            store.add(segCount, new PathFilePathInfo(path, storedInfo));
        }
        List[] lists = store.getLists();
        int size = 0;
        int i = 0;
        while (i < lists.length) {
            size += lists[i].size();
            ++i;
        }
        PathFilePathInfo[] infos = new PathFilePathInfo[size];
        int num = 0;
        int i2 = 0;
        while (i2 < lists.length) {
            List list = lists[i2];
            int listSize = list.size();
            int k = 0;
            while (k < listSize) {
                infos[num++] = (PathFilePathInfo)list.get(k);
                ++k;
            }
            ++i2;
        }
        return infos;
    }

    public static CDataDiscoveredInfoCalculator getDefault() {
        if (fInstance == null) {
            fInstance = new CDataDiscoveredInfoCalculator();
        }
        return fInstance;
    }

    public DiscoveredSettingInfo getSettingInfos(IProject project, CConfigurationData cfgData) {
        InfoContext context = this.createContext(project, cfgData);
        try {
            IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(project, context);
            if (info instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo2) {
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 perFileInfo = (IDiscoveredPathManager.IPerFileDiscoveredPathInfo2)info;
                DiscoveredSettingInfo dsInfo = new DiscoveredSettingInfo(true, this.getSettingInfos(project, cfgData, perFileInfo, true));
                return dsInfo;
            }
            IPath[] includes = info.getIncludePaths();
            Map symbols = info.getSymbols();
            PathInfo pathInfo = new PathInfo(includes, null, symbols, null, null);
            CFolderData rootData = cfgData.getRootFolderData();
            IRcSettingInfo rcInfo = CDataDiscoveredInfoCalculator.createRcSettingInfo(rootData, pathInfo);
            return new DiscoveredSettingInfo(false, new IRcSettingInfo[]{rcInfo});
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
            return new DiscoveredSettingInfo(false, new IRcSettingInfo[0]);
        }
    }

    protected InfoContext createContext(IProject project, CConfigurationData data) {
        return new InfoContext(project, this.idForData((CDataObject)data));
    }

    protected String idForData(CDataObject data) {
        return data.getId();
    }

    public static class DiscoveredSettingInfo {
        private boolean fIsPerFileDiscovery;
        private IRcSettingInfo[] fInfos;

        public DiscoveredSettingInfo(boolean isPerFileDiscovery, IRcSettingInfo[] infos) {
            this.fIsPerFileDiscovery = isPerFileDiscovery;
            this.fInfos = infos;
        }

        public boolean isPerFileDiscovery() {
            return this.fIsPerFileDiscovery;
        }

        public IRcSettingInfo[] getRcSettingInfos() {
            return this.fInfos;
        }
    }

    private static class ExtsSet {
        private String[] fExts;
        private HashSet fExtsSet;
        private int fHash;

        public ExtsSet(String[] exts) {
            this.fExts = exts == null || exts.length == 0 ? EMPTY_STRING_ARRAY : (String[])exts.clone();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExtsSet)) {
                return false;
            }
            ExtsSet other = (ExtsSet)obj;
            if (this.fExts.length != other.fExts.length) {
                return false;
            }
            if (this.fExts.length != 0) {
                HashSet set = (HashSet)this.calcExtsSet().clone();
                set.removeAll(other.calcExtsSet());
                if (set.size() != 0) {
                    return false;
                }
            }
            return true;
        }

        public String[] getExtensions() {
            return (String[])this.fExts.clone();
        }

        public int hashCode() {
            int hash = this.fHash;
            if (hash == 0) {
                hash = 47;
                int i = 0;
                while (i < this.fExts.length) {
                    hash += this.fExts[i].hashCode();
                    ++i;
                }
                this.fHash = hash;
            }
            return hash;
        }

        private HashSet calcExtsSet() {
            if (this.fExtsSet == null) {
                this.fExtsSet = new HashSet(Arrays.asList(this.fExts));
            }
            return this.fExtsSet;
        }

        public String toString() {
            if (this.fExts.length == 0) {
                return "<empty>";
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fExts.length) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.fExts[i]);
                ++i;
            }
            return buf.toString();
        }
    }

    private static class ExtsSetSettings {
        private ExtsSet fExtsSet;
        Map fPathFilePathInfoMap;
        CLanguageData fBaseLangData;
        boolean fIsDerived;
        private PathInfo fMaxMatchInfo;
        private List fMaxMatchInfoList;
        private int fHash;

        public ExtsSetSettings(CLanguageData baseLangData, ExtsSet extsSet, boolean isDerived) {
            this.fExtsSet = extsSet;
            this.fBaseLangData = baseLangData;
            this.fIsDerived = isDerived;
        }

        void add(ExtsSetSettings setting) {
            if (setting.fPathFilePathInfoMap != null) {
                for (List list : setting.fPathFilePathInfoMap.values()) {
                    int size = list.size();
                    int i = 0;
                    while (i < size) {
                        this.add((PathFilePathInfo)list.get(i));
                        ++i;
                    }
                }
            }
        }

        void updateLangData(CLanguageData lData, boolean isDerived) {
            this.fBaseLangData = lData;
            this.fIsDerived = lData != null ? isDerived : false;
        }

        public void add(PathFilePathInfo pInfo) {
            PathInfo fileInfo;
            ArrayList<PathFilePathInfo> list;
            if (this.fPathFilePathInfoMap == null) {
                this.fPathFilePathInfoMap = new HashMap(3);
            }
            List<PathFilePathInfo> list2 = list = (fileInfo = pInfo.fInfo) == this.fMaxMatchInfo ? this.fMaxMatchInfoList : (List)this.fPathFilePathInfoMap.get(fileInfo);
            if (list == null) {
                list = new ArrayList<PathFilePathInfo>();
                this.fPathFilePathInfoMap.put(fileInfo, list);
                if (this.fMaxMatchInfo == null) {
                    this.fMaxMatchInfo = fileInfo;
                    this.fMaxMatchInfoList = list;
                }
            } else if (this.fMaxMatchInfoList != list && this.fMaxMatchInfoList.size() == list.size()) {
                this.fMaxMatchInfoList = list;
                this.fMaxMatchInfo = fileInfo;
            }
            list.add(pInfo);
        }

        public boolean isMultiple() {
            return this.fPathFilePathInfoMap != null && this.fPathFilePathInfoMap.size() > 1;
        }

        public PathInfo getMaxMatchPathInfo() {
            return this.fMaxMatchInfo;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.isMultiple()) {
                return false;
            }
            if (!(obj instanceof ExtsSetSettings)) {
                return false;
            }
            ExtsSetSettings other = (ExtsSetSettings)obj;
            if (other.isMultiple()) {
                return false;
            }
            if (!this.fExtsSet.equals(other.fExtsSet)) {
                return false;
            }
            return CDataUtil.objectsEqual((Object)this.fMaxMatchInfo, (Object)other.fMaxMatchInfo);
        }

        public int hashCode() {
            int hash = this.fHash;
            if (hash == 0) {
                if (this.isMultiple()) {
                    hash = super.hashCode();
                } else {
                    hash = this.fExtsSet.hashCode();
                    if (this.fMaxMatchInfo != null) {
                        hash += this.fMaxMatchInfo.hashCode();
                    }
                }
                this.fHash = hash;
            }
            return hash;
        }
    }

    public static interface ILangSettingInfo {
        public CLanguageData getLanguageData();

        public PathInfo getFilePathInfo();
    }

    public static interface IRcSettingInfo {
        public CResourceData getResourceData();

        public ILangSettingInfo[] getLangInfos();
    }

    private static class LangSettingInfo
    implements ILangSettingInfo {
        private CLanguageData fLangData;
        private PathInfo fPathInfo;

        LangSettingInfo(CLanguageData langData, PathInfo info) {
            this.fLangData = langData;
            this.fPathInfo = info;
        }

        public PathInfo getFilePathInfo() {
            return this.fPathInfo;
        }

        public CLanguageData getLanguageData() {
            return this.fLangData;
        }
    }

    private static class ListIndexStore {
        private int fMaxIndex;
        private List[] fStore;

        public ListIndexStore(int size) {
            if (size < 0) {
                size = 0;
            }
            this.fStore = new List[size];
        }

        public void add(int index, Object value) {
            List<Object> list;
            List list2 = list = this.checkResize(index) ? new ArrayList() : this.fStore[index];
            if (list == null) {
                this.fStore[index] = list = new ArrayList();
            }
            if (this.fMaxIndex < index) {
                this.fMaxIndex = index;
            }
            list.add(value);
        }

        private boolean checkResize(int index) {
            if (index >= this.fStore.length) {
                int newSize = ++index;
                List[] resized = new List[newSize];
                if (this.fStore != null && this.fStore.length != 0) {
                    System.arraycopy(this.fStore, 0, resized, 0, this.fStore.length);
                }
                this.fStore = resized;
                return true;
            }
            return false;
        }

        public List[] getLists() {
            int size = this.fMaxIndex + 1;
            ArrayList<List> list = new ArrayList<List>(size);
            int i = 0;
            while (i < size) {
                List l = this.fStore[i];
                if (l != null) {
                    list.add(l);
                }
                ++i;
            }
            return list.toArray(new List[list.size()]);
        }
    }

    private static class PathFilePathInfo {
        IPath fPath;
        PathInfo fInfo;

        PathFilePathInfo(IPath path, PathInfo info) {
            this.fPath = path;
            this.fInfo = info;
        }
    }

    private static class RcSetSettings {
        private CResourceData fRcData;
        private HashMap fExtToExtsSetMap;
        private HashMap fExtsSetToExtsSetSettingsMap;
        private PathSettingsContainer fContainer;
        private boolean fIsDerived;

        RcSetSettings(PathSettingsContainer cr, CResourceData rcData, boolean isDerived) {
            this.fContainer = cr;
            this.fRcData = rcData;
            this.fIsDerived = isDerived;
            cr.setValue((Object)this);
        }

        public RcSetSettings getChild(IPath path, boolean exactPath) {
            PathSettingsContainer cr = this.fContainer.getChildContainer(path, false, exactPath);
            if (cr != null) {
                return (RcSetSettings)cr.getValue();
            }
            return null;
        }

        public RcSetSettings getChild(IPath path) {
            PathSettingsContainer cr = this.fContainer.getChildContainer(path, false, true);
            if (cr != null) {
                return (RcSetSettings)cr.getValue();
            }
            return null;
        }

        public CResourceData getResourceData() {
            return this.fRcData;
        }

        public RcSetSettings createChild(IPath path, CResourceData data, boolean isDerived) {
            PathSettingsContainer cr = this.fContainer.getChildContainer(path, true, true);
            RcSetSettings child = (RcSetSettings)cr.getValue();
            if (child == null) {
                child = new RcSetSettings(cr, data, isDerived);
            }
            return child;
        }

        void updateRcData(CResourceData data, boolean isDerived) {
            this.fRcData = data;
            this.fIsDerived = data != null ? isDerived : false;
            this.updateLangDatas();
        }

        private void updateLangDatas() {
            block7: {
                block6: {
                    if (this.fRcData.getType() != 8) break block6;
                    CLanguageData lData = ((CFileData)this.fRcData).getLanguageData();
                    ExtsSetSettings extSetting = (ExtsSetSettings)this.fExtToExtsSetMap.get(CDataDiscoveredInfoCalculator.getFileExt(this.fRcData.getPath()));
                    if (extSetting != null) {
                        extSetting.fBaseLangData = lData;
                        boolean bl = extSetting.fIsDerived = lData != null ? this.fIsDerived : false;
                    }
                    if (!(extSetting != null ? this.fExtsSetToExtsSetSettingsMap.size() > 1 : this.fExtsSetToExtsSetSettingsMap.size() > 0)) break block7;
                    for (ExtsSetSettings s : this.fExtsSetToExtsSetSettingsMap.values()) {
                        if (s == extSetting) continue;
                        s.fBaseLangData = null;
                        s.fIsDerived = false;
                    }
                    break block7;
                }
                CLanguageData[] lDatas = ((CFolderData)this.fRcData).getLanguageDatas();
                HashMap map = (HashMap)this.fExtsSetToExtsSetSettingsMap.clone();
                int i = 0;
                while (i < lDatas.length) {
                    CLanguageData lData = lDatas[i];
                    ExtsSetSettings extSetting = (ExtsSetSettings)map.remove(new ExtsSet(lData.getSourceExtensions()));
                    if (extSetting != null) {
                        extSetting.fBaseLangData = lData;
                        extSetting.fIsDerived = this.fIsDerived;
                    }
                    ++i;
                }
                if (map.size() != 0) {
                    for (ExtsSetSettings extSetting : map.values()) {
                        extSetting.fBaseLangData = null;
                        extSetting.fIsDerived = false;
                    }
                }
            }
        }

        public IPath getPath() {
            return this.fContainer.getPath();
        }

        public RcSetSettings getParent() {
            PathSettingsContainer cr = this.fContainer.getParentContainer();
            if (cr != null) {
                return (RcSetSettings)cr.getValue();
            }
            return null;
        }

        void internalSetSettingsMap(HashMap map) {
            this.fExtsSetToExtsSetSettingsMap = map;
            this.fExtToExtsSetMap = CDataDiscoveredInfoCalculator.calcExtToExtSetSettingsMap(map);
        }

        void internalAdd(ExtsSetSettings setting) {
            ExtsSetSettings cur;
            if (this.fExtsSetToExtsSetSettingsMap == null) {
                this.fExtsSetToExtsSetSettingsMap = new HashMap();
            }
            if ((cur = (ExtsSetSettings)this.fExtsSetToExtsSetSettingsMap.get(setting.fExtsSet)) != null) {
                cur.add(setting);
            } else {
                this.fExtsSetToExtsSetSettingsMap.put(setting.fExtsSet, setting);
                this.fExtToExtsSetMap = CDataDiscoveredInfoCalculator.addExtsInfoToMap(setting, this.fExtToExtsSetMap);
            }
        }

        void internalAddSettingsMap(HashMap map) {
            for (ExtsSetSettings setting : map.values()) {
                this.internalAdd(setting);
            }
        }

        public boolean settingsEqual(RcSetSettings other) {
            return this.fExtsSetToExtsSetSettingsMap.equals(other.fExtsSetToExtsSetSettingsMap);
        }

        public RcSetSettings[] getChildren(final boolean includeCurrent) {
            final ArrayList list = new ArrayList();
            this.fContainer.accept(new IPathSettingsContainerVisitor(){

                public boolean visit(PathSettingsContainer container) {
                    if (includeCurrent || container != RcSetSettings.this.fContainer) {
                        list.add(container.getValue());
                    }
                    return true;
                }
            });
            return list.toArray(new RcSetSettings[list.size()]);
        }

        public boolean containsEqualMaxMatches(RcSetSettings other, boolean ignoreGenerated) {
            if (!ignoreGenerated && this.fExtsSetToExtsSetSettingsMap.size() < other.fExtsSetToExtsSetSettingsMap.size()) {
                return false;
            }
            for (Map.Entry entry : other.fExtsSetToExtsSetSettingsMap.entrySet()) {
                ExtsSetSettings otherSetting = (ExtsSetSettings)entry.getValue();
                if (ignoreGenerated && otherSetting.fBaseLangData == null) continue;
                ExtsSetSettings thisSetting = (ExtsSetSettings)this.fExtsSetToExtsSetSettingsMap.get(entry.getKey());
                if (thisSetting == null) {
                    return false;
                }
                if (otherSetting.fMaxMatchInfo == null || otherSetting.fMaxMatchInfo.equals(thisSetting.fMaxMatchInfo)) continue;
                return false;
            }
            return true;
        }

        void removeChild(RcSetSettings setting) {
            IPath path = setting.fContainer.getPath();
            IPath thisPath = this.fContainer.getPath();
            if (!thisPath.isPrefixOf(path)) {
                throw new IllegalArgumentException();
            }
            path = path.removeFirstSegments(thisPath.segmentCount());
            this.fContainer.removeChildContainer(path);
        }
    }

    private static class RcSettingInfo
    implements IRcSettingInfo {
        private ArrayList fLangInfoList;
        private CResourceData fRcData;

        RcSettingInfo(CResourceData rcData) {
            this.fRcData = rcData;
        }

        public ILangSettingInfo[] getLangInfos() {
            if (this.fLangInfoList != null && this.fLangInfoList.size() != 0) {
                return this.fLangInfoList.toArray(new ILangSettingInfo[this.fLangInfoList.size()]);
            }
            return new ILangSettingInfo[0];
        }

        public CResourceData getResourceData() {
            return this.fRcData;
        }

        void add(ILangSettingInfo info) {
            if (this.fLangInfoList == null) {
                this.fLangInfoList = new ArrayList();
            }
            this.fLangInfoList.add(info);
        }
    }
}

