/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.internal.core.scannerconfig2.MakeConfigurationDataProviderMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScannerConfigInfoFactory2 {
    private static final String SCANNER_CONFIG = "scannerConfiguration";
    private static final String SC_AUTODISCOVERY = "autodiscovery";
    private static final String ENABLED = "enabled";
    private static final String SELECTED_PROFILE_ID = "selectedProfileId";
    private static final String PROBLEM_REPORTING_ENABLED = "problemReportingEnabled";
    private static final String PROFILE = "profile";
    private static final String ID = "id";
    private static final String BUILD_OUTPUT_PROVIDER = "buildOutputProvider";
    private static final String OPEN_ACTION = "openAction";
    private static final String FILE_PATH = "filePath";
    private static final String PARSER = "parser";
    private static final String SCANNER_INFO_PROVIDER = "scannerInfoProvider";
    private static final String RUN_ACTION = "runAction";
    private static final String USE_DEFAULT = "useDefault";
    private static final String COMMAND = "command";
    private static final String ARGUMENTS = "arguments";
    private static final String DOT = ".";
    private static final String SCD = "SCD.";
    private static final String SCANNER_CONFIG_AUTODISCOVERY_ENABLED_SUFFIX = "enabled";
    private static final String SCANNER_CONFIG_SELECTED_PROFILE_ID_SUFFIX = "selectedProfileId";
    private static final String SCANNER_CONFIG_PROBLEM_REPORTING_ENABLED_SUFFIX = "problemReportingEnabled";
    private static final String BUILD_OUTPUT_OPEN_ACTION_ENABLED = ".BOP.open.enabled";
    private static final String BUILD_OUTPUT_OPEN_ACTION_FILE_PATH = ".BOP.open.path";
    private static final String BUILD_OUTPUT_PARSER_ENABLED = ".BOP.parser.enabled";
    private static final String SI_PROVIDER_RUN_ACTION_USE_DEFAULT = ".run.useDefault";
    private static final String SI_PROVIDER_RUN_ACTION_COMMAND = ".run.command";
    private static final String SI_PROVIDER_RUN_ACTION_ARGUMENTS = ".run.arguments";
    private static final String SI_PROVIDER_OPEN_ACTION_FILE_PATH = ".open.path";
    private static final String SI_PROVIDER_PARSER_ENABLED = ".parser.enabled";
    private static final String INFO_INSTANCE_IDS = "SCD.instanceIds";
    private static final String DELIMITER = ";";
    private static final String ELEMENT_CS_INFO = "scannerConfigBuildInfo";
    private static final String ATTRIBUTE_CS_INFO_INSTANCE_ID = "instanceId";

    public static IScannerConfigBuilderInfo2 create(IProject project, String profileId) throws CoreException {
        IScannerConfigBuilderInfo2Set container = ScannerConfigInfoFactory2.createInfoSet(project, profileId);
        return container.getInfo(new InfoContext(project));
    }

    public static IScannerConfigBuilderInfo2 create(Preferences prefs, String profileId, boolean useDefaults) {
        IScannerConfigBuilderInfo2Set container = ScannerConfigInfoFactory2.createInfoSet(prefs, profileId, useDefaults);
        return container.getInfo(new InfoContext(null));
    }

    public static IScannerConfigBuilderInfo2Set createInfoSet(Preferences prefs, String profileId, boolean useDefaults) {
        return new PreferenceSet(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2Set createInfoSet(IProject project, String profileId) {
        return new ScannerConfigInfoSet(project, profileId);
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private InfoContext context;
        private String profileId;
        private ScannerConfigInfoSet container;

        BuildProperty(ScannerConfigInfoSet container, IProject project, InfoContext context, String profileId, Element element) {
            this.project = project;
            this.context = context;
            this.profileId = profileId;
            this.container = container;
            this.load(element);
        }

        BuildProperty(ScannerConfigInfoSet container, IProject project, InfoContext context, Store base, String profileId) {
            super(base, profileId);
            this.project = project;
            this.context = context;
            this.container = container;
            if (!profileId.equals("")) {
                this.profileId = profileId;
            } else if (base instanceof BuildProperty) {
                BuildProperty prop = (BuildProperty)base;
                this.profileId = prop.profileId;
            } else {
                Preference pref = (Preference)base;
                this.profileId = pref.profileId;
            }
        }

        protected void load(Element element) {
            List<String> profileIds = ScannerConfigProfileManager.getInstance().getProfileIds(this.context);
            ArrayList<String> loadedProfiles = new ArrayList<String>();
            Node sc = element.getFirstChild();
            while (sc != null) {
                if (sc.getNodeName().equals(ScannerConfigInfoFactory2.SC_AUTODISCOVERY)) {
                    this.autoDiscoveryEnabled = Boolean.valueOf(((Element)sc).getAttribute("enabled"));
                    this.selectedProfile = this.profileId == "" ? ((Element)sc).getAttribute("selectedProfileId") : this.profileId;
                    this.problemReportingEnabled = Boolean.valueOf(((Element)sc).getAttribute("problemReportingEnabled"));
                } else if (sc.getNodeName().equals(ScannerConfigInfoFactory2.PROFILE) && profileIds.contains(((Element)sc).getAttribute(ScannerConfigInfoFactory2.ID))) {
                    this.load(sc);
                    loadedProfiles.add(((Element)sc).getAttribute(ScannerConfigInfoFactory2.ID));
                }
                sc = sc.getNextSibling();
            }
            if (loadedProfiles.size() < 1) {
                if (this.migrateScannerConfigBuildInfo(ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID)) {
                    loadedProfiles.add(ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID);
                } else {
                    this.autoDiscoveryEnabled = false;
                }
            }
            if (loadedProfiles.size() < profileIds.size()) {
                for (String profileId : profileIds) {
                    if (loadedProfiles.contains(profileId)) continue;
                    this.loadDefaults(profileId);
                    loadedProfiles.add(profileId);
                }
            }
        }

        private void loadDefaults(String profileId) {
            Store.ProfileOptions po = new Store.ProfileOptions();
            po.buildOutputFileActionEnabled = false;
            po.buildOutputParserEnabled = true;
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            po.providerOptionsMap = new LinkedHashMap();
            for (String providerId : configuredProfile.getSIProviderIds()) {
                Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                ScannerConfigProfile.ScannerInfoProvider configuredProvider = configuredProfile.getScannerInfoProviderElement(providerId);
                ppo.providerKind = configuredProvider.getProviderKind();
                ppo.providerOutputParserEnabled = false;
                if (ppo.providerKind.equals("run")) {
                    ppo.providerRunUseDefault = true;
                    ppo.providerRunCommand = configuredProvider.getAction().getAttribute(ScannerConfigInfoFactory2.COMMAND);
                    ppo.providerRunArguments = configuredProvider.getAction().getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                } else if (ppo.providerKind.equals("open")) {
                    ppo.providerOpenFilePath = configuredProvider.getAction().getAttribute("file");
                }
                po.providerOptionsMap.put(providerId, ppo);
            }
            if (this.profileOptionsMap == null) {
                this.profileOptionsMap = new LinkedHashMap();
            }
            this.profileOptionsMap.put(profileId, po);
        }

        private boolean migrateScannerConfigBuildInfo(String profileId) {
            boolean rc = true;
            try {
                IScannerConfigBuilderInfo oldInfo = MakeCorePlugin.createScannerConfigBuildInfo(this.project, ScannerConfigBuilder.BUILDER_ID);
                this.autoDiscoveryEnabled = oldInfo.isAutoDiscoveryEnabled();
                this.problemReportingEnabled = oldInfo.isSIProblemGenerationEnabled();
                this.selectedProfile = profileId;
                Store.ProfileOptions po = new Store.ProfileOptions();
                po.buildOutputFileActionEnabled = false;
                po.buildOutputParserEnabled = oldInfo.isMakeBuilderConsoleParserEnabled();
                Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                ppo.providerKind = "run";
                ppo.providerOutputParserEnabled = oldInfo.isESIProviderCommandEnabled();
                ppo.providerRunUseDefault = oldInfo.isDefaultESIProviderCmd();
                ppo.providerRunCommand = oldInfo.getESIProviderCommand().toString();
                ppo.providerRunArguments = oldInfo.getESIProviderArguments();
                ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(this.selectedProfile);
                String providerId = (String)configuredProfile.getSIProviderIds().get(0);
                po.providerOptionsMap = new LinkedHashMap(1);
                po.providerOptionsMap.put(providerId, ppo);
                this.profileOptionsMap = new LinkedHashMap(1);
                this.profileOptionsMap.put(profileId, po);
                this.isDirty = true;
                this.save();
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                rc = false;
            }
            return rc;
        }

        private void load(Node profile) {
            if (this.profileOptionsMap == null) {
                this.profileOptionsMap = new LinkedHashMap(1);
            }
            Store.ProfileOptions po = new Store.ProfileOptions();
            String profileId = ((Element)profile).getAttribute(ScannerConfigInfoFactory2.ID);
            this.profileOptionsMap.put(profileId, po);
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            List providerIds = configuredProfile.getSIProviderIds();
            int providerCounter = 0;
            po.providerOptionsMap = new LinkedHashMap(providerIds.size());
            Node child = profile.getFirstChild();
            while (child != null) {
                if (ScannerConfigInfoFactory2.BUILD_OUTPUT_PROVIDER.equals(child.getNodeName())) {
                    Node grandchild = child.getFirstChild();
                    while (grandchild != null) {
                        if (ScannerConfigInfoFactory2.OPEN_ACTION.equals(grandchild.getNodeName())) {
                            po.buildOutputFileActionEnabled = Boolean.valueOf(((Element)grandchild).getAttribute("enabled"));
                            po.buildOutputFilePath = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.FILE_PATH);
                        } else if (ScannerConfigInfoFactory2.PARSER.equals(grandchild.getNodeName())) {
                            po.buildOutputParserEnabled = Boolean.valueOf(((Element)grandchild).getAttribute("enabled"));
                        }
                        grandchild = grandchild.getNextSibling();
                    }
                } else if (ScannerConfigInfoFactory2.SCANNER_INFO_PROVIDER.equals(child.getNodeName())) {
                    String providerId = ((Element)child).getAttribute(ScannerConfigInfoFactory2.ID);
                    if (providerIds.get(providerCounter).equals(providerId)) {
                        Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                        po.providerOptionsMap.put(providerId, ppo);
                        ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                        Node grandchild = child.getFirstChild();
                        while (grandchild != null) {
                            if (ScannerConfigInfoFactory2.RUN_ACTION.equals(grandchild.getNodeName())) {
                                ppo.providerRunUseDefault = Boolean.valueOf(((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.USE_DEFAULT));
                                ppo.providerRunCommand = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.COMMAND);
                                ppo.providerRunArguments = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                            } else if (ScannerConfigInfoFactory2.OPEN_ACTION.equals(grandchild.getNodeName())) {
                                ppo.providerOpenFilePath = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.FILE_PATH);
                            } else if (ScannerConfigInfoFactory2.PARSER.equals(grandchild.getNodeName())) {
                                ppo.providerOutputParserEnabled = Boolean.valueOf(((Element)grandchild).getAttribute("enabled"));
                            }
                            grandchild = grandchild.getNextSibling();
                        }
                        ++providerCounter;
                    }
                }
                child = child.getNextSibling();
            }
        }

        private void store(Element sc) {
            Document doc = sc.getOwnerDocument();
            Node child = sc.getFirstChild();
            while (child != null) {
                sc.removeChild(child);
                child = sc.getFirstChild();
            }
            Element autod = doc.createElement(ScannerConfigInfoFactory2.SC_AUTODISCOVERY);
            sc.appendChild(autod);
            autod.setAttribute("enabled", Boolean.toString(this.autoDiscoveryEnabled));
            autod.setAttribute("selectedProfileId", this.selectedProfile);
            autod.setAttribute("problemReportingEnabled", Boolean.toString(this.problemReportingEnabled));
            for (String profileId : this.profileOptionsMap.keySet()) {
                Element profile = doc.createElement(ScannerConfigInfoFactory2.PROFILE);
                profile.setAttribute(ScannerConfigInfoFactory2.ID, profileId);
                this.store(profile, (Store.ProfileOptions)this.profileOptionsMap.get(profileId));
                sc.appendChild(profile);
            }
            this.isDirty = false;
        }

        private void store(Element profile, Store.ProfileOptions po) {
            Document doc = profile.getOwnerDocument();
            Element child = doc.createElement(ScannerConfigInfoFactory2.BUILD_OUTPUT_PROVIDER);
            Element grandchild = doc.createElement(ScannerConfigInfoFactory2.OPEN_ACTION);
            grandchild.setAttribute("enabled", Boolean.toString(po.buildOutputFileActionEnabled));
            if (po.buildOutputFilePath != null) {
                grandchild.setAttribute(ScannerConfigInfoFactory2.FILE_PATH, po.buildOutputFilePath);
            }
            child.appendChild(grandchild);
            grandchild = doc.createElement(ScannerConfigInfoFactory2.PARSER);
            grandchild.setAttribute("enabled", Boolean.toString(po.buildOutputParserEnabled));
            child.appendChild(grandchild);
            profile.appendChild(child);
            ArrayList providerIds = new ArrayList(po.providerOptionsMap.keySet());
            int i = 0;
            while (i < providerIds.size()) {
                String providerId = (String)providerIds.get(i);
                Store.ProfileOptions.ProviderOptions ppo = (Store.ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                if (ppo != null) {
                    child = doc.createElement(ScannerConfigInfoFactory2.SCANNER_INFO_PROVIDER);
                    child.setAttribute(ScannerConfigInfoFactory2.ID, providerId);
                    String providerKind = ppo.providerKind;
                    if (providerKind.equals("run")) {
                        grandchild = doc.createElement(ScannerConfigInfoFactory2.RUN_ACTION);
                        grandchild.setAttribute(ScannerConfigInfoFactory2.USE_DEFAULT, Boolean.toString(ppo.providerRunUseDefault));
                        if (ppo.providerRunCommand != null) {
                            grandchild.setAttribute(ScannerConfigInfoFactory2.COMMAND, ppo.providerRunCommand);
                        }
                        if (ppo.providerRunArguments != null) {
                            grandchild.setAttribute(ScannerConfigInfoFactory2.ARGUMENTS, ppo.providerRunArguments);
                        }
                    } else if (providerKind.equals("open")) {
                        grandchild = doc.createElement(ScannerConfigInfoFactory2.OPEN_ACTION);
                        if (ppo.providerOpenFilePath != null) {
                            grandchild.setAttribute(ScannerConfigInfoFactory2.FILE_PATH, ppo.providerOpenFilePath);
                        }
                    }
                    child.appendChild(grandchild);
                    grandchild = doc.createElement(ScannerConfigInfoFactory2.PARSER);
                    grandchild.setAttribute("enabled", Boolean.toString(ppo.providerOutputParserEnabled));
                    child.appendChild(grandchild);
                    profile.appendChild(child);
                }
                ++i;
            }
        }

        public synchronized void save() throws CoreException {
            if (this.isDirty) {
                this.container.save(true);
                this.isDirty = false;
            }
        }

        public InfoContext getContext() {
            return this.context;
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String profileId;
        private boolean useDefaults;
        private PreferenceSet prefsContainer;
        private InfoContext context;

        public Preference(PreferenceSet container, Preferences prefs, InfoContext context, String profileId, boolean useDefaults) {
            this.prefs = prefs;
            this.profileId = profileId;
            this.useDefaults = useDefaults;
            this.prefsContainer = container;
            this.context = context;
            this.load();
        }

        Preference(PreferenceSet container, Preferences prefs, InfoContext context, Store base, String profileId, boolean useDefaults) {
            super(base, profileId);
            this.prefs = prefs;
            this.prefsContainer = container;
            this.useDefaults = useDefaults;
            this.context = context;
            if (!profileId.equals("")) {
                this.profileId = profileId;
            } else if (base instanceof BuildProperty) {
                BuildProperty prop = (BuildProperty)base;
                this.profileId = prop.profileId;
            } else {
                Preference pref = (Preference)base;
                this.profileId = pref.profileId;
            }
        }

        protected void load() {
            String instanceId = this.context.getInstanceId();
            String prefix = instanceId.length() == 0 ? "" : "instanceId." + instanceId + ScannerConfigInfoFactory2.DOT;
            this.autoDiscoveryEnabled = this.getBoolean(String.valueOf(prefix) + "enabled");
            this.selectedProfile = "".equals(this.profileId) ? this.getString(String.valueOf(prefix) + "selectedProfileId") : this.profileId;
            this.problemReportingEnabled = this.getBoolean(String.valueOf(prefix) + "problemReportingEnabled");
            if ("".equals(this.selectedProfile) && !this.useDefaults) {
                this.selectedProfile = this.prefs.getDefaultString(String.valueOf(prefix) + "selectedProfileId");
            }
            List<String> profileIds = ScannerConfigProfileManager.getInstance().getProfileIds(this.context);
            this.profileOptionsMap = new LinkedHashMap(profileIds.size());
            for (String profileId : profileIds) {
                Store.ProfileOptions po = new Store.ProfileOptions();
                this.profileOptionsMap.put(profileId, po);
                boolean profileStored = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + "enabled");
                if (!profileStored && !this.useDefaults) {
                    this.loadFromProfileConfiguration(po, profileId);
                    continue;
                }
                po.buildOutputFileActionEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_ENABLED);
                po.buildOutputFilePath = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_FILE_PATH);
                po.buildOutputParserEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_PARSER_ENABLED);
                ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
                List providerIds = configuredProfile.getSIProviderIds();
                po.providerOptionsMap = new LinkedHashMap(providerIds.size());
                int i = 0;
                while (i < providerIds.size()) {
                    String providerId = (String)providerIds.get(i);
                    Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                    po.providerOptionsMap.put(providerId, ppo);
                    ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                    ppo.providerOutputParserEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_PARSER_ENABLED);
                    if (ppo.providerKind.equals("run")) {
                        ppo.providerRunUseDefault = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_USE_DEFAULT);
                        ppo.providerRunCommand = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_COMMAND);
                        ppo.providerRunArguments = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_ARGUMENTS);
                    } else if (ppo.providerKind.equals("open")) {
                        ppo.providerOpenFilePath = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_OPEN_ACTION_FILE_PATH);
                    }
                    ++i;
                }
            }
        }

        private void store() {
            String prefix;
            String instanceId = this.context.getInstanceId();
            String string = prefix = instanceId.length() == 0 ? "" : "instanceId." + instanceId + ScannerConfigInfoFactory2.DOT;
            if (this.isDirty) {
                this.set(String.valueOf(prefix) + "enabled", this.autoDiscoveryEnabled);
                this.set(String.valueOf(prefix) + "selectedProfileId", this.selectedProfile);
                this.set(String.valueOf(prefix) + "problemReportingEnabled", this.problemReportingEnabled);
                ArrayList profileIds = new ArrayList(this.profileOptionsMap.keySet());
                for (String profileId : profileIds) {
                    Store.ProfileOptions po = (Store.ProfileOptions)this.profileOptionsMap.get(profileId);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + "enabled", !this.useDefaults);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_ENABLED, po.buildOutputFileActionEnabled);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_FILE_PATH, po.buildOutputFilePath);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_PARSER_ENABLED, po.buildOutputParserEnabled);
                    ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
                    List providerIds = configuredProfile.getSIProviderIds();
                    int i = 0;
                    while (i < providerIds.size()) {
                        String providerId = (String)providerIds.get(i);
                        Store.ProfileOptions.ProviderOptions ppo = (Store.ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                        this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_PARSER_ENABLED, ppo.providerOutputParserEnabled);
                        String providerKind = ppo.providerKind;
                        if (providerKind.equals("run")) {
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_USE_DEFAULT, ppo.providerRunUseDefault);
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_COMMAND, ppo.providerRunCommand);
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_ARGUMENTS, ppo.providerRunArguments);
                        } else if (providerKind.equals("open")) {
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_OPEN_ACTION_FILE_PATH, ppo.providerOpenFilePath);
                        }
                        ++i;
                    }
                }
                this.isDirty = false;
            }
        }

        private boolean getBoolean(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultBoolean(name);
            }
            return this.prefs.getBoolean(name);
        }

        private void set(String name, boolean value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        private String getString(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(name);
            }
            return this.prefs.getString(name);
        }

        private void set(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        public void save() throws CoreException {
            if (this.isDirty) {
                this.prefsContainer.save();
            }
        }

        public InfoContext getContext() {
            return this.context;
        }
    }

    private static class PreferenceSet
    extends StoreSet {
        private Preferences prefs;
        private boolean useDefaults;

        PreferenceSet(Preferences prefs, String profileId, boolean loadDefaults) {
            this.prefs = prefs;
            this.useDefaults = loadDefaults;
            this.load(profileId);
        }

        private void load(String profileId) {
            InfoContext defaultContext = new InfoContext(null);
            String instancesStr = this.getString(ScannerConfigInfoFactory2.INFO_INSTANCE_IDS);
            String[] instanceIds = CDataUtil.stringToArray((String)instancesStr, (String)ScannerConfigInfoFactory2.DELIMITER);
            Preference pref = new Preference(this, this.prefs, defaultContext, profileId, this.useDefaults);
            this.fMap.put(defaultContext, pref);
            if (instanceIds != null && instanceIds.length != 0) {
                int i = 0;
                while (i < instanceIds.length) {
                    String id = instanceIds[i];
                    if (id.length() != 0) {
                        InfoContext c = new InfoContext(null, id);
                        Preference p = new Preference(this, this.prefs, c, profileId, this.useDefaults);
                        this.fMap.put(c, p);
                    }
                    ++i;
                }
            }
        }

        public void save() throws CoreException {
            if (this.isDirty()) {
                HashSet<String> idSet = new HashSet<String>(this.fMap.size() - 1);
                Preference pref = (Preference)this.fMap.get(new InfoContext(null));
                pref.store();
                for (Map.Entry entry : this.fMap.entrySet()) {
                    Preference p;
                    String instanceId;
                    InfoContext context = (InfoContext)entry.getKey();
                    if (context.isDefaultContext() || (instanceId = context.getInstanceId()).length() == 0 || (p = (Preference)entry.getValue()) == pref) continue;
                    p.store();
                    idSet.add(instanceId);
                }
                if (idSet.size() != 0) {
                    String[] ids = idSet.toArray(new String[idSet.size()]);
                    String idsString = CDataUtil.arrayToString((String[])ids, (String)ScannerConfigInfoFactory2.DELIMITER);
                    this.set(ScannerConfigInfoFactory2.INFO_INSTANCE_IDS, idsString);
                }
                this.fIsDirty = false;
            }
        }

        public IProject getProject() {
            return null;
        }

        protected Store doCreateStore(InfoContext context, Store base, String profileId) {
            return new Preference(this, this.prefs, context, base, profileId, this.useDefaults);
        }

        private String getString(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(name);
            }
            return this.prefs.getString(name);
        }

        private void set(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }
    }

    private static class ScannerConfigInfoSet
    extends StoreSet {
        private IProject fProject;

        ScannerConfigInfoSet(IProject project, String profileId) {
            this.fProject = project;
            this.load(profileId);
        }

        private void load(String profileId) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, false);
                Element rootEl = descriptor != null ? descriptor.getProjectData(ScannerConfigInfoFactory2.SCANNER_CONFIG) : null;
                InfoContext defaultContext = new InfoContext(this.fProject);
                if (rootEl == null || !rootEl.hasChildNodes()) {
                    BuildProperty prop = new BuildProperty(this, this.fProject, defaultContext, (Store)ScannerConfigInfoFactory2.create(MakeCorePlugin.getDefault().getPluginPreferences(), profileId, false), profileId);
                    this.fMap.put(defaultContext, prop);
                    prop.isDirty = true;
                } else {
                    BuildProperty prop = new BuildProperty(this, this.fProject, defaultContext, profileId, rootEl);
                    this.fMap.put(defaultContext, prop);
                    Node sc = rootEl.getFirstChild();
                    while (sc != null) {
                        Element el;
                        String instanceId;
                        if (sc.getNodeName().equals(ScannerConfigInfoFactory2.ELEMENT_CS_INFO) && (instanceId = (el = (Element)sc).getAttribute(ScannerConfigInfoFactory2.ATTRIBUTE_CS_INFO_INSTANCE_ID)).length() != 0) {
                            InfoContext c = new InfoContext(this.fProject, instanceId);
                            BuildProperty p = new BuildProperty(this, this.fProject, c, profileId, el);
                            this.fMap.put(c, p);
                        }
                        sc = sc.getNextSibling();
                    }
                }
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }

        public void save() throws CoreException {
            this.save(false);
        }

        public void save(boolean serializeDescriptor) throws CoreException {
            if (this.isDirty()) {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
                Element sc = descriptor.getProjectData(ScannerConfigInfoFactory2.SCANNER_CONFIG);
                Document doc = sc.getOwnerDocument();
                Node child = sc.getFirstChild();
                while (child != null) {
                    sc.removeChild(child);
                    child = sc.getFirstChild();
                }
                BuildProperty prop = (BuildProperty)this.fMap.get(new InfoContext(this.fProject));
                prop.store(sc);
                for (Map.Entry entry : this.fMap.entrySet()) {
                    BuildProperty p;
                    String instanceId;
                    InfoContext context = (InfoContext)entry.getKey();
                    if (context.isDefaultContext() || (instanceId = context.getInstanceId()).length() == 0 || (p = (BuildProperty)entry.getValue()) == prop) continue;
                    Element el = doc.createElement(ScannerConfigInfoFactory2.ELEMENT_CS_INFO);
                    el.setAttribute(ScannerConfigInfoFactory2.ATTRIBUTE_CS_INFO_INSTANCE_ID, instanceId);
                    p.store(el);
                    sc.appendChild(el);
                }
                if (serializeDescriptor) {
                    descriptor.saveProjectData();
                }
                this.fIsDirty = false;
            }
        }

        public IProject getProject() {
            return this.fProject;
        }

        protected Store doCreateStore(InfoContext context, Store base, String profileId) {
            return new BuildProperty(this, this.fProject, context, base, profileId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Store
    implements IScannerConfigBuilderInfo2 {
        protected static final String EMPTY_STRING = "";
        protected boolean isDirty;
        protected boolean autoDiscoveryEnabled;
        protected boolean problemReportingEnabled;
        protected String selectedProfile = "";
        protected Map profileOptionsMap;

        protected Store() {
            this.isDirty = false;
        }

        protected Store(Store base, String profileId) {
            this.autoDiscoveryEnabled = base.autoDiscoveryEnabled;
            this.problemReportingEnabled = base.problemReportingEnabled;
            this.selectedProfile = EMPTY_STRING.equals(profileId) ? base.selectedProfile : profileId;
            this.profileOptionsMap = new LinkedHashMap(base.profileOptionsMap);
            for (Map.Entry entry : this.profileOptionsMap.entrySet()) {
                ProfileOptions basePo = (ProfileOptions)entry.getValue();
                entry.setValue(new ProfileOptions(basePo));
            }
            this.isDirty = true;
        }

        @Override
        public boolean isAutoDiscoveryEnabled() {
            return this.autoDiscoveryEnabled;
        }

        @Override
        public void setAutoDiscoveryEnabled(boolean enable) {
            this.autoDiscoveryEnabled = this.setDirty(this.autoDiscoveryEnabled, enable);
        }

        @Override
        public boolean isProblemReportingEnabled() {
            return this.problemReportingEnabled;
        }

        @Override
        public void setProblemReportingEnabled(boolean enable) {
            this.problemReportingEnabled = this.setDirty(this.problemReportingEnabled, enable);
        }

        @Override
        public String getSelectedProfileId() {
            return this.selectedProfile;
        }

        @Override
        public void setSelectedProfileId(String profileId) {
            this.selectedProfile = this.setDirty(this.selectedProfile, profileId);
        }

        public List getProfileIdList() {
            return new ArrayList(this.profileOptionsMap.keySet());
        }

        @Override
        public boolean isBuildOutputFileActionEnabled() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputFileActionEnabled : false;
        }

        @Override
        public void setBuildOutputFileActionEnabled(boolean enable) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputFileActionEnabled = this.setDirty(po.buildOutputFileActionEnabled, enable);
            }
        }

        @Override
        public String getBuildOutputFilePath() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputFilePath : EMPTY_STRING;
        }

        @Override
        public void setBuildOutputFilePath(String path) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputFilePath = this.setDirty(po.buildOutputFilePath, path);
            }
        }

        @Override
        public boolean isBuildOutputParserEnabled() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputParserEnabled : true;
        }

        @Override
        public void setBuildOutputParserEnabled(boolean enable) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputParserEnabled = this.setDirty(po.buildOutputParserEnabled, enable);
            }
        }

        @Override
        public List<String> getProviderIdList() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? new ArrayList(po.providerOptionsMap.keySet()) : new ArrayList(0);
        }

        @Override
        public boolean isProviderOutputParserEnabled(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? false : ppo.providerOutputParserEnabled;
            }
            return false;
        }

        @Override
        public void setProviderOutputParserEnabled(String providerId, boolean enable) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerOutputParserEnabled = this.setDirty(ppo.providerOutputParserEnabled, enable);
            }
        }

        @Override
        public boolean isUseDefaultProviderCommand(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? false : ppo.providerRunUseDefault;
            }
            return false;
        }

        @Override
        public void setUseDefaultProviderCommand(String providerId, boolean enable) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunUseDefault = this.setDirty(ppo.providerRunUseDefault, enable);
            }
        }

        @Override
        public String getProviderRunCommand(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerRunCommand;
            }
            return null;
        }

        @Override
        public void setProviderRunCommand(String providerId, String command) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunCommand = this.setDirty(ppo.providerRunCommand, command);
            }
        }

        @Override
        public String getProviderRunArguments(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerRunArguments;
            }
            return null;
        }

        @Override
        public void setProviderRunArguments(String providerId, String arguments) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunArguments = this.setDirty(ppo.providerRunArguments, arguments);
            }
        }

        @Override
        public String getProviderOpenFilePath(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerOpenFilePath;
            }
            return null;
        }

        @Override
        public void setProviderOpenFilePath(String providerId, String filePath) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerOpenFilePath = this.setDirty(ppo.providerOpenFilePath, filePath);
            }
        }

        private boolean setDirty(boolean l, boolean r) {
            this.isDirty = this.isDirty || l != r;
            return r;
        }

        private String setDirty(String l, String r) {
            this.isDirty = this.isDirty || !l.equals(r);
            return r;
        }

        protected void loadFromProfileConfiguration(ProfileOptions po, String profileId) {
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            List providerIds = configuredProfile.getSIProviderIds();
            po.buildOutputParserEnabled = false;
            po.buildOutputFileActionEnabled = false;
            po.buildOutputFilePath = EMPTY_STRING;
            if (configuredProfile.getBuildOutputProviderElement() != null) {
                po.buildOutputParserEnabled = true;
                if (configuredProfile.getBuildOutputProviderElement().getAction() != null) {
                    po.buildOutputFileActionEnabled = true;
                    String buildOutputFilePath = configuredProfile.getBuildOutputProviderElement().getAction().getAttribute("file");
                    po.buildOutputFilePath = buildOutputFilePath != null ? buildOutputFilePath : EMPTY_STRING;
                }
            }
            po.providerOptionsMap = new LinkedHashMap(providerIds.size());
            int i = 0;
            while (i < providerIds.size()) {
                String attrValue;
                ProfileOptions.ProviderOptions ppo = new ProfileOptions.ProviderOptions();
                String providerId = (String)providerIds.get(i);
                po.providerOptionsMap.put(providerId, ppo);
                ppo.providerOutputParserEnabled = configuredProfile.getScannerInfoProviderElement(providerId) != null;
                ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                if (ppo.providerKind.equals("run")) {
                    attrValue = configuredProfile.getScannerInfoProviderElement(providerId).getAction().getAttribute(ScannerConfigInfoFactory2.COMMAND);
                    ppo.providerRunCommand = attrValue != null ? attrValue : EMPTY_STRING;
                    attrValue = configuredProfile.getScannerInfoProviderElement(providerId).getAction().getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                    ppo.providerRunArguments = attrValue != null ? attrValue : EMPTY_STRING;
                    ppo.providerRunUseDefault = true;
                } else if (ppo.providerKind.equals("open")) {
                    attrValue = configuredProfile.getScannerInfoProviderElement(providerId).getAction().getAttribute("file");
                    ppo.providerOpenFilePath = attrValue != null ? attrValue : EMPTY_STRING;
                }
                ++i;
            }
        }

        static class ProfileOptions {
            protected boolean buildOutputFileActionEnabled;
            protected String buildOutputFilePath = "";
            protected boolean buildOutputParserEnabled;
            protected Map providerOptionsMap;

            ProfileOptions() {
            }

            ProfileOptions(ProfileOptions base) {
                this.buildOutputFileActionEnabled = base.buildOutputFileActionEnabled;
                this.buildOutputFilePath = base.buildOutputFilePath;
                this.buildOutputParserEnabled = base.buildOutputParserEnabled;
                this.providerOptionsMap = new LinkedHashMap(base.providerOptionsMap);
                for (Map.Entry entry : this.providerOptionsMap.entrySet()) {
                    ProviderOptions basePo = (ProviderOptions)entry.getValue();
                    entry.setValue(new ProviderOptions(basePo));
                }
            }

            static class ProviderOptions {
                protected String providerKind;
                protected boolean providerOutputParserEnabled;
                protected boolean providerRunUseDefault;
                protected String providerRunCommand = "";
                protected String providerRunArguments = "";
                protected String providerOpenFilePath = "";

                ProviderOptions() {
                }

                ProviderOptions(ProviderOptions base) {
                    this.providerKind = base.providerKind;
                    this.providerOutputParserEnabled = base.providerOutputParserEnabled;
                    this.providerRunUseDefault = base.providerRunUseDefault;
                    this.providerRunCommand = base.providerRunCommand;
                    this.providerRunArguments = base.providerRunArguments;
                    this.providerOpenFilePath = base.providerOpenFilePath;
                }
            }
        }
    }

    private static abstract class StoreSet
    implements IScannerConfigBuilderInfo2Set {
        protected HashMap fMap = new HashMap();
        protected boolean fIsDirty;

        StoreSet() {
        }

        public IScannerConfigBuilderInfo2 createInfo(InfoContext context, IScannerConfigBuilderInfo2 base, String profileId) {
            this.fIsDirty = true;
            Store store = this.doCreateStore(context, (Store)base, profileId);
            this.fMap.put(context, store);
            return store;
        }

        protected abstract Store doCreateStore(InfoContext var1, Store var2, String var3);

        public IScannerConfigBuilderInfo2 createInfo(InfoContext context, IScannerConfigBuilderInfo2 base) {
            this.fIsDirty = true;
            return this.createInfo(context, base, "");
        }

        public InfoContext[] getContexts() {
            return this.fMap.keySet().toArray(new InfoContext[this.fMap.size()]);
        }

        public IScannerConfigBuilderInfo2 getInfo(InfoContext context) {
            return (IScannerConfigBuilderInfo2)this.fMap.get(context);
        }

        public Map getInfoMap() {
            return Collections.unmodifiableMap(this.fMap);
        }

        public IScannerConfigBuilderInfo2 removeInfo(InfoContext context) throws CoreException {
            this.checkRemoveInfo(context);
            this.fIsDirty = true;
            return (IScannerConfigBuilderInfo2)this.fMap.remove(context);
        }

        private void checkRemoveInfo(InfoContext context) throws CoreException {
            if (context.isDefaultContext()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.make.core", MakeConfigurationDataProviderMessages.getString("ScannerConfigInfoFactory2.0")));
            }
        }

        public boolean isDirty() {
            if (this.fIsDirty) {
                return true;
            }
            for (Store prop : this.fMap.values()) {
                if (!prop.isDirty) continue;
                return true;
            }
            return false;
        }

        public IScannerConfigBuilderInfo2 createInfo(InfoContext context) {
            this.fIsDirty = true;
            return this.createInfo(context, "");
        }

        public IScannerConfigBuilderInfo2 createInfo(InfoContext context, String profileId) {
            this.fIsDirty = true;
            IScannerConfigBuilderInfo2 base = this.getInfo(new InfoContext(this.getProject()));
            return this.createInfo(context, base, profileId);
        }
    }
}

