/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IInputOrder;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.ILanguageInfoCalculator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.AdditionalInput;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputOrder;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class InputType
extends BuildObject
implements IInputType {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = new String();
    private IInputType superClass;
    private String superClassId;
    private ITool parent;
    private Vector inputOrderList;
    private Vector additionalInputList;
    private String[] sourceContentTypeIds;
    private IContentType[] sourceContentTypes;
    private String[] headerContentTypeIds;
    private IContentType[] headerContentTypes;
    private String[] inputExtensions;
    private String[] headerExtensions;
    private String dependencyContentTypeId;
    private IContentType dependencyContentType;
    private List dependencyExtensions;
    private String optionId;
    private String assignToOptionId;
    private String buildVariable;
    private Boolean multipleOfType;
    private Boolean primaryInput;
    private IConfigurationElement dependencyGeneratorElement = null;
    private IManagedDependencyGeneratorType dependencyGenerator = null;
    private String languageId;
    private String languageName;
    private IConfigurationElement languageInfoCalculatorElement;
    private ILanguageInfoCalculator languageInfoCalculator;
    private String buildInfoDicsoveryProfileId;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private boolean isExtensionInputType = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private boolean rebuildState;

    public InputType(ITool parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionInputType = true;
        this.resolved = false;
        this.loadFromManifest(element);
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        ManagedBuildManager.addExtensionInputType(this);
        IManagedConfigElement[] iElements = element.getChildren();
        int l = 0;
        while (l < iElements.length) {
            IManagedConfigElement iElement = iElements[l];
            if (iElement.getName().equals("inputOrder")) {
                InputOrder inputOrder = new InputOrder((IInputType)this, iElement);
                this.getInputOrderList().add(inputOrder);
            } else if (iElement.getName().equals("additionalInput")) {
                AdditionalInput addlInput = new AdditionalInput((IInputType)this, iElement);
                this.getAdditionalInputList().add(addlInput);
            }
            ++l;
        }
    }

    public InputType(Tool parent, IInputType superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionInputType = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionInputType(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public InputType(ITool parent, ICStorageElement element) {
        this.parent = parent;
        this.isExtensionInputType = false;
        this.loadFromProject(element);
        ICStorageElement[] configElements = element.getChildren();
        int i = 0;
        while (i < configElements.length) {
            ICStorageElement configElement = configElements[i];
            if (configElement.getName().equals("inputOrder")) {
                InputOrder inputOrder = new InputOrder((IInputType)this, configElement);
                this.getInputOrderList().add(inputOrder);
            } else if (configElement.getName().equals("additionalInput")) {
                AdditionalInput addlInput = new AdditionalInput((IInputType)this, configElement);
                this.getAdditionalInputList().add(addlInput);
            }
            ++i;
        }
    }

    public InputType(ITool parent, String Id, String name, InputType inputType) {
        Iterator iter;
        this.parent = parent;
        this.superClass = inputType.superClass;
        if (this.superClass != null && inputType.superClassId != null) {
            this.superClassId = new String(inputType.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionInputType = false;
        boolean copyIds = Id.equals(inputType.id);
        if (inputType.sourceContentTypeIds != null) {
            this.sourceContentTypeIds = (String[])inputType.sourceContentTypeIds.clone();
        }
        if (inputType.sourceContentTypes != null) {
            this.sourceContentTypes = (IContentType[])inputType.sourceContentTypes.clone();
        }
        if (inputType.inputExtensions != null) {
            this.inputExtensions = (String[])inputType.inputExtensions.clone();
        }
        if (inputType.headerContentTypeIds != null) {
            this.headerContentTypeIds = (String[])inputType.headerContentTypeIds.clone();
        }
        if (inputType.headerContentTypes != null) {
            this.headerContentTypes = (IContentType[])inputType.headerContentTypes.clone();
        }
        if (inputType.headerExtensions != null) {
            this.headerExtensions = (String[])inputType.headerExtensions.clone();
        }
        if (inputType.dependencyContentTypeId != null) {
            this.dependencyContentTypeId = new String(inputType.dependencyContentTypeId);
        }
        this.dependencyContentType = inputType.dependencyContentType;
        if (inputType.dependencyExtensions != null) {
            this.dependencyExtensions = new ArrayList(inputType.dependencyExtensions);
        }
        if (inputType.optionId != null) {
            this.optionId = new String(inputType.optionId);
        }
        if (inputType.assignToOptionId != null) {
            this.assignToOptionId = new String(inputType.assignToOptionId);
        }
        if (inputType.buildVariable != null) {
            this.buildVariable = new String(inputType.buildVariable);
        }
        if (inputType.multipleOfType != null) {
            this.multipleOfType = new Boolean(inputType.multipleOfType);
        }
        if (inputType.primaryInput != null) {
            this.primaryInput = new Boolean(inputType.primaryInput);
        }
        this.dependencyGeneratorElement = inputType.dependencyGeneratorElement;
        this.dependencyGenerator = inputType.dependencyGenerator;
        this.languageId = inputType.languageId;
        this.languageName = inputType.languageName;
        this.languageInfoCalculatorElement = inputType.languageInfoCalculatorElement;
        this.languageInfoCalculator = inputType.languageInfoCalculator;
        this.buildInfoDicsoveryProfileId = inputType.buildInfoDicsoveryProfileId;
        if (inputType.inputOrderList != null) {
            iter = inputType.getInputOrderList().listIterator();
            while (iter.hasNext()) {
                InputOrder inputOrder = (InputOrder)iter.next();
                InputOrder newInputOrder = new InputOrder((IInputType)this, inputOrder);
                this.getInputOrderList().add(newInputOrder);
            }
        }
        if (inputType.additionalInputList != null) {
            iter = inputType.getAdditionalInputList().listIterator();
            while (iter.hasNext()) {
                AdditionalInput additionalInput = (AdditionalInput)iter.next();
                AdditionalInput newAdditionalInput = new AdditionalInput((IInputType)this, additionalInput);
                this.getAdditionalInputList().add(newAdditionalInput);
            }
        }
        if (copyIds) {
            this.isDirty = inputType.isDirty;
            this.rebuildState = inputType.rebuildState;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String isPI;
        String hs;
        StringTokenizer tokenizer;
        String inputs;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        ArrayList<Object> list = new ArrayList<Object>();
        String ids = element.getAttribute("sourceContentType");
        if (ids != null) {
            StringTokenizer tokenizer2 = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer2.hasMoreElements()) {
                list.add(tokenizer2.nextElement());
            }
            if (list.size() != 0) {
                this.sourceContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if ((inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextElement());
            }
            if (list.size() != 0) {
                this.inputExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if ((ids = element.getAttribute("headerContentType")) != null) {
            tokenizer = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextElement());
            }
            if (list.size() != 0) {
                this.headerContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if ((hs = element.getAttribute("headers")) != null) {
            StringTokenizer tokenizer3 = new StringTokenizer(hs, DEFAULT_SEPARATOR);
            while (tokenizer3.hasMoreElements()) {
                list.add(tokenizer3.nextElement());
            }
            if (list.size() != 0) {
                this.headerExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        this.dependencyContentTypeId = element.getAttribute("dependencyContentType");
        String headers = element.getAttribute("dependencyExtensions");
        if (headers != null) {
            StringTokenizer tokenizer4 = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer4.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer4.nextElement());
            }
        }
        this.optionId = element.getAttribute("option");
        this.assignToOptionId = element.getAttribute("assignToOption");
        String isMOT = element.getAttribute("multipleOfType");
        if (isMOT != null) {
            this.multipleOfType = new Boolean("true".equals(isMOT));
        }
        if ((isPI = element.getAttribute("primaryInput")) != null) {
            this.primaryInput = new Boolean("true".equals(isPI));
        }
        this.buildVariable = element.getAttribute("buildVariable");
        this.languageId = element.getAttribute("languageId");
        this.languageName = element.getAttribute("languageName");
        if (element.getAttribute("languageInfoCalculator") != null && element instanceof DefaultManagedConfigElement) {
            this.languageInfoCalculatorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.buildInfoDicsoveryProfileId = element.getAttribute("scannerConfigDiscoveryProfileId");
        String depGenerator = element.getAttribute("dependencyCalculator");
        if (depGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.dependencyGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected boolean loadFromProject(ICStorageElement element) {
        String isPI;
        String isMOT;
        String headers;
        String inputs;
        IContentType type;
        int i;
        StringTokenizer tokenizer;
        String ids;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionInputType(this.superClassId);
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        ArrayList<Object> list = new ArrayList<Object>();
        if (element.getAttribute("sourceContentType") != null && (ids = element.getAttribute("sourceContentType")) != null) {
            tokenizer = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextElement());
            }
            if (list.size() != 0) {
                this.sourceContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
            if (this.sourceContentTypeIds != null) {
                i = 0;
                while (i < this.sourceContentTypeIds.length) {
                    type = manager.getContentType(this.sourceContentTypeIds[i]);
                    if (type != null) {
                        list.add(type);
                    }
                    ++i;
                }
                if (list.size() != 0) {
                    this.sourceContentTypes = list.toArray(new IContentType[list.size()]);
                    list.clear();
                }
            }
        }
        if (element.getAttribute("sources") != null && (inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextElement());
            }
            if (list.size() != 0) {
                this.inputExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if (element.getAttribute("headerContentType") != null && (ids = element.getAttribute("headerContentType")) != null) {
            tokenizer = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextElement());
            }
            if (list.size() != 0) {
                this.headerContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
            if (this.headerContentTypeIds != null) {
                i = 0;
                while (i < this.headerContentTypeIds.length) {
                    type = manager.getContentType(this.headerContentTypeIds[i]);
                    if (type != null) {
                        list.add(type);
                    }
                    ++i;
                }
                if (list.size() != 0) {
                    this.headerContentTypes = list.toArray(new IContentType[list.size()]);
                    list.clear();
                }
            }
        }
        if (element.getAttribute("headers") != null && (inputs = element.getAttribute("headers")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextElement());
            }
            if (list.size() != 0) {
                this.headerExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if (element.getAttribute("dependencyContentType") != null) {
            this.dependencyContentTypeId = element.getAttribute("dependencyContentType");
            if (this.dependencyContentTypeId != null && this.dependencyContentTypeId.length() > 0) {
                this.dependencyContentType = manager.getContentType(this.dependencyContentTypeId);
            }
        }
        if (element.getAttribute("dependencyExtensions") != null && (headers = element.getAttribute("dependencyExtensions")) != null) {
            tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.getAttribute("option") != null) {
            this.optionId = element.getAttribute("option");
        }
        if (element.getAttribute("assignToOption") != null) {
            this.assignToOptionId = element.getAttribute("assignToOption");
        }
        if (element.getAttribute("multipleOfType") != null && (isMOT = element.getAttribute("multipleOfType")) != null) {
            this.multipleOfType = new Boolean("true".equals(isMOT));
        }
        if (element.getAttribute("primaryInput") != null && (isPI = element.getAttribute("primaryInput")) != null) {
            this.primaryInput = new Boolean("true".equals(isPI));
        }
        if (element.getAttribute("buildVariable") != null) {
            this.buildVariable = element.getAttribute("buildVariable");
        }
        this.languageId = element.getAttribute("languageId");
        this.languageName = element.getAttribute("languageName");
        this.buildInfoDicsoveryProfileId = element.getAttribute("scannerConfigDiscoveryProfileId");
        element.getAttribute("dependencyCalculator");
        return true;
    }

    private String composeString(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(array[0]);
        int i = 1;
        while (i < array.length) {
            buf.append(separator).append(array[i]);
            ++i;
        }
        return buf.toString();
    }

    public void serialize(ICStorageElement element) {
        String inputs;
        String s;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.sourceContentTypeIds != null) {
            s = this.composeString(this.sourceContentTypeIds, DEFAULT_SEPARATOR);
            element.setAttribute("sourceContentType", s);
        }
        if (this.inputExtensions != null) {
            inputs = this.composeString(this.inputExtensions, DEFAULT_SEPARATOR);
            element.setAttribute("sources", inputs);
        }
        if (this.headerContentTypeIds != null) {
            s = this.composeString(this.headerContentTypeIds, DEFAULT_SEPARATOR);
            element.setAttribute("headerContentType", s);
        }
        if (this.headerExtensions != null) {
            inputs = this.composeString(this.headerExtensions, DEFAULT_SEPARATOR);
            element.setAttribute("headers", inputs);
        }
        if (this.dependencyContentTypeId != null) {
            element.setAttribute("dependencyContentType", this.dependencyContentTypeId);
        }
        if (this.getDependencyExtensionsList().size() > 0) {
            List list = this.getDependencyExtensionsList();
            Iterator iter = list.listIterator();
            String headers = (String)iter.next();
            while (iter.hasNext()) {
                headers = String.valueOf(headers) + DEFAULT_SEPARATOR;
                headers = String.valueOf(headers) + iter.next();
            }
            element.setAttribute("dependencyExtensions", headers);
        }
        if (this.optionId != null) {
            element.setAttribute("option", this.optionId);
        }
        if (this.assignToOptionId != null) {
            element.setAttribute("assignToOption", this.assignToOptionId);
        }
        if (this.multipleOfType != null) {
            element.setAttribute("multipleOfType", this.multipleOfType.toString());
        }
        if (this.primaryInput != null) {
            element.setAttribute("primaryInput", this.primaryInput.toString());
        }
        if (this.buildVariable != null) {
            element.setAttribute("buildVariable", this.buildVariable);
        }
        if (this.languageId != null) {
            element.setAttribute("languageId", this.languageId);
        }
        if (this.languageName != null) {
            element.setAttribute("languageName", this.languageName);
        }
        if (this.buildInfoDicsoveryProfileId != null) {
            element.setAttribute("scannerConfigDiscoveryProfileId", this.buildInfoDicsoveryProfileId);
        }
        Vector childElements = this.getInputOrderList();
        Iterator iter = childElements.listIterator();
        while (iter.hasNext()) {
            InputOrder io = (InputOrder)iter.next();
            ICStorageElement ioElement = element.createChild("inputOrder");
            io.serialize(ioElement);
        }
        childElements = this.getAdditionalInputList();
        iter = childElements.listIterator();
        while (iter.hasNext()) {
            AdditionalInput ai = (AdditionalInput)iter.next();
            ICStorageElement aiElement = element.createChild("additionalInput");
            ai.serialize(aiElement);
        }
        this.isDirty = false;
    }

    public ITool getParent() {
        return this.parent;
    }

    public IInputOrder createInputOrder(String path) {
        InputOrder inputOrder = new InputOrder(this, false);
        inputOrder.setPath(path);
        this.getInputOrderList().add(inputOrder);
        this.setDirty(true);
        return inputOrder;
    }

    public IInputOrder[] getInputOrders() {
        Vector ours = this.getInputOrderList();
        IInputOrder[] orders = ours.toArray(new IInputOrder[ours.size()]);
        return orders;
    }

    public IInputOrder getInputOrder(String path) {
        Vector orders = this.getInputOrderList();
        Iterator iter = orders.listIterator();
        while (iter.hasNext()) {
            InputOrder io = (InputOrder)iter.next();
            if (path.compareToIgnoreCase(io.getPath()) == 0) continue;
            return io;
        }
        return null;
    }

    public void removeInputOrder(String path) {
        IInputOrder order = this.getInputOrder(path);
        if (order != null) {
            this.removeInputOrder(order);
        }
    }

    public void removeInputOrder(IInputOrder element) {
        this.getInputOrderList().remove(element);
        this.setDirty(true);
    }

    public IAdditionalInput createAdditionalInput(String paths) {
        AdditionalInput addlInput = new AdditionalInput(this, false);
        addlInput.setPaths(paths);
        this.getAdditionalInputList().add(addlInput);
        this.setDirty(true);
        return addlInput;
    }

    IAdditionalInput createAdditionalInput(IAdditionalInput base) {
        AdditionalInput newAdditionalInput = new AdditionalInput((IInputType)this, (AdditionalInput)base);
        this.getAdditionalInputList().add(newAdditionalInput);
        this.setDirty(true);
        return newAdditionalInput;
    }

    public IAdditionalInput[] getAdditionalInputs() {
        Vector ours = this.getAdditionalInputList();
        IAdditionalInput[] inputs = ours.toArray(new IAdditionalInput[ours.size()]);
        return inputs;
    }

    public IAdditionalInput getAdditionalInput(String paths) {
        String[] inputTokens = paths.split(";");
        Vector inputs = this.getInputOrderList();
        Iterator iter = inputs.listIterator();
        while (iter.hasNext()) {
            AdditionalInput ai = (AdditionalInput)iter.next();
            boolean match = false;
            String[] tokens = ai.getPaths();
            if (tokens.length == inputTokens.length) {
                match = true;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].compareToIgnoreCase(inputTokens[i]) != 0) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            return ai;
        }
        return null;
    }

    public void removeAdditionalInput(String path) {
        IAdditionalInput input = this.getAdditionalInput(path);
        if (input != null) {
            this.removeAdditionalInput(input);
        }
    }

    public void removeAdditionalInput(IAdditionalInput element) {
        this.getAdditionalInputList().remove(element);
        this.setDirty(true);
    }

    public IPath[] getAdditionalDependencies() {
        ArrayList<IPath> deps = new ArrayList<IPath>();
        for (AdditionalInput current : this.getAdditionalInputList()) {
            String[] paths;
            int kind = current.getKind();
            if (kind != 1 && kind != 3 || (paths = current.getPaths()) == null) continue;
            int i = 0;
            while (i < paths.length) {
                if (paths[i].length() > 0) {
                    deps.add(Path.fromOSString((String)paths[i]));
                }
                ++i;
            }
        }
        return deps.toArray(new IPath[deps.size()]);
    }

    public IPath[] getAdditionalResources() {
        ArrayList<IPath> ins = new ArrayList<IPath>();
        for (AdditionalInput current : this.getAdditionalInputList()) {
            String[] paths;
            int kind = current.getKind();
            if (kind != 2 && kind != 3 || (paths = current.getPaths()) == null) continue;
            int i = 0;
            while (i < paths.length) {
                if (paths[i].length() > 0) {
                    ins.add(Path.fromOSString((String)paths[i]));
                }
                ++i;
            }
        }
        return ins.toArray(new IPath[ins.size()]);
    }

    private Vector getInputOrderList() {
        if (this.inputOrderList == null) {
            this.inputOrderList = new Vector();
        }
        return this.inputOrderList;
    }

    private Vector getAdditionalInputList() {
        if (this.additionalInputList == null) {
            this.additionalInputList = new Vector();
        }
        return this.additionalInputList;
    }

    public IInputType getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public String getBuildVariable() {
        if (this.buildVariable == null) {
            if (this.superClass != null) {
                return this.superClass.getBuildVariable();
            }
            return EMPTY_STRING;
        }
        return this.buildVariable;
    }

    public void setBuildVariable(String variableName) {
        if (variableName == null && this.buildVariable == null) {
            return;
        }
        if (this.buildVariable == null || variableName == null || !variableName.equals(this.buildVariable)) {
            this.buildVariable = variableName;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IContentType getDependencyContentType() {
        if (this.dependencyContentType == null) {
            if (this.superClass != null) {
                return this.superClass.getDependencyContentType();
            }
            return null;
        }
        return this.dependencyContentType;
    }

    public void setDependencyContentType(IContentType type) {
        if (this.dependencyContentType != type) {
            this.dependencyContentType = type;
            this.dependencyContentTypeId = this.dependencyContentType != null ? this.dependencyContentType.getId() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String[] getDependencyExtensionsAttribute() {
        if (this.dependencyExtensions == null || this.dependencyExtensions.size() == 0) {
            if (this.superClass != null) {
                return this.superClass.getDependencyExtensionsAttribute();
            }
            if (this.dependencyExtensions == null) {
                this.dependencyExtensions = new ArrayList();
            }
        }
        return this.dependencyExtensions.toArray(new String[this.dependencyExtensions.size()]);
    }

    public void setDependencyExtensionsAttribute(String extensions) {
        this.getDependencyExtensionsList().clear();
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public String[] getDependencyExtensions(ITool tool) {
        IContentType type = this.getDependencyContentType();
        if (type != null) {
            String[] exts = ((Tool)tool).getContentTypeFileSpecs(type);
            if (type.getId().compareTo("org.eclipse.cdt.core.cxxHeader") == 0) {
                boolean h_found = false;
                int i = 0;
                while (i < exts.length) {
                    if (exts[i].compareTo("h") == 0) {
                        h_found = true;
                        break;
                    }
                    ++i;
                }
                if (!h_found) {
                    String[] cppexts = new String[exts.length + 1];
                    int i2 = 0;
                    while (i2 < exts.length) {
                        cppexts[i2] = exts[i2];
                        ++i2;
                    }
                    cppexts[i2] = "h";
                    return cppexts;
                }
            }
            return exts;
        }
        return this.getDependencyExtensionsAttribute();
    }

    public boolean isDependencyExtension(ITool tool, String ext) {
        String[] exts = this.getDependencyExtensions(tool);
        int i = 0;
        while (i < exts.length) {
            if (ext.equals(exts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getDependencyExtensionsList() {
        if (this.dependencyExtensions == null) {
            this.dependencyExtensions = new ArrayList();
        }
        return this.dependencyExtensions;
    }

    public IManagedDependencyGeneratorType getDependencyGenerator() {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGeneratorType)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        if (this.dependencyGeneratorElement == null && this.superClass != null) {
            return ((InputType)this.superClass).getDependencyGeneratorElement();
        }
        return this.dependencyGeneratorElement;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
        this.dependencyGeneratorElement = element;
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public boolean getMultipleOfType() {
        if (this.multipleOfType == null) {
            if (this.superClass != null) {
                return this.superClass.getMultipleOfType();
            }
            return false;
        }
        return this.multipleOfType;
    }

    public void setMultipleOfType(boolean b) {
        if (this.multipleOfType == null || b != this.multipleOfType) {
            this.multipleOfType = new Boolean(b);
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public boolean getPrimaryInput() {
        if (this.primaryInput == null) {
            if (this.superClass != null) {
                return this.superClass.getPrimaryInput();
            }
            return false;
        }
        return this.primaryInput;
    }

    public void setPrimaryInput(boolean b) {
        if (this.primaryInput == null || b != this.primaryInput) {
            this.primaryInput = new Boolean(b);
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String getOptionId() {
        if (this.optionId == null) {
            if (this.superClass != null) {
                return this.superClass.getOptionId();
            }
            return null;
        }
        return this.optionId;
    }

    public void setOptionId(String id) {
        if (id == null && this.optionId == null) {
            return;
        }
        if (id == null || this.optionId == null || !this.optionId.equals(id)) {
            this.optionId = id;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String getAssignToOptionId() {
        if (this.assignToOptionId == null) {
            if (this.superClass != null) {
                return this.superClass.getAssignToOptionId();
            }
            return null;
        }
        return this.assignToOptionId;
    }

    public void setAssignToOptionId(String id) {
        if (id == null && this.assignToOptionId == null) {
            return;
        }
        if (id == null || this.assignToOptionId == null || !this.assignToOptionId.equals(id)) {
            this.assignToOptionId = id;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IContentType getSourceContentType() {
        IContentType[] types = this.getSourceContentTypes();
        if (types != null && types.length != 0) {
            return types[0];
        }
        return null;
    }

    public IContentType[] getSourceContentTypes() {
        if (this.sourceContentTypes == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceContentTypes();
            }
            return new IContentType[0];
        }
        return (IContentType[])this.sourceContentTypes.clone();
    }

    public IContentType[] getHeaderContentTypes() {
        if (this.headerContentTypes == null) {
            if (this.superClass != null) {
                return this.superClass.getHeaderContentTypes();
            }
            return new IContentType[0];
        }
        return (IContentType[])this.headerContentTypes.clone();
    }

    public String[] getHeaderExtensionsAttribute() {
        if (this.headerExtensions == null) {
            if (this.superClass != null) {
                return this.superClass.getHeaderExtensionsAttribute();
            }
            return new String[0];
        }
        return (String[])this.headerExtensions.clone();
    }

    public String[] getHeaderContentTypeIds() {
        if (this.headerContentTypeIds == null) {
            if (this.superClass != null) {
                return this.superClass.getHeaderContentTypeIds();
            }
            return new String[0];
        }
        return (String[])this.headerContentTypeIds.clone();
    }

    public String[] getSourceContentTypeIds() {
        if (this.sourceContentTypeIds == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceContentTypeIds();
            }
            return new String[0];
        }
        return (String[])this.sourceContentTypeIds.clone();
    }

    public void setHeaderContentTypeIds(String[] ids) {
        if (!Arrays.equals(this.headerContentTypeIds, ids)) {
            this.headerContentTypeIds = ids != null ? (String[])ids.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void setHeaderExtensionsAttribute(String[] extensions) {
        if (!Arrays.equals(this.headerExtensions, extensions)) {
            this.headerExtensions = extensions != null ? (String[])extensions.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void setSourceContentTypeIds(String[] ids) {
        if (!Arrays.equals(this.sourceContentTypeIds, ids)) {
            this.sourceContentTypeIds = ids != null ? (String[])ids.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void setSourceExtensionsAttribute(String[] extensions) {
        if (!Arrays.equals(this.inputExtensions, extensions)) {
            this.inputExtensions = extensions != null ? (String[])extensions.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void setSourceContentType(IContentType type) {
        if (type == null) {
            if (this.sourceContentTypes != null) {
                this.sourceContentTypes = null;
                this.sourceContentTypeIds = null;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        } else {
            if (this.sourceContentTypes == null || this.sourceContentTypes.length != 1 || this.sourceContentTypes[0] != type) {
                this.sourceContentTypes = new IContentType[1];
                this.sourceContentTypes[0] = type;
                this.sourceContentTypeIds = new String[1];
                this.sourceContentTypeIds[0] = type.getId();
                this.setDirty(true);
                this.setRebuildState(true);
            }
            return;
        }
    }

    public void setSourceContentTypes(IContentType[] types) {
        if (types == null) {
            if (this.sourceContentTypes != null) {
                this.sourceContentTypes = null;
                this.sourceContentTypeIds = null;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        } else {
            this.sourceContentTypes = (IContentType[])types.clone();
            this.sourceContentTypeIds = new String[types.length];
            int i = 0;
            while (i < types.length) {
                this.sourceContentTypeIds[i] = types[i].getId();
                ++i;
            }
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String[] getSourceExtensionsAttribute() {
        if (this.inputExtensions == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceExtensionsAttribute();
            }
            return new String[0];
        }
        return (String[])this.inputExtensions.clone();
    }

    public void setSourceExtensionsAttribute(String extensions) {
        if (extensions == null) {
            if (this.inputExtensions != null) {
                this.inputExtensions = null;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        } else {
            Object[] newExts;
            ArrayList<Object> list = new ArrayList<Object>();
            if (extensions != null) {
                StringTokenizer tokenizer = new StringTokenizer(extensions, DEFAULT_SEPARATOR);
                while (tokenizer.hasMoreElements()) {
                    list.add(tokenizer.nextElement());
                }
            }
            if (!Arrays.equals(newExts = list.toArray(new String[list.size()]), this.inputExtensions)) {
                this.inputExtensions = newExts;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        }
    }

    public String[] getSourceExtensions(ITool tool) {
        return this.getSourceExtensions(tool, ((Tool)tool).getProject());
    }

    public String[] getSourceExtensions(ITool tool, IProject project) {
        IContentType[] types = this.getSourceContentTypes();
        if (types.length != 0) {
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < types.length) {
                IContentType type = types[i];
                list.addAll(Arrays.asList(((Tool)tool).getContentTypeFileSpecs(type, project)));
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        return this.getSourceExtensionsAttribute();
    }

    public String[] getHeaderExtensions(ITool tool) {
        IContentType[] types = this.getHeaderContentTypes();
        if (types.length != 0) {
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < types.length) {
                IContentType type = types[i];
                list.addAll(Arrays.asList(((Tool)tool).getContentTypeFileSpecs(type)));
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        return this.getHeaderExtensionsAttribute();
    }

    public boolean isSourceExtension(ITool tool, String ext) {
        return this.isSourceExtension(tool, ext, ((Tool)tool).getProject());
    }

    public boolean isSourceExtension(ITool tool, String ext, IProject project) {
        String[] exts = this.getSourceExtensions(tool, project);
        int i = 0;
        while (i < exts.length) {
            if (ext.equals(exts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isExtensionElement() {
        return this.isExtensionInputType;
    }

    public boolean isDirty() {
        if (this.isExtensionInputType) {
            return false;
        }
        for (Object current : this.getInputOrderList()) {
            if (!((InputOrder)current).isDirty()) continue;
            return true;
        }
        for (Object current : this.getAdditionalInputList()) {
            if (!((AdditionalInput)current).isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            for (Object current : this.getInputOrderList()) {
                ((InputOrder)current).setDirty(false);
            }
            for (Object current : this.getAdditionalInputList()) {
                ((AdditionalInput)current).setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            IContentType type;
            int i;
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionInputType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "inputType", this.getId());
                }
            }
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<IContentType> list = new ArrayList<IContentType>();
            if (this.sourceContentTypeIds != null) {
                i = 0;
                while (i < this.sourceContentTypeIds.length) {
                    type = manager.getContentType(this.sourceContentTypeIds[i]);
                    if (type != null) {
                        list.add(type);
                    }
                    ++i;
                }
                if (list.size() != 0) {
                    this.sourceContentTypes = list.toArray(new IContentType[list.size()]);
                    list.clear();
                } else {
                    this.sourceContentTypes = new IContentType[0];
                }
            }
            if (this.headerContentTypeIds != null) {
                i = 0;
                while (i < this.headerContentTypeIds.length) {
                    type = manager.getContentType(this.headerContentTypeIds[i]);
                    if (type != null) {
                        list.add(type);
                    }
                    ++i;
                }
                if (list.size() != 0) {
                    this.headerContentTypes = list.toArray(new IContentType[list.size()]);
                    list.clear();
                } else {
                    this.headerContentTypes = new IContentType[0];
                }
            }
            if (this.dependencyContentTypeId != null && this.dependencyContentTypeId.length() > 0) {
                this.dependencyContentType = manager.getContentType(this.dependencyContentTypeId);
            }
            for (Object current : this.getInputOrderList()) {
                ((InputOrder)current).resolveReferences();
            }
            for (Object current : this.getAdditionalInputList()) {
                ((AdditionalInput)current).resolveReferences();
            }
        }
    }

    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public boolean needsRebuild() {
        if (this.rebuildState) {
            return true;
        }
        for (Object current : this.getInputOrderList()) {
            if (!((InputOrder)current).needsRebuild()) continue;
            return true;
        }
        for (Object current : this.getAdditionalInputList()) {
            if (!((AdditionalInput)current).needsRebuild()) continue;
            return true;
        }
        return this.rebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.rebuildState = rebuild;
        if (!rebuild) {
            for (Object current : this.getInputOrderList()) {
                ((InputOrder)current).setRebuildState(false);
            }
            for (Object current : this.getAdditionalInputList()) {
                ((AdditionalInput)current).setRebuildState(false);
            }
        }
    }

    public IResourceInfo getRcInfo(ITool tool) {
        IBuildObject parent = tool.getParent();
        if (parent instanceof IFileInfo) {
            return (IFileInfo)parent;
        }
        if (parent instanceof IToolChain) {
            return ((IToolChain)parent).getParentFolderInfo();
        }
        return null;
    }

    private ILanguageInfoCalculator getLanguageInfoCalculator() {
        if (this.languageInfoCalculator == null && this.languageInfoCalculatorElement != null) {
            try {
                Object ex = this.languageInfoCalculatorElement.createExecutableExtension("languageInfoCalculator");
                if (ex instanceof ILanguageInfoCalculator) {
                    this.languageInfoCalculator = (ILanguageInfoCalculator)ex;
                }
            }
            catch (CoreException coreException) {}
        }
        return this.languageInfoCalculator;
    }

    public String getLanguageIdAttribute() {
        if (this.languageId == null) {
            if (this.superClass != null) {
                return ((InputType)this.superClass).getLanguageIdAttribute();
            }
            return null;
        }
        return this.languageId;
    }

    public String getLanguageNameAttribute() {
        if (this.languageName == null) {
            if (this.superClass != null) {
                return ((InputType)this.superClass).getLanguageNameAttribute();
            }
            return null;
        }
        return this.languageName;
    }

    public String getLanguageId(ITool tool) {
        ILanguageInfoCalculator calc;
        IResourceInfo rcInfo = this.getRcInfo(tool);
        String langId = this.languageId;
        if ((langId == null || this.isExtensionInputType) && (calc = this.getLanguageInfoCalculator()) != null) {
            langId = calc.getLanguageId(rcInfo, tool, this);
        }
        if (langId == null) {
            langId = this.getLanguageIdAttribute();
        }
        return langId;
    }

    public String getLanguageName(ITool tool) {
        ILanguageInfoCalculator calc;
        IResourceInfo rcInfo = this.getRcInfo(tool);
        String langName = this.languageName;
        if ((langName == null || this.isExtensionInputType) && (calc = this.getLanguageInfoCalculator()) != null) {
            langName = calc.getLanguageName(rcInfo, tool, this);
        }
        if (langName == null && (langName = this.getLanguageNameAttribute()) == null) {
            String name;
            IContentType[] types = this.getSourceContentTypes();
            int i = 0;
            while (i < types.length) {
                name = types[i].getName();
                if (name != null && name.length() != 0) {
                    langName = name;
                    break;
                }
                ++i;
            }
            if (langName == null) {
                types = this.getHeaderContentTypes();
                i = 0;
                while (i < types.length) {
                    name = types[i].getName();
                    if (name != null && name.length() != 0) {
                        langName = name;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (langName == null) {
            String[] exts = this.getSourceExtensions(tool);
            if (exts.length != 0) {
                langName = CDataUtil.arrayToString((String[])exts, (String)DEFAULT_SEPARATOR);
            } else {
                exts = this.getHeaderExtensions(tool);
                if (exts.length != 0) {
                    langName = CDataUtil.arrayToString((String[])exts, (String)DEFAULT_SEPARATOR);
                }
            }
        }
        if (langName == null && (langName = this.getName()) == null && (langName = tool.getName()) == null) {
            langName = this.getId();
        }
        return langName;
    }

    public String getDiscoveryProfileId(ITool tool) {
        int nPos;
        String id = this.getDiscoveryProfileIdAttribute();
        if (id == null) {
            id = ((Tool)tool).getDiscoveryProfileId();
        }
        if (id != null && (nPos = id.indexOf(124)) > 0) {
            id = id.substring(0, nPos);
        }
        return id;
    }

    public String getDiscoveryProfileIdAttribute() {
        if (this.buildInfoDicsoveryProfileId == null && this.superClass != null) {
            return ((InputType)this.superClass).getDiscoveryProfileIdAttribute();
        }
        return this.buildInfoDicsoveryProfileId;
    }

    public void setLanguageIdAttribute(String id) {
        this.languageId = id;
    }

    public void setLanguageNameAttribute(String name) {
        this.languageName = name;
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.superClass != null) {
            return ((InputType)this.superClass).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    public boolean isEnabled(ITool tool) {
        if (tool.isExtensionElement()) {
            return true;
        }
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
        if (calc == null) {
            return true;
        }
        return calc.isInputTypeEnabled(tool, this);
    }

    public boolean hasScannerConfigSettings() {
        return this.getDiscoveryProfileIdAttribute() != null;
    }

    public boolean hasCustomSettings() {
        return false;
    }
}

