/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class IBContentProvider
extends AsyncTreeContentProvider {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private boolean fComputeIncludedBy = true;

    public IBContentProvider(Display disp) {
        super(disp);
    }

    public Object getParent(Object element) {
        if (element instanceof IBNode) {
            IBNode node = (IBNode)element;
            return node.getParent();
        }
        return super.getParent(element);
    }

    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        IBNode node;
        if (parentElement instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)parentElement;
            return new Object[]{new IBNode(null, new IBFile(tu), null, 0, 0, 0L)};
        }
        if (parentElement instanceof IBNode && ((node = (IBNode)parentElement).isRecursive() || node.getRepresentedIFL() == null)) {
            return NO_CHILDREN;
        }
        return null;
    }

    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        block15: {
            if (parentElement instanceof IBNode) {
                IIndex index;
                IBNode node = (IBNode)parentElement;
                IIndexFileLocation ifl = node.getRepresentedIFL();
                ICProject project = node.getCProject();
                if (ifl == null) {
                    return NO_CHILDREN;
                }
                try {
                    ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
                    index = CCorePlugin.getIndexManager().getIndex(scope);
                    index.acquireReadLock();
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                    return NO_CHILDREN;
                }
                catch (InterruptedException interruptedException) {
                    return NO_CHILDREN;
                }
                try {
                    IIndexInclude[] includes;
                    IBFile directiveFile = null;
                    IBFile targetFile = null;
                    if (this.fComputeIncludedBy) {
                        includes = this.findIncludedBy(index, ifl, NPM);
                    } else {
                        includes = this.findIncludesTo(index, ifl, NPM);
                        directiveFile = node.getRepresentedFile();
                    }
                    if (includes.length <= 0) break block15;
                    ArrayList<IBNode> result = new ArrayList<IBNode>(includes.length);
                    int i = 0;
                    while (i < includes.length) {
                        IIndexInclude include = includes[i];
                        try {
                            if (this.fComputeIncludedBy) {
                                directiveFile = targetFile = new IBFile(project, include.getIncludedByLocation());
                            } else {
                                IIndexFileLocation includesPath = include.getIncludesLocation();
                                targetFile = includesPath == null ? new IBFile(include.getName()) : new IBFile(project, includesPath);
                            }
                            IBNode newnode = new IBNode(node, targetFile, directiveFile, include.getNameOffset(), include.getNameLength(), include.getIncludedBy().getTimestamp());
                            newnode.setIsActiveCode(include.isActive());
                            newnode.setIsSystemInclude(include.isSystemInclude());
                            result.add(newnode);
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                        }
                        ++i;
                    }
                    Object[] objectArray = result.toArray();
                    return objectArray;
                }
                finally {
                    index.releaseReadLock();
                }
            }
        }
        return NO_CHILDREN;
    }

    public void setComputeIncludedBy(boolean value) {
        this.fComputeIncludedBy = value;
    }

    public boolean getComputeIncludedBy() {
        return this.fComputeIncludedBy;
    }

    private IIndexInclude[] findIncludedBy(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludedBy(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    int i = 0;
                    while (i < files.length) {
                        IIndexInclude[] includes = index.findIncludedBy(files[i]);
                        int j = 0;
                        while (j < includes.length) {
                            IIndexInclude indexInclude = includes[j];
                            if (handled.add(indexInclude.getIncludedByLocation())) {
                                list.add(indexInclude);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return new IIndexInclude[0];
    }

    public IIndexInclude[] findIncludesTo(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludes(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    int i = 0;
                    while (i < files.length) {
                        IIndexInclude[] includes = index.findIncludes(files[i]);
                        int j = 0;
                        while (j < includes.length) {
                            IIndexInclude indexInclude = includes[j];
                            if (handled.add(indexInclude.getIncludesLocation())) {
                                list.add(indexInclude);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return new IIndexInclude[0];
    }
}

