/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.ui.refactoring.utils.CPPASTAllVisitor;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class NamespaceHelper {
    public static ICPPASTQualifiedName getSurroundingNamespace(final IFile insertFile, final int offset) throws CoreException {
        final CPPASTQualifiedName qualifiedName = new CPPASTQualifiedName();
        TranslationUnitHelper.loadTranslationUnit(insertFile, false).accept((ASTVisitor)new CPPASTAllVisitor(){

            public int visit(IASTDeclSpecifier declSpec) {
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier && NamespaceHelper.checkFileNameAndLocation(insertFile, offset, (IASTNode)declSpec)) {
                    qualifiedName.addName(NamespaceHelper.createNameWithTemplates((IASTNode)declSpec));
                }
                return super.visit(declSpec);
            }

            public int visit(ICPPASTNamespaceDefinition namespace) {
                if (NamespaceHelper.checkFileNameAndLocation(insertFile, offset, (IASTNode)namespace)) {
                    qualifiedName.addName(namespace.getName());
                }
                return super.visit(namespace);
            }
        });
        return qualifiedName;
    }

    private static boolean checkFileNameAndLocation(IFile insertFile, int offset, IASTNode namespace) {
        return namespace.getFileLocation().getFileName().endsWith(insertFile.getFullPath().toOSString()) && offset >= namespace.getNodeLocations()[0].getNodeOffset() && offset <= namespace.getNodeLocations()[0].getNodeOffset() + namespace.getNodeLocations()[0].getNodeLength();
    }

    private static IASTName createNameWithTemplates(IASTNode declarationParent) {
        IASTName parentName = ((ICPPASTCompositeTypeSpecifier)declarationParent).getName();
        if (NamespaceHelper.classHasTemplates(declarationParent)) {
            CPPASTTemplateId templateId = new CPPASTTemplateId();
            templateId.setTemplateName(parentName);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = ((ICPPASTTemplateDeclaration)declarationParent.getParent().getParent()).getTemplateParameters();
            int n = iCPPASTTemplateParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n2];
                if (templateParameter instanceof CPPASTSimpleTypeTemplateParameter) {
                    CPPASTSimpleTypeTemplateParameter simpleTypeTemplateParameter = (CPPASTSimpleTypeTemplateParameter)templateParameter;
                    CPPASTTypeId id = new CPPASTTypeId();
                    CPPASTNamedTypeSpecifier namedTypeSpecifier = new CPPASTNamedTypeSpecifier();
                    namedTypeSpecifier.setName(simpleTypeTemplateParameter.getName());
                    id.setDeclSpecifier((IASTDeclSpecifier)namedTypeSpecifier);
                    templateId.addTemplateArgument((IASTTypeId)id);
                }
                ++n2;
            }
            parentName = templateId;
        }
        return parentName;
    }

    private static boolean classHasTemplates(IASTNode declarationParent) {
        return declarationParent.getParent() != null && declarationParent.getParent().getParent() instanceof ICPPASTTemplateDeclaration;
    }
}

