/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.wizards.classwizard.AbstractMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.core.runtime.CoreException;

public final class ConstructorMethodStub
extends AbstractMethodStub {
    private static String NAME = NewClassWizardMessages.getString("NewClassCodeGeneration.stub.constructor.name");

    public ConstructorMethodStub() {
        this(ASTAccessVisibility.PUBLIC, false);
    }

    public ConstructorMethodStub(ASTAccessVisibility access, boolean isInline) {
        super(NAME, access, false, isInline);
    }

    public String createMethodDeclaration(ITranslationUnit tu, String className, IBaseClassInfo[] baseClasses, String lineDelimiter) throws CoreException {
        StringBuffer buf = new StringBuffer();
        buf.append(className);
        buf.append("()");
        if (this.fIsInline) {
            buf.append('{');
            buf.append(lineDelimiter);
            String body = CodeGeneration.getConstructorBodyContent(tu, className, null, lineDelimiter);
            if (body != null) {
                buf.append(body);
                buf.append(lineDelimiter);
            }
            buf.append('}');
        } else {
            buf.append(";");
        }
        return buf.toString();
    }

    public String createMethodImplementation(ITranslationUnit tu, String className, IBaseClassInfo[] baseClasses, String lineDelimiter) throws CoreException {
        if (this.fIsInline) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(className);
        buf.append("::");
        buf.append(className);
        buf.append("()");
        buf.append(lineDelimiter);
        buf.append('{');
        buf.append(lineDelimiter);
        String body = CodeGeneration.getConstructorBodyContent(tu, className, null, lineDelimiter);
        if (body != null) {
            buf.append(body);
            buf.append(lineDelimiter);
        }
        buf.append('}');
        return buf.toString();
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean canModifyVirtual() {
        return false;
    }
}

