/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class AssignmentInConditionChecker
extends AbstractIndexAstChecker {
    private static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.AssignmentInConditionProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckCodeVisitor());
    }

    class CheckCodeVisitor
    extends ASTVisitor {
        CheckCodeVisitor() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expression) {
            if (this.isAssignmentExpression(expression) && this.isUsedAsCondition(expression)) {
                AssignmentInConditionChecker.this.reportProblem(AssignmentInConditionChecker.ER_ID, (IASTNode)expression, new Object[]{expression.getRawSignature()});
            }
            return 3;
        }

        private boolean isAssignmentExpression(IASTExpression e) {
            if (e instanceof IASTBinaryExpression) {
                IASTBinaryExpression binExpr = (IASTBinaryExpression)e;
                return binExpr.getOperator() == 17;
            }
            return false;
        }

        private boolean isUsedAsCondition(IASTExpression expression) {
            ASTNodeProperty prop = expression.getPropertyInParent();
            return prop == IASTForStatement.CONDITION || prop == IASTIfStatement.CONDITION;
        }
    }
}

