/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.model;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemReporterPersistent;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CodanMarkerProblemReporter
implements IProblemReporterPersistent {
    public void reportProblem(String id, IProblemLocation loc, Object ... args) {
        IResource file = loc.getFile();
        int lineNumber = loc.getLineNumber();
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        IProblem problem = CheckersRegistry.getInstance().getResourceProfile(file).findProblem(id);
        if (problem == null) {
            throw new IllegalArgumentException("Id is not registered:" + id);
        }
        if (!problem.isEnabled()) {
            return;
        }
        int severity = problem.getSeverity().intValue();
        String messagePattern = problem.getMessagePattern();
        String message = id;
        if (messagePattern == null) {
            if (args != null && args.length > 0 && args[0] instanceof String) {
                message = (String)args[0];
            }
        } else {
            message = MessageFormat.format(messagePattern, args);
        }
        this.reportProblem(id, problem.getMarkerType(), severity, file, lineNumber, loc.getStartingChar(), loc.getEndingChar(), message);
    }

    public void reportProblem(String id, String markerType, int severity, IResource file, int lineNumber, int startChar, int endChar, String message) {
        try {
            IMarker[] cur = file.findMarkers(markerType, false, 0);
            if (cur != null) {
                IMarker[] iMarkerArray = cur;
                int n = cur.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker element = iMarkerArray[n2];
                    int line = (Integer)element.getAttribute("lineNumber");
                    if (line == lineNumber) {
                        String mesg = (String)element.getAttribute("message");
                        int sev = (Integer)element.getAttribute("severity");
                        if (sev == severity && mesg.equals(message)) {
                            return;
                        }
                    }
                    ++n2;
                }
            }
            IMarker marker = file.createMarker(markerType);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("org.eclipse.core.resources.problemmarker", (Object)id);
            marker.setAttribute("charEnd", endChar);
            marker.setAttribute("charStart", startChar);
            marker.setAttribute("org.eclipse.cdt.core.problem", 42);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void deleteProblems(IResource file) {
        try {
            file.deleteMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 0);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void deleteAllProblems() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 2);
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
        }
    }

    public void deleteProblems(final IResource file, final IChecker checker) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker[] markers = file.findMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 2);
                    ICheckersRegistry reg = CodanRuntime.getInstance().getChechersRegistry();
                    int i = 0;
                    while (i < markers.length) {
                        IMarker m = markers[i];
                        String id = m.getAttribute("org.eclipse.core.resources.problemmarker", "");
                        Collection<IProblem> problems = reg.getRefProblems(checker);
                        for (IProblem iProblem : problems) {
                            if (!iProblem.getId().equals(id)) continue;
                            m.delete();
                        }
                        ++i;
                    }
                }
            }, null, 1, null);
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
        }
    }
}

