/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.model;

import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;

public class CodanProblem
implements IProblemWorkingCopy {
    private String id;
    private String name;
    private String message;
    private CodanSeverity severity = CodanSeverity.Warning;
    private boolean enabled = true;
    private IProblemPreference preference;
    private boolean frozen;
    private String description;
    private String markerType = "org.eclipse.cdt.codan.core.codanProblem";

    public CodanSeverity getSeverity() {
        return this.severity;
    }

    public CodanProblem(String problemId, String name) {
        this.id = problemId;
        this.name = name;
        this.frozen = false;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSeverity(CodanSeverity sev) {
        if (sev == null) {
            throw new NullPointerException();
        }
        this.severity = sev;
    }

    public void setEnabled(boolean checked) {
        this.enabled = checked;
    }

    public Object clone() throws CloneNotSupportedException {
        CodanProblem prob = (CodanProblem)super.clone();
        if (this.preference != null) {
            prob.preference = (IProblemPreference)this.preference.clone();
        }
        return prob;
    }

    public void setPreference(IProblemPreference value) {
        this.preference = value;
    }

    public IProblemPreference getPreference() {
        return this.preference;
    }

    public String getMessagePattern() {
        return this.message;
    }

    protected void freeze() {
        this.frozen = true;
    }

    public void setMessagePattern(String message) {
        this.checkSet();
        this.message = message;
    }

    protected void checkSet() {
        if (this.frozen) {
            throw new IllegalStateException("Object is unmodifieble");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(String type) {
        this.markerType = type;
    }
}

