/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.dialogs.CustomizeProblemDialog;
import org.eclipse.cdt.codan.internal.ui.preferences.FieldEditorOverlayPage;
import org.eclipse.cdt.codan.internal.ui.preferences.ProblemsTreeEditor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CodanPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    private IProblemProfile profile;
    private ISelectionChangedListener problemSelectionListener;
    private IProblem selectedProblem;
    private Group info;
    private Label infoDesc;
    private Label infoMessage;
    private Label infoParams;
    private Button infoButton;
    private ProblemsTreeEditor checkedTreeEditor;

    public CodanPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.cdt.codan.core"));
        this.problemSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CodanPreferencePage.this.info != null && event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection s = (ITreeSelection)event.getSelection();
                    if (s.getFirstElement() instanceof IProblem) {
                        CodanPreferencePage.this.setSelectedProblem((IProblem)s.getFirstElement());
                    } else {
                        CodanPreferencePage.this.setSelectedProblem(null);
                    }
                }
            }
        };
    }

    protected String getPageId() {
        return "org.eclipse.cdt.codan.internal.ui.preferences.CodanPreferencePage";
    }

    public void createFieldEditors() {
        this.profile = this.isPropertyPage() ? this.getRegistry().getResourceProfileWorkingCopy((IResource)this.getElement()) : this.getRegistry().getWorkspaceProfile();
        this.checkedTreeEditor = new ProblemsTreeEditor(this.getFieldEditorParent(), this.profile);
        this.addField(this.checkedTreeEditor);
        this.checkedTreeEditor.getTreeViewer().addSelectionChangedListener(this.problemSelectionListener);
        this.checkedTreeEditor.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CodanPreferencePage.this.openCustomizeDialog();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        this.createInfoControl(comp);
        return comp;
    }

    private void createInfoControl(Composite comp) {
        this.info = new Group(comp, 0);
        this.info.setLayoutData((Object)new GridData(1808));
        this.info.setLayout((Layout)new GridLayout(3, false));
        this.info.setText(CodanUIMessages.CodanPreferencePage_Info);
        GridDataFactory gdLab = GridDataFactory.swtDefaults().align(1, 1).grab(false, false);
        GridDataFactory gdFact = GridDataFactory.swtDefaults().align(1, 1).grab(true, true);
        Label labelMessage = new Label((Composite)this.info, 0);
        labelMessage.setText(CodanUIMessages.CodanPreferencePage_MessageLabel);
        labelMessage.setLayoutData((Object)gdLab.create());
        this.infoMessage = new Label((Composite)this.info, 64);
        this.infoMessage.setLayoutData((Object)gdFact.copy().span(2, 1).create());
        Label labelDesc = new Label((Composite)this.info, 0);
        labelDesc.setText(CodanUIMessages.CodanPreferencePage_Description);
        labelDesc.setLayoutData((Object)gdLab.create());
        this.infoDesc = new Label((Composite)this.info, 64);
        PixelConverter pixelConverter = new PixelConverter((Control)comp);
        this.infoDesc.setLayoutData((Object)gdFact.copy().span(2, 1).hint(pixelConverter.convertWidthInCharsToPixels(60), pixelConverter.convertHeightInCharsToPixels(3)).create());
        Label labelParams = new Label((Composite)this.info, 0);
        labelParams.setText(CodanUIMessages.CodanPreferencePage_Parameters);
        labelParams.setLayoutData((Object)gdLab.create());
        this.infoParams = new Label((Composite)this.info, 0);
        this.infoParams.setLayoutData((Object)gdFact.create());
        this.infoButton = new Button((Composite)this.info, 8);
        this.infoButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 1).create());
        this.infoButton.setText(CodanUIMessages.CodanPreferencePage_Customize);
        this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodanPreferencePage.this.openCustomizeDialog();
            }
        });
        this.restoreWidgetValues();
    }

    protected void setSelectedProblem(IProblem problem) {
        this.selectedProblem = problem;
        this.updateProblemInfo();
    }

    protected ICheckersRegistry getRegistry() {
        return CodanRuntime.getInstance().getChechersRegistry();
    }

    public boolean performOk() {
        this.saveWidgetValues();
        this.getRegistry().updateProfile((IResource)this.getElement(), null);
        return super.performOk();
    }

    private void saveWidgetValues() {
        CodanUIActivator.getDefault().getDialogSettings().put(this.getWidgetId(), this.selectedProblem == null ? "" : this.selectedProblem.getId());
    }

    private void restoreWidgetValues() {
        String id = CodanUIActivator.getDefault().getDialogSettings().get(this.getWidgetId());
        if (id != null && id.length() > 0) {
            this.checkedTreeEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.profile.findProblem(id)), true);
        } else {
            this.setSelectedProblem(null);
        }
    }

    protected String getWidgetId() {
        return String.valueOf(this.getPageId()) + ".selection";
    }

    private void updateProblemInfo() {
        if (this.selectedProblem == null) {
            this.infoMessage.setText("");
            this.infoDesc.setText("");
            this.infoParams.setText("");
            this.infoButton.setEnabled(false);
        } else {
            IProblemPreference pref = this.selectedProblem.getPreference();
            String description = this.selectedProblem.getDescription();
            if (description == null) {
                description = CodanUIMessages.CodanPreferencePage_NoInfo;
            }
            String messagePattern = this.selectedProblem.getMessagePattern();
            String message = CodanUIMessages.CodanPreferencePage_NoInfo;
            if (messagePattern != null) {
                message = MessageFormat.format(messagePattern, "X", "Y", "Z");
            }
            this.infoMessage.setText(message);
            this.infoDesc.setText(description);
            this.infoParams.setText(pref == null ? CodanUIMessages.CodanPreferencePage_NoInfo : CodanUIMessages.CodanPreferencePage_HasPreferences);
            this.infoButton.setEnabled(true);
        }
        this.info.layout(true);
    }

    public void init(IWorkbench workbench) {
    }

    protected void openCustomizeDialog() {
        CustomizeProblemDialog d = new CustomizeProblemDialog(this.getShell(), this.selectedProblem, (IResource)this.getElement());
        d.open();
    }
}

