/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemCategory;
import org.eclipse.cdt.codan.core.model.IProblemElement;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.core.CodanPreferencesLoader;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.preferences.CheckedTreeEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ProblemsTreeEditor
extends CheckedTreeEditor {
    private CodanPreferencesLoader codanPreferencesLoader = new CodanPreferencesLoader();

    public ProblemsTreeEditor() {
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof IProblemWorkingCopy) {
            ((IProblemWorkingCopy)element).setEnabled(event.getChecked());
        } else if (element instanceof IProblemCategory) {
            IProblemCategory cat = (IProblemCategory)element;
            IProblemElement[] children = cat.getChildren();
            int i = 0;
            while (i < children.length) {
                IProblemElement pe = children[i];
                this.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.getTreeViewer(), (Object)pe, event.getChecked()));
                ++i;
            }
        }
        this.getTreeViewer().refresh();
    }

    public ProblemsTreeEditor(Composite parent, IProblemProfile profile) {
        super("problems", CodanUIMessages.ProblemsTreeEditor_Problems, parent);
        this.setEmptySelectionAllowed(true);
        this.getTreeViewer().getTree().setHeaderVisible(true);
        this.getTreeViewer().setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.getTreeViewer().setCheckStateProvider((ICheckStateProvider)new ProblemsCheckStateProvider());
        TreeViewerColumn column1 = new TreeViewerColumn((TreeViewer)this.getTreeViewer(), 0);
        column1.getColumn().setWidth(300);
        column1.getColumn().setText(CodanUIMessages.ProblemsTreeEditor_NameColumn);
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    return p.getName();
                }
                if (element instanceof IProblemCategory) {
                    IProblemCategory p = (IProblemCategory)element;
                    return p.getName();
                }
                return null;
            }
        });
        TreeViewerColumn column2 = new TreeViewerColumn((TreeViewer)this.getTreeViewer(), 0);
        column2.getColumn().setWidth(100);
        column2.getColumn().setText(CodanUIMessages.ProblemsTreeEditor_SeverityColumn);
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    switch (p.getSeverity().intValue()) {
                        case 0: {
                            return images.getImage("IMG_OBJS_INFO_TSK");
                        }
                        case 1: {
                            return images.getImage("IMG_OBJS_WARN_TSK");
                        }
                        case 2: {
                            return images.getImage("IMG_OBJS_ERROR_TSK");
                        }
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    return p.getSeverity().toString();
                }
                return null;
            }
        });
        column2.setEditingSupport(new EditingSupport((ColumnViewer)this.getTreeViewer()){

            protected boolean canEdit(Object element) {
                return element instanceof IProblem;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)ProblemsTreeEditor.this.getTreeViewer().getTree(), CodanSeverity.stringValues());
            }

            protected Object getValue(Object element) {
                return ((IProblem)element).getSeverity().intValue();
            }

            protected void setValue(Object element, Object value) {
                int index = (Integer)value;
                CodanSeverity val = CodanSeverity.values()[index];
                ((IProblemWorkingCopy)element).setSeverity(val);
                ProblemsTreeEditor.this.getTreeViewer().update(element, null);
            }
        });
        this.getTreeViewer().setAutoExpandLevel(2);
        this.codanPreferencesLoader.setInput(profile);
        this.getViewer().setInput((Object)profile);
    }

    protected void doLoad() {
        if (this.getTreeControl() != null) {
            IProblem[] probs = this.codanPreferencesLoader.getProblems();
            int i = 0;
            while (i < probs.length) {
                String id = probs[i].getId();
                String s = this.getPreferenceStore().getString(id);
                if (s == null || s.length() == 0) {
                    s = this.codanPreferencesLoader.getProperty(id);
                }
                this.codanPreferencesLoader.setProperty(id, s);
                ++i;
            }
            this.getViewer().setInput((Object)this.codanPreferencesLoader.getInput());
        }
    }

    protected void doLoadDefault() {
        if (this.getTreeControl() != null) {
            IProblem[] probs = this.codanPreferencesLoader.getProblems();
            int i = 0;
            while (i < probs.length) {
                String id = probs[i].getId();
                String s = this.getPreferenceStore().getDefaultString(id);
                if (s == null || s.length() == 0) {
                    s = this.codanPreferencesLoader.getProperty(id);
                }
                this.codanPreferencesLoader.setProperty(id, s);
                ++i;
            }
            this.getViewer().setInput((Object)this.codanPreferencesLoader.getInput());
        }
    }

    protected void doStore() {
        this.codanPreferencesLoader.setInput((IProblemProfile)this.getViewer().getInput());
        IProblem[] probs = this.codanPreferencesLoader.getProblems();
        int i = 0;
        while (i < probs.length) {
            String id = probs[i].getId();
            String s = this.codanPreferencesLoader.getProperty(id);
            this.getPreferenceStore().setValue(id, s);
            String params = this.codanPreferencesLoader.getPreferencesString(id);
            if (params != null) {
                this.getPreferenceStore().setValue(this.codanPreferencesLoader.getPreferencesKey(id), params);
            }
            ++i;
        }
    }

    protected Object modelFromString(String s) {
        return this.codanPreferencesLoader.getInput();
    }

    protected String modelToString(Object model) {
        return "";
    }

    class ProblemsCheckStateProvider
    implements ICheckStateProvider {
        ProblemsCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof IProblem) {
                IProblem p = (IProblem)element;
                return p.isEnabled();
            }
            if (element instanceof IProblemCategory) {
                IProblemCategory p = (IProblemCategory)element;
                IProblemElement[] children = p.getChildren();
                int i = 0;
                while (i < children.length) {
                    IProblemElement object = children[i];
                    if (this.isChecked(object)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            if (element instanceof IProblem) {
                return false;
            }
            if (element instanceof IProblemCategory) {
                IProblemCategory p = (IProblemCategory)element;
                IProblemElement[] children = p.getChildren();
                boolean all_checked = true;
                boolean all_unchecked = true;
                int i = 0;
                while (i < children.length) {
                    IProblemElement object = children[i];
                    if (this.isChecked(object)) {
                        all_unchecked = false;
                    } else {
                        all_checked = false;
                    }
                    ++i;
                }
                return !all_checked && !all_unchecked;
            }
            return false;
        }
    }

    class ProblemsContentProvider
    implements IContentProvider,
    ITreeContentProvider {
        ProblemsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof IProblemCategory) {
                return ((IProblemCategory)parentElement).getChildren();
            }
            if (parentElement instanceof IProblemProfile) {
                return ((IProblemProfile)parentElement).getRoot().getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }
    }
}

