/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.ui.CodanEditorUtility;
import org.eclipse.core.resources.IMarker;

public abstract class AbstractCodanProblemDetailsProvider {
    protected IMarker marker;

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    protected String getProblemMessage() {
        String message = this.marker.getAttribute("message", "");
        return message;
    }

    protected String getProblemId() {
        String id = this.marker.getAttribute("org.eclipse.core.resources.problemmarker", null);
        return id;
    }

    public abstract boolean isApplicable(String var1);

    public String getStyledProblemMessage() {
        String message = this.escapeForLink(this.getProblemMessage());
        String href = this.getLocationHRef();
        String link = href.replaceFirst("^file:", "");
        link = link.replaceFirst("#(\\d+)$", ":$1");
        return "<a href=\"" + href + "\">" + link + "</a> \n" + message;
    }

    protected String getLocationHRef() {
        return CodanEditorUtility.getLocationHRef(this.marker);
    }

    public String getStyledProblemDescription() {
        String id = this.getProblemId();
        if (id == null) {
            return "";
        }
        IProblem problem = CodanRuntime.getInstance().getChechersRegistry().getDefaultProfile().findProblem(id);
        return this.escapeForLink(problem.getDescription());
    }

    protected String escapeForLink(String text) {
        return text.replaceAll("&", "&&");
    }
}

