/*******************************************************************************
* Copyright (c) 2006, 2010 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*********************************************************************************/

// This file was generated by LPG

package org.eclipse.cdt.internal.core.dom.lrparser.cpp;

import lpg.lpgjavaruntime.*;

import java.util.*;
import org.eclipse.cdt.core.dom.ast.*;
import org.eclipse.cdt.core.dom.lrparser.IDOMTokenMap;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.ITokenCollector;
import org.eclipse.cdt.core.dom.lrparser.CPreprocessorAdapter;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.FixedBacktrackingParser;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.index.IIndex;

import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.core.dom.lrparser.ISecondaryParser;

import org.eclipse.cdt.core.dom.ast.cpp.*;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPSecondaryParserFactory;

public class CPPNoCastExpressionParser extends PrsStream implements RuleAction, ITokenStream, 
                                                       ITokenCollector, IParser< IASTExpression > 
                                                        , ISecondaryParser< IASTExpression >   
{
    private static ParseTable prs = new CPPNoCastExpressionParserprs();
    private FixedBacktrackingParser btParser;

    public FixedBacktrackingParser getParser() { return btParser; }
    private void setResult(Object object) { btParser.setSym1(object); }
    public Object getRhsSym(int i) { return btParser.getSym(i); }

    public int getRhsTokenIndex(int i) { return btParser.getToken(i); }
    public IToken getRhsIToken(int i) { return super.getIToken(getRhsTokenIndex(i)); }
    
    public int getRhsFirstTokenIndex(int i) { return btParser.getFirstToken(i); }
    public IToken getRhsFirstIToken(int i) { return super.getIToken(getRhsFirstTokenIndex(i)); }

    public int getRhsLastTokenIndex(int i) { return btParser.getLastToken(i); }
    public IToken getRhsLastIToken(int i) { return super.getIToken(getRhsLastTokenIndex(i)); }

    public int getLeftSpan() { return btParser.getFirstToken(); }
    public IToken getLeftIToken()  { return super.getIToken(getLeftSpan()); }

    public int getRightSpan() { return btParser.getLastToken(); }
    public IToken getRightIToken() { return super.getIToken(getRightSpan()); }

    public int getRhsErrorTokenIndex(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (err instanceof ErrorToken ? index : 0);
    }
    public ErrorToken getRhsErrorIToken(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (ErrorToken) (err instanceof ErrorToken ? err : null);
    }

    public CPPNoCastExpressionParser(LexStream lexStream)
    {
        super(lexStream);

        try
        {
            super.remapTerminalSymbols(orderedTerminalSymbols(), CPPNoCastExpressionParserprs.EOFT_SYMBOL);
        }
        catch(NullExportedSymbolsException e) {
        }
        catch(NullTerminalSymbolsException e) {
        }
        catch(UnimplementedTerminalsException e)
        {
            java.util.ArrayList unimplemented_symbols = e.getSymbols();
            System.out.println("The Lexer will not scan the following token(s):");
            for (int i = 0; i < unimplemented_symbols.size(); i++)
            {
                Integer id = (Integer) unimplemented_symbols.get(i);
                System.out.println("    " + CPPNoCastExpressionParsersym.orderedTerminalSymbols[id.intValue()]);               
            }
            System.out.println();                        
        }
        catch(UndefinedEofSymbolException e)
        {
            throw new Error(new UndefinedEofSymbolException
                                ("The Lexer does not implement the Eof symbol " +
                                 CPPNoCastExpressionParsersym.orderedTerminalSymbols[CPPNoCastExpressionParserprs.EOFT_SYMBOL]));
        } 
    }

    public String[] orderedTerminalSymbols() { return CPPNoCastExpressionParsersym.orderedTerminalSymbols; }
    public String getTokenKindName(int kind) { return CPPNoCastExpressionParsersym.orderedTerminalSymbols[kind]; }
    public int getEOFTokenKind() { return CPPNoCastExpressionParserprs.EOFT_SYMBOL; }
    public PrsStream getParseStream() { return (PrsStream) this; }
    
    //
    // Report error message for given error_token.
    //
    public final void reportErrorTokenMessage(int error_token, String msg)
    {
        int firsttok = super.getFirstErrorToken(error_token),
            lasttok = super.getLastErrorToken(error_token);
        String location = super.getFileName() + ':' +
                          (firsttok > lasttok
                                    ? (super.getEndLine(lasttok) + ":" + super.getEndColumn(lasttok))
                                    : (super.getLine(error_token) + ":" +
                                       super.getColumn(error_token) + ":" +
                                       super.getEndLine(error_token) + ":" +
                                       super.getEndColumn(error_token)))
                          + ": ";
        super.reportError((firsttok > lasttok ? ParseErrorCodes.INSERTION_CODE : ParseErrorCodes.SUBSTITUTION_CODE), location, msg);
    }

    public void parser()
    {
        parser(null, 0);
    }
    
    public void parser(Monitor monitor)
    {
        parser(monitor, 0);
    }
    
    public void parser(int error_repair_count)
    {
        parser(null, error_repair_count);
    }

    public void parser(Monitor monitor, int error_repair_count)
    {
        try
        {
            btParser = new FixedBacktrackingParser(monitor, (TokenStream) this, prs, (RuleAction) this);
        }
        catch (NotBacktrackParseTableException e)
        {
            throw new Error(new NotBacktrackParseTableException
                                ("Regenerate CPPNoCastExpressionParserprs.java with -BACKTRACK option"));
        }
        catch (BadParseSymFileException e)
        {
            throw new Error(new BadParseSymFileException("Bad Parser Symbol File -- CPPNoCastExpressionParsersym.java"));
        }

        try
        {
            btParser.parse(error_repair_count);
        }
        catch (BadParseException e)
        {
            reset(e.error_token); // point to error token
            DiagnoseParser diagnoseParser = new DiagnoseParser(this, prs);
            diagnoseParser.diagnose(e.error_token);
        }
    }


private  CPPBuildASTParserAction  action;
private IASTCompletionNode compNode;


public CPPNoCastExpressionParser(IScanner scanner, IDOMTokenMap tokenMap, IBuiltinBindingsProvider builtinBindingsProvider, IIndex index, Map<String,String> properties) {
	initActions(properties);
	action.initializeTranslationUnit(scanner, builtinBindingsProvider, index);
	CPreprocessorAdapter.runCPreprocessor(scanner, this, tokenMap);
}

private void initActions(Map<String,String> properties) {
	ScopedStack<Object> astStack = new ScopedStack<Object>();
	
	action = new  CPPBuildASTParserAction (this, astStack,  CPPNodeFactory.getDefault() ,  CPPSecondaryParserFactory.getDefault() );
	action.setParserProperties(properties);
	
	 
}


public void addToken(IToken token) {
	token.setKind(mapKind(token.getKind())); // TODO does mapKind need to be called?
	super.addToken(token);
}


public  IASTExpression  parse() {
	// this has to be done, or... kaboom!
	setStreamLength(getSize());
	
	final int errorRepairCount = -1;  // -1 means full error handling
	parser(null, errorRepairCount); // do the actual parse
	super.resetTokenStream(); // allow tokens to be garbage collected

	compNode = action.getASTCompletionNode(); // the completion node may be null
	return ( IASTExpression ) action.getParseResult();
}


public IASTCompletionNode getCompletionNode() {
	return compNode;
}

// uncomment this method to use with backtracking parser
public List<IToken> getRuleTokens() {
    return getTokens().subList(getLeftSpan(), getRightSpan() + 1);
}

public String[] getOrderedTerminalSymbols() {
	return CPPNoCastExpressionParsersym.orderedTerminalSymbols;
}

@SuppressWarnings("nls")
public String getName() {
	return "CPPNoCastExpressionParser";
}



private ITokenMap tokenMap = null;

public void setTokens(List<IToken> tokens) {
	resetTokenStream();
	addToken(new Token(null, 0, 0, 0)); // dummy token
	for(IToken token : tokens) {
		token.setKind(tokenMap.mapKind(token.getKind()));
		addToken(token);
	}
	addToken(new Token(null, 0, 0, CPPNoCastExpressionParsersym.TK_EOF_TOKEN));
}

public CPPNoCastExpressionParser(ITokenStream stream, Map<String,String> properties) {  // constructor for creating secondary parser
	initActions(properties);
	tokenMap = new TokenMap(CPPNoCastExpressionParsersym.orderedTerminalSymbols, stream.getOrderedTerminalSymbols());
}	


    public void ruleAction(int ruleNumber)
    {
        switch (ruleNumber)
        {
  
            //
            // Rule 1:  <openscope-ast> ::= $Empty
            //
            case 1: { action.   openASTScope();             break;
            }  
  
            //
            // Rule 2:  <empty> ::= $Empty
            //
            case 2: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 13:  translation_unit ::= declaration_seq_opt
            //
            case 13: { action.   consumeTranslationUnit();            break;
            }  
  
            //
            // Rule 16:  literal ::= integer
            //
            case 16: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_integer_constant);            break;
            }  
  
            //
            // Rule 17:  literal ::= floating
            //
            case 17: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_float_constant);            break;
            }  
  
            //
            // Rule 18:  literal ::= charconst
            //
            case 18: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_char_constant);            break;
            }  
  
            //
            // Rule 19:  literal ::= stringlit
            //
            case 19: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_string_literal);            break;
            }  
  
            //
            // Rule 20:  literal ::= true
            //
            case 20: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_true);            break;
            }  
  
            //
            // Rule 21:  literal ::= false
            //
            case 21: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_false);            break;
            }  
  
            //
            // Rule 22:  literal ::= this
            //
            case 22: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_this);            break;
            }  
  
            //
            // Rule 24:  primary_expression ::= ( expression )
            //
            case 24: { action.   consumeExpressionBracketed();             break;
            }  
  
            //
            // Rule 26:  id_expression ::= qualified_or_unqualified_name
            //
            case 26: { action.   consumeExpressionName();             break;
            }  
  
            //
            // Rule 33:  unqualified_id_name ::= ~ identifier_token
            //
            case 33: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 34:  unqualified_id_name ::= ~ template_id_name
            //
            case 34: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 35:  identifier_name ::= identifier_token
            //
            case 35: { action.   consumeIdentifierName();             break;
            }  
  
            //
            // Rule 36:  template_opt ::= template
            //
            case 36: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 37:  template_opt ::= $Empty
            //
            case 37: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 38:  dcolon_opt ::= ::
            //
            case 38: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 39:  dcolon_opt ::= $Empty
            //
            case 39: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 40:  qualified_id_name ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name
            //
            case 40: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 41:  qualified_id_name ::= :: unqualified_id_name
            //
            case 41: { action.   consumeGlobalQualifiedId();             break;
            }  
  
            //
            // Rule 42:  nested_name_specifier ::= class_or_namespace_name :: nested_name_specifier_with_template
            //
            case 42: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 43:  nested_name_specifier ::= class_or_namespace_name ::
            //
            case 43: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 44:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template :: nested_name_specifier_with_template
            //
            case 44: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 45:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template ::
            //
            case 45: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 46:  class_or_namespace_name_with_template ::= template_opt class_or_namespace_name
            //
            case 46: { action.   consumeNameWithTemplateKeyword();             break;
            }  
  
            //
            // Rule 48:  nested_name_specifier_opt ::= $Empty
            //
            case 48: { action.   consumeNestedNameSpecifierEmpty();             break;
            }  
  
            //
            // Rule 51:  postfix_expression ::= postfix_expression [ expression ]
            //
            case 51: { action.   consumeExpressionArraySubscript();             break;
            }  
  
            //
            // Rule 52:  postfix_expression ::= postfix_expression ( expression_list_opt )
            //
            case 52: { action.   consumeExpressionFunctionCall();             break;
            }  
  
            //
            // Rule 53:  postfix_expression ::= simple_type_specifier ( expression_list_opt )
            //
            case 53: { action.   consumeExpressionSimpleTypeConstructor();            break;
            }  
  
            //
            // Rule 54:  postfix_expression ::= typename dcolon_opt nested_name_specifier <empty> identifier_name ( expression_list_opt )
            //
            case 54: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 55:  postfix_expression ::= typename dcolon_opt nested_name_specifier template_opt template_id_name ( expression_list_opt )
            //
            case 55: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 56:  postfix_expression ::= postfix_expression . qualified_or_unqualified_name
            //
            case 56: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 57:  postfix_expression ::= postfix_expression -> qualified_or_unqualified_name
            //
            case 57: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 58:  postfix_expression ::= postfix_expression . template qualified_or_unqualified_name
            //
            case 58: { action.   consumeExpressionFieldReference(false, true);             break;
            }  
  
            //
            // Rule 59:  postfix_expression ::= postfix_expression -> template qualified_or_unqualified_name
            //
            case 59: { action.   consumeExpressionFieldReference(true, true);             break;
            }  
  
            //
            // Rule 60:  postfix_expression ::= postfix_expression . pseudo_destructor_name
            //
            case 60: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 61:  postfix_expression ::= postfix_expression -> pseudo_destructor_name
            //
            case 61: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 62:  postfix_expression ::= postfix_expression ++
            //
            case 62: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixIncr);             break;
            }  
  
            //
            // Rule 63:  postfix_expression ::= postfix_expression --
            //
            case 63: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixDecr);             break;
            }  
  
            //
            // Rule 64:  postfix_expression ::= dynamic_cast < type_id > ( expression )
            //
            case 64: { action.   consumeExpressionCast(ICPPASTCastExpression.op_dynamic_cast);             break;
            }  
  
            //
            // Rule 65:  postfix_expression ::= static_cast < type_id > ( expression )
            //
            case 65: { action.   consumeExpressionCast(ICPPASTCastExpression.op_static_cast);             break;
            }  
  
            //
            // Rule 66:  postfix_expression ::= reinterpret_cast < type_id > ( expression )
            //
            case 66: { action.   consumeExpressionCast(ICPPASTCastExpression.op_reinterpret_cast);             break;
            }  
  
            //
            // Rule 67:  postfix_expression ::= const_cast < type_id > ( expression )
            //
            case 67: { action.   consumeExpressionCast(ICPPASTCastExpression.op_const_cast);             break;
            }  
  
            //
            // Rule 68:  postfix_expression ::= typeid ( expression )
            //
            case 68: { action.   consumeExpressionUnaryOperator(ICPPASTUnaryExpression.op_typeid);             break;
            }  
  
            //
            // Rule 69:  postfix_expression ::= typeid ( type_id )
            //
            case 69: { action.   consumeExpressionTypeId(ICPPASTTypeIdExpression.op_typeid);            break;
            }  
  
            //
            // Rule 70:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt type_name :: destructor_type_name
            //
            case 70: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 71:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier template template_id_name :: destructor_type_name
            //
            case 71: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 72:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt destructor_type_name
            //
            case 72: { action.   consumePsudoDestructorName(false);             break;
            }  
  
            //
            // Rule 73:  destructor_type_name ::= ~ identifier_token
            //
            case 73: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 74:  destructor_type_name ::= ~ template_id_name
            //
            case 74: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 78:  unary_expression ::= ++ cast_expression
            //
            case 78: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixIncr);             break;
            }  
  
            //
            // Rule 79:  unary_expression ::= -- cast_expression
            //
            case 79: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixDecr);             break;
            }  
  
            //
            // Rule 80:  unary_expression ::= & cast_expression
            //
            case 80: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_amper);             break;
            }  
  
            //
            // Rule 81:  unary_expression ::= * cast_expression
            //
            case 81: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_star);             break;
            }  
  
            //
            // Rule 82:  unary_expression ::= + cast_expression
            //
            case 82: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 83:  unary_expression ::= - cast_expression
            //
            case 83: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 84:  unary_expression ::= ~ cast_expression
            //
            case 84: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_tilde);             break;
            }  
  
            //
            // Rule 85:  unary_expression ::= ! cast_expression
            //
            case 85: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_not);             break;
            }  
  
            //
            // Rule 86:  unary_expression ::= sizeof unary_expression
            //
            case 86: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_sizeof);             break;
            }  
  
            //
            // Rule 87:  unary_expression ::= sizeof ( type_id )
            //
            case 87: { action.   consumeExpressionTypeId(ICPPASTTypeIdExpression.op_sizeof);            break;
            }  
  
            //
            // Rule 88:  new_expression ::= dcolon_opt new new_placement_opt new_type_id <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 88: { action.   consumeExpressionNew(true);             break;
            }  
  
            //
            // Rule 89:  new_expression ::= dcolon_opt new new_placement_opt ( type_id ) <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 89: { action.   consumeExpressionNew(false);             break;
            }  
  
            //
            // Rule 91:  new_placement_opt ::= $Empty
            //
            case 91: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 92:  new_type_id ::= type_specifier_seq
            //
            case 92: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 93:  new_type_id ::= type_specifier_seq new_declarator
            //
            case 93: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 94:  new_declarator ::= <openscope-ast> new_pointer_operators
            //
            case 94: { action.   consumeNewDeclarator();            break;
            }  
  
            //
            // Rule 101:  new_initializer ::= ( expression_list_opt )
            //
            case 101: { action.   consumeNewInitializer();             break;
            }  
  
            //
            // Rule 103:  new_initializer_opt ::= $Empty
            //
            case 103: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 104:  delete_expression ::= dcolon_opt delete cast_expression
            //
            case 104: { action.   consumeExpressionDelete(false);             break;
            }  
  
            //
            // Rule 105:  delete_expression ::= dcolon_opt delete [ ] cast_expression
            //
            case 105: { action.   consumeExpressionDelete(true);             break;
            }  
  
            //
            // Rule 108:  pm_expression ::= pm_expression .* cast_expression
            //
            case 108: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmdot);             break;
            }  
  
            //
            // Rule 109:  pm_expression ::= pm_expression ->* cast_expression
            //
            case 109: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmarrow);             break;
            }  
  
            //
            // Rule 111:  multiplicative_expression ::= multiplicative_expression * pm_expression
            //
            case 111: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiply);             break;
            }  
  
            //
            // Rule 112:  multiplicative_expression ::= multiplicative_expression / pm_expression
            //
            case 112: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divide);             break;
            }  
  
            //
            // Rule 113:  multiplicative_expression ::= multiplicative_expression % pm_expression
            //
            case 113: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_modulo);             break;
            }  
  
            //
            // Rule 115:  additive_expression ::= additive_expression + multiplicative_expression
            //
            case 115: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 116:  additive_expression ::= additive_expression - multiplicative_expression
            //
            case 116: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 118:  shift_expression ::= shift_expression << additive_expression
            //
            case 118: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeft);             break;
            }  
  
            //
            // Rule 119:  shift_expression ::= shift_expression >> additive_expression
            //
            case 119: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRight);             break;
            }  
  
            //
            // Rule 121:  relational_expression ::= relational_expression < shift_expression
            //
            case 121: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessThan);             break;
            }  
  
            //
            // Rule 122:  relational_expression ::= relational_expression > shift_expression
            //
            case 122: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterThan);             break;
            }  
  
            //
            // Rule 123:  relational_expression ::= relational_expression <= shift_expression
            //
            case 123: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessEqual);             break;
            }  
  
            //
            // Rule 124:  relational_expression ::= relational_expression >= shift_expression
            //
            case 124: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterEqual);             break;
            }  
  
            //
            // Rule 126:  equality_expression ::= equality_expression == relational_expression
            //
            case 126: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_equals);             break;
            }  
  
            //
            // Rule 127:  equality_expression ::= equality_expression != relational_expression
            //
            case 127: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_notequals);             break;
            }  
  
            //
            // Rule 129:  and_expression ::= and_expression & equality_expression
            //
            case 129: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAnd);             break;
            }  
  
            //
            // Rule 131:  exclusive_or_expression ::= exclusive_or_expression ^ and_expression
            //
            case 131: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXor);             break;
            }  
  
            //
            // Rule 133:  inclusive_or_expression ::= inclusive_or_expression | exclusive_or_expression
            //
            case 133: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOr);             break;
            }  
  
            //
            // Rule 135:  logical_and_expression ::= logical_and_expression && inclusive_or_expression
            //
            case 135: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalAnd);             break;
            }  
  
            //
            // Rule 137:  logical_or_expression ::= logical_or_expression || logical_and_expression
            //
            case 137: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalOr);             break;
            }  
  
            //
            // Rule 139:  conditional_expression ::= logical_or_expression ? expression : assignment_expression
            //
            case 139: { action.   consumeExpressionConditional();             break;
            }  
  
            //
            // Rule 140:  throw_expression ::= throw
            //
            case 140: { action.   consumeExpressionThrow(false);             break;
            }  
  
            //
            // Rule 141:  throw_expression ::= throw assignment_expression
            //
            case 141: { action.   consumeExpressionThrow(true);             break;
            }  
  
            //
            // Rule 144:  assignment_expression ::= logical_or_expression = assignment_expression
            //
            case 144: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_assign);             break;
            }  
  
            //
            // Rule 145:  assignment_expression ::= logical_or_expression *= assignment_expression
            //
            case 145: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiplyAssign);             break;
            }  
  
            //
            // Rule 146:  assignment_expression ::= logical_or_expression /= assignment_expression
            //
            case 146: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divideAssign);             break;
            }  
  
            //
            // Rule 147:  assignment_expression ::= logical_or_expression %= assignment_expression
            //
            case 147: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_moduloAssign);             break;
            }  
  
            //
            // Rule 148:  assignment_expression ::= logical_or_expression += assignment_expression
            //
            case 148: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plusAssign);             break;
            }  
  
            //
            // Rule 149:  assignment_expression ::= logical_or_expression -= assignment_expression
            //
            case 149: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minusAssign);             break;
            }  
  
            //
            // Rule 150:  assignment_expression ::= logical_or_expression >>= assignment_expression
            //
            case 150: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRightAssign);             break;
            }  
  
            //
            // Rule 151:  assignment_expression ::= logical_or_expression <<= assignment_expression
            //
            case 151: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeftAssign);             break;
            }  
  
            //
            // Rule 152:  assignment_expression ::= logical_or_expression &= assignment_expression
            //
            case 152: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAndAssign);             break;
            }  
  
            //
            // Rule 153:  assignment_expression ::= logical_or_expression ^= assignment_expression
            //
            case 153: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXorAssign);             break;
            }  
  
            //
            // Rule 154:  assignment_expression ::= logical_or_expression |= assignment_expression
            //
            case 154: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOrAssign);             break;
            }  
  
            //
            // Rule 156:  expression_list ::= <openscope-ast> expression_list_actual
            //
            case 156: { action.   consumeExpressionList();             break;
            }  
  
            //
            // Rule 160:  expression_list_opt ::= $Empty
            //
            case 160: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 162:  expression_opt ::= $Empty
            //
            case 162: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 165:  constant_expression_opt ::= $Empty
            //
            case 165: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 174:  statement ::= ERROR_TOKEN
            //
            case 174: { action.   consumeStatementProblem();             break;
            }  
  
            //
            // Rule 175:  labeled_statement ::= identifier : statement
            //
            case 175: { action.   consumeStatementLabeled();             break;
            }  
  
            //
            // Rule 176:  labeled_statement ::= case constant_expression : statement
            //
            case 176: { action.   consumeStatementCase();             break;
            }  
  
            //
            // Rule 177:  labeled_statement ::= default : statement
            //
            case 177: { action.   consumeStatementDefault();             break;
            }  
  
            //
            // Rule 178:  expression_statement ::= expression ;
            //
            case 178: { action.   consumeStatementExpression();             break;
            }  
  
            //
            // Rule 179:  expression_statement ::= ;
            //
            case 179: { action.   consumeStatementNull();             break;
            }  
  
            //
            // Rule 180:  compound_statement ::= { <openscope-ast> statement_seq }
            //
            case 180: { action.   consumeStatementCompoundStatement(true);             break;
            }  
  
            //
            // Rule 181:  compound_statement ::= { }
            //
            case 181: { action.   consumeStatementCompoundStatement(false);             break;
            }  
  
            //
            // Rule 184:  selection_statement ::= if ( condition ) statement
            //
            case 184: { action.   consumeStatementIf(false);             break;
            }  
  
            //
            // Rule 185:  selection_statement ::= if ( condition ) statement else statement
            //
            case 185: { action.   consumeStatementIf(true);             break;
            }  
  
            //
            // Rule 186:  selection_statement ::= switch ( condition ) statement
            //
            case 186: { action.   consumeStatementSwitch();             break;
            }  
  
            //
            // Rule 188:  condition ::= type_specifier_seq declarator = assignment_expression
            //
            case 188: { action.   consumeConditionDeclaration();             break;
            }  
  
            //
            // Rule 190:  condition_opt ::= $Empty
            //
            case 190: { action.   consumeEmpty();            break;
            }  
  
            //
            // Rule 191:  iteration_statement ::= while ( condition ) statement
            //
            case 191: { action.   consumeStatementWhileLoop();             break;
            }  
  
            //
            // Rule 192:  iteration_statement ::= do statement while ( expression ) ;
            //
            case 192: { action.   consumeStatementDoLoop(true);             break;
            }  
  
            //
            // Rule 193:  iteration_statement ::= do statement
            //
            case 193: { action.   consumeStatementDoLoop(false);             break;
            }  
  
            //
            // Rule 194:  iteration_statement ::= for ( for_init_statement condition_opt ; expression_opt ) statement
            //
            case 194: { action.  consumeStatementForLoop();            break;
            }  
  
            //
            // Rule 196:  for_init_statement ::= simple_declaration_with_declspec
            //
            case 196: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 197:  jump_statement ::= break ;
            //
            case 197: { action.   consumeStatementBreak();             break;
            }  
  
            //
            // Rule 198:  jump_statement ::= continue ;
            //
            case 198: { action.   consumeStatementContinue();             break;
            }  
  
            //
            // Rule 199:  jump_statement ::= return expression ;
            //
            case 199: { action.   consumeStatementReturn(true);             break;
            }  
  
            //
            // Rule 200:  jump_statement ::= return ;
            //
            case 200: { action.   consumeStatementReturn(false);             break;
            }  
  
            //
            // Rule 201:  jump_statement ::= goto identifier_token ;
            //
            case 201: { action.   consumeStatementGoto();             break;
            }  
  
            //
            // Rule 202:  declaration_statement ::= block_declaration
            //
            case 202: { action.   consumeStatementDeclarationWithDisambiguation();             break;
            }  
  
            //
            // Rule 203:  declaration_statement ::= function_definition
            //
            case 203: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 211:  declaration ::= ERROR_TOKEN
            //
            case 211: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 221:  simple_declaration ::= declaration_specifiers_opt <openscope-ast> init_declarator_list_opt ;
            //
            case 221: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 222:  simple_declaration_with_declspec ::= declaration_specifiers <openscope-ast> init_declarator_list_opt ;
            //
            case 222: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 223:  declaration_specifiers ::= <openscope-ast> simple_declaration_specifiers
            //
            case 223: { action.   consumeDeclarationSpecifiersSimple();             break;
            }  
  
            //
            // Rule 224:  declaration_specifiers ::= <openscope-ast> class_declaration_specifiers
            //
            case 224: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 225:  declaration_specifiers ::= <openscope-ast> elaborated_declaration_specifiers
            //
            case 225: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 226:  declaration_specifiers ::= <openscope-ast> enum_declaration_specifiers
            //
            case 226: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 227:  declaration_specifiers ::= <openscope-ast> type_name_declaration_specifiers
            //
            case 227: { action.   consumeDeclarationSpecifiersTypeName();             break;
            }  
  
            //
            // Rule 229:  declaration_specifiers_opt ::= $Empty
            //
            case 229: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 233:  no_type_declaration_specifier ::= friend
            //
            case 233: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 234:  no_type_declaration_specifier ::= typedef
            //
            case 234: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 254:  storage_class_specifier ::= auto
            //
            case 254: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 255:  storage_class_specifier ::= register
            //
            case 255: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 256:  storage_class_specifier ::= static
            //
            case 256: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 257:  storage_class_specifier ::= extern
            //
            case 257: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 258:  storage_class_specifier ::= mutable
            //
            case 258: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 259:  function_specifier ::= inline
            //
            case 259: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 260:  function_specifier ::= virtual
            //
            case 260: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 261:  function_specifier ::= explicit
            //
            case 261: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 262:  simple_type_specifier ::= simple_type_specifier_token
            //
            case 262: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 276:  type_name_specifier ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 276: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 277:  type_name_specifier ::= dcolon_opt nested_name_specifier template template_id_name
            //
            case 277: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 278:  type_name_specifier ::= typename dcolon_opt nested_name_specifier identifier_name
            //
            case 278: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 279:  type_name_specifier ::= typename dcolon_opt nested_name_specifier template_opt template_id_name
            //
            case 279: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 281:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 281: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 282:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt template_opt template_id_name
            //
            case 282: { action.   consumeTypeSpecifierElaborated(true);              break;
            }  
  
            //
            // Rule 283:  elaborated_type_specifier ::= enum elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 283: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 287:  enum_specifier ::= enum enum_specifier_hook { <openscope-ast> enumerator_list_opt comma_opt }
            //
            case 287: { action.   consumeTypeSpecifierEnumeration(false);            break;
            }  
  
            //
            // Rule 288:  enum_specifier ::= enum enum_specifier_hook identifier_token { <openscope-ast> enumerator_list_opt comma_opt }
            //
            case 288: { action.   consumeTypeSpecifierEnumeration(true);            break;
            }  
  
            //
            // Rule 294:  enumerator_definition ::= identifier_token
            //
            case 294: { action.   consumeEnumerator(false);            break;
            }  
  
            //
            // Rule 295:  enumerator_definition ::= identifier_token = constant_expression
            //
            case 295: { action.   consumeEnumerator(true);            break;
            }  
  
            //
            // Rule 297:  namespace_definition ::= namespace namespace_name namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 297: { action.   consumeNamespaceDefinition(true);             break;
            }  
  
            //
            // Rule 298:  namespace_definition ::= namespace namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 298: { action.   consumeNamespaceDefinition(false);             break;
            }  
  
            //
            // Rule 300:  namespace_alias_definition ::= namespace identifier_token = dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 300: { action.   consumeNamespaceAliasDefinition();            break;
            }  
  
            //
            // Rule 301:  using_declaration ::= using typename_opt dcolon_opt nested_name_specifier_opt unqualified_id_name ;
            //
            case 301: { action.   consumeUsingDeclaration();             break;
            }  
  
            //
            // Rule 302:  typename_opt ::= typename
            //
            case 302: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 303:  typename_opt ::= $Empty
            //
            case 303: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 304:  using_directive ::= using namespace dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 304: { action.   consumeUsingDirective();             break;
            }  
  
            //
            // Rule 305:  asm_definition ::= asm ( stringlit ) ;
            //
            case 305: { action.   consumeDeclarationASM();            break;
            }  
  
            //
            // Rule 306:  linkage_specification ::= extern stringlit { <openscope-ast> declaration_seq_opt }
            //
            case 306: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 307:  linkage_specification ::= extern stringlit <openscope-ast> declaration
            //
            case 307: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 312:  init_declarator_complete ::= init_declarator
            //
            case 312: { action.   consumeInitDeclaratorComplete();             break;
            }  
  
            //
            // Rule 314:  init_declarator ::= complete_declarator initializer
            //
            case 314: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 317:  declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 317: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 319:  function_declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 319: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 323:  basic_direct_declarator ::= declarator_id_name
            //
            case 323: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 324:  basic_direct_declarator ::= ( declarator )
            //
            case 324: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 325:  function_direct_declarator ::= basic_direct_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 325: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 326:  array_direct_declarator ::= array_direct_declarator array_modifier
            //
            case 326: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 327:  array_direct_declarator ::= basic_direct_declarator array_modifier
            //
            case 327: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 328:  array_modifier ::= [ constant_expression ]
            //
            case 328: { action.   consumeDirectDeclaratorArrayModifier(true);             break;
            }  
  
            //
            // Rule 329:  array_modifier ::= [ ]
            //
            case 329: { action.   consumeDirectDeclaratorArrayModifier(false);             break;
            }  
  
            //
            // Rule 330:  ptr_operator ::= pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 330: { action.   consumePointer();             break;
            }  
  
            //
            // Rule 331:  ptr_operator ::= pointer_hook & pointer_hook
            //
            case 331: { action.   consumeReferenceOperator();             break;
            }  
  
            //
            // Rule 332:  ptr_operator ::= dcolon_opt nested_name_specifier pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 332: { action.   consumePointerToMember();             break;
            }  
  
            //
            // Rule 339:  cv_qualifier ::= const
            //
            case 339: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 340:  cv_qualifier ::= volatile
            //
            case 340: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 342:  declarator_id_name ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 342: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 343:  type_id ::= type_specifier_seq
            //
            case 343: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 344:  type_id ::= type_specifier_seq abstract_declarator
            //
            case 344: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 347:  abstract_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 347: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 348:  abstract_declarator ::= <openscope-ast> ptr_operator_seq direct_abstract_declarator
            //
            case 348: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 352:  basic_direct_abstract_declarator ::= ( abstract_declarator )
            //
            case 352: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 353:  basic_direct_abstract_declarator ::= ( )
            //
            case 353: { action.   consumeAbstractDeclaratorEmpty();             break;
            }  
  
            //
            // Rule 354:  array_direct_abstract_declarator ::= array_modifier
            //
            case 354: { action.   consumeDirectDeclaratorArrayDeclarator(false);             break;
            }  
  
            //
            // Rule 355:  array_direct_abstract_declarator ::= array_direct_abstract_declarator array_modifier
            //
            case 355: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 356:  array_direct_abstract_declarator ::= basic_direct_abstract_declarator array_modifier
            //
            case 356: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 357:  function_direct_abstract_declarator ::= basic_direct_abstract_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 357: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 358:  function_direct_abstract_declarator ::= ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 358: { action.   consumeDirectDeclaratorFunctionDeclarator(false);             break;
            }  
  
            //
            // Rule 359:  parameter_declaration_clause ::= parameter_declaration_list_opt ...
            //
            case 359: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 360:  parameter_declaration_clause ::= parameter_declaration_list_opt
            //
            case 360: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 361:  parameter_declaration_clause ::= parameter_declaration_list , ...
            //
            case 361: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 367:  abstract_declarator_opt ::= $Empty
            //
            case 367: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 368:  parameter_declaration ::= declaration_specifiers parameter_init_declarator
            //
            case 368: { action.   consumeParameterDeclaration();             break;
            }  
  
            //
            // Rule 369:  parameter_declaration ::= declaration_specifiers
            //
            case 369: { action.   consumeParameterDeclarationWithoutDeclarator();             break;
            }  
  
            //
            // Rule 371:  parameter_init_declarator ::= declarator = parameter_initializer
            //
            case 371: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 373:  parameter_init_declarator ::= abstract_declarator = parameter_initializer
            //
            case 373: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 374:  parameter_init_declarator ::= = parameter_initializer
            //
            case 374: { action.   consumeDeclaratorWithInitializer(false);             break;
            }  
  
            //
            // Rule 375:  parameter_initializer ::= assignment_expression
            //
            case 375: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 376:  function_definition ::= declaration_specifiers_opt function_declarator <openscope-ast> ctor_initializer_list_opt function_body
            //
            case 376: { action.   consumeFunctionDefinition(false);             break;
            }  
  
            //
            // Rule 377:  function_definition ::= declaration_specifiers_opt function_declarator try <openscope-ast> ctor_initializer_list_opt function_body <openscope-ast> handler_seq
            //
            case 377: { action.   consumeFunctionDefinition(true);             break;
            }  
  
            //
            // Rule 380:  initializer ::= ( expression_list )
            //
            case 380: { action.   consumeInitializerConstructor();             break;
            }  
  
            //
            // Rule 381:  initializer_clause ::= assignment_expression
            //
            case 381: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 382:  initializer_clause ::= initializer_list
            //
            case 382: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 383:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq , } end_initializer_list
            //
            case 383: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 384:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq } end_initializer_list
            //
            case 384: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 385:  initializer_list ::= { <openscope-ast> }
            //
            case 385: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 386:  start_initializer_list ::= $Empty
            //
            case 386: { action.   initializerListStart();            break;
            }  
  
            //
            // Rule 387:  end_initializer_list ::= $Empty
            //
            case 387: { action.   initializerListEnd();            break;
            }  
  
            //
            // Rule 392:  class_specifier ::= class_head { <openscope-ast> member_declaration_list_opt }
            //
            case 392: { action.   consumeClassSpecifier();             break;
            }  
  
            //
            // Rule 393:  class_head ::= class_keyword composite_specifier_hook identifier_name_opt class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 393: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 394:  class_head ::= class_keyword composite_specifier_hook template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 394: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 395:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier identifier_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 395: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 396:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 396: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 400:  identifier_name_opt ::= $Empty
            //
            case 400: { action.   consumeEmpty();             break;
            } 
  
            //
            // Rule 404:  visibility_label ::= access_specifier_keyword :
            //
            case 404: { action.   consumeVisibilityLabel();             break;
            }  
  
            //
            // Rule 405:  member_declaration ::= declaration_specifiers_opt <openscope-ast> member_declarator_list ;
            //
            case 405: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 406:  member_declaration ::= declaration_specifiers_opt ;
            //
            case 406: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 409:  member_declaration ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name ;
            //
            case 409: { action.   consumeMemberDeclarationQualifiedId();             break;
            }  
  
            //
            // Rule 415:  member_declaration ::= ERROR_TOKEN
            //
            case 415: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 424:  member_declarator ::= declarator constant_initializer
            //
            case 424: { action.   consumeMemberDeclaratorWithInitializer();             break;
            }  
  
            //
            // Rule 425:  member_declarator ::= bit_field_declarator : constant_expression
            //
            case 425: { action.   consumeBitField(true);             break;
            }  
  
            //
            // Rule 426:  member_declarator ::= : constant_expression
            //
            case 426: { action.   consumeBitField(false);             break;
            }  
  
            //
            // Rule 427:  bit_field_declarator ::= identifier_name
            //
            case 427: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 428:  constant_initializer ::= = constant_expression
            //
            case 428: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 434:  base_specifier ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 434: { action.   consumeBaseSpecifier(false, false);             break;
            }  
  
            //
            // Rule 435:  base_specifier ::= virtual access_specifier_keyword_opt dcolon_opt nested_name_specifier_opt class_name
            //
            case 435: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 436:  base_specifier ::= access_specifier_keyword virtual dcolon_opt nested_name_specifier_opt class_name
            //
            case 436: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 437:  base_specifier ::= access_specifier_keyword dcolon_opt nested_name_specifier_opt class_name
            //
            case 437: { action.   consumeBaseSpecifier(true, false);             break;
            }  
  
            //
            // Rule 438:  access_specifier_keyword ::= private
            //
            case 438: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 439:  access_specifier_keyword ::= protected
            //
            case 439: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 440:  access_specifier_keyword ::= public
            //
            case 440: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 442:  access_specifier_keyword_opt ::= $Empty
            //
            case 442: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 444:  conversion_function_id_name ::= conversion_function_id < <openscope-ast> template_argument_list_opt >
            //
            case 444: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 445:  conversion_function_id ::= operator conversion_type_id
            //
            case 445: { action.   consumeConversionName();            break;
            }  
  
            //
            // Rule 446:  conversion_type_id ::= type_specifier_seq conversion_declarator
            //
            case 446: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 447:  conversion_type_id ::= type_specifier_seq
            //
            case 447: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 448:  conversion_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 448: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 454:  mem_initializer ::= mem_initializer_name ( expression_list_opt )
            //
            case 454: { action.   consumeConstructorChainInitializer();             break;
            }  
  
            //
            // Rule 455:  mem_initializer_name ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 455: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 458:  operator_function_id_name ::= operator_id_name < <openscope-ast> template_argument_list_opt >
            //
            case 458: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 459:  operator_id_name ::= operator overloadable_operator
            //
            case 459: { action.   consumeOperatorName();             break;
            }  
  
            //
            // Rule 502:  template_declaration ::= export_opt template < <openscope-ast> template_parameter_list > declaration
            //
            case 502: { action.   consumeTemplateDeclaration();             break;
            }  
  
            //
            // Rule 503:  export_opt ::= export
            //
            case 503: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 504:  export_opt ::= $Empty
            //
            case 504: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 508:  template_parameter ::= parameter_declaration
            //
            case 508: { action.   consumeTemplateParamterDeclaration();             break;
            }  
  
            //
            // Rule 509:  type_parameter ::= class identifier_name_opt
            //
            case 509: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 510:  type_parameter ::= class identifier_name_opt = type_id
            //
            case 510: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 511:  type_parameter ::= typename identifier_name_opt
            //
            case 511: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 512:  type_parameter ::= typename identifier_name_opt = type_id
            //
            case 512: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 513:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt
            //
            case 513: { action.   consumeTemplatedTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 514:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt = id_expression
            //
            case 514: { action.   consumeTemplatedTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 515:  template_id_name ::= identifier_name < <openscope-ast> template_argument_list_opt >
            //
            case 515: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 520:  template_argument ::= assignment_expression
            //
            case 520: { action.   consumeTemplateArgumentExpression();             break;
            }  
  
            //
            // Rule 521:  template_argument ::= type_id
            //
            case 521: { action.   consumeTemplateArgumentTypeId();             break;
            }  
  
            //
            // Rule 522:  explicit_instantiation ::= template declaration
            //
            case 522: { action.   consumeTemplateExplicitInstantiation();             break;
            }  
  
            //
            // Rule 523:  explicit_specialization ::= template < > declaration
            //
            case 523: { action.   consumeTemplateExplicitSpecialization();             break;
            }  
  
            //
            // Rule 524:  try_block ::= try compound_statement <openscope-ast> handler_seq
            //
            case 524: { action.   consumeStatementTryBlock(true);             break;
            }  
  
            //
            // Rule 525:  try_block ::= try compound_statement
            //
            case 525: { action.   consumeStatementTryBlock(false);             break;
            }  
  
            //
            // Rule 528:  handler ::= catch ( exception_declaration ) compound_statement
            //
            case 528: { action.   consumeStatementCatchHandler(false);             break;
            }  
  
            //
            // Rule 529:  handler ::= catch ( ... ) compound_statement
            //
            case 529: { action.   consumeStatementCatchHandler(true);             break;
            }  
  
            //
            // Rule 530:  exception_declaration ::= type_specifier_seq <openscope-ast> declarator
            //
            case 530: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 531:  exception_declaration ::= type_specifier_seq <openscope-ast> abstract_declarator
            //
            case 531: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 532:  exception_declaration ::= type_specifier_seq
            //
            case 532: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 534:  exception_specification ::= throw ( )
            //
            case 534: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 540:  no_cast_start ::= ERROR_TOKEN
            //
            case 540: { action.   consumeEmpty();             break;
            }  

    
            default:
                break;
        }
        return;
    }
}

