/*******************************************************************************
* Copyright (c) 2006, 2010 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*********************************************************************************/

// This file was generated by LPG

package org.eclipse.cdt.internal.core.dom.lrparser.gpp;

import lpg.lpgjavaruntime.*;

import java.util.*;
import org.eclipse.cdt.core.dom.ast.*;
import org.eclipse.cdt.core.dom.lrparser.IDOMTokenMap;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.ITokenCollector;
import org.eclipse.cdt.core.dom.lrparser.CPreprocessorAdapter;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.FixedBacktrackingParser;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.index.IIndex;

import org.eclipse.cdt.core.dom.ast.cpp.*;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPSecondaryParserFactory;

import org.eclipse.cdt.core.dom.lrparser.action.gnu.GNUBuildASTParserAction;

import org.eclipse.cdt.core.dom.lrparser.action.gnu.GPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.gnu.GPPSecondaryParserFactory;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.*;

public class GPPParser extends PrsStream implements RuleAction, ITokenStream, 
                                                       ITokenCollector, IParser< IASTTranslationUnit  > 
                                                           
{
    private static ParseTable prs = new GPPParserprs();
    private FixedBacktrackingParser btParser;

    public FixedBacktrackingParser getParser() { return btParser; }
    private void setResult(Object object) { btParser.setSym1(object); }
    public Object getRhsSym(int i) { return btParser.getSym(i); }

    public int getRhsTokenIndex(int i) { return btParser.getToken(i); }
    public IToken getRhsIToken(int i) { return super.getIToken(getRhsTokenIndex(i)); }
    
    public int getRhsFirstTokenIndex(int i) { return btParser.getFirstToken(i); }
    public IToken getRhsFirstIToken(int i) { return super.getIToken(getRhsFirstTokenIndex(i)); }

    public int getRhsLastTokenIndex(int i) { return btParser.getLastToken(i); }
    public IToken getRhsLastIToken(int i) { return super.getIToken(getRhsLastTokenIndex(i)); }

    public int getLeftSpan() { return btParser.getFirstToken(); }
    public IToken getLeftIToken()  { return super.getIToken(getLeftSpan()); }

    public int getRightSpan() { return btParser.getLastToken(); }
    public IToken getRightIToken() { return super.getIToken(getRightSpan()); }

    public int getRhsErrorTokenIndex(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (err instanceof ErrorToken ? index : 0);
    }
    public ErrorToken getRhsErrorIToken(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (ErrorToken) (err instanceof ErrorToken ? err : null);
    }

    public GPPParser(LexStream lexStream)
    {
        super(lexStream);

        try
        {
            super.remapTerminalSymbols(orderedTerminalSymbols(), GPPParserprs.EOFT_SYMBOL);
        }
        catch(NullExportedSymbolsException e) {
        }
        catch(NullTerminalSymbolsException e) {
        }
        catch(UnimplementedTerminalsException e)
        {
            java.util.ArrayList unimplemented_symbols = e.getSymbols();
            System.out.println("The Lexer will not scan the following token(s):");
            for (int i = 0; i < unimplemented_symbols.size(); i++)
            {
                Integer id = (Integer) unimplemented_symbols.get(i);
                System.out.println("    " + GPPParsersym.orderedTerminalSymbols[id.intValue()]);               
            }
            System.out.println();                        
        }
        catch(UndefinedEofSymbolException e)
        {
            throw new Error(new UndefinedEofSymbolException
                                ("The Lexer does not implement the Eof symbol " +
                                 GPPParsersym.orderedTerminalSymbols[GPPParserprs.EOFT_SYMBOL]));
        } 
    }

    public String[] orderedTerminalSymbols() { return GPPParsersym.orderedTerminalSymbols; }
    public String getTokenKindName(int kind) { return GPPParsersym.orderedTerminalSymbols[kind]; }
    public int getEOFTokenKind() { return GPPParserprs.EOFT_SYMBOL; }
    public PrsStream getParseStream() { return (PrsStream) this; }
    
    //
    // Report error message for given error_token.
    //
    public final void reportErrorTokenMessage(int error_token, String msg)
    {
        int firsttok = super.getFirstErrorToken(error_token),
            lasttok = super.getLastErrorToken(error_token);
        String location = super.getFileName() + ':' +
                          (firsttok > lasttok
                                    ? (super.getEndLine(lasttok) + ":" + super.getEndColumn(lasttok))
                                    : (super.getLine(error_token) + ":" +
                                       super.getColumn(error_token) + ":" +
                                       super.getEndLine(error_token) + ":" +
                                       super.getEndColumn(error_token)))
                          + ": ";
        super.reportError((firsttok > lasttok ? ParseErrorCodes.INSERTION_CODE : ParseErrorCodes.SUBSTITUTION_CODE), location, msg);
    }

    public void parser()
    {
        parser(null, 0);
    }
    
    public void parser(Monitor monitor)
    {
        parser(monitor, 0);
    }
    
    public void parser(int error_repair_count)
    {
        parser(null, error_repair_count);
    }

    public void parser(Monitor monitor, int error_repair_count)
    {
        try
        {
            btParser = new FixedBacktrackingParser(monitor, (TokenStream) this, prs, (RuleAction) this);
        }
        catch (NotBacktrackParseTableException e)
        {
            throw new Error(new NotBacktrackParseTableException
                                ("Regenerate GPPParserprs.java with -BACKTRACK option"));
        }
        catch (BadParseSymFileException e)
        {
            throw new Error(new BadParseSymFileException("Bad Parser Symbol File -- GPPParsersym.java"));
        }

        try
        {
            btParser.parse(error_repair_count);
        }
        catch (BadParseException e)
        {
            reset(e.error_token); // point to error token
            DiagnoseParser diagnoseParser = new DiagnoseParser(this, prs);
            diagnoseParser.diagnose(e.error_token);
        }
    }


private  GPPBuildASTParserAction  action;
private IASTCompletionNode compNode;


public GPPParser(IScanner scanner, IDOMTokenMap tokenMap, IBuiltinBindingsProvider builtinBindingsProvider, IIndex index, Map<String,String> properties) {
	initActions(properties);
	action.initializeTranslationUnit(scanner, builtinBindingsProvider, index);
	CPreprocessorAdapter.runCPreprocessor(scanner, this, tokenMap);
}

private void initActions(Map<String,String> properties) {
	ScopedStack<Object> astStack = new ScopedStack<Object>();
	
	action = new  GPPBuildASTParserAction (this, astStack,  CPPNodeFactory.getDefault() ,  GPPSecondaryParserFactory.getDefault() );
	action.setParserProperties(properties);
	
	

	gnuAction = new  GNUBuildASTParserAction  (this, astStack,  CPPNodeFactory.getDefault() );
	gnuAction.setParserProperties(properties);

}


public void addToken(IToken token) {
	token.setKind(mapKind(token.getKind())); // TODO does mapKind need to be called?
	super.addToken(token);
}


public  IASTTranslationUnit   parse() {
	// this has to be done, or... kaboom!
	setStreamLength(getSize());
	
	final int errorRepairCount = -1;  // -1 means full error handling
	parser(null, errorRepairCount); // do the actual parse
	super.resetTokenStream(); // allow tokens to be garbage collected

	compNode = action.getASTCompletionNode(); // the completion node may be null
	return ( IASTTranslationUnit  ) action.getParseResult();
}


public IASTCompletionNode getCompletionNode() {
	return compNode;
}

// uncomment this method to use with backtracking parser
public List<IToken> getRuleTokens() {
    return getTokens().subList(getLeftSpan(), getRightSpan() + 1);
}

public String[] getOrderedTerminalSymbols() {
	return GPPParsersym.orderedTerminalSymbols;
}

@SuppressWarnings("nls")
public String getName() {
	return "GPPParser";
}


private  GNUBuildASTParserAction  gnuAction;

    public void ruleAction(int ruleNumber)
    {
        switch (ruleNumber)
        {
  
            //
            // Rule 1:  <openscope-ast> ::= $Empty
            //
            case 1: { action.   openASTScope();             break;
            }  
  
            //
            // Rule 2:  <empty> ::= $Empty
            //
            case 2: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 13:  translation_unit ::= declaration_seq_opt
            //
            case 13: { action.   consumeTranslationUnit();            break;
            }  
  
            //
            // Rule 16:  literal ::= integer
            //
            case 16: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_integer_constant);            break;
            }  
  
            //
            // Rule 17:  literal ::= floating
            //
            case 17: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_float_constant);            break;
            }  
  
            //
            // Rule 18:  literal ::= charconst
            //
            case 18: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_char_constant);            break;
            }  
  
            //
            // Rule 19:  literal ::= stringlit
            //
            case 19: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_string_literal);            break;
            }  
  
            //
            // Rule 20:  literal ::= true
            //
            case 20: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_true);            break;
            }  
  
            //
            // Rule 21:  literal ::= false
            //
            case 21: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_false);            break;
            }  
  
            //
            // Rule 22:  literal ::= this
            //
            case 22: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_this);            break;
            }  
  
            //
            // Rule 24:  primary_expression ::= ( expression )
            //
            case 24: { action.   consumeExpressionBracketed();             break;
            }  
  
            //
            // Rule 26:  id_expression ::= qualified_or_unqualified_name
            //
            case 26: { action.   consumeExpressionName();             break;
            }  
  
            //
            // Rule 33:  unqualified_id_name ::= ~ identifier_token
            //
            case 33: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 34:  unqualified_id_name ::= ~ template_id_name
            //
            case 34: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 35:  identifier_name ::= identifier_token
            //
            case 35: { action.   consumeIdentifierName();             break;
            }  
  
            //
            // Rule 36:  template_opt ::= template
            //
            case 36: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 37:  template_opt ::= $Empty
            //
            case 37: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 38:  dcolon_opt ::= ::
            //
            case 38: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 39:  dcolon_opt ::= $Empty
            //
            case 39: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 40:  qualified_id_name ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name
            //
            case 40: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 41:  qualified_id_name ::= :: unqualified_id_name
            //
            case 41: { action.   consumeGlobalQualifiedId();             break;
            }  
  
            //
            // Rule 42:  nested_name_specifier ::= class_or_namespace_name :: nested_name_specifier_with_template
            //
            case 42: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 43:  nested_name_specifier ::= class_or_namespace_name ::
            //
            case 43: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 44:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template :: nested_name_specifier_with_template
            //
            case 44: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 45:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template ::
            //
            case 45: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 46:  class_or_namespace_name_with_template ::= template_opt class_or_namespace_name
            //
            case 46: { action.   consumeNameWithTemplateKeyword();             break;
            }  
  
            //
            // Rule 48:  nested_name_specifier_opt ::= $Empty
            //
            case 48: { action.   consumeNestedNameSpecifierEmpty();             break;
            }  
  
            //
            // Rule 51:  postfix_expression ::= postfix_expression [ expression ]
            //
            case 51: { action.   consumeExpressionArraySubscript();             break;
            }  
  
            //
            // Rule 52:  postfix_expression ::= postfix_expression ( expression_list_opt )
            //
            case 52: { action.   consumeExpressionFunctionCall();             break;
            }  
  
            //
            // Rule 53:  postfix_expression ::= simple_type_specifier ( expression_list_opt )
            //
            case 53: { action.   consumeExpressionSimpleTypeConstructor();            break;
            }  
  
            //
            // Rule 54:  postfix_expression ::= typename dcolon_opt nested_name_specifier <empty> identifier_name ( expression_list_opt )
            //
            case 54: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 55:  postfix_expression ::= typename dcolon_opt nested_name_specifier template_opt template_id_name ( expression_list_opt )
            //
            case 55: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 56:  postfix_expression ::= postfix_expression . qualified_or_unqualified_name
            //
            case 56: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 57:  postfix_expression ::= postfix_expression -> qualified_or_unqualified_name
            //
            case 57: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 58:  postfix_expression ::= postfix_expression . template qualified_or_unqualified_name
            //
            case 58: { action.   consumeExpressionFieldReference(false, true);             break;
            }  
  
            //
            // Rule 59:  postfix_expression ::= postfix_expression -> template qualified_or_unqualified_name
            //
            case 59: { action.   consumeExpressionFieldReference(true, true);             break;
            }  
  
            //
            // Rule 60:  postfix_expression ::= postfix_expression . pseudo_destructor_name
            //
            case 60: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 61:  postfix_expression ::= postfix_expression -> pseudo_destructor_name
            //
            case 61: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 62:  postfix_expression ::= postfix_expression ++
            //
            case 62: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixIncr);             break;
            }  
  
            //
            // Rule 63:  postfix_expression ::= postfix_expression --
            //
            case 63: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixDecr);             break;
            }  
  
            //
            // Rule 64:  postfix_expression ::= dynamic_cast < type_id > ( expression )
            //
            case 64: { action.   consumeExpressionCast(ICPPASTCastExpression.op_dynamic_cast);             break;
            }  
  
            //
            // Rule 65:  postfix_expression ::= static_cast < type_id > ( expression )
            //
            case 65: { action.   consumeExpressionCast(ICPPASTCastExpression.op_static_cast);             break;
            }  
  
            //
            // Rule 66:  postfix_expression ::= reinterpret_cast < type_id > ( expression )
            //
            case 66: { action.   consumeExpressionCast(ICPPASTCastExpression.op_reinterpret_cast);             break;
            }  
  
            //
            // Rule 67:  postfix_expression ::= const_cast < type_id > ( expression )
            //
            case 67: { action.   consumeExpressionCast(ICPPASTCastExpression.op_const_cast);             break;
            }  
  
            //
            // Rule 68:  postfix_expression ::= typeid ( expression )
            //
            case 68: { action.   consumeExpressionUnaryOperator(ICPPASTUnaryExpression.op_typeid);             break;
            }  
  
            //
            // Rule 69:  postfix_expression ::= typeid ( type_id )
            //
            case 69: { action.   consumeExpressionTypeId(ICPPASTTypeIdExpression.op_typeid);            break;
            }  
  
            //
            // Rule 70:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt type_name :: destructor_type_name
            //
            case 70: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 71:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier template template_id_name :: destructor_type_name
            //
            case 71: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 72:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt destructor_type_name
            //
            case 72: { action.   consumePsudoDestructorName(false);             break;
            }  
  
            //
            // Rule 73:  destructor_type_name ::= ~ identifier_token
            //
            case 73: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 74:  destructor_type_name ::= ~ template_id_name
            //
            case 74: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 78:  unary_expression ::= ++ cast_expression
            //
            case 78: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixIncr);             break;
            }  
  
            //
            // Rule 79:  unary_expression ::= -- cast_expression
            //
            case 79: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixDecr);             break;
            }  
  
            //
            // Rule 80:  unary_expression ::= & cast_expression
            //
            case 80: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_amper);             break;
            }  
  
            //
            // Rule 81:  unary_expression ::= * cast_expression
            //
            case 81: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_star);             break;
            }  
  
            //
            // Rule 82:  unary_expression ::= + cast_expression
            //
            case 82: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 83:  unary_expression ::= - cast_expression
            //
            case 83: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 84:  unary_expression ::= ~ cast_expression
            //
            case 84: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_tilde);             break;
            }  
  
            //
            // Rule 85:  unary_expression ::= ! cast_expression
            //
            case 85: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_not);             break;
            }  
  
            //
            // Rule 86:  unary_expression ::= sizeof unary_expression
            //
            case 86: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_sizeof);             break;
            }  
  
            //
            // Rule 87:  unary_expression ::= sizeof ( type_id )
            //
            case 87: { action.   consumeExpressionTypeId(ICPPASTTypeIdExpression.op_sizeof);            break;
            }  
  
            //
            // Rule 88:  new_expression ::= dcolon_opt new new_placement_opt new_type_id <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 88: { action.   consumeExpressionNew(true);             break;
            }  
  
            //
            // Rule 89:  new_expression ::= dcolon_opt new new_placement_opt ( type_id ) <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 89: { action.   consumeExpressionNew(false);             break;
            }  
  
            //
            // Rule 91:  new_placement_opt ::= $Empty
            //
            case 91: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 92:  new_type_id ::= type_specifier_seq
            //
            case 92: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 93:  new_type_id ::= type_specifier_seq new_declarator
            //
            case 93: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 94:  new_declarator ::= <openscope-ast> new_pointer_operators
            //
            case 94: { action.   consumeNewDeclarator();            break;
            }  
  
            //
            // Rule 101:  new_initializer ::= ( expression_list_opt )
            //
            case 101: { action.   consumeNewInitializer();             break;
            }  
  
            //
            // Rule 103:  new_initializer_opt ::= $Empty
            //
            case 103: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 104:  delete_expression ::= dcolon_opt delete cast_expression
            //
            case 104: { action.   consumeExpressionDelete(false);             break;
            }  
  
            //
            // Rule 105:  delete_expression ::= dcolon_opt delete [ ] cast_expression
            //
            case 105: { action.   consumeExpressionDelete(true);             break;
            }  
  
            //
            // Rule 107:  cast_expression ::= ( type_id ) cast_expression
            //
            case 107: { action.   consumeExpressionCast(ICPPASTCastExpression.op_cast);             break;
            }  
  
            //
            // Rule 109:  pm_expression ::= pm_expression .* cast_expression
            //
            case 109: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmdot);             break;
            }  
  
            //
            // Rule 110:  pm_expression ::= pm_expression ->* cast_expression
            //
            case 110: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmarrow);             break;
            }  
  
            //
            // Rule 112:  multiplicative_expression ::= multiplicative_expression * pm_expression
            //
            case 112: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiply);             break;
            }  
  
            //
            // Rule 113:  multiplicative_expression ::= multiplicative_expression / pm_expression
            //
            case 113: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divide);             break;
            }  
  
            //
            // Rule 114:  multiplicative_expression ::= multiplicative_expression % pm_expression
            //
            case 114: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_modulo);             break;
            }  
  
            //
            // Rule 116:  additive_expression ::= additive_expression + multiplicative_expression
            //
            case 116: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 117:  additive_expression ::= additive_expression - multiplicative_expression
            //
            case 117: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 119:  shift_expression ::= shift_expression << additive_expression
            //
            case 119: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeft);             break;
            }  
  
            //
            // Rule 120:  shift_expression ::= shift_expression >> additive_expression
            //
            case 120: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRight);             break;
            }  
  
            //
            // Rule 122:  relational_expression ::= relational_expression < shift_expression
            //
            case 122: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessThan);             break;
            }  
  
            //
            // Rule 123:  relational_expression ::= relational_expression > shift_expression
            //
            case 123: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterThan);             break;
            }  
  
            //
            // Rule 124:  relational_expression ::= relational_expression <= shift_expression
            //
            case 124: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessEqual);             break;
            }  
  
            //
            // Rule 125:  relational_expression ::= relational_expression >= shift_expression
            //
            case 125: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterEqual);             break;
            }  
  
            //
            // Rule 127:  equality_expression ::= equality_expression == relational_expression
            //
            case 127: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_equals);             break;
            }  
  
            //
            // Rule 128:  equality_expression ::= equality_expression != relational_expression
            //
            case 128: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_notequals);             break;
            }  
  
            //
            // Rule 130:  and_expression ::= and_expression & equality_expression
            //
            case 130: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAnd);             break;
            }  
  
            //
            // Rule 132:  exclusive_or_expression ::= exclusive_or_expression ^ and_expression
            //
            case 132: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXor);             break;
            }  
  
            //
            // Rule 134:  inclusive_or_expression ::= inclusive_or_expression | exclusive_or_expression
            //
            case 134: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOr);             break;
            }  
  
            //
            // Rule 136:  logical_and_expression ::= logical_and_expression && inclusive_or_expression
            //
            case 136: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalAnd);             break;
            }  
  
            //
            // Rule 138:  logical_or_expression ::= logical_or_expression || logical_and_expression
            //
            case 138: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalOr);             break;
            }  
  
            //
            // Rule 140:  conditional_expression ::= logical_or_expression ? expression : assignment_expression
            //
            case 140: { action.   consumeExpressionConditional();             break;
            }  
  
            //
            // Rule 141:  throw_expression ::= throw
            //
            case 141: { action.   consumeExpressionThrow(false);             break;
            }  
  
            //
            // Rule 142:  throw_expression ::= throw assignment_expression
            //
            case 142: { action.   consumeExpressionThrow(true);             break;
            }  
  
            //
            // Rule 145:  assignment_expression ::= logical_or_expression = assignment_expression
            //
            case 145: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_assign);             break;
            }  
  
            //
            // Rule 146:  assignment_expression ::= logical_or_expression *= assignment_expression
            //
            case 146: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiplyAssign);             break;
            }  
  
            //
            // Rule 147:  assignment_expression ::= logical_or_expression /= assignment_expression
            //
            case 147: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divideAssign);             break;
            }  
  
            //
            // Rule 148:  assignment_expression ::= logical_or_expression %= assignment_expression
            //
            case 148: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_moduloAssign);             break;
            }  
  
            //
            // Rule 149:  assignment_expression ::= logical_or_expression += assignment_expression
            //
            case 149: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plusAssign);             break;
            }  
  
            //
            // Rule 150:  assignment_expression ::= logical_or_expression -= assignment_expression
            //
            case 150: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minusAssign);             break;
            }  
  
            //
            // Rule 151:  assignment_expression ::= logical_or_expression >>= assignment_expression
            //
            case 151: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRightAssign);             break;
            }  
  
            //
            // Rule 152:  assignment_expression ::= logical_or_expression <<= assignment_expression
            //
            case 152: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeftAssign);             break;
            }  
  
            //
            // Rule 153:  assignment_expression ::= logical_or_expression &= assignment_expression
            //
            case 153: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAndAssign);             break;
            }  
  
            //
            // Rule 154:  assignment_expression ::= logical_or_expression ^= assignment_expression
            //
            case 154: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXorAssign);             break;
            }  
  
            //
            // Rule 155:  assignment_expression ::= logical_or_expression |= assignment_expression
            //
            case 155: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOrAssign);             break;
            }  
  
            //
            // Rule 157:  expression_list ::= <openscope-ast> expression_list_actual
            //
            case 157: { action.   consumeExpressionList();             break;
            }  
  
            //
            // Rule 161:  expression_list_opt ::= $Empty
            //
            case 161: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 163:  expression_opt ::= $Empty
            //
            case 163: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 166:  constant_expression_opt ::= $Empty
            //
            case 166: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 175:  statement ::= ERROR_TOKEN
            //
            case 175: { action.   consumeStatementProblem();             break;
            }  
  
            //
            // Rule 176:  labeled_statement ::= identifier : statement
            //
            case 176: { action.   consumeStatementLabeled();             break;
            }  
  
            //
            // Rule 177:  labeled_statement ::= case constant_expression : statement
            //
            case 177: { action.   consumeStatementCase();             break;
            }  
  
            //
            // Rule 178:  labeled_statement ::= default : statement
            //
            case 178: { action.   consumeStatementDefault();             break;
            }  
  
            //
            // Rule 179:  expression_statement ::= expression ;
            //
            case 179: { action.   consumeStatementExpression();             break;
            }  
  
            //
            // Rule 180:  expression_statement ::= ;
            //
            case 180: { action.   consumeStatementNull();             break;
            }  
  
            //
            // Rule 181:  compound_statement ::= { <openscope-ast> statement_seq }
            //
            case 181: { action.   consumeStatementCompoundStatement(true);             break;
            }  
  
            //
            // Rule 182:  compound_statement ::= { }
            //
            case 182: { action.   consumeStatementCompoundStatement(false);             break;
            }  
  
            //
            // Rule 185:  selection_statement ::= if ( condition ) statement
            //
            case 185: { action.   consumeStatementIf(false);             break;
            }  
  
            //
            // Rule 186:  selection_statement ::= if ( condition ) statement else statement
            //
            case 186: { action.   consumeStatementIf(true);             break;
            }  
  
            //
            // Rule 187:  selection_statement ::= switch ( condition ) statement
            //
            case 187: { action.   consumeStatementSwitch();             break;
            }  
  
            //
            // Rule 189:  condition ::= type_specifier_seq declarator = assignment_expression
            //
            case 189: { action.   consumeConditionDeclaration();             break;
            }  
  
            //
            // Rule 191:  condition_opt ::= $Empty
            //
            case 191: { action.   consumeEmpty();            break;
            }  
  
            //
            // Rule 192:  iteration_statement ::= while ( condition ) statement
            //
            case 192: { action.   consumeStatementWhileLoop();             break;
            }  
  
            //
            // Rule 193:  iteration_statement ::= do statement while ( expression ) ;
            //
            case 193: { action.   consumeStatementDoLoop(true);             break;
            }  
  
            //
            // Rule 194:  iteration_statement ::= do statement
            //
            case 194: { action.   consumeStatementDoLoop(false);             break;
            }  
  
            //
            // Rule 195:  iteration_statement ::= for ( for_init_statement condition_opt ; expression_opt ) statement
            //
            case 195: { action.  consumeStatementForLoop();            break;
            }  
  
            //
            // Rule 197:  for_init_statement ::= simple_declaration_with_declspec
            //
            case 197: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 198:  jump_statement ::= break ;
            //
            case 198: { action.   consumeStatementBreak();             break;
            }  
  
            //
            // Rule 199:  jump_statement ::= continue ;
            //
            case 199: { action.   consumeStatementContinue();             break;
            }  
  
            //
            // Rule 200:  jump_statement ::= return expression ;
            //
            case 200: { action.   consumeStatementReturn(true);             break;
            }  
  
            //
            // Rule 201:  jump_statement ::= return ;
            //
            case 201: { action.   consumeStatementReturn(false);             break;
            }  
  
            //
            // Rule 202:  jump_statement ::= goto identifier_token ;
            //
            case 202: { action.   consumeStatementGoto();             break;
            }  
  
            //
            // Rule 203:  declaration_statement ::= block_declaration
            //
            case 203: { action.   consumeStatementDeclarationWithDisambiguation();             break;
            }  
  
            //
            // Rule 204:  declaration_statement ::= function_definition
            //
            case 204: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 212:  declaration ::= ERROR_TOKEN
            //
            case 212: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 222:  simple_declaration ::= declaration_specifiers_opt <openscope-ast> init_declarator_list_opt ;
            //
            case 222: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 223:  simple_declaration_with_declspec ::= declaration_specifiers <openscope-ast> init_declarator_list_opt ;
            //
            case 223: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 224:  declaration_specifiers ::= <openscope-ast> simple_declaration_specifiers
            //
            case 224: { action.   consumeDeclarationSpecifiersSimple();             break;
            }  
  
            //
            // Rule 225:  declaration_specifiers ::= <openscope-ast> class_declaration_specifiers
            //
            case 225: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 226:  declaration_specifiers ::= <openscope-ast> elaborated_declaration_specifiers
            //
            case 226: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 227:  declaration_specifiers ::= <openscope-ast> enum_declaration_specifiers
            //
            case 227: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 228:  declaration_specifiers ::= <openscope-ast> type_name_declaration_specifiers
            //
            case 228: { action.   consumeDeclarationSpecifiersTypeName();             break;
            }  
  
            //
            // Rule 230:  declaration_specifiers_opt ::= $Empty
            //
            case 230: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 234:  no_type_declaration_specifier ::= friend
            //
            case 234: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 235:  no_type_declaration_specifier ::= typedef
            //
            case 235: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 255:  storage_class_specifier ::= auto
            //
            case 255: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 256:  storage_class_specifier ::= register
            //
            case 256: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 257:  storage_class_specifier ::= static
            //
            case 257: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 258:  storage_class_specifier ::= extern
            //
            case 258: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 259:  storage_class_specifier ::= mutable
            //
            case 259: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 260:  function_specifier ::= inline
            //
            case 260: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 261:  function_specifier ::= virtual
            //
            case 261: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 262:  function_specifier ::= explicit
            //
            case 262: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 263:  simple_type_specifier ::= simple_type_specifier_token
            //
            case 263: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 277:  type_name_specifier ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 277: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 278:  type_name_specifier ::= dcolon_opt nested_name_specifier template template_id_name
            //
            case 278: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 279:  type_name_specifier ::= typename dcolon_opt nested_name_specifier identifier_name
            //
            case 279: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 280:  type_name_specifier ::= typename dcolon_opt nested_name_specifier template_opt template_id_name
            //
            case 280: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 282:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 282: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 283:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt template_opt template_id_name
            //
            case 283: { action.   consumeTypeSpecifierElaborated(true);              break;
            }  
  
            //
            // Rule 284:  elaborated_type_specifier ::= enum elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 284: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 288:  enum_specifier ::= enum enum_specifier_hook { <openscope-ast> enumerator_list_opt comma_opt }
            //
            case 288: { action.   consumeTypeSpecifierEnumeration(false);            break;
            }  
  
            //
            // Rule 289:  enum_specifier ::= enum enum_specifier_hook identifier_token { <openscope-ast> enumerator_list_opt comma_opt }
            //
            case 289: { action.   consumeTypeSpecifierEnumeration(true);            break;
            }  
  
            //
            // Rule 295:  enumerator_definition ::= identifier_token
            //
            case 295: { action.   consumeEnumerator(false);            break;
            }  
  
            //
            // Rule 296:  enumerator_definition ::= identifier_token = constant_expression
            //
            case 296: { action.   consumeEnumerator(true);            break;
            }  
  
            //
            // Rule 298:  namespace_definition ::= namespace namespace_name namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 298: { action.   consumeNamespaceDefinition(true);             break;
            }  
  
            //
            // Rule 299:  namespace_definition ::= namespace namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 299: { action.   consumeNamespaceDefinition(false);             break;
            }  
  
            //
            // Rule 301:  namespace_alias_definition ::= namespace identifier_token = dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 301: { action.   consumeNamespaceAliasDefinition();            break;
            }  
  
            //
            // Rule 302:  using_declaration ::= using typename_opt dcolon_opt nested_name_specifier_opt unqualified_id_name ;
            //
            case 302: { action.   consumeUsingDeclaration();             break;
            }  
  
            //
            // Rule 303:  typename_opt ::= typename
            //
            case 303: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 304:  typename_opt ::= $Empty
            //
            case 304: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 305:  using_directive ::= using namespace dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 305: { action.   consumeUsingDirective();             break;
            }  
  
            //
            // Rule 306:  linkage_specification ::= extern stringlit { <openscope-ast> declaration_seq_opt }
            //
            case 306: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 307:  linkage_specification ::= extern stringlit <openscope-ast> declaration
            //
            case 307: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 312:  init_declarator_complete ::= init_declarator
            //
            case 312: { action.   consumeInitDeclaratorComplete();             break;
            }  
  
            //
            // Rule 314:  init_declarator ::= complete_declarator initializer
            //
            case 314: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 317:  declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 317: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 319:  function_declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 319: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 323:  basic_direct_declarator ::= declarator_id_name
            //
            case 323: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 324:  basic_direct_declarator ::= ( declarator )
            //
            case 324: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 325:  function_direct_declarator ::= basic_direct_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 325: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 326:  array_direct_declarator ::= array_direct_declarator array_modifier
            //
            case 326: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 327:  array_direct_declarator ::= basic_direct_declarator array_modifier
            //
            case 327: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 328:  array_modifier ::= [ constant_expression ]
            //
            case 328: { action.   consumeDirectDeclaratorArrayModifier(true);             break;
            }  
  
            //
            // Rule 329:  array_modifier ::= [ ]
            //
            case 329: { action.   consumeDirectDeclaratorArrayModifier(false);             break;
            }  
  
            //
            // Rule 330:  ptr_operator ::= pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 330: { action.   consumePointer();             break;
            }  
  
            //
            // Rule 331:  ptr_operator ::= pointer_hook & pointer_hook
            //
            case 331: { action.   consumeReferenceOperator();             break;
            }  
  
            //
            // Rule 332:  ptr_operator ::= dcolon_opt nested_name_specifier pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 332: { action.   consumePointerToMember();             break;
            }  
  
            //
            // Rule 339:  cv_qualifier ::= const
            //
            case 339: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 340:  cv_qualifier ::= volatile
            //
            case 340: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 342:  declarator_id_name ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 342: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 343:  type_id ::= type_specifier_seq
            //
            case 343: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 344:  type_id ::= type_specifier_seq abstract_declarator
            //
            case 344: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 347:  abstract_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 347: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 348:  abstract_declarator ::= <openscope-ast> ptr_operator_seq direct_abstract_declarator
            //
            case 348: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 352:  basic_direct_abstract_declarator ::= ( abstract_declarator )
            //
            case 352: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 353:  basic_direct_abstract_declarator ::= ( )
            //
            case 353: { action.   consumeAbstractDeclaratorEmpty();             break;
            }  
  
            //
            // Rule 354:  array_direct_abstract_declarator ::= array_modifier
            //
            case 354: { action.   consumeDirectDeclaratorArrayDeclarator(false);             break;
            }  
  
            //
            // Rule 355:  array_direct_abstract_declarator ::= array_direct_abstract_declarator array_modifier
            //
            case 355: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 356:  array_direct_abstract_declarator ::= basic_direct_abstract_declarator array_modifier
            //
            case 356: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 357:  function_direct_abstract_declarator ::= basic_direct_abstract_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 357: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 358:  function_direct_abstract_declarator ::= ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 358: { action.   consumeDirectDeclaratorFunctionDeclarator(false);             break;
            }  
  
            //
            // Rule 359:  parameter_declaration_clause ::= parameter_declaration_list_opt ...
            //
            case 359: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 360:  parameter_declaration_clause ::= parameter_declaration_list_opt
            //
            case 360: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 361:  parameter_declaration_clause ::= parameter_declaration_list , ...
            //
            case 361: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 367:  abstract_declarator_opt ::= $Empty
            //
            case 367: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 368:  parameter_declaration ::= declaration_specifiers parameter_init_declarator
            //
            case 368: { action.   consumeParameterDeclaration();             break;
            }  
  
            //
            // Rule 369:  parameter_declaration ::= declaration_specifiers
            //
            case 369: { action.   consumeParameterDeclarationWithoutDeclarator();             break;
            }  
  
            //
            // Rule 371:  parameter_init_declarator ::= declarator = parameter_initializer
            //
            case 371: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 373:  parameter_init_declarator ::= abstract_declarator = parameter_initializer
            //
            case 373: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 374:  parameter_init_declarator ::= = parameter_initializer
            //
            case 374: { action.   consumeDeclaratorWithInitializer(false);             break;
            }  
  
            //
            // Rule 375:  parameter_initializer ::= assignment_expression
            //
            case 375: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 376:  function_definition ::= declaration_specifiers_opt function_declarator <openscope-ast> ctor_initializer_list_opt function_body
            //
            case 376: { action.   consumeFunctionDefinition(false);             break;
            }  
  
            //
            // Rule 377:  function_definition ::= declaration_specifiers_opt function_declarator try <openscope-ast> ctor_initializer_list_opt function_body <openscope-ast> handler_seq
            //
            case 377: { action.   consumeFunctionDefinition(true);             break;
            }  
  
            //
            // Rule 380:  initializer ::= ( expression_list )
            //
            case 380: { action.   consumeInitializerConstructor();             break;
            }  
  
            //
            // Rule 381:  initializer_clause ::= assignment_expression
            //
            case 381: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 382:  initializer_clause ::= initializer_list
            //
            case 382: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 383:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq , } end_initializer_list
            //
            case 383: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 384:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq } end_initializer_list
            //
            case 384: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 385:  initializer_list ::= { <openscope-ast> }
            //
            case 385: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 386:  start_initializer_list ::= $Empty
            //
            case 386: { action.   initializerListStart();            break;
            }  
  
            //
            // Rule 387:  end_initializer_list ::= $Empty
            //
            case 387: { action.   initializerListEnd();            break;
            }  
  
            //
            // Rule 392:  class_specifier ::= class_head { <openscope-ast> member_declaration_list_opt }
            //
            case 392: { action.   consumeClassSpecifier();             break;
            }  
  
            //
            // Rule 393:  class_head ::= class_keyword composite_specifier_hook identifier_name_opt class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 393: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 394:  class_head ::= class_keyword composite_specifier_hook template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 394: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 395:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier identifier_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 395: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 396:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 396: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 400:  identifier_name_opt ::= $Empty
            //
            case 400: { action.   consumeEmpty();             break;
            } 
  
            //
            // Rule 404:  visibility_label ::= access_specifier_keyword :
            //
            case 404: { action.   consumeVisibilityLabel();             break;
            }  
  
            //
            // Rule 405:  member_declaration ::= declaration_specifiers_opt <openscope-ast> member_declarator_list ;
            //
            case 405: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 406:  member_declaration ::= declaration_specifiers_opt ;
            //
            case 406: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 409:  member_declaration ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name ;
            //
            case 409: { action.   consumeMemberDeclarationQualifiedId();             break;
            }  
  
            //
            // Rule 415:  member_declaration ::= ERROR_TOKEN
            //
            case 415: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 424:  member_declarator ::= declarator constant_initializer
            //
            case 424: { action.   consumeMemberDeclaratorWithInitializer();             break;
            }  
  
            //
            // Rule 425:  member_declarator ::= bit_field_declarator : constant_expression
            //
            case 425: { action.   consumeBitField(true);             break;
            }  
  
            //
            // Rule 426:  member_declarator ::= : constant_expression
            //
            case 426: { action.   consumeBitField(false);             break;
            }  
  
            //
            // Rule 427:  bit_field_declarator ::= identifier_name
            //
            case 427: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 428:  constant_initializer ::= = constant_expression
            //
            case 428: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 434:  base_specifier ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 434: { action.   consumeBaseSpecifier(false, false);             break;
            }  
  
            //
            // Rule 435:  base_specifier ::= virtual access_specifier_keyword_opt dcolon_opt nested_name_specifier_opt class_name
            //
            case 435: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 436:  base_specifier ::= access_specifier_keyword virtual dcolon_opt nested_name_specifier_opt class_name
            //
            case 436: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 437:  base_specifier ::= access_specifier_keyword dcolon_opt nested_name_specifier_opt class_name
            //
            case 437: { action.   consumeBaseSpecifier(true, false);             break;
            }  
  
            //
            // Rule 438:  access_specifier_keyword ::= private
            //
            case 438: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 439:  access_specifier_keyword ::= protected
            //
            case 439: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 440:  access_specifier_keyword ::= public
            //
            case 440: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 442:  access_specifier_keyword_opt ::= $Empty
            //
            case 442: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 444:  conversion_function_id_name ::= conversion_function_id < <openscope-ast> template_argument_list_opt >
            //
            case 444: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 445:  conversion_function_id ::= operator conversion_type_id
            //
            case 445: { action.   consumeConversionName();            break;
            }  
  
            //
            // Rule 446:  conversion_type_id ::= type_specifier_seq conversion_declarator
            //
            case 446: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 447:  conversion_type_id ::= type_specifier_seq
            //
            case 447: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 448:  conversion_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 448: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 454:  mem_initializer ::= mem_initializer_name ( expression_list_opt )
            //
            case 454: { action.   consumeConstructorChainInitializer();             break;
            }  
  
            //
            // Rule 455:  mem_initializer_name ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 455: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 458:  operator_function_id_name ::= operator_id_name < <openscope-ast> template_argument_list_opt >
            //
            case 458: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 459:  operator_id_name ::= operator overloadable_operator
            //
            case 459: { action.   consumeOperatorName();             break;
            }  
  
            //
            // Rule 502:  template_declaration ::= export_opt template < <openscope-ast> template_parameter_list > declaration
            //
            case 502: { action.   consumeTemplateDeclaration();             break;
            }  
  
            //
            // Rule 503:  export_opt ::= export
            //
            case 503: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 504:  export_opt ::= $Empty
            //
            case 504: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 508:  template_parameter ::= parameter_declaration
            //
            case 508: { action.   consumeTemplateParamterDeclaration();             break;
            }  
  
            //
            // Rule 509:  type_parameter ::= class identifier_name_opt
            //
            case 509: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 510:  type_parameter ::= class identifier_name_opt = type_id
            //
            case 510: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 511:  type_parameter ::= typename identifier_name_opt
            //
            case 511: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 512:  type_parameter ::= typename identifier_name_opt = type_id
            //
            case 512: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 513:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt
            //
            case 513: { action.   consumeTemplatedTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 514:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt = id_expression
            //
            case 514: { action.   consumeTemplatedTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 515:  template_id_name ::= identifier_name < <openscope-ast> template_argument_list_opt >
            //
            case 515: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 520:  template_argument ::= assignment_expression
            //
            case 520: { action.   consumeTemplateArgumentExpression();             break;
            }  
  
            //
            // Rule 521:  template_argument ::= type_id
            //
            case 521: { action.   consumeTemplateArgumentTypeId();             break;
            }  
  
            //
            // Rule 522:  explicit_instantiation ::= template declaration
            //
            case 522: { action.   consumeTemplateExplicitInstantiation();             break;
            }  
  
            //
            // Rule 523:  explicit_specialization ::= template < > declaration
            //
            case 523: { action.   consumeTemplateExplicitSpecialization();             break;
            }  
  
            //
            // Rule 524:  try_block ::= try compound_statement <openscope-ast> handler_seq
            //
            case 524: { action.   consumeStatementTryBlock(true);             break;
            }  
  
            //
            // Rule 525:  try_block ::= try compound_statement
            //
            case 525: { action.   consumeStatementTryBlock(false);             break;
            }  
  
            //
            // Rule 528:  handler ::= catch ( exception_declaration ) compound_statement
            //
            case 528: { action.   consumeStatementCatchHandler(false);             break;
            }  
  
            //
            // Rule 529:  handler ::= catch ( ... ) compound_statement
            //
            case 529: { action.   consumeStatementCatchHandler(true);             break;
            }  
  
            //
            // Rule 530:  exception_declaration ::= type_specifier_seq <openscope-ast> declarator
            //
            case 530: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 531:  exception_declaration ::= type_specifier_seq <openscope-ast> abstract_declarator
            //
            case 531: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 532:  exception_declaration ::= type_specifier_seq
            //
            case 532: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 534:  exception_specification ::= throw ( )
            //
            case 534: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 555:  attribute_parameter ::= assignment_expression
            //
            case 555: { action.   consumeIgnore();            break;
            }  
 
            //
            // Rule 566:  extended_asm_declaration ::= asm volatile_opt ( extended_asm_param_seq ) ;
            //
            case 566: {  gnuAction.consumeDeclarationASM();           break;
            } 
  
            //
            // Rule 577:  unary_expression ::= __alignof__ unary_expression
            //
            case 577: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_alignOf);             break;
            }  
  
            //
            // Rule 578:  unary_expression ::= __alignof__ ( type_id )
            //
            case 578: { action.   consumeExpressionTypeId(IASTTypeIdExpression.op_alignof);             break;
            }  
  
            //
            // Rule 579:  unary_expression ::= typeof unary_expression
            //
            case 579: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_typeof);             break;
            }  
  
            //
            // Rule 580:  unary_expression ::= typeof ( type_id )
            //
            case 580: { action.   consumeExpressionTypeId(IASTTypeIdExpression.op_typeof);             break;
            }  
  
            //
            // Rule 581:  relational_expression ::= relational_expression >? shift_expression
            //
            case 581: { action.   consumeExpressionBinaryOperator(IASTBinaryExpression.op_max);             break;
            }  
  
            //
            // Rule 582:  relational_expression ::= relational_expression <? shift_expression
            //
            case 582: { action.   consumeExpressionBinaryOperator(IASTBinaryExpression.op_min);             break;
            }  
  
            //
            // Rule 583:  conditional_expression ::= logical_or_expression ? <empty> : assignment_expression
            //
            case 583: { action.   consumeExpressionConditional();             break;
            }  
 
            //
            // Rule 584:  primary_expression ::= ( compound_statement )
            //
            case 584: {  gnuAction.consumeCompoundStatementExpression();            break;
            } 
  
            //
            // Rule 585:  labeled_statement ::= case case_range_expression : statement
            //
            case 585: { action.   consumeStatementCase();             break;
            }  
  
            //
            // Rule 586:  case_range_expression ::= constant_expression ... constant_expression
            //
            case 586: { action.   consumeExpressionBinaryOperator(IASTBinaryExpression.op_assign);             break;
            }  
  
            //
            // Rule 590:  typeof_type_specifier ::= typeof unary_expression
            //
            case 590: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_typeof);             break;
            }  
  
            //
            // Rule 591:  typeof_type_specifier ::= typeof ( type_id )
            //
            case 591: { action.   consumeExpressionTypeId(IASTTypeIdExpression.op_typeof);             break;
            }  
  
            //
            // Rule 592:  declaration_specifiers ::= <openscope-ast> typeof_declaration_specifiers
            //
            case 592: { action.   consumeDeclarationSpecifiersTypeof();             break;
            }  
  
            //
            // Rule 605:  declarator ::= <openscope-ast> ptr_operator_seq attribute_or_decl_specifier_seq direct_declarator
            //
            case 605: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 608:  simple_type_specifier ::= _Complex
            //
            case 608: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 609:  simple_type_specifier ::= _Imaginary
            //
            case 609: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 610:  cv_qualifier ::= restrict
            //
            case 610: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 611:  explicit_instantiation ::= extern template declaration
            //
            case 611: { action.   consumeTemplateExplicitInstantiationGCC(IGPPASTExplicitTemplateInstantiation.ti_extern);             break;
            }  
  
            //
            // Rule 612:  explicit_instantiation ::= static template declaration
            //
            case 612: { action.   consumeTemplateExplicitInstantiationGCC(IGPPASTExplicitTemplateInstantiation.ti_static);             break;
            }  
  
            //
            // Rule 613:  explicit_instantiation ::= inline template declaration
            //
            case 613: { action.   consumeTemplateExplicitInstantiationGCC(IGPPASTExplicitTemplateInstantiation.ti_inline);             break;
            }  
  
            //
            // Rule 614:  postfix_expression ::= ( type_id ) initializer_list
            //
            case 614: { action.   consumeExpressionTypeIdInitializer();             break;
            }  

    
            default:
                break;
        }
        return;
    }
}

