/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.Assert;

public class CPPASTAmbiguousDeclarator
extends ASTAmbiguousNode
implements IASTAmbiguousDeclarator,
ICPPASTDeclarator {
    private IASTDeclarator[] dtors = new IASTDeclarator[2];
    private int dtorPos = -1;
    private IASTInitializer fInitializer;

    public CPPASTAmbiguousDeclarator(IASTDeclarator ... decls) {
        IASTDeclarator[] iASTDeclaratorArray = decls;
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator d = iASTDeclaratorArray[n2];
            if (d != null) {
                this.addDeclarator(d);
            }
            ++n2;
        }
    }

    protected void beforeResolution() {
        IScope scope = CPPVisitor.getContainingNonTemplateScope(this);
        if (scope instanceof ICPPASTInternalScope) {
            ((ICPPASTInternalScope)scope).populateCache();
        }
    }

    protected void afterResolution(ASTVisitor resolver, IASTNode best) {
        if (this.fInitializer != null) {
            ((IASTDeclarator)best).setInitializer(this.fInitializer);
            this.fInitializer.accept(resolver);
        }
    }

    public IASTDeclarator copy() {
        throw new UnsupportedOperationException();
    }

    public void addDeclarator(IASTDeclarator d) {
        this.assertNotFrozen();
        if (d != null) {
            this.dtors = (IASTDeclarator[])ArrayUtil.append(IASTDeclarator.class, this.dtors, ++this.dtorPos, d);
            d.setParent(this);
            d.setPropertyInParent(SUBDECLARATOR);
        }
    }

    public IASTDeclarator[] getDeclarators() {
        this.dtors = (IASTDeclarator[])ArrayUtil.removeNullsAfter(IASTDeclarator.class, this.dtors, this.dtorPos);
        return this.dtors;
    }

    public IASTNode[] getNodes() {
        return this.getDeclarators();
    }

    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    public IASTName getName() {
        return this.dtors[0].getName();
    }

    public IASTDeclarator getNestedDeclarator() {
        return this.dtors[0].getNestedDeclarator();
    }

    public IASTPointerOperator[] getPointerOperators() {
        return this.dtors[0].getPointerOperators();
    }

    public int getRoleForName(IASTName name) {
        return this.dtors[0].getRoleForName(name);
    }

    public void addPointerOperator(IASTPointerOperator operator) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    public void setInitializer(IASTInitializer initializer) {
        this.fInitializer = initializer;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    public void setNestedDeclarator(IASTDeclarator nested) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    public boolean declaresParameterPack() {
        return false;
    }

    public void setDeclaresParameterPack(boolean val) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }
}

