/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.indexer.DeltaAnalyzer;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CModelListener
implements IElementChangedListener,
IResourceChangeListener {
    private static final int UPDATE_LR_CHANGED_FILES_COUNT = 5;
    private PDOMManager fManager;
    private LinkedHashMap<ITranslationUnit, ITranslationUnit> fLRUs = new LinkedHashMap<ITranslationUnit, ITranslationUnit>(5, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ITranslationUnit, ITranslationUnit> eldest) {
            return this.size() > 5;
        }
    };

    public CModelListener(PDOMManager manager) {
        this.fManager = manager;
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        HashMap<ICProject, DeltaAnalyzer> changeMap = new HashMap<ICProject, DeltaAnalyzer>();
        this.processDelta(event.getDelta(), changeMap);
        this.addLastRecentlyUsed(changeMap);
        for (Map.Entry<ICProject, DeltaAnalyzer> entry : changeMap.entrySet()) {
            ICProject cproject = entry.getKey();
            DeltaAnalyzer analyzer = entry.getValue();
            this.fManager.changeProject(cproject, analyzer.getForcedTUs(), analyzer.getChangedTUs(), analyzer.getRemovedTUs());
        }
    }

    private void processDelta(ICElementDelta delta, HashMap<ICProject, DeltaAnalyzer> changeMap) {
        int type = delta.getElement().getElementType();
        block0 : switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i], changeMap);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject project = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 1: {
                        this.fManager.addProject(project);
                        break block0;
                    }
                    case 4: {
                        this.processProjectDelta(project, delta, changeMap);
                        break block0;
                    }
                    case 2: {
                        this.fManager.removeProject(project, delta);
                    }
                }
            }
        }
    }

    private void processProjectDelta(ICProject project, ICElementDelta delta, HashMap<ICProject, DeltaAnalyzer> changeMap) {
        IPDOMIndexer indexer = this.fManager.getIndexer(project);
        if (indexer != null && indexer.getID().equals("org.eclipse.cdt.core.nullindexer")) {
            return;
        }
        DeltaAnalyzer deltaAnalyzer = new DeltaAnalyzer();
        try {
            deltaAnalyzer.analyzeDelta(delta);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        changeMap.put(project, deltaAnalyzer);
    }

    private void addLastRecentlyUsed(HashMap<ICProject, DeltaAnalyzer> changeMap) {
        boolean addLRUs = false;
        int count = 0;
        ITranslationUnit[] newLRUs = new ITranslationUnit[5];
        for (DeltaAnalyzer analyzer : changeMap.values()) {
            for (ITranslationUnit tu : analyzer.getChangedList()) {
                newLRUs[count++ % 5] = tu;
                if (addLRUs || !tu.isHeaderUnit()) continue;
                addLRUs = true;
            }
        }
        if (count > 0) {
            if (addLRUs) {
                for (ITranslationUnit tu : this.fLRUs.keySet()) {
                    if (!tu.getResource().exists()) continue;
                    ICProject cproject = tu.getCProject();
                    DeltaAnalyzer analyzer = changeMap.get(cproject);
                    if (analyzer == null) {
                        analyzer = new DeltaAnalyzer();
                        changeMap.put(cproject, analyzer);
                    }
                    analyzer.getForcedList().add(tu);
                }
            }
            count = Math.min(count, newLRUs.length);
            int i = 0;
            while (i < count) {
                ITranslationUnit tu = newLRUs[i];
                this.fLRUs.put(tu, tu);
                ++i;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 16) {
            this.fManager.handlePostBuildEvent();
        }
    }
}

