/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryContentsKey;
import org.eclipse.cdt.core.settings.model.util.EntryNameKey;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CExternalSettinsDeltaCalculator {
    private static CExternalSettinsDeltaCalculator fInstance;

    private CExternalSettinsDeltaCalculator() {
    }

    public static CExternalSettinsDeltaCalculator getInstance() {
        if (fInstance == null) {
            fInstance = new CExternalSettinsDeltaCalculator();
        }
        return fInstance;
    }

    private static ExtSettingsDelta createDelta(CExternalSetting setting1, CExternalSetting setting2) {
        int[] kinds = KindBasedStore.getAllEntryKinds();
        ExtSettingsDelta extDelta = null;
        int[] nArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            ICSettingEntry[] entries1 = setting1.getEntries(kind);
            ICSettingEntry[] entries2 = setting2.getEntries(kind);
            Map<EntryContentsKey, ICSettingEntry> map1 = CDataUtil.fillEntriesMapByContentsKey(new LinkedHashMap<EntryContentsKey, ICSettingEntry>(), entries1);
            Map<EntryContentsKey, ICSettingEntry> map2 = CDataUtil.fillEntriesMapByContentsKey(new LinkedHashMap<EntryContentsKey, ICSettingEntry>(), entries2);
            LinkedHashMap<EntryContentsKey, ICSettingEntry> map1Copy = new LinkedHashMap<EntryContentsKey, ICSettingEntry>(map1);
            map1.keySet().removeAll(map2.keySet());
            map2.keySet().removeAll(map1Copy.keySet());
            ICSettingEntry[] entriesAdded = null;
            ICSettingEntry[] entriesRemoved = null;
            if (map1.size() != 0) {
                entriesAdded = map1.values().toArray(new ICSettingEntry[map1.size()]);
            }
            if (map2.size() != 0) {
                entriesRemoved = map2.values().toArray(new ICSettingEntry[map2.size()]);
            }
            if (entriesAdded != null || entriesRemoved != null) {
                if (extDelta == null) {
                    extDelta = new ExtSettingsDelta(setting1);
                }
                extDelta.fEntryChangeStore.put(kind, new ICSettingEntry[][]{entriesAdded, entriesRemoved});
            }
            ++n2;
        }
        return extDelta;
    }

    static boolean settingsMatch(ICExternalSetting setting1, ICExternalSetting setting2) {
        if (setting1.equals(setting2)) {
            return true;
        }
        return CExternalSettinsDeltaCalculator.settingsMatch(setting1, setting2.getCompatibleLanguageIds(), setting2.getCompatibleContentTypeIds(), setting2.getCompatibleExtensions());
    }

    static boolean settingsMatch(ICExternalSetting setting, String[] languageIDs, String[] contentTypeIDs, String[] extensions) {
        if (!Arrays.equals(setting.getCompatibleLanguageIds(), languageIDs)) {
            return false;
        }
        if (!Arrays.equals(setting.getCompatibleContentTypeIds(), contentTypeIDs)) {
            return false;
        }
        return Arrays.equals(setting.getCompatibleExtensions(), extensions);
    }

    private static Map<ExtSettingMapKey, ICExternalSetting> toSettingsKeyMap(ICExternalSetting[] settings) {
        HashMap<ExtSettingMapKey, ICExternalSetting> map = new HashMap<ExtSettingMapKey, ICExternalSetting>();
        ICExternalSetting[] iCExternalSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ICExternalSetting setting = iCExternalSettingArray[n2];
            if (map.put(new ExtSettingMapKey(setting), setting) != null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        return map;
    }

    ExtSettingsDelta[] getSettingChange(CExternalSetting[] newSettings, CExternalSetting[] oldSettings) {
        if (newSettings == null || newSettings.length == 0) {
            return CExternalSettinsDeltaCalculator.createDeltas(oldSettings, false);
        }
        if (oldSettings == null || oldSettings.length == 0) {
            return CExternalSettinsDeltaCalculator.createDeltas(newSettings, true);
        }
        ArrayList<ExtSettingsDelta> deltaList = new ArrayList<ExtSettingsDelta>();
        Map<ExtSettingMapKey, ICExternalSetting> newMap = CExternalSettinsDeltaCalculator.toSettingsKeyMap(newSettings);
        Map<ExtSettingMapKey, ICExternalSetting> oldMap = CExternalSettinsDeltaCalculator.toSettingsKeyMap(oldSettings);
        for (Map.Entry<ExtSettingMapKey, ICExternalSetting> entry : newMap.entrySet()) {
            CExternalSetting newSetting = (CExternalSetting)entry.getValue();
            CExternalSetting oldSetting = (CExternalSetting)oldMap.remove(entry.getKey());
            if (oldSetting == null) {
                deltaList.add(new ExtSettingsDelta(newSetting, true));
                continue;
            }
            ExtSettingsDelta delta = CExternalSettinsDeltaCalculator.createDelta(newSetting, oldSetting);
            if (delta == null) continue;
            deltaList.add(delta);
        }
        for (ICExternalSetting oldSettng : oldMap.values()) {
            deltaList.add(new ExtSettingsDelta((CExternalSetting)oldSettng, false));
        }
        if (deltaList.size() == 0) {
            return null;
        }
        return deltaList.toArray(new ExtSettingsDelta[deltaList.size()]);
    }

    private static ExtSettingsDelta[] createDeltas(CExternalSetting[] settings, boolean added) {
        if (settings == null || settings.length == 0) {
            return null;
        }
        ExtSettingsDelta[] deltas = new ExtSettingsDelta[settings.length];
        int i = 0;
        while (i < settings.length) {
            deltas[i] = new ExtSettingsDelta(settings[i], added);
            ++i;
        }
        return deltas;
    }

    Set<ICSettingEntry> calculateUpdatedEntries(ICSettingEntry[] current, ICSettingEntry[] added, ICSettingEntry[] removed) {
        LinkedHashSet<ICSettingEntry> set = new LinkedHashSet<ICSettingEntry>();
        set.addAll(Arrays.asList(current));
        set.addAll(Arrays.asList(added));
        set.removeAll(Arrays.asList(removed));
        return set;
    }

    static ICSettingEntry[][] getAllEntries(ExtSettingsDelta[] deltas, int kind) {
        if (deltas == null || deltas.length == 0) {
            return null;
        }
        LinkedHashMap<EntryNameKey, ICSettingEntry> addedMap = new LinkedHashMap<EntryNameKey, ICSettingEntry>();
        LinkedHashMap<EntryNameKey, ICSettingEntry> removedMap = new LinkedHashMap<EntryNameKey, ICSettingEntry>();
        ExtSettingsDelta[] extSettingsDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            ExtSettingsDelta delta = extSettingsDeltaArray[n2];
            ICSettingEntry[][] change = delta.getEntriesDelta(kind);
            if (change != null) {
                if (change[0] != null) {
                    CDataUtil.fillEntriesMapByNameKey(addedMap, change[0]);
                }
                if (change[1] != null) {
                    CDataUtil.fillEntriesMapByNameKey(removedMap, change[1]);
                }
                removedMap.keySet().removeAll(addedMap.keySet());
            }
            ++n2;
        }
        if (addedMap.size() == 0 && removedMap.size() == 0) {
            return null;
        }
        ICSettingEntry[][] result = new ICSettingEntry[2][];
        if (addedMap.size() != 0) {
            result[0] = addedMap.values().toArray(new ICSettingEntry[addedMap.size()]);
        }
        if (removedMap.size() != 0) {
            result[1] = removedMap.values().toArray(new ICSettingEntry[removedMap.size()]);
        }
        return result;
    }

    static class ExtSettingMapKey {
        private ICExternalSetting fSetting;

        public ExtSettingMapKey(ICExternalSetting setting) {
            this.fSetting = setting;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExtSettingMapKey)) {
                return false;
            }
            ExtSettingMapKey other = (ExtSettingMapKey)obj;
            return CExternalSettinsDeltaCalculator.settingsMatch(this.fSetting, other.fSetting);
        }

        public int hashCode() {
            return this.code(this.fSetting.getCompatibleLanguageIds()) + this.code(this.fSetting.getCompatibleContentTypeIds()) + this.code(this.fSetting.getCompatibleExtensions());
        }

        private int code(String[] arr) {
            if (arr == null || arr.length == 0) {
                return 0;
            }
            int code = 0;
            String[] stringArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                code += str.hashCode();
                ++n2;
            }
            return code;
        }

        public ICExternalSetting getSetting() {
            return this.fSetting;
        }
    }

    static class ExtSettingsDelta {
        CExternalSetting fSetting;
        boolean fAdded;
        KindBasedStore<ICSettingEntry[][]> fEntryChangeStore;

        ExtSettingsDelta(CExternalSetting setting) {
            this.fSetting = setting;
            this.fEntryChangeStore = new KindBasedStore(false);
        }

        ExtSettingsDelta(CExternalSetting setting, boolean added) {
            this.fSetting = setting;
            this.fAdded = added;
        }

        boolean isChange() {
            return this.fEntryChangeStore != null;
        }

        boolean isAdded() {
            return this.fAdded;
        }

        CExternalSetting getSetting() {
            return this.fSetting;
        }

        ICSettingEntry[][] getEntriesDelta(int kind) {
            if (this.fEntryChangeStore != null) {
                return this.fEntryChangeStore.get(kind);
            }
            ICSettingEntry[] entries = this.fSetting.getEntries(kind);
            if (entries == null || entries.length == 0) {
                return null;
            }
            ICSettingEntry[][] delta = new ICSettingEntry[2][];
            if (this.fAdded) {
                delta[0] = entries;
            } else {
                delta[1] = entries;
            }
            return delta;
        }

        ICSettingEntry[][] getEntriesDelta() {
            int[] kinds = KindBasedStore.getLanguageEntryKinds();
            ArrayList<ICSettingEntry> added = new ArrayList<ICSettingEntry>();
            ArrayList<ICSettingEntry> removed = new ArrayList<ICSettingEntry>();
            int[] nArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                int kind = nArray[n2];
                ICSettingEntry[][] d = this.getEntriesDelta(kind);
                if (d != null) {
                    if (d[0] != null) {
                        added.addAll(Arrays.asList(d[0]));
                    }
                    if (d[1] != null) {
                        removed.addAll(Arrays.asList(d[1]));
                    }
                }
                ++n2;
            }
            ICSettingEntry[][] delta = new ICSettingEntry[2][];
            if (added.size() != 0) {
                delta[0] = added.toArray(new ICSettingEntry[added.size()]);
            }
            if (removed.size() != 0) {
                delta[1] = removed.toArray(new ICSettingEntry[removed.size()]);
            }
            return delta;
        }
    }
}

