/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.IExecutableImporter;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.core.executables.IProjectExecutablesProvider;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemappingFactory;
import org.eclipse.cdt.debug.core.executables.ISourceFilesProvider;
import org.eclipse.cdt.debug.core.executables.StandardExecutableProvider;
import org.eclipse.cdt.debug.internal.core.executables.StandardExecutableImporter;
import org.eclipse.cdt.debug.internal.core.executables.StandardSourceFileRemappingFactory;
import org.eclipse.cdt.debug.internal.core.executables.StandardSourceFilesProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutablesManager
extends PlatformObject
implements IResourceChangeListener,
ICProjectDescriptionListener {
    private static final String EXECUTABLES_MANAGER_DEBUG_TRACING = "org.eclipse.cdt.debug.coreEXECUTABLES_MANAGER_DEBUG_TRACING";
    private Map<IProject, IProjectExecutablesProvider> executablesProviderMap = new HashMap<IProject, IProjectExecutablesProvider>();
    private Map<IProject, List<Executable>> executablesMap = new HashMap<IProject, List<Executable>>();
    private List<IExecutablesChangeListener> changeListeners = Collections.synchronizedList(new ArrayList());
    private List<IProjectExecutablesProvider> executableProviders;
    private List<ISourceFilesProvider> sourceFileProviders;
    private List<ISourceFileRemappingFactory> sourceFileRemappingFactories;
    private List<IExecutableImporter> executableImporters;
    private boolean DEBUG;
    private Job refreshJob = new Job("Get Executables"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            ExecutablesManager.this.trace("Get Executables job started at " + ExecutablesManager.this.getStringFromTimestamp(System.currentTimeMillis()));
            List projects = ExecutablesManager.this.getProjectsToCheck();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
            for (IProject project : projects) {
                if (subMonitor.isCanceled()) {
                    ExecutablesManager.this.trace("Get Executables job cancelled at " + ExecutablesManager.this.getStringFromTimestamp(System.currentTimeMillis()));
                    return Status.CANCEL_STATUS;
                }
                subMonitor.subTask("Checking project: " + project.getName());
                IProjectExecutablesProvider provider = ExecutablesManager.this.getExecutablesProviderForProject(project);
                if (provider == null) continue;
                ExecutablesManager.this.trace("Getting executables for project: " + project.getName() + " using " + provider.toString());
                Map map = ExecutablesManager.this.executablesMap;
                synchronized (map) {
                    List<Executable> executables = provider.getExecutables(project, (IProgressMonitor)subMonitor.newChild(1, 0));
                    if (!monitor.isCanceled()) {
                        ExecutablesManager.this.executablesMap.put(project, executables);
                    }
                }
            }
            List list = ExecutablesManager.this.changeListeners;
            synchronized (list) {
                for (IExecutablesChangeListener listener : ExecutablesManager.this.changeListeners) {
                    listener.executablesListChanged();
                }
            }
            ExecutablesManager.this.trace("Get Executables job finished at " + ExecutablesManager.this.getStringFromTimestamp(System.currentTimeMillis()));
            return Status.OK_STATUS;
        }
    };
    private static ExecutablesManager executablesManager = null;

    public static ExecutablesManager getExecutablesManager() {
        if (executablesManager == null) {
            executablesManager = new ExecutablesManager();
        }
        return executablesManager;
    }

    public ExecutablesManager() {
        DebugOptions service;
        ServiceReference reference;
        BundleContext context = CDebugCorePlugin.getDefault().getBundle().getBundleContext();
        if (context != null && (reference = CDebugCorePlugin.getDefault().getBundle().getBundleContext().getServiceReference(DebugOptions.class.getName())) != null && (service = (DebugOptions)context.getService(reference)) != null) {
            try {
                this.DEBUG = service.getBooleanOption(EXECUTABLES_MANAGER_DEBUG_TRACING, false);
            }
            finally {
                context.ungetService(reference);
            }
        }
        this.refreshJob.setPriority(20);
        this.loadExecutableProviderExtensions();
        this.loadSoureFileProviderExtensions();
        this.loadSoureRemappingExtensions();
        this.loadExecutableImporterExtensions();
        this.executableProviders.add(0, new StandardExecutableProvider());
        this.sourceFileProviders.add(0, new StandardSourceFilesProvider());
        this.sourceFileRemappingFactories.add(0, new StandardSourceFileRemappingFactory());
        this.executableImporters.add(0, new StandardExecutableImporter());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 17);
        CoreModel.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener((ICProjectDescriptionListener)this, 4);
        this.scheduleRefresh();
    }

    public void addExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Executable> getExecutables(boolean wait) {
        this.trace("getExecutables called at " + this.getStringFromTimestamp(System.currentTimeMillis()));
        ArrayList<Executable> executables = new ArrayList<Executable>();
        if (wait && this.refreshJob.getState() != 0) {
            this.trace("waiting for refresh job to finish at " + this.getStringFromTimestamp(System.currentTimeMillis()));
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException interruptedException) {}
            this.trace("refresh job finished at " + this.getStringFromTimestamp(System.currentTimeMillis()));
        }
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            for (List<Executable> exes : this.executablesMap.values()) {
                for (Executable exe : exes) {
                    if (executables.contains((Object)exe)) continue;
                    executables.add(exe);
                }
            }
        }
        this.trace("getExecutables returned at " + this.getStringFromTimestamp(System.currentTimeMillis()));
        return executables;
    }

    public Collection<Executable> getExecutables() {
        return this.getExecutables(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Executable> getExecutablesForProject(IProject project) {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            List<Executable> exes = this.executablesMap.get(project);
            if (exes != null) {
                for (Executable exe : exes) {
                    if (executables.contains((Object)exe)) continue;
                    executables.add(exe);
                }
            }
        }
        return executables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importExecutables(final String[] fileNames, IProgressMonitor monitor) {
        boolean handled = false;
        monitor.beginTask("Import Executables", this.executableImporters.size());
        List<IExecutableImporter> list = this.executableImporters;
        synchronized (list) {
            Collections.sort(this.executableImporters, new Comparator<IExecutableImporter>(){

                @Override
                public int compare(IExecutableImporter arg0, IExecutableImporter arg1) {
                    int p1;
                    int p0 = arg0.getPriority(fileNames);
                    if (p0 < (p1 = arg1.getPriority(fileNames))) {
                        return 1;
                    }
                    if (p0 > p1) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (IExecutableImporter importer : this.executableImporters) {
                handled = importer.importExecutables(fileNames, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (handled || monitor.isCanceled()) break;
            }
        }
        if (handled) {
            this.scheduleRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executableExists(IPath exePath) {
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            Iterator<List<Executable>> iterator = this.executablesMap.values().iterator();
            block3: while (true) {
                Executable exe;
                if (!iterator.hasNext()) {
                    return false;
                }
                List<Executable> exes = iterator.next();
                Iterator<Executable> iterator2 = exes.iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while (!(exe = iterator2.next()).getPath().equals((Object)exePath));
                break;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceFiles(final Executable executable, IProgressMonitor monitor) {
        String[] result = new String[]{};
        this.trace("getSourceFiles called at " + this.getStringFromTimestamp(System.currentTimeMillis()) + " for " + executable.getPath().toOSString());
        List<ISourceFilesProvider> list = this.sourceFileProviders;
        synchronized (list) {
            Collections.sort(this.sourceFileProviders, new Comparator<ISourceFilesProvider>(){

                @Override
                public int compare(ISourceFilesProvider arg0, ISourceFilesProvider arg1) {
                    int p1;
                    int p0 = arg0.getPriority(executable);
                    if (p0 < (p1 = arg1.getPriority(executable))) {
                        return 1;
                    }
                    if (p0 > p1) {
                        return -1;
                    }
                    return 0;
                }
            });
            monitor.beginTask("Finding source files in " + executable.getName(), this.sourceFileProviders.size() * 1000);
            for (ISourceFilesProvider provider : this.sourceFileProviders) {
                String[] sourceFiles = provider.getSourceFiles(executable, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (sourceFiles.length <= 0) continue;
                result = sourceFiles;
                this.trace("getSourceFiles got " + sourceFiles.length + " files from " + provider.toString());
                break;
            }
            monitor.done();
        }
        this.trace("getSourceFiles returned at " + this.getStringFromTimestamp(System.currentTimeMillis()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus removeExecutables(Executable[] executables, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.cdt.debug.core", 2, "Couldn't remove all of the selected executables", null);
        monitor.beginTask("Remove Executables", executables.length);
        Executable[] executableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            Executable executable = executableArray[n2];
            IProjectExecutablesProvider provider = this.getExecutablesProviderForProject(executable.getProject());
            if (provider != null) {
                IStatus result = provider.removeExecutable(executable, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (result.isOK()) {
                    List<Executable> exes = this.executablesMap.get(executable.getProject());
                    if (exes != null) {
                        exes.remove((Object)executable);
                    }
                } else {
                    status.add(result);
                }
            }
            ++n2;
        }
        if (status.getChildren().length != executables.length) {
            List<IExecutablesChangeListener> list = this.changeListeners;
            synchronized (list) {
                for (IExecutablesChangeListener listener : this.changeListeners) {
                    listener.executablesListChanged();
                }
            }
        }
        return status;
    }

    public void refresh(List<IProject> projects) {
        if (projects == null || projects.size() == 0) {
            this.executablesMap.clear();
        } else {
            for (IProject project : projects) {
                this.executablesMap.remove(project);
            }
        }
        this.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            IResourceDelta[] projects;
            if (event.getType() == 16) {
                block17: {
                    Object obj = event.getSource();
                    if (obj != null && obj instanceof IProject) {
                        try {
                            IProject project = (IProject)obj;
                            if (project.getDescription().getBuildSpec().length <= 0 || !this.executablesMap.containsKey(obj)) break block17;
                            List<Executable> executables = this.executablesMap.remove(obj);
                            this.trace("Scheduling refresh because project " + ((IProject)obj).getName() + " built or cleaned");
                            this.scheduleRefresh();
                            if (executables == null || executables.size() <= 0) break block17;
                            List<IExecutablesChangeListener> list = this.changeListeners;
                            synchronized (list) {
                                for (IExecutablesChangeListener listener : this.changeListeners) {
                                    listener.executablesChanged(executables);
                                }
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return;
            }
            boolean refreshNeeded = false;
            IResourceDelta[] iResourceDeltaArray = projects = event.getDelta().getAffectedChildren();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projectDelta = iResourceDeltaArray[n2];
                if ((projectDelta.getFlags() & 0x4000) != 0 && projectDelta.getKind() == 4) {
                    if (this.executablesMap.containsKey(projectDelta.getResource())) {
                        this.executablesMap.remove(projectDelta.getResource());
                    }
                    refreshNeeded = true;
                }
                ++n2;
            }
            if (refreshNeeded) {
                this.trace("Scheduling refresh because project(s) opened or closed");
                this.scheduleRefresh();
                return;
            }
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource deltaResource;
                        if ((delta.getKind() == 1 || delta.getKind() == 2) && (deltaResource = delta.getResource()) != null) {
                            boolean refresh = false;
                            if (delta.getKind() == 2 && deltaResource instanceof IProject) {
                                if (ExecutablesManager.this.executablesMap.containsKey(deltaResource)) {
                                    ExecutablesManager.this.executablesMap.remove(deltaResource);
                                    refresh = true;
                                    ExecutablesManager.this.trace("Scheduling refresh because project " + deltaResource.getName() + " deleted");
                                }
                            } else {
                                IPath resourcePath = deltaResource.getLocation();
                                if (resourcePath != null && Executable.isExecutableFile(resourcePath) && ExecutablesManager.this.executablesMap.containsKey(deltaResource.getProject())) {
                                    ExecutablesManager.this.executablesMap.remove(deltaResource.getProject());
                                    refresh = true;
                                    ExecutablesManager.this.trace("Scheduling refresh because a binary was added/removed");
                                }
                            }
                            if (refresh) {
                                ExecutablesManager.this.scheduleRefresh();
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(CProjectDescriptionEvent event) {
        boolean refresh = false;
        int eventType = event.getEventType();
        if (eventType == 4) {
            Map<IProject, List<Executable>> map = this.executablesMap;
            synchronized (map) {
                ICProjectDescription newDesc = event.getNewCProjectDescription();
                ICProjectDescription oldDesc = event.getOldCProjectDescription();
                if (oldDesc != null && newDesc != null) {
                    String oldConfigName;
                    String newConfigName = newDesc.getActiveConfiguration().getName();
                    if (!newConfigName.equals(oldConfigName = oldDesc.getActiveConfiguration().getName()) && this.executablesMap.containsKey(newDesc.getProject())) {
                        this.executablesMap.remove(newDesc.getProject());
                        refresh = true;
                        this.trace("Scheduling refresh because active build configuration changed");
                    }
                } else if (newDesc != null && oldDesc == null) {
                    refresh = true;
                    this.trace("Scheduling refresh because project " + newDesc.getProject().getName() + " created");
                }
            }
        }
        if (refresh) {
            this.scheduleRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IProject> getProjectsToCheck() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!this.executablesMap.containsKey(project) && CoreModel.hasCNature((IProject)project)) {
                    projects.add(project);
                }
                ++n2;
            }
        }
        return projects;
    }

    private void scheduleRefresh() {
        this.trace("scheduleRefresh called at " + this.getStringFromTimestamp(System.currentTimeMillis()));
        this.refreshJob.cancel();
        this.refreshJob.schedule();
    }

    private IProjectExecutablesProvider getExecutablesProviderForProject(IProject project) {
        IProjectExecutablesProvider provider = this.executablesProviderMap.get(project);
        if (provider == null) {
            try {
                IProjectDescription description = project.getDescription();
                int mostNaturesMatched = 0;
                for (IProjectExecutablesProvider exeProvider : this.executableProviders) {
                    List<String> natures = exeProvider.getProjectNatures();
                    int naturesMatched = 0;
                    String[] stringArray = description.getNatureIds();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String nature = stringArray[n2];
                        if (natures.contains(nature)) {
                            ++naturesMatched;
                        }
                        ++n2;
                    }
                    if (naturesMatched <= mostNaturesMatched) continue;
                    provider = exeProvider;
                    mostNaturesMatched = naturesMatched;
                }
                this.executablesProviderMap.put(project, provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return provider;
    }

    ISourceFileRemappingFactory[] getSourceFileRemappingFactories() {
        return this.sourceFileRemappingFactories.toArray(new ISourceFileRemappingFactory[this.sourceFileRemappingFactories.size()]);
    }

    private void loadExecutableProviderExtensions() {
        this.executableProviders = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.ExecutablesProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof IProjectExecutablesProvider) {
                    this.executableProviders.add((IProjectExecutablesProvider)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException coreException) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load ExecutablesProvider extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void loadSoureFileProviderExtensions() {
        this.sourceFileProviders = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.SourceFilesProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof ISourceFilesProvider) {
                    this.sourceFileProviders.add((ISourceFilesProvider)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException coreException) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load SourceFilesProvider extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void loadSoureRemappingExtensions() {
        this.sourceFileRemappingFactories = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.SourceRemappingProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof ISourceFileRemappingFactory) {
                    this.sourceFileRemappingFactories.add((ISourceFileRemappingFactory)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException coreException) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load SourceRemappingProvider extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void loadExecutableImporterExtensions() {
        this.executableImporters = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.ExecutablesImporter");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof IExecutableImporter) {
                    this.executableImporters.add((IExecutableImporter)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException coreException) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load ExecutablesImporter extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void trace(String msg) {
        if (this.DEBUG) {
            System.out.println(msg);
        }
    }

    private String getStringFromTimestamp(long timestamp) {
        return DateFormat.getTimeInstance(2).format(new Date(timestamp));
    }
}

