/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IProjectExecutablesProvider;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemapping;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemappingFactory;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardExecutableProvider
implements IProjectExecutablesProvider {
    List<String> supportedNatureIds = new ArrayList<String>();

    public StandardExecutableProvider() {
        this.supportedNatureIds.add("org.eclipse.cdt.core.cnature");
        this.supportedNatureIds.add("org.eclipse.cdt.core.ccnature");
    }

    @Override
    public List<String> getProjectNatures() {
        return this.supportedNatureIds;
    }

    @Override
    public List<Executable> getExecutables(IProject project, IProgressMonitor monitor) {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        ICProject cproject = CModelManager.getDefault().create(project);
        try {
            IBinary[] binaries = cproject.getBinaryContainer().getBinaries();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)binaries.length);
            IBinary[] iBinaryArray = binaries;
            int n = binaries.length;
            int n2 = 0;
            while (n2 < n) {
                IBinary binary = iBinaryArray[n2];
                if (!progress.isCanceled()) {
                    if (binary.isExecutable() || binary.isSharedLib()) {
                        ISourceFileRemappingFactory[] factories;
                        IPath exePath = binary.getResource().getLocation();
                        if (exePath == null) {
                            exePath = binary.getPath();
                        }
                        ArrayList<ISourceFileRemapping> srcRemappers = new ArrayList<ISourceFileRemapping>(2);
                        ISourceFileRemappingFactory[] iSourceFileRemappingFactoryArray = factories = ExecutablesManager.getExecutablesManager().getSourceFileRemappingFactories();
                        int n3 = factories.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISourceFileRemappingFactory factory = iSourceFileRemappingFactoryArray[n4];
                            ISourceFileRemapping remapper = factory.createRemapper(binary);
                            if (remapper != null) {
                                srcRemappers.add(remapper);
                            }
                            ++n4;
                        }
                        executables.add(new Executable(exePath, project, binary.getResource(), srcRemappers.toArray(new ISourceFileRemapping[srcRemappers.size()])));
                    }
                    progress.worked(1);
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (CModelException cModelException) {}
        return executables;
    }

    @Override
    public IStatus removeExecutable(Executable executable, IProgressMonitor monitor) {
        IResource exeResource = executable.getResource();
        if (exeResource != null) {
            try {
                exeResource.delete(true, monitor);
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.cdt.debug.core", "Can't remove " + executable.getName() + ": it is built by project \"" + executable.getProject().getName() + "\"");
    }
}

