/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.windows;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.windows.WindowsDebugger;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.services.IProcesses;

public class RestartCommand
implements IRestart {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final EDCLaunch fLaunch;
    private IChannel fChannel;

    public RestartCommand(DsfSession session, EDCLaunch launch, IChannel channel) {
        this.fExecutor = session.getExecutor();
        this.fLaunch = launch;
        this.fChannel = channel;
        this.fTracker = new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canRestart() {
        return true;
    }

    public void restart() throws DebugException {
        Query<Object> restartQuery = new Query<Object>(){

            protected void execute(DataRequestMonitor<Object> rm) {
                final IProcesses tcfProcesses = (IProcesses)RestartCommand.this.fChannel.getRemoteService("Processes");
                RunControl dsfRC = (RunControl)RestartCommand.this.fTracker.getService(IRunControl.class);
                if (tcfProcesses != null && dsfRC != null) {
                    dsfRC.getRootDMC().terminate(new RequestMonitor((Executor)RestartCommand.this.fExecutor, (RequestMonitor)rm, (DataRequestMonitor)rm){
                        private final /* synthetic */ DataRequestMonitor val$rm;
                        {
                            this.val$rm = dataRequestMonitor;
                            super($anonymous0, $anonymous1);
                        }

                        protected void handleSuccess() {
                            WindowsDebugger.getDefault().launchProcess((ILaunch)RestartCommand.this.fLaunch, tcfProcesses, (RequestMonitor)this.val$rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        this.fExecutor.execute((Runnable)restartQuery);
        try {
            restartQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
    }
}

