/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.windows;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.ITCFAgentLauncher;
import org.eclipse.cdt.debug.edc.windows.WindowsDebugger;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Win32AgentDescriptor
implements ITCFAgentLauncher {
    private static final String NAME = "Win32 Debug Agent";
    private static Process agentProcess;

    public Map<String, String> getPeerAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("Name", NAME);
        attrs.put("DebugSupport", "Win32 Debug API");
        return attrs;
    }

    public String getPeerName() {
        return NAME;
    }

    public List<String> getServiceNames() {
        ArrayList<String> serviceNames = new ArrayList<String>();
        serviceNames.add("Processes");
        serviceNames.add("RunControl");
        serviceNames.add("SimpleRegisters");
        serviceNames.add("Memory");
        return serviceNames;
    }

    public boolean isLaunchable() {
        return File.separatorChar == '\\';
    }

    public void launch() throws Exception {
        URL url = FileLocator.find((Bundle)WindowsDebugger.getDefault().getBundle(), (IPath)new Path("$os$/EDCWindowsDebugAgent.exe"), null);
        if (url != null) {
            url = FileLocator.resolve((URL)url);
            agentProcess = ProcessFactory.getFactory().exec(new String[]{new Path(url.getFile()).toOSString()});
        }
    }

    public void shutdown() throws Exception {
        if (agentProcess != null) {
            agentProcess.destroy();
        }
    }
}

