/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.windows.launch;

import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.TCFServiceManager;
import org.eclipse.cdt.debug.edc.launch.AbstractFinalLaunchSequence;
import org.eclipse.cdt.debug.edc.launch.ChooseProcessItem;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.ui.console.AbstractLoggingConsoleFactory;
import org.eclipse.cdt.debug.edc.windows.RestartCommand;
import org.eclipse.cdt.debug.edc.windows.WindowsDebugger;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tm.tcf.protocol.IChannel;

public class WindowsFinalLaunchSequence
extends AbstractFinalLaunchSequence {
    protected Sequence.Step initLoggingStep = new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
            IChannel channel = tcfServiceManager.getChannelForPeer(WindowsFinalLaunchSequence.this.getTCFPeer());
            AbstractLoggingConsoleFactory.openConsole((String)"DebugProgramOutputConsoleFactory", (String)"Program Output Console", (String)"ProgramOutputConsoleLogger", (IChannel)channel, (boolean)true);
            requestMonitor.done();
        }
    };
    protected Sequence.Step initRestartStep = new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
            IChannel channel = tcfServiceManager.getChannelForPeer(WindowsFinalLaunchSequence.this.getTCFPeer());
            WindowsFinalLaunchSequence.this.launch.getSession().registerModelAdapter(IRestart.class, (Object)new RestartCommand(WindowsFinalLaunchSequence.this.launch.getSession(), WindowsFinalLaunchSequence.this.launch, channel));
            requestMonitor.done();
        }
    };

    public WindowsFinalLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        super(executor, launch, pm, "Configure Windows Debugger:", "Abort configuring Windows debugger");
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        boolean doAttach = false;
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("attach")) {
                doAttach = true;
            }
        }
        catch (CoreException coreException) {}
        this.steps.add(this.trackerStep);
        this.steps.add(this.initFindPeerStep);
        this.steps.add(this.initRunControlStep);
        this.steps.add(this.initLoggingStep);
        this.steps.add(this.initRestartStep);
        this.steps.add(this.initRegistersServiceStep);
        this.steps.add(this.initMemoryServiceStep);
        this.steps.add(this.initProcessesServiceStep);
        this.steps.add(doAttach ? this.attachStep : this.launchStep);
        this.steps.add(this.cleanupStep);
    }

    protected ChooseProcessItem chooseProcess(ChooseProcessItem[] processes, String defaultSelection) throws CoreException {
        return WindowsDebugger.chooseProcess(processes);
    }

    protected void specifyRequiredPeer() {
        this.peerAttributes.put("DebugSupport", "Win32 Debug API");
    }
}

