/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import java.util.List;
import org.eclipse.cdt.debug.edc.formatter.AbstractVariableConverter;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.core.runtime.CoreException;

public class DefaultArrayFormatter
implements IVariableFormatProvider {
    public static boolean handlesType(IType type) {
        IType unqualifiedType = FormatUtils.getUnqualifiedTypeRemovePointers(type);
        return unqualifiedType instanceof IArrayType;
    }

    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (DefaultArrayFormatter.handlesType(type)) {
            return new DefaultArrayConverter(type, true);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (DefaultArrayFormatter.handlesType(type)) {
            return new DefaultArrayConverter(type, false);
        }
        return null;
    }

    public class DefaultArrayConverter
    extends AbstractVariableConverter {
        private static final int STOP_LENGTH = 300;

        public DefaultArrayConverter(IType type, boolean forDetails) {
            super(type, forDetails);
        }

        protected String getSummaryValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            IExpressions expressions = (IExpressions)((IEDCExpression)variable).getServiceTracker().getService(IExpressions.class);
            if (expressions == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder("[");
            List<IExpressions.IExpressionDMContext> children = FormatUtils.getAllChildExpressions(variable);
            boolean skip = true;
            for (IExpressions.IExpressionDMContext child : children) {
                if (skip) {
                    skip = false;
                } else {
                    sb.append(", ");
                }
                String customString = this.getCustomValueString(child);
                if (customString != null) {
                    sb.append("{");
                    sb.append(customString);
                    sb.append("}");
                } else {
                    IEDCExpression childExpression = (IEDCExpression)child;
                    IFormattedValues.FormattedValueDMContext fvc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)childExpression, "NATURAL.Format");
                    IFormattedValues.FormattedValueDMData formattedValue = childExpression.getFormattedValue(fvc);
                    sb.append(formattedValue.getFormattedValue());
                }
                if (sb.length() <= 300) continue;
                if (children.get(children.size() - 1).equals(child)) break;
                sb.append(", ...");
                break;
            }
            return sb.append("]").toString();
        }

        private String getCustomValueString(IExpressions.IExpressionDMContext variable) throws CoreException {
            IVariableValueConverter converter = FormatUtils.getCustomValueConverter(variable);
            if (converter != null) {
                return converter.getValue(variable);
            }
            return null;
        }

        protected String getDetailsValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            return this.getSummaryValue(variable);
        }
    }
}

