/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.NoOp;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorAddrOf;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorCast;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorCastValue;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperatorIndirection;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.core.runtime.CoreException;

public class InstructionSequence {
    private List<Instruction> fInstructions = new ArrayList<Instruction>(10);
    private List<String> fErrors = new ArrayList<String>();
    private String fSnippet;
    private CoreException fException;

    public InstructionSequence(String snippet) {
        this.fSnippet = snippet;
    }

    public CoreException getException() {
        return this.fException;
    }

    public String getSnippet() {
        return this.fSnippet;
    }

    public void addError(String error) {
        this.fErrors.add(error);
    }

    public boolean hasErrors() {
        return !this.fErrors.isEmpty();
    }

    public String[] getErrorMessages() {
        return this.fErrors.toArray(new String[this.fErrors.size()]);
    }

    public Instruction[] getInstructions() {
        int size = this.fInstructions.size();
        Instruction[] instructions = new Instruction[size];
        if (size > 0) {
            this.fInstructions.toArray(instructions);
        }
        return instructions;
    }

    public Instruction getInstruction(int address) {
        return this.fInstructions.get(address);
    }

    public void add(Instruction instruction) {
        this.fInstructions.add(instruction);
    }

    public int indexOf(Instruction instruction) {
        return this.fInstructions.indexOf(instruction);
    }

    public boolean isEmpty() {
        return this.fInstructions.isEmpty();
    }

    public void insert(Instruction instruction, int index) {
        this.fInstructions.add(index, instruction);
    }

    public Instruction get(int address) {
        return this.fInstructions.get(address);
    }

    public int getEnd() {
        return this.fInstructions.size() - 1;
    }

    public void removeNoOps() {
        Iterator<Instruction> iter = this.fInstructions.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof NoOp)) continue;
            iter.remove();
        }
    }

    public void reduceCasts(TypeEngine typeEngine) {
        boolean anyChanges = false;
        int i = 0;
        while (i < this.fInstructions.size()) {
            block13: {
                Instruction inst = this.fInstructions.get(i);
                if (inst instanceof OperatorAddrOf && i + 1 < this.fInstructions.size()) {
                    Instruction inst2 = this.fInstructions.get(i + 1);
                    if (inst2 instanceof OperatorCast && i + 2 < this.fInstructions.size()) {
                        Instruction inst3 = this.fInstructions.get(i + 2);
                        if (inst3 instanceof OperatorIndirection) {
                            IType castType = null;
                            try {
                                castType = TypeUtils.getStrippedType(((OperatorCast)inst2).getCastType(typeEngine));
                            }
                            catch (CoreException coreException) {
                                break block13;
                            }
                            if (castType instanceof IPointerType || castType instanceof IArrayType) {
                                OperatorCastValue cv = new OperatorCastValue(inst.getSize(), castType.getType());
                                this.fInstructions.set(i, cv);
                                this.fInstructions.set(i + 1, new NoOp(inst2.getSize()));
                                this.fInstructions.set(i + 2, new NoOp(inst3.getSize()));
                                anyChanges = true;
                            }
                        }
                    } else if (inst2 instanceof OperatorCastValue) {
                        IType castType;
                        try {
                            castType = TypeUtils.getStrippedType(((OperatorCastValue)inst2).getCastType(typeEngine));
                        }
                        catch (CoreException coreException) {
                            break block13;
                        }
                        if (castType instanceof IPointerType || castType instanceof IArrayType) {
                            OperatorCastValue cv = new OperatorCastValue(inst.getSize(), castType.getType());
                            this.fInstructions.set(i, cv);
                            this.fInstructions.set(i + 1, new NoOp(inst2.getSize()));
                            anyChanges = true;
                        }
                    }
                }
            }
            ++i;
        }
        if (anyChanges) {
            this.removeNoOps();
        }
    }
}

