/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.InstructionSequence;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;

public class Interpreter {
    private final Instruction[] instructions;
    private int instructionCounter;
    private final IDMContext context;
    private Stack<OperandValue> stack;
    private OperandValue lastValue;
    private boolean fStopped = false;
    private final DsfServicesTracker tracker;
    private final TypeEngine typeEngine;

    public Interpreter(DsfServicesTracker tracker, IDMContext context, TypeEngine typeEngine, InstructionSequence instructionSequence) {
        this.tracker = tracker;
        this.context = context;
        this.typeEngine = typeEngine;
        this.instructions = instructionSequence.getInstructions();
    }

    public DsfServicesTracker getServicesTracker() {
        return this.tracker;
    }

    public void execute() throws CoreException {
        this.reset();
        while (this.instructionCounter < this.instructions.length && !this.fStopped) {
            Instruction instruction = this.instructions[this.instructionCounter++];
            Interpreter old = instruction.fInterpreter;
            instruction.setInterpreter(this);
            instruction.execute();
            instruction.setInterpreter(old);
        }
    }

    public void stop() {
        this.fStopped = true;
    }

    private void reset() {
        this.stack = new Stack();
        this.instructionCounter = 0;
    }

    public void jump(int offset) {
        this.instructionCounter += offset;
    }

    public void push(OperandValue object) {
        this.stack.push(object);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public OperandValue peek() {
        return this.stack.peek();
    }

    public OperandValue pop() throws EmptyStackException {
        return this.stack.pop();
    }

    public IDMContext getContext() {
        return this.context;
    }

    public OperandValue getResult() {
        if (this.stack == null || this.stack.isEmpty()) {
            return this.lastValue;
        }
        OperandValue top = this.stack.peek();
        return top;
    }

    public TypeEngine getTypeEngine() {
        return this.typeEngine;
    }
}

