/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.FunctionScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfCompileUnit;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.core.runtime.IPath;

public class DwarfFunctionScope
extends FunctionScope
implements IFunctionScope {
    protected int declFileNum;

    public DwarfFunctionScope(String name, IScope parent, IAddress lowAddress, IAddress highAddress, ILocationProvider frameBaseLocationProvider) {
        super(name, parent, lowAddress, highAddress, frameBaseLocationProvider);
    }

    public void setDeclFileNum(int declFileNum) {
        this.declFileNum = declFileNum;
    }

    public IPath getDeclFile() {
        IPath file = super.getDeclFile();
        if (file == null && this.declFileNum != 0) {
            IScope cu = this.getParent();
            while (cu != null) {
                if (cu instanceof DwarfCompileUnit) {
                    return ((DwarfCompileUnit)cu).getFileEntry(this.declFileNum);
                }
                cu = cu.getParent();
            }
        }
        return file;
    }
}

