/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.symbols;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.symbols.InvalidVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.MemoryVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.ValueVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IInvalidVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IMemoryVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IRegisterVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IValueVariableLocation;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public final class VariableLocationFactory {
    protected VariableLocationFactory() {
    }

    public static IMemoryVariableLocation createMemoryVariableLocation(DsfServicesTracker tracker, IDMContext context, BigInteger addressValue, boolean isRuntimeAddress) {
        return new MemoryVariableLocation(tracker, context, addressValue, isRuntimeAddress);
    }

    public static IMemoryVariableLocation createMemoryVariableLocation(DsfServicesTracker tracker, IDMContext context, BigInteger addressValue) {
        return new MemoryVariableLocation(tracker, context, addressValue, true);
    }

    public static IMemoryVariableLocation createMemoryVariableLocation(DsfServicesTracker tracker, IDMContext context, long addressValue) {
        return new MemoryVariableLocation(tracker, context, BigInteger.valueOf(addressValue), true);
    }

    public static IMemoryVariableLocation createMemoryVariableLocation(DsfServicesTracker tracker, IDMContext context, Number addressValue) {
        BigInteger addr = addressValue instanceof BigInteger ? (BigInteger)addressValue : BigInteger.valueOf(addressValue.longValue());
        return new MemoryVariableLocation(tracker, context, addr, true);
    }

    public static IRegisterVariableLocation createRegisterVariableLocation(DsfServicesTracker tracker, IDMContext context, String name, int id) {
        return new RegisterVariableLocation(tracker, context, name, id);
    }

    public static IRegisterVariableLocation createRegisterVariableLocation(DsfServicesTracker tracker, IDMContext context, int id) {
        return new RegisterVariableLocation(tracker, context, null, id);
    }

    public static IInvalidVariableLocation createInvalidVariableLocation(String message) {
        return new InvalidVariableLocation(message);
    }

    public static IValueVariableLocation createValueVariableLocation(BigInteger value) {
        return new ValueVariableLocation(value);
    }
}

