/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.editors;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractDebugTextHover
implements ICEditorTextHover,
ITextHoverExtension {
    private static final int MAX_HOVER_INFO_SIZE = 100;
    private IEditorPart fEditor;

    protected abstract boolean canEvaluate();

    protected abstract String evaluateExpression(String var1);

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String expression;
        if (this.canEvaluate() && (expression = this.getExpressionText(textViewer, hoverRegion)) != null) {
            String result = this.evaluateExpression(expression);
            if (result == null) {
                return null;
            }
            try {
                StringBuilder buffer = new StringBuilder();
                AbstractDebugTextHover.appendVariable(buffer, AbstractDebugTextHover.makeHTMLSafe(expression), AbstractDebugTextHover.makeHTMLSafe(result.trim()));
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (DebugException x) {
                CDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        if (viewer != null) {
            return CDebugUIUtils.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    public final void setEditor(IEditorPart editor) {
        if (editor != null) {
            this.fEditor = editor;
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return null;
    }

    protected String getExpressionText(ITextViewer textViewer, final IRegion hoverRegion) {
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        ICElement cElement = CDTUITools.getEditorInputCElement((IEditorInput)this.getEditor().getEditorInput());
        if (cElement instanceof ITranslationUnit) {
            final Position expressionPosition = new Position(0);
            SharedASTJob job = new SharedASTJob(CDebugUIMessages.getString("AbstractDebugTextHover.jobName"), (ITranslationUnit)cElement){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                    if (ast != null) {
                        int offset = hoverRegion.getOffset();
                        int length = hoverRegion.getLength();
                        IASTName name = ast.getNodeSelector(null).findEnclosingName(offset, length);
                        if (name != null) {
                            this.computeExpressionExtent((IASTNode)name, expressionPosition);
                        } else {
                            IASTNode node = ast.getNodeSelector(null).findFirstContainedNode(offset, length);
                            if (node instanceof IASTExpression) {
                                this.computeExpressionExtent(node, expressionPosition);
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }

                private void computeExpressionExtent(IASTNode node0, Position pos) {
                    IASTNode node = node0;
                    while (node != null && !(node instanceof IASTExpression) && !(node instanceof IASTDeclaration)) {
                        node = node.getParent();
                    }
                    if (node instanceof IASTExpression) {
                        ExpressionChecker checker = new ExpressionChecker();
                        if (checker.check(node)) {
                            IASTFileLocation loc = node.getFileLocation();
                            pos.offset = loc.getNodeOffset();
                            pos.length = loc.getNodeLength();
                        }
                    } else if (node0 instanceof IASTName) {
                        IASTFileLocation loc = node0.getFileLocation();
                        pos.offset = loc.getNodeOffset();
                        pos.length = loc.getNodeLength();
                    }
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                job.cancel();
                Thread.currentThread().interrupt();
            }
            if (expressionPosition.getLength() > 0) {
                try {
                    ITypedRegion[] partitions;
                    StringBuilder result = new StringBuilder();
                    ITypedRegion[] iTypedRegionArray = partitions = TextUtilities.computePartitioning((IDocument)document, (String)"___c_partitioning", (int)expressionPosition.offset, (int)expressionPosition.length, (boolean)false);
                    int n = partitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypedRegion partition = iTypedRegionArray[n2];
                        if ("__dftl_partition_content_type".equals(partition.getType()) || "__c_character".equals(partition.getType()) || "__c_string".equals(partition.getType())) {
                            result.append(document.get(partition.getOffset(), partition.getLength()));
                        } else {
                            result.append(' ');
                        }
                        ++n2;
                    }
                    String text = result.toString().replaceAll("(\\r\\n|\\n|\t| )+", " ").trim();
                    return text;
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    protected IAdaptable getSelectionAdaptable() {
        return DebugUITools.getDebugContext();
    }

    protected final IEditorPart getEditor() {
        return this.fEditor;
    }

    private static void appendVariable(StringBuilder buffer, String expression, String value) throws DebugException {
        if (value.length() > 100) {
            value = String.valueOf(value.substring(0, 100)) + " ...";
        }
        buffer.append("<p>");
        buffer.append("<pre>").append(expression).append("</pre>");
        buffer.append(" = ");
        buffer.append("<b><pre>").append(value).append("</pre></b>");
        buffer.append("</p>");
    }

    private static String makeHTMLSafe(String string) {
        StringBuilder buffer = new StringBuilder(string.length());
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static class ExpressionChecker
    extends ASTVisitor {
        private boolean fValid;

        private ExpressionChecker() {
            this.shouldVisitExpressions = true;
        }

        private boolean check(IASTNode node) {
            this.fValid = true;
            node.accept((ASTVisitor)this);
            return this.fValid;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTFunctionCallExpression) {
                this.fValid = false;
            } else if (expression instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
                switch (unaryExpression.getOperator()) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 10: {
                        this.fValid = false;
                    }
                }
            } else if (expression instanceof IASTBinaryExpression) {
                IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
                switch (binaryExpression.getOperator()) {
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        this.fValid = false;
                    }
                }
            } else if (expression instanceof ICPPASTNewExpression) {
                this.fValid = false;
            } else if (expression instanceof ICPPASTDeleteExpression) {
                this.fValid = false;
            } else if (expression instanceof IGNUASTCompoundStatementExpression) {
                this.fValid = false;
            }
            if (!this.fValid) {
                return 2;
            }
            return 3;
        }
    }
}

