/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.debug.ui.ICDebuggerPageExtension;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CLaunchConfigurationTab;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbCoreDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbServerDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchImages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CDebuggerTab
extends CLaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.cdt.dsf.gdb.launch.debuggerTab";
    private static final String LOCAL_DEBUGGER_ID = "gdb";
    private static final String REMOTE_DEBUGGER_ID = "gdbserver";
    protected ILaunchConfiguration fLaunchConfiguration;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected String fDebuggerId;
    protected ICDebuggerPage fDynamicTab;
    protected Composite fDynamicTabHolder;
    private boolean fInitDefaults;
    private Combo fDCombo;
    private boolean fIsInitializing;
    protected boolean fAttachMode;
    protected boolean fRemoteMode;
    protected boolean fCoreMode;
    protected Button fStopInMain;
    protected Text fStopInMainSymbol;
    private ScrolledComposite fContainer;
    private Composite fContents;
    private ICDebuggerPageExtension.IContentChangeListener fContentListener = new ICDebuggerPageExtension.IContentChangeListener(){

        public void contentChanged() {
            CDebuggerTab.this.contentsChanged();
        }
    };

    public CDebuggerTab(SessionType sessionType, boolean attach) {
        if (sessionType == SessionType.REMOTE) {
            this.fRemoteMode = true;
        } else if (sessionType == SessionType.CORE) {
            this.fCoreMode = true;
        }
        this.fAttachMode = attach;
        ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDefaultDebugConfiguration();
        if (dc == null) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE, LOCAL_DEBUGGER_ID);
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public void createControl(Composite parent) {
        this.fContainer = new ScrolledComposite(parent, 768);
        this.fContainer.setLayoutData((Object)new GridData(1808));
        this.fContainer.setLayout((Layout)new FillLayout());
        this.fContainer.setExpandHorizontal(true);
        this.fContainer.setExpandVertical(true);
        this.fContents = new Composite((Composite)this.fContainer, 0);
        this.setControl((Control)this.fContainer);
        GdbUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.gdb.ui.launch_configuration_dialog_debugger_tab");
        int numberOfColumns = this.fAttachMode ? 2 : 1;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        this.fContents.setLayout((Layout)layout);
        GridData gd = new GridData(1, 2, true, false);
        this.fContents.setLayoutData((Object)gd);
        if (this.fAttachMode) {
            this.createDebuggerCombo(this.fContents);
        }
        this.createOptionsComposite(this.fContents);
        this.createDebuggerGroup(this.fContents, 2);
        this.fContainer.setContent((Control)this.fContents);
    }

    protected void initDebuggerTypes(String selection) {
        if (this.fAttachMode) {
            this.setInitializeDefault(selection.equals(""));
            if (selection.equals("")) {
                selection = LOCAL_DEBUGGER_ID;
            }
            this.loadDebuggerCombo(new String[]{LOCAL_DEBUGGER_ID, REMOTE_DEBUGGER_ID}, selection);
        } else {
            if (this.fRemoteMode) {
                this.setDebuggerId(REMOTE_DEBUGGER_ID);
            } else {
                this.setDebuggerId(LOCAL_DEBUGGER_ID);
            }
            this.updateComboFromSelection();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
            this.setInitializeDefault(false);
        }
        if (this.fAttachMode && this.fRemoteMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote_attach");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", REMOTE_DEBUGGER_ID);
        } else if (this.fAttachMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", LOCAL_DEBUGGER_ID);
        } else if (this.fRemoteMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", REMOTE_DEBUGGER_ID);
        } else if (this.fCoreMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", LOCAL_DEBUGGER_ID);
        } else {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", LOCAL_DEBUGGER_ID);
        }
        if (!this.fAttachMode && !this.fCoreMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        this.setLaunchConfiguration(config);
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(config);
        }
        try {
            String id = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.initDebuggerTypes(id);
            this.initializeCommonControls(config);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getDebuggerId() != null) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", this.getDebuggerId());
            ICDebuggerPage dynamicTab = this.getDynamicTab();
            if (dynamicTab == null) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", null);
            } else {
                dynamicTab.performApply(config);
            }
        }
        if (this.fAttachMode && this.fRemoteMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote_attach");
        } else if (this.fAttachMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
        } else if (this.fRemoteMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
        } else if (this.fCoreMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
        } else {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        }
        if (!this.fAttachMode && !this.fCoreMode) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", this.fStopInMainSymbol.getText());
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!this.validateDebuggerConfig(config)) {
            return false;
        }
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            String mainSymbol = this.fStopInMainSymbol.getText().trim();
            if (this.fStopInMain.getSelection() && mainSymbol.length() == 0) {
                this.setErrorMessage(LaunchMessages.getString((String)"CDebuggerTab.Stop_on_startup_at_can_not_be_empty"));
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.getDebuggerId() == null) {
            this.setErrorMessage(LaunchMessages.getString((String)"AbstractCDebuggerTab.No_debugger_available"));
            return false;
        }
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    protected boolean validateDebuggerConfig(ILaunchConfiguration config) {
        String debuggerType = this.getDebuggerId();
        if (debuggerType == null) {
            this.setErrorMessage(LaunchMessages.getString((String)"CDebuggerTab.No_debugger_available"));
            return false;
        }
        return true;
    }

    protected void update() {
        if (!this.isInitializing()) {
            super.updateLaunchConfigurationDialog();
        }
    }

    protected void createOptionsComposite(Composite parent) {
        Composite optionsComp = new Composite(parent, 0);
        int numberOfColumns = this.fAttachMode ? 1 : 3;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        optionsComp.setLayout((Layout)layout);
        optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        if (!this.fAttachMode && !this.fCoreMode) {
            this.fStopInMain = this.createCheckButton(optionsComp, LaunchMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup"));
            this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CDebuggerTab.this.fStopInMainSymbol.setEnabled(CDebuggerTab.this.fStopInMain.getSelection());
                    CDebuggerTab.this.update();
                }
            });
            this.fStopInMainSymbol = new Text(optionsComp, 2052);
            GridData gridData = new GridData(4, 2, false, false);
            gridData.widthHint = 100;
            this.fStopInMainSymbol.setLayoutData((Object)gridData);
            this.fStopInMainSymbol.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    CDebuggerTab.this.update();
                }
            });
            this.fStopInMainSymbol.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = LaunchMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup");
                }
            });
        }
    }

    protected Shell getShell() {
        return super.getShell();
    }

    public void dispose() {
        ICDebuggerPage debuggerPage = this.getDynamicTab();
        if (debuggerPage != null) {
            debuggerPage.dispose();
        }
        super.dispose();
    }

    protected void initializeCommonControls(ILaunchConfiguration config) {
        try {
            if (!this.fAttachMode && !this.fCoreMode) {
                this.fStopInMain.setSelection(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true));
                this.fStopInMainSymbol.setText(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main"));
                this.fStopInMainSymbol.setEnabled(this.fStopInMain.getSelection());
            } else if (this.fAttachMode) {
                this.fRemoteMode = this.getDebuggerId().equals(REMOTE_DEBUGGER_ID);
            }
        }
        catch (CoreException coreException) {}
    }

    protected void setInitializeDefault(boolean init) {
        this.fInitDefaults = init;
    }

    protected void contentsChanged() {
        this.fContainer.setMinSize(this.fContents.computeSize(-1, -1));
    }

    protected void loadDynamicDebugArea() {
        Composite dynamicTabHolder = this.getDynamicTabHolder();
        Control[] children = dynamicTabHolder.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        String debuggerId = this.getIdForCurrentDebugger();
        if (debuggerId == null) {
            this.setDynamicTab(null);
        } else if (debuggerId.equals(LOCAL_DEBUGGER_ID)) {
            if (this.fCoreMode) {
                this.setDynamicTab((ICDebuggerPage)new GdbCoreDebuggerPage());
            } else {
                this.setDynamicTab((ICDebuggerPage)new GdbDebuggerPage());
            }
        } else if (debuggerId.equals(REMOTE_DEBUGGER_ID)) {
            this.setDynamicTab((ICDebuggerPage)new GdbServerDebuggerPage());
        } else assert (false) : "Unknown debugger id";
        this.setDebuggerId(debuggerId);
        ICDebuggerPage debuggerPage = this.getDynamicTab();
        if (debuggerPage == null) {
            return;
        }
        debuggerPage.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        debuggerPage.createControl(dynamicTabHolder);
        debuggerPage.getControl().setVisible(true);
        dynamicTabHolder.layout(true);
        this.contentsChanged();
    }

    protected void setDebuggerId(String id) {
        this.fDebuggerId = id;
    }

    protected String getDebuggerId() {
        return this.fDebuggerId;
    }

    protected ICDebuggerPage getDynamicTab() {
        return this.fDynamicTab;
    }

    protected void setDynamicTab(ICDebuggerPage tab) {
        if (this.fDynamicTab instanceof ICDebuggerPageExtension) {
            ((ICDebuggerPageExtension)this.fDynamicTab).removeContentChangeListener(this.fContentListener);
        }
        this.fDynamicTab = tab;
        if (this.fDynamicTab instanceof ICDebuggerPageExtension) {
            ((ICDebuggerPageExtension)this.fDynamicTab).addContentChangeListener(this.fContentListener);
        }
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
        this.setLaunchConfigurationWorkingCopy(null);
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    public String getErrorMessage() {
        ICDebuggerPage tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void handleDebuggerChanged() {
        this.loadDynamicDebugArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (wc != null) {
                wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", null);
            }
        } else {
            if (wc == null) {
                try {
                    if (this.getLaunchConfiguration().isWorkingCopy()) {
                        this.setLaunchConfigurationWorkingCopy((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration());
                    } else {
                        this.setLaunchConfigurationWorkingCopy(this.getLaunchConfiguration().getWorkingCopy());
                    }
                    wc = this.getLaunchConfigurationWorkingCopy();
                }
                catch (CoreException coreException) {
                    return;
                }
            }
            if (this.initDefaults()) {
                this.getDynamicTab().setDefaults(wc);
            }
            this.setInitializeDefault(false);
            this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        ICDebuggerPage dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.activated(workingCopy);
        }
    }

    protected boolean initDefaults() {
        return this.fInitDefaults;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_DEBUGGER_TAB);
    }

    public String getName() {
        return LaunchMessages.getString((String)"AbstractCDebuggerTab.Debugger");
    }

    protected void createDebuggerCombo(Composite parent) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comboComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comboComp.setLayoutData((Object)gd);
        Label dlabel = new Label(comboComp, 0);
        dlabel.setText(LaunchMessages.getString((String)"Launch.common.DebuggerColon"));
        this.fDCombo = new Combo(comboComp, 12);
        this.fDCombo.setLayoutData((Object)new GridData(768));
        this.fDCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!CDebuggerTab.this.isInitializing()) {
                    CDebuggerTab.this.setInitializeDefault(true);
                    CDebuggerTab.this.updateComboFromSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void loadDebuggerCombo(String[] names, String current) {
        if (this.fDCombo == null) {
            return;
        }
        this.fDCombo.removeAll();
        int select = -1;
        int i = 0;
        while (i < names.length) {
            this.fDCombo.add(names[i]);
            if (names[i].equalsIgnoreCase(current)) {
                select = i;
            }
            ++i;
        }
        if (select != -1) {
            this.fDCombo.select(select);
        } else {
            this.fDCombo.select(0);
        }
        this.updateComboFromSelection();
        this.getControl().getParent().layout(true);
    }

    protected void createDebuggerGroup(Composite parent, int colspan) {
        Group debuggerGroup = new Group(parent, 16);
        debuggerGroup.setText(LaunchMessages.getString((String)"CDebuggerTab.Debugger_Options"));
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        debuggerGroup.setLayout((Layout)tabHolderLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = colspan;
        debuggerGroup.setLayoutData((Object)gd);
    }

    protected void updateComboFromSelection() {
        this.handleDebuggerChanged();
        this.updateLaunchConfigurationDialog();
        this.initializeCommonControls(this.getLaunchConfiguration());
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    protected void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    protected String getIdForCurrentDebugger() {
        if (this.fDCombo == null) {
            return this.getDebuggerId();
        }
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return this.fDCombo.getItem(selectedIndex);
    }
}

