/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlock;
import org.eclipse.cdt.dsf.gdb.internal.memory.Messages;
import org.eclipse.cdt.dsf.service.DsfServices;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GdbMemoryBlockRetrieval
extends DsfMemoryBlockRetrieval
implements IMemorySpaceAwareMemoryBlockRetrieval {
    private final ServiceTracker fMemorySpaceServiceTracker;
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String ATTR_EXPRESSION_LIST_CONTEXT = "context";
    private static final String MEMORY_BLOCK_EXPRESSION = "gdbmemoryBlockExpression";
    private static final String ATTR_MEMORY_BLOCK_EXPR_LABEL = "label";
    private static final String ATTR_MEMORY_BLOCK_EXPR_ADDRESS = "address";
    private static final String ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID = "memorySpaceID";
    private static final String CONTEXT_RESERVED = "reserved-for-future-use";

    public GdbMemoryBlockRetrieval(String modelId, ILaunchConfiguration config, DsfSession session) throws DebugException {
        super(modelId, config, session);
        BundleContext bundle = GdbPlugin.getBundleContext();
        String filter = DsfServices.createServiceFilter(IMemorySpaces.class, (String)session.getId());
        try {
            this.fMemorySpaceServiceTracker = new ServiceTracker(bundle, bundle.createFilter(filter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fMemorySpaceServiceTracker.open();
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        return this.getMemoryBlock(expression, context, null);
    }

    public IMemorySpaceAwareMemoryBlock getMemoryBlock(String expression, Object context, String memorySpaceID) throws DebugException {
        BigInteger blockAddress;
        IMemory.IMemoryDMContext memoryDmc;
        block9: {
            memoryDmc = null;
            IDMContext dmc = null;
            if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                memoryDmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
            }
            if (memoryDmc == null) {
                return null;
            }
            try {
                int base = 10;
                int offset = 0;
                if (expression.startsWith("0x") || expression.startsWith("0X")) {
                    base = 16;
                    offset = 2;
                } else if (expression.startsWith("0b")) {
                    base = 2;
                    offset = 2;
                } else if (expression.startsWith("0")) {
                    base = 8;
                    offset = 1;
                }
                blockAddress = new BigInteger(expression.substring(offset), base);
            }
            catch (NumberFormatException numberFormatException) {
                blockAddress = this.resolveMemoryAddress(dmc, expression);
                if (blockAddress != null) break block9;
                return null;
            }
        }
        return new GdbMemoryBlock(this, memoryDmc, this.getModelId(), expression, blockAddress, this.getAddressableSize(), 0L, memorySpaceID);
    }

    public void getMemorySpaces(final Object context, final IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest request) {
        Query<String[]> query = new Query<String[]>(){

            protected void execute(final DataRequestMonitor<String[]> drm) {
                IDMContext dmc = null;
                if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                    IMemorySpaces service = (IMemorySpaces)GdbMemoryBlockRetrieval.this.fMemorySpaceServiceTracker.getService();
                    if (service != null) {
                        service.getMemorySpaces(dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)GdbMemoryBlockRetrieval.this.getExecutor(), drm){

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    request.setMemorySpaces((String[])this.getData());
                                } else {
                                    request.setStatus(this.getStatus());
                                }
                                request.done();
                                drm.done();
                            }
                        });
                    } else {
                        request.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, Messages.Err_MemoryServiceNotAvailable, null));
                        request.done();
                        drm.done();
                    }
                }
            }
        };
        this.getExecutor().execute((Runnable)query);
    }

    public String encodeAddress(String expression, String memorySpaceID) {
        String result = null;
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service != null) {
            result = service.encodeAddress(expression, memorySpaceID);
        }
        if (result == null) {
            result = String.valueOf(memorySpaceID) + ':' + expression;
        }
        return result;
    }

    public IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult decodeAddress(String str) throws CoreException {
        IMemorySpaces.DecodeResult result;
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service != null && (result = service.decodeAddress(str)) != null) {
            return new IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult(){

                public String getMemorySpaceId() {
                    return result.getMemorySpaceId();
                }

                public String getExpression() {
                    return result.getExpression();
                }
            };
        }
        int index = str.indexOf(58);
        if (index == -1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, String.valueOf(Messages.Err_InvalidEncodedAddress) + ": " + str, null));
        }
        final String memorySpaceID = str.substring(0, index);
        final String expression = index < str.length() - 1 ? str.substring(index + 1) : "";
        return new IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult(){

            public String getMemorySpaceId() {
                return memorySpaceID;
            }

            public String getExpression() {
                return expression;
            }
        };
    }

    ServiceTracker getMemorySpaceServiceTracker() {
        return this.fMemorySpaceServiceTracker;
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this);
        Document document = DebugPlugin.newDocument();
        Element expressionList = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        expressionList.setAttribute(ATTR_EXPRESSION_LIST_CONTEXT, CONTEXT_RESERVED);
        IMemoryBlock[] iMemoryBlockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlock block = iMemoryBlockArray[n2];
            if (block instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension memoryBlock = (IMemoryBlockExtension)block;
                Element expression = document.createElement(MEMORY_BLOCK_EXPRESSION);
                expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS, memoryBlock.getBigBaseAddress().toString());
                if (block instanceof IMemorySpaceAwareMemoryBlock) {
                    String memorySpaceID = ((IMemorySpaceAwareMemoryBlock)memoryBlock).getMemorySpaceID();
                    if (memorySpaceID != null) {
                        expression.setAttribute(ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID, memorySpaceID);
                        IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult result = ((IMemorySpaceAwareMemoryBlockRetrieval)memoryBlock.getMemoryBlockRetrieval()).decodeAddress(memoryBlock.getExpression());
                        expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, result.getExpression());
                    } else {
                        expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
                    }
                } else {
                    assert (false);
                    expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
                }
                expressionList.appendChild(expression);
            }
            ++n2;
        }
        document.appendChild(expressionList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    protected void createBlocksFromConfiguration(IMemory.IMemoryDMContext memoryCtx, String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (!root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            Status status = new Status(4, "org.eclipse.cdt.dsf.gdb", 120, "Memory monitor initialization: invalid memento", null);
            throw new CoreException((IStatus)status);
        }
        if (root.getAttribute(ATTR_EXPRESSION_LIST_CONTEXT).equals(CONTEXT_RESERVED)) {
            ArrayList<GdbMemoryBlock> blocks = new ArrayList<GdbMemoryBlock>();
            NodeList expressionList = root.getChildNodes();
            int length = expressionList.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = expressionList.item(i);
                if (node.getNodeType() == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) {
                    String label = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL);
                    String address = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS);
                    String memorySpaceID = null;
                    if (entry.hasAttribute(ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID) && (memorySpaceID = entry.getAttribute(ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID)).length() == 0) {
                        memorySpaceID = null;
                        assert (false) : "should have either no memory space or a valid (non-empty) ID";
                    }
                    BigInteger blockAddress = new BigInteger(address);
                    GdbMemoryBlock block = new GdbMemoryBlock(this, memoryCtx, this.getModelId(), label, blockAddress, this.getAddressableSize(), 0L, memorySpaceID);
                    blocks.add(block);
                }
                ++i;
            }
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(blocks.toArray(new IMemoryBlock[blocks.size()]));
        }
    }

    public boolean creatingBlockRequiresMemorySpaceID() {
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service != null) {
            return service.creatingBlockRequiresMemorySpaceID();
        }
        return false;
    }
}

