/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public class FinalLaunchSequence
extends Sequence {
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fTracker != null) {
                FinalLaunchSequence.this.fTracker.dispose();
            }
            FinalLaunchSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fGDBBackend = (IGDBBackend)FinalLaunchSequence.this.fTracker.getService(IGDBBackend.class);
            if (FinalLaunchSequence.this.fGDBBackend == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot obtain GDBBackend service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fCommandControl = (IGDBControl)FinalLaunchSequence.this.fTracker.getService(IGDBControl.class);
            if (FinalLaunchSequence.this.fCommandControl == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot obtain control service", null));
            }
            FinalLaunchSequence.this.fCommandFactory = FinalLaunchSequence.this.fCommandControl.getCommandFactory();
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fProcService = (IMIProcesses)FinalLaunchSequence.this.fTracker.getService(IMIProcesses.class);
            if (FinalLaunchSequence.this.fProcService == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot obtain process service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                final String gdbinitFile = FinalLaunchSequence.this.fGDBBackend.getGDBInitFile();
                if (gdbinitFile != null && gdbinitFile.length() > 0) {
                    FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createCLISource(FinalLaunchSequence.this.fCommandControl.getContext(), gdbinitFile), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleCompleted() {
                            if (!gdbinitFile.equals(".gdbinit")) {
                                requestMonitor.setStatus(this.getStatus());
                            }
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get gdbinit option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            IPath dir = null;
            try {
                dir = FinalLaunchSequence.this.fGDBBackend.getGDBWorkingDirectory();
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get working directory", (Throwable)e));
                requestMonitor.done();
                return;
            }
            if (dir != null) {
                FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIEnvironmentCD(FinalLaunchSequence.this.fCommandControl.getContext(), dir.toPortableString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            boolean clear = false;
            Properties properties = new Properties();
            try {
                clear = FinalLaunchSequence.this.fGDBBackend.getClearEnvironment();
                properties = FinalLaunchSequence.this.fGDBBackend.getEnvironmentVariables();
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get environment information", (Throwable)e));
                requestMonitor.done();
                return;
            }
            if (clear || properties.size() > 0) {
                FinalLaunchSequence.this.fCommandControl.setEnvironment(properties, clear, requestMonitor);
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            boolean noFileCommand = false;
            try {
                noFileCommand = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.USE_SOLIB_SYMBOLS_FOR_APP", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot read use solib symbols for app options", (Throwable)e));
                requestMonitor.done();
                return;
            }
            IPath execPath = FinalLaunchSequence.this.fGDBBackend.getProgramPath();
            if (!noFileCommand && execPath != null && !execPath.isEmpty()) {
                FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIFileExecAndSymbols(FinalLaunchSequence.this.fCommandControl.getContext(), execPath.toPortableString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                String args = FinalLaunchSequence.this.fGDBBackend.getProgramArguments();
                if (args != null) {
                    FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetArgs(FinalLaunchSequence.this.fCommandControl.getContext(), args), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get inferior arguments", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            boolean isNonStop = false;
            try {
                isNonStop = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", false);
            }
            catch (CoreException coreException) {}
            if (isNonStop) {
                FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetTargetAsync(FinalLaunchSequence.this.fCommandControl.getContext(), true), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                    protected void handleSuccess() {
                        FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetPagination(FinalLaunchSequence.this.fCommandControl.getContext(), false), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                            protected void handleSuccess() {
                                FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetNonStop(FinalLaunchSequence.this.fCommandControl.getContext(), true), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                            }
                        });
                    }
                });
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                boolean autolib = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", true);
                FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetAutoSolib(FinalLaunchSequence.this.fCommandControl.getContext(), autolib), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot set shared library option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                List<String> p = FinalLaunchSequence.this.fGDBBackend.getSharedLibraryPaths();
                if (p.size() > 0) {
                    String[] paths = p.toArray(new String[p.size()]);
                    FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetSolibSearchPath(FinalLaunchSequence.this.fCommandControl.getContext(), paths), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleSuccess() {
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot set share library paths", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            CSourceLookup sourceLookup = (CSourceLookup)((Object)FinalLaunchSequence.this.fTracker.getService(CSourceLookup.class));
            CSourceLookupDirector locator = (CSourceLookupDirector)FinalLaunchSequence.this.fLaunch.getSourceLocator();
            ISourceLookup.ISourceLookupDMContext sourceLookupDmc = (ISourceLookup.ISourceLookupDMContext)FinalLaunchSequence.this.fCommandControl.getContext();
            sourceLookup.setSourceLookupPath(sourceLookupDmc, locator.getSourceContainers(), requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            block9: {
                if (FinalLaunchSequence.this.fSessionType == SessionType.CORE) {
                    try {
                        String coreFile = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
                        final String coreType = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "CORE_FILE");
                        if (coreFile.length() == 0) {
                            new PromptForCoreJob("Prompt for post mortem file", new DataRequestMonitor<String>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                                protected void handleSuccess() {
                                    String newCoreFile = (String)this.getData();
                                    if (newCoreFile == null || newCoreFile.length() == 0) {
                                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get post mortem file path", null));
                                        requestMonitor.done();
                                    } else if (coreType.equals("CORE_FILE")) {
                                        FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMITargetSelectCore((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), newCoreFile), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                                    } else if (coreType.equals("TRACE_FILE")) {
                                        IGDBTraceControl traceControl = (IGDBTraceControl)(this).FinalLaunchSequence.this.fTracker.getService(IGDBTraceControl.class);
                                        if (traceControl != null) {
                                            IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), IGDBTraceControl.ITraceTargetDMContext.class);
                                            traceControl.loadTraceData(targetDmc, newCoreFile, requestMonitor);
                                        } else {
                                            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Tracing not supported", null));
                                            requestMonitor.done();
                                        }
                                    } else {
                                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Invalid post-mortem type", null));
                                        requestMonitor.done();
                                    }
                                }
                            }).schedule();
                            break block9;
                        }
                        if (coreType.equals("CORE_FILE")) {
                            FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMITargetSelectCore((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), coreFile), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                            break block9;
                        }
                        if (coreType.equals("TRACE_FILE")) {
                            IGDBTraceControl traceControl = (IGDBTraceControl)FinalLaunchSequence.this.fTracker.getService(IGDBTraceControl.class);
                            if (traceControl != null) {
                                IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), IGDBTraceControl.ITraceTargetDMContext.class);
                                traceControl.loadTraceData(targetDmc, coreFile, requestMonitor);
                            } else {
                                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Tracing not supported", null));
                                requestMonitor.done();
                            }
                            break block9;
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Invalid post-mortem type", null));
                        requestMonitor.done();
                    }
                    catch (CoreException e) {
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get post mortem file path", (Throwable)e));
                        requestMonitor.done();
                    }
                } else {
                    requestMonitor.done();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PromptForCoreJob
        extends Job {
            DataRequestMonitor<String> fRequestMonitor;

            public PromptForCoreJob(String name, DataRequestMonitor<String> rm) {
                super(name);
                this.fRequestMonitor = rm;
            }

            protected IStatus run(IProgressMonitor monitor) {
                Status promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
                Status filePrompt = new Status(1, "org.eclipse.cdt.dsf.gdb.ui", 1001, "", null);
                IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)promptStatus);
                Status NO_CORE_STATUS = new Status(4, "org.eclipse.cdt.dsf.gdb", -1, LaunchMessages.getString("LocalCDILaunchDelegate.6"), null);
                if (prompter == null) {
                    this.fRequestMonitor.setStatus((IStatus)NO_CORE_STATUS);
                    this.fRequestMonitor.done();
                    return Status.OK_STATUS;
                }
                try {
                    Object result = prompter.handleStatus((IStatus)filePrompt, null);
                    if (result instanceof String) {
                        this.fRequestMonitor.setData((Object)((String)result));
                    } else {
                        this.fRequestMonitor.setStatus((IStatus)NO_CORE_STATUS);
                    }
                }
                catch (CoreException coreException) {
                    this.fRequestMonitor.setStatus((IStatus)NO_CORE_STATUS);
                }
                this.fRequestMonitor.done();
                return Status.OK_STATUS;
            }
        }
    }, new Sequence.Step(){
        private boolean fTcpConnection;
        private String fRemoteTcpHost;
        private String fRemoteTcpPort;
        private String fSerialDevice;

        private boolean checkConnectionType(RequestMonitor requestMonitor) {
            try {
                this.fTcpConnection = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot retrieve connection mode", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getSerialDevice(RequestMonitor requestMonitor) {
            try {
                this.fSerialDevice = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.DEV", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot retrieve serial device", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpHost(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpHost = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.HOST", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot retrieve remote TCP host", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpPort(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpPort = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot retrieve remote TCP port", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fSessionType == SessionType.REMOTE) {
                if (!this.checkConnectionType(requestMonitor)) {
                    return;
                }
                if (this.fTcpConnection) {
                    if (!this.getTcpHost(requestMonitor)) {
                        return;
                    }
                    if (!this.getTcpPort(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), this.fRemoteTcpHost, this.fRemoteTcpPort, FinalLaunchSequence.this.fAttach), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    if (!this.getSerialDevice(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), this.fSerialDevice, FinalLaunchSequence.this.fAttach), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fAttach && FinalLaunchSequence.this.fSessionType != SessionType.REMOTE) {
                int pid = -1;
                try {
                    pid = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
                }
                catch (CoreException coreException) {}
                if (pid != -1) {
                    FinalLaunchSequence.this.fProcService.attachDebuggerToProcess(FinalLaunchSequence.this.fProcService.createProcessContext(FinalLaunchSequence.this.fCommandControl.getContext(), Integer.toString(pid)), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    IConnect connectCommand = (IConnect)FinalLaunchSequence.this.fLaunch.getSession().getModelAdapter(IConnect.class);
                    if (connectCommand != null) {
                        connectCommand.connect(requestMonitor);
                    } else {
                        requestMonitor.done();
                    }
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fSessionType != SessionType.CORE) {
                MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)FinalLaunchSequence.this.fTracker.getService(MIBreakpointsManager.class));
                IBreakpoints.IBreakpointsTargetDMContext breakpointDmc = (IBreakpoints.IBreakpointsTargetDMContext)FinalLaunchSequence.this.fCommandControl.getContext();
                bpmService.startTrackingBreakpoints(breakpointDmc, requestMonitor);
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fSessionType != SessionType.CORE) {
                FinalLaunchSequence.this.fCommandControl.start(FinalLaunchSequence.this.fLaunch, requestMonitor);
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fLaunch.getSession().dispatchEvent((Object)new DataModelInitializedEvent((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext()), FinalLaunchSequence.this.fCommandControl.getProperties());
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fTracker.dispose();
            FinalLaunchSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};
    GdbLaunch fLaunch;
    SessionType fSessionType;
    boolean fAttach;
    private IGDBControl fCommandControl;
    private IGDBBackend fGDBBackend;
    private IMIProcesses fProcService;
    private CommandFactory fCommandFactory;
    DsfServicesTracker fTracker;

    public FinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType sessionType, boolean attach, IProgressMonitor pm) {
        super(executor, pm, LaunchMessages.getString("FinalLaunchSequence.0"), LaunchMessages.getString("FinalLaunchSequence.1"));
        this.fLaunch = launch;
        this.fSessionType = sessionType;
        this.fAttach = attach;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }
}

