/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSourceLookup
extends AbstractDsfService
implements ISourceLookup {
    private Map<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector> fDirectors = new HashMap<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector>();
    ICommandControl fConnection;
    private CommandFactory fCommandFactory;

    public CSourceLookup(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void setSourceLookupDirector(ISourceLookup.ISourceLookupDMContext ctx, CSourceLookupDirector director) {
        this.fDirectors.put(ctx, director);
    }

    public void setSourceLookupPath(ISourceLookup.ISourceLookupDMContext ctx, ISourceContainer[] containers, RequestMonitor rm) {
        List<String> pathList = this.getSourceLookupPath(containers);
        String[] paths = pathList.toArray(new String[pathList.size()]);
        this.fConnection.queueCommand(this.fCommandFactory.createMIEnvironmentDirectory((IDMContext)ctx, paths, false), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    private List<String> getSourceLookupPath(ISourceContainer[] containers) {
        ArrayList<String> list = new ArrayList<String>(containers.length);
        int i = 0;
        while (i < containers.length) {
            File dir;
            IContainer container;
            IPath location;
            IProject project;
            if (containers[i] instanceof ProjectSourceContainer && (project = ((ProjectSourceContainer)containers[i]).getProject()) != null && project.exists() && (location = project.getLocation()) != null) {
                list.add(location.toPortableString());
            }
            if (containers[i] instanceof FolderSourceContainer && (container = ((FolderSourceContainer)containers[i]).getContainer()) != null && container.exists() && (location = container.getLocation()) != null) {
                list.add(location.toPortableString());
            }
            if (containers[i] instanceof DirectorySourceContainer && (dir = ((DirectorySourceContainer)containers[i]).getDirectory()) != null && dir.exists()) {
                Path path = new Path(dir.getAbsolutePath());
                list.add(path.toPortableString());
            }
            if (containers[i].isComposite()) {
                try {
                    list.addAll(this.getSourceLookupPath(containers[i].getSourceContainers()));
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return list;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                CSourceLookup.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.register(new String[]{CSourceLookup.class.getName(), ISourceLookup.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void getDebuggerPath(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Object source, final DataRequestMonitor<String> rm) {
        if (!(source instanceof String)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Only string source element is supported", null));
            rm.done();
            return;
        }
        final String sourceString = (String)source;
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        new Job("Lookup Debugger Path"){

            protected IStatus run(IProgressMonitor monitor) {
                IPath debuggerPath = director.getCompilationPath(sourceString);
                if (debuggerPath != null) {
                    rm.setData((Object)debuggerPath.toString());
                } else {
                    rm.setData((Object)sourceString);
                }
                rm.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void getSource(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, final String debuggerPath, final DataRequestMonitor<Object> rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        new Job("Lookup Source"){

            protected IStatus run(IProgressMonitor monitor) {
                block6: {
                    try {
                        try {
                            Object[] sources = director.findSourceElements((Object)debuggerPath);
                            if (sources == null || sources.length == 0) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "No sources found", null));
                                break block6;
                            }
                            rm.setData(sources[0]);
                        }
                        catch (CoreException e) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Source lookup failed", (Throwable)e));
                            rm.done();
                        }
                    }
                    finally {
                        rm.done();
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

