/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.GDBTypeParser;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.MIVariableManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetAttributes;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetChildCount;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetChildren;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetValue;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetVar;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetAttributesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetChildCountInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetChildrenInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetValueInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetVarInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIExpressions
extends AbstractDsfService
implements IExpressions2,
ICachingService {
    public static final String DETAILS_FORMAT = "Details";
    private static final String[] FORMATS_SUPPORTED = new String[]{"Details", "NATURAL.Format", "DECIMAL.Format", "HEX.Format", "BINARY.Format", "OCTAL.Format"};
    private CommandCache fExpressionCache;
    private MIVariableManager varManager;
    private CommandFactory fCommandFactory;
    private boolean fTraceVisualization;

    public MIExpressions(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                MIExpressions.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IExpressions.class.getName(), IExpressions2.class.getName(), MIExpressions.class.getName()}, new Hashtable());
        this.varManager = this.createMIVariableManager();
        this.fExpressionCache = new CommandCache(this.getSession(), (ICommandControl)this.varManager);
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fExpressionCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        requestMonitor.done();
    }

    protected MIVariableManager createMIVariableManager() {
        return new MIVariableManager(this.getSession(), this.getServicesTracker());
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.varManager.dispose();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression) {
        return this.createExpression(ctx, expression, expression);
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression, String relExpr) {
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IStack.IFrameDMContext.class);
        if (frameDmc != null) {
            return new MIExpressionDMC(this.getSession().getId(), expression, relExpr, frameDmc);
        }
        IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execCtx != null) {
            MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
            if (stackService != null) {
                frameDmc = stackService.createFrameDMContext(execCtx, 0);
                return new MIExpressionDMC(this.getSession().getId(), expression, relExpr, frameDmc);
            }
            return new InvalidContextExpressionDMC(this.getSession().getId(), expression, (IDMContext)execCtx);
        }
        IMemory.IMemoryDMContext memoryCtx = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMemory.IMemoryDMContext.class);
        if (memoryCtx != null) {
            return new MIExpressionDMC(this.getSession().getId(), expression, relExpr, memoryCtx);
        }
        return new InvalidContextExpressionDMC(this.getSession().getId(), expression, ctx);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)dmc, formatId);
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)FORMATS_SUPPORTED);
        rm.done();
    }

    public void getExpressionData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetVar(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetVarInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMData.BasicType basicType = null;
                    GDBTypeParser.GDBType gdbType = ((ExprMetaGetVarInfo)this.getData()).getGDBType();
                    if (gdbType != null) {
                        switch (gdbType.getType()) {
                            case 3: {
                                basicType = IExpressions.IExpressionDMData.BasicType.array;
                                break;
                            }
                            case 4: {
                                basicType = IExpressions.IExpressionDMData.BasicType.function;
                                break;
                            }
                            case 1: 
                            case 2: {
                                basicType = IExpressions.IExpressionDMData.BasicType.pointer;
                                break;
                            }
                            default: {
                                basicType = ((ExprMetaGetVarInfo)this.getData()).getNumChildren() > 0 ? IExpressions.IExpressionDMData.BasicType.composite : IExpressions.IExpressionDMData.BasicType.basic;
                            }
                        }
                    }
                    rm.setData((Object)new ExpressionDMData(((ExprMetaGetVarInfo)this.getData()).getExpr(), ((ExprMetaGetVarInfo)this.getData()).getType(), ((ExprMetaGetVarInfo)this.getData()).getNumChildren(), ((ExprMetaGetVarInfo)this.getData()).getEditable(), basicType));
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getExpressionAddressData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        IExpressions.IExpressionDMContext addressDmc = this.createExpression((IDMContext)dmc, "&(" + dmc.getExpression() + ")");
        final IExpressions.IExpressionDMContext sizeDmc = this.createExpression((IDMContext)dmc, "sizeof(" + dmc.getExpression() + ")");
        if (addressDmc instanceof InvalidContextExpressionDMC || sizeDmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            this.fExpressionCache.execute(this.fCommandFactory.createMIDataEvaluateExpression(addressDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    String tmpAddrStr = ((MIDataEvaluateExpressionInfo)this.getData()).getValue();
                    int split = tmpAddrStr.indexOf(32);
                    if (split != -1) {
                        tmpAddrStr = tmpAddrStr.substring(0, split);
                    }
                    final String addrStr = tmpAddrStr;
                    MIExpressions.this.fExpressionCache.execute(MIExpressions.this.fCommandFactory.createMIDataEvaluateExpression(sizeDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)MIExpressions.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            try {
                                int size = Integer.parseInt(((MIDataEvaluateExpressionInfo)this.getData()).getValue());
                                rm.setData((Object)new ExpressionDMAddress(addrStr, size));
                            }
                            catch (NumberFormatException numberFormatException) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unexpected size format from backend: " + ((MIDataEvaluateExpressionInfo)this.getData()).getValue(), null));
                            }
                            rm.done();
                        }
                    });
                }
            });
        }
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        MIExpressionDMC exprDmc = (MIExpressionDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIExpressionDMC.class);
        if (exprDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else if (DETAILS_FORMAT.equals(dmc.getFormatID())) {
            this.fExpressionCache.execute(this.fCommandFactory.createMIDataEvaluateExpression(exprDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((MIDataEvaluateExpressionInfo)this.getData()).getValue()));
                    rm.done();
                }

                protected void handleError() {
                    if (MIExpressions.this.fTraceVisualization) {
                        rm.setData((Object)new IFormattedValues.FormattedValueDMData(""));
                        rm.done();
                    } else {
                        super.handleError();
                    }
                }
            });
        } else {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetValue(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetValueInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((ExprMetaGetValueInfo)this.getData()).getValue()));
                    rm.done();
                }
            });
        }
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getSubExpressions(final IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetChildren(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetChildrenInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    ExpressionInfo[] childrenExpr = ((ExprMetaGetChildrenInfo)this.getData()).getChildrenExpressions();
                    IExpressions.IExpressionDMContext[] childArray = new IExpressions.IExpressionDMContext[childrenExpr.length];
                    int i = 0;
                    while (i < childArray.length) {
                        childArray[i] = MIExpressions.this.createExpression(dmc.getParents()[0], childrenExpr[i].getFullExpr(), childrenExpr[i].getRelExpr());
                        ++i;
                    }
                    rm.setData((Object)childArray);
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprCtx, final int startIndex, final int length, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (startIndex < 0 || length < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid range for evaluating sub expressions.", null));
            rm.done();
            return;
        }
        if (exprCtx instanceof MIExpressionDMC) {
            this.getSubExpressions(exprCtx, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMContext[] subExpressions = (IExpressions.IExpressionDMContext[])this.getData();
                    if (startIndex >= subExpressions.length) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Invalid range for evaluating sub expressions.", null));
                        rm.done();
                        return;
                    }
                    int realLength = length;
                    if (startIndex + length > subExpressions.length) {
                        realLength = subExpressions.length - startIndex;
                    }
                    IExpressions.IExpressionDMContext[] subRange = new IExpressions.IExpressionDMContext[realLength];
                    System.arraycopy(subExpressions, startIndex, subRange, 0, realLength);
                    rm.setData((Object)subRange);
                    rm.done();
                }
            });
        } else if (exprCtx instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getSubExpressionCount(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Integer> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetChildCount(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetChildCountInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((ExprMetaGetChildCountInfo)this.getData()).getChildNum());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void canWriteExpression(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Boolean> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetAttributes(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetAttributesInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((ExprMetaGetAttributesInfo)this.getData()).getEditable());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void writeExpression(final IExpressions.IExpressionDMContext dmc, String expressionValue, String formatId, final RequestMonitor rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.varManager.writeValue(dmc, expressionValue, formatId, new RequestMonitor((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIExpressions.this.fExpressionCache.reset();
                    MIExpressions.this.getSession().dispatchEvent((Object)new ExpressionChangedEvent(dmc), MIExpressions.this.getProperties());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fExpressionCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fExpressionCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fExpressionCache.setContextAvailable(e.getDMContext(), true);
        this.fExpressionCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        this.fExpressionCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.fTraceVisualization = e.isVisualizationModeEnabled();
    }

    public void flushCache(IDMContext context) {
        this.fExpressionCache.reset(context);
        this.varManager.markAllOutOfDate();
    }

    public IExpressions2.ICastedExpressionDMContext createCastedExpression(IExpressions.IExpressionDMContext exprDMC, IExpressions2.CastInfo castInfo) {
        if (exprDMC instanceof MIExpressionDMC && castInfo != null) {
            StringBuffer buffer;
            String castType = castInfo.getTypeString();
            String castExpression = exprDMC.getExpression();
            int castingLength = castInfo.getArrayCount();
            int castingIndex = castInfo.getArrayStartIndex();
            if (castType != null && castType.length() > 0) {
                buffer = new StringBuffer();
                buffer.append('(').append(castType).append(')');
                buffer.append('(').append(castExpression).append(')');
                castExpression = buffer.toString();
            }
            if (castingLength > 0) {
                buffer = new StringBuffer();
                buffer.append("*(");
                buffer.append('(').append(castExpression).append(')');
                buffer.append('+').append(castingIndex).append(')');
                buffer.append('@').append(castingLength);
                castExpression = buffer.toString();
            }
            return new CastedExpressionDMC((MIExpressionDMC)exprDMC, castExpression, castInfo);
        }
        assert (false);
        return null;
    }

    protected class CastedExpressionDMC
    extends MIExpressionDMC
    implements IExpressions2.ICastedExpressionDMContext {
        private final IExpressions2.CastInfo fCastInfo;
        private String fCastExpression;

        public CastedExpressionDMC(MIExpressionDMC exprDMC, String castExpression, IExpressions2.CastInfo castInfo) {
            super(MIExpressions.this.getSession().getId(), exprDMC.getExpression(), exprDMC.getRelativeExpression(), (IDMContext)exprDMC);
            this.fCastInfo = castInfo;
            this.fCastExpression = castExpression;
        }

        public IExpressions2.CastInfo getCastInfo() {
            return this.fCastInfo;
        }

        public String getExpression() {
            return this.fCastExpression;
        }

        public boolean equals(Object other) {
            return super.equals(other) && this.fCastInfo.equals((Object)((CastedExpressionDMC)((Object)other)).fCastInfo);
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".expr" + "[" + this.getExpression() + ", " + this.getRelativeExpression() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExpressionChangedEvent
    extends AbstractDMEvent<IExpressions.IExpressionDMContext>
    implements IExpressions.IExpressionChangedDMEvent {
        public ExpressionChangedEvent(IExpressions.IExpressionDMContext context) {
            super((IDMContext)context);
        }
    }

    protected static class ExpressionDMAddress
    implements IExpressions.IExpressionDMAddress {
        IAddress fAddr;
        int fSize;

        public ExpressionDMAddress(IAddress addr, int size) {
            this.fAddr = addr;
            this.fSize = size;
        }

        public ExpressionDMAddress(String addrStr, int size) {
            this.fSize = size;
            this.fAddr = addrStr.length() <= 10 ? new Addr32(addrStr) : new Addr64(addrStr);
        }

        public IAddress getAddress() {
            return this.fAddr;
        }

        public int getSize() {
            return this.fSize;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMAddress) {
                ExpressionDMAddress otherAddr = (ExpressionDMAddress)other;
                return this.fSize == otherAddr.getSize() && (this.fAddr == null ? otherAddr.getAddress() == null : this.fAddr.equals((Object)otherAddr.getAddress()));
            }
            return false;
        }

        public int hashCode() {
            return (this.fAddr == null ? 0 : this.fAddr.hashCode()) + this.fSize;
        }

        public String toString() {
            return String.valueOf(this.fAddr == null ? "null" : "(" + this.fAddr.toHexAddressString()) + ", " + this.fSize + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExpressionDMData
    implements IExpressions.IExpressionDMData {
        private final String relativeExpression;
        private final String exprType;
        private final int numChildren;
        private final boolean editable;
        private final IExpressions.IExpressionDMData.BasicType fBasicType;

        public ExpressionDMData(String expr, String type, int num, boolean edit) {
            this(expr, type, num, edit, null);
        }

        public ExpressionDMData(String expr, String type, int num, boolean edit, IExpressions.IExpressionDMData.BasicType basicType) {
            this.relativeExpression = expr;
            this.exprType = type;
            this.numChildren = num;
            this.editable = edit;
            this.fBasicType = basicType;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            return this.fBasicType;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return new HashMap<String, Integer>();
        }

        public String getName() {
            return this.relativeExpression;
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public String getTypeId() {
            return null;
        }

        public String getTypeName() {
            return this.exprType;
        }

        public int getNumChildren() {
            return this.numChildren;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMData) {
                ExpressionDMData otherData = (ExpressionDMData)other;
                return this.getNumChildren() == otherData.getNumChildren() && (this.getTypeName() == null ? otherData.getTypeName() == null : this.getTypeName().equals(otherData.getTypeName())) && (this.getName() == null ? otherData.getName() == null : this.getName().equals(otherData.getName()));
            }
            return false;
        }

        public int hashCode() {
            return this.relativeExpression == null ? 0 : (String.valueOf(this.relativeExpression.hashCode()) + this.exprType == null ? 0 : this.exprType.hashCode() + this.numChildren);
        }

        public String toString() {
            return "relExpr=" + this.relativeExpression + ", type=" + this.exprType + ", numchildren=" + this.numChildren;
        }
    }

    public static class ExpressionInfo {
        private final String fullExpression;
        private final String relativeExpression;

        public ExpressionInfo(String full, String relative) {
            this.fullExpression = full;
            this.relativeExpression = relative;
        }

        public String getFullExpr() {
            return this.fullExpression;
        }

        public String getRelExpr() {
            return this.relativeExpression;
        }

        public boolean equals(Object other) {
            return other instanceof ExpressionInfo && (this.fullExpression == null ? ((ExpressionInfo)other).fullExpression == null : this.fullExpression.equals(((ExpressionInfo)other).fullExpression)) && (this.relativeExpression == null ? ((ExpressionInfo)other).relativeExpression == null : this.relativeExpression.equals(((ExpressionInfo)other).relativeExpression));
        }

        public int hashCode() {
            return (this.fullExpression == null ? 0 : this.fullExpression.hashCode()) ^ (this.relativeExpression == null ? 0 : this.relativeExpression.hashCode());
        }

        public String toString() {
            return "[" + this.fullExpression + ", " + this.relativeExpression + "]";
        }
    }

    protected static class InvalidContextExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private final String expression;

        public InvalidContextExpressionDMC(String sessionId, String expr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.expression = expr;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.expression == null ? ((InvalidContextExpressionDMC)((Object)other)).getExpression() == null : this.expression.equals(((InvalidContextExpressionDMC)((Object)other)).getExpression());
        }

        public int hashCode() {
            return this.expression == null ? super.baseHashCode() : super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".invalid_expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }
    }

    protected static class MIExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private ExpressionInfo exprInfo;

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IStack.IFrameDMContext frameCtx) {
            this(sessionId, expression, relExpr, (IDMContext)frameCtx);
        }

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IMIExecutionDMContext execCtx) {
            this(sessionId, expression, relExpr, (IDMContext)execCtx);
        }

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IMemory.IMemoryDMContext memoryCtx) {
            this(sessionId, expression, relExpr, (IDMContext)memoryCtx);
        }

        private MIExpressionDMC(String sessionId, String expr, String relExpr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.exprInfo = new ExpressionInfo(expr, relExpr);
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.exprInfo.equals(((MIExpressionDMC)((Object)other)).exprInfo);
        }

        public int hashCode() {
            return super.baseHashCode() + this.exprInfo.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".expr" + this.exprInfo.toString();
        }

        public String getExpression() {
            return this.exprInfo.getFullExpr();
        }

        public String getRelativeExpression() {
            return this.exprInfo.getRelExpr();
        }
    }
}

