/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.mi.service.command.events.MIEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MIInferiorSignalExitEvent
extends MIEvent<ICommandControlService.ICommandControlDMContext> {
    private final String sigName;
    private final String sigMeaning;

    public MIInferiorSignalExitEvent(ICommandControlService.ICommandControlDMContext ctx, int token, MIResult[] results, String sigName, String sigMeaning) {
        super(ctx, token, results);
        this.sigName = sigName;
        this.sigMeaning = sigMeaning;
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public static MIInferiorSignalExitEvent parse(ICommandControlService.ICommandControlDMContext ctx, int token, MIResult[] results) {
        String sigName = "";
        String sigMeaning = "";
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("signal-name")) {
                sigName = str;
            } else if (var.equals("signal-meaning")) {
                sigMeaning = str;
            }
            ++i;
        }
        return new MIInferiorSignalExitEvent(ctx, token, results, sigName, sigMeaning);
    }
}

