/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIInfoSharedLibraryInfo
extends MIInfo {
    DsfMISharedInfo[] shared;

    public CLIInfoSharedLibraryInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public DsfMISharedInfo[] getMIShared() {
        return this.shared;
    }

    void parse() {
        ArrayList<DsfMISharedInfo> aList = new ArrayList<DsfMISharedInfo>();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseShared(str.trim(), aList);
                }
                ++i;
            }
        }
        this.shared = new DsfMISharedInfo[aList.size()];
        int i = 0;
        while (i < aList.size()) {
            this.shared[i] = (DsfMISharedInfo)aList.get(i);
            ++i;
        }
    }

    void parseShared(String str, List<DsfMISharedInfo> aList) {
        Pattern pattern;
        Matcher matcher;
        if (str.length() > 0 && (matcher = (pattern = Pattern.compile("(0x.*)(0x.*)(Yes|No)(\\s*)(.*)", 8)).matcher(str)).find()) {
            DsfMISharedInfo s = new DsfMISharedInfo(matcher.group(1), matcher.group(2), matcher.group(3).equals("Yes"), matcher.group(5));
            aList.add(s);
        }
    }

    public class DsfMISharedInfo {
        String from;
        String to;
        boolean isread;
        String name;

        public DsfMISharedInfo(String start, String end, boolean read, String location) {
            this.from = start;
            this.to = end;
            this.isread = read;
            this.name = location;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean isRead() {
            return this.isread;
        }

        public String getName() {
            return this.name;
        }

        public void setSymbolsRead(boolean read) {
            this.isread = read;
        }
    }
}

