/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MITraceListVariablesInfo
extends MIInfo {
    private MITraceVariableInfo[] fVariables;

    public MITraceListVariablesInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public MITraceVariableInfo[] getTraceVariables() {
        return this.fVariables;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MITraceVariableInfo> aList = new ArrayList<MITraceVariableInfo>(1);
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("trace-variables")) {
                    this.parseTable(results[i].getMIValue(), aList);
                }
                ++i;
            }
        }
        this.fVariables = aList.toArray(new MITraceVariableInfo[aList.size()]);
    }

    private void parseTable(MIValue val, List<MITraceVariableInfo> aList) {
        if (val instanceof MITuple) {
            MIResult[] table = ((MITuple)val).getMIResults();
            int i = 0;
            while (i < table.length) {
                String variable = table[i].getVariable();
                if (variable.equals("body")) {
                    this.parseBody(table[i].getMIValue(), aList);
                }
                ++i;
            }
        }
    }

    private void parseBody(MIValue body, List<MITraceVariableInfo> aList) {
        if (body instanceof MIList) {
            MIResult[] vars = ((MIList)body).getMIResults();
            int i = 0;
            while (i < vars.length) {
                String variable = vars[i].getVariable();
                if (variable.equals("variable")) {
                    this.parseVariable(vars[i].getMIValue(), aList);
                }
                ++i;
            }
        }
    }

    private void parseVariable(MIValue variable, List<MITraceVariableInfo> aList) {
        if (variable instanceof MITuple) {
            MIResult[] results = ((MITuple)variable).getMIResults();
            MITraceVariableInfo info = new MITraceVariableInfo();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getCString();
                }
                if (var.equals("name")) {
                    info.fName = str;
                } else if (var.equals("initial")) {
                    info.fInitialValue = str;
                } else if (var.equals("current")) {
                    info.fCurrentValue = str;
                }
                ++i;
            }
            aList.add(info);
        }
    }

    public class MITraceVariableInfo {
        private String fName;
        private String fInitialValue;
        private String fCurrentValue;

        public String getName() {
            return this.fName;
        }

        public String getCurrentValue() {
            return this.fCurrentValue;
        }

        public String getInitialValue() {
            return this.fInitialValue;
        }
    }
}

