/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.debug.service.IBreakpointAttributeTranslator2;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointsMediator2
extends AbstractDsfService
implements IBreakpointsListener {
    private IBreakpointAttributeTranslator2 fAttributeTranslator2;
    IBreakpoints fBreakpointsService;
    IBreakpointManager fBreakpointManager;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<TargetBP>>> fPlatformBPs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<TargetBP>>>();
    private Map<IBreakpoint, Map<String, Object>> fBreakpointAttributes = new HashMap<IBreakpoint, Map<String, Object>>();
    private Set<IBreakpoint> fRunningEvents = new HashSet<IBreakpoint>();
    private Map<IBreakpoint, LinkedList<PendingEventInfo>> fPendingEvents = new HashMap<IBreakpoint, LinkedList<PendingEventInfo>>();

    public BreakpointsMediator2(DsfSession session, IBreakpointAttributeTranslator2 attributeTranslator) {
        super(session);
        this.fAttributeTranslator2 = attributeTranslator;
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor(this.getExecutor(), rm){

            protected void handleSuccess() {
                BreakpointsMediator2.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fBreakpointsService = this.getServicesTracker().getService(IBreakpoints.class);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fAttributeTranslator2.initialize(this);
        this.fBreakpointManager.addBreakpointListener((IBreakpointsListener)this);
        this.register(new String[]{BreakpointsMediator2.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(final RequestMonitor rm) {
        this.unregister();
        this.fBreakpointManager.removeBreakpointListener((IBreakpointsListener)this);
        this.fAttributeTranslator2.dispose();
        CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getExecutor(), rm){

            protected void handleCompleted() {
                BreakpointsMediator2.super.shutdown(rm);
            }
        };
        ArrayList<IBreakpoints.IBreakpointsTargetDMContext> platformBPKeysCopy = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>(this.fPlatformBPs.size());
        platformBPKeysCopy.addAll(0, this.fPlatformBPs.keySet());
        for (IBreakpoints.IBreakpointsTargetDMContext dmc : platformBPKeysCopy) {
            this.stopTrackingBreakpoints(dmc, countingRm);
        }
        countingRm.setDoneCount(platformBPKeysCopy.size());
    }

    @Override
    protected BundleContext getBundleContext() {
        return DsfPlugin.getBundleContext();
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.dsf";
    }

    protected Plugin getPlugin() {
        return DsfPlugin.getDefault();
    }

    public void startTrackingBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        Map<IBreakpoint, List<TargetBP>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs != null) {
            rm.setStatus((IStatus)new Status(4, this.getPluginID(), 10005, "Context already initialized", null));
            rm.done();
            return;
        }
        this.fPlatformBPs.put(dmc, new HashMap());
        new Job("Install initial breakpoint list."){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                BreakpointsMediator2.this.doBreakpointsAdded(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(), dmc, rm);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void stopTrackingBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        Map<IBreakpoint, List<TargetBP>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null || platformBPs.size() == 0) {
            rm.setStatus((IStatus)new Status(1, this.getPluginID(), 10005, "Breakpoints not installed for given context", null));
            rm.done();
            return;
        }
        final IBreakpoint[] bps = platformBPs.keySet().toArray(new IBreakpoint[platformBPs.size()]);
        new Job("Uninstall target breakpoints list."){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                BreakpointsMediator2.this.doBreakpointsRemoved(bps, dmc, rm);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public ITargetBreakpointInfo[] getTargetBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, IBreakpoint platformBp) {
        List<TargetBP> bpInfo;
        assert (this.getExecutor().isInExecutorThread());
        Map<IBreakpoint, List<TargetBP>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs != null && (bpInfo = platformBPs.get(platformBp)) != null) {
            return bpInfo.toArray(new ITargetBreakpointInfo[bpInfo.size()]);
        }
        return null;
    }

    public IBreakpoint getPlatformBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, IBreakpoints.IBreakpointDMContext bp) {
        assert (this.getExecutor().isInExecutorThread());
        for (IBreakpoints.IBreakpointsTargetDMContext bpContext : this.fPlatformBPs.keySet()) {
            Map<IBreakpoint, List<TargetBP>> platformBPs;
            if (dmc != null && !dmc.equals(bpContext) || (platformBPs = this.fPlatformBPs.get(bpContext)) == null || platformBPs.size() <= 0) continue;
            for (Map.Entry<IBreakpoint, List<TargetBP>> e : platformBPs.entrySet()) {
                for (TargetBP tbp : e.getValue()) {
                    if (!tbp.getTargetBreakpoint().equals(bp)) continue;
                    return e.getKey();
                }
            }
        }
        return null;
    }

    private void installBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final IBreakpoint breakpoint, List<Map<String, Object>> attrsList, final DataRequestMonitor<List<TargetBP>> rm) {
        final Map<IBreakpoint, List<TargetBP>> platformBPs = this.fPlatformBPs.get(dmc);
        assert (platformBPs != null);
        assert (!platformBPs.containsKey(breakpoint));
        final ArrayList<TargetBP> targetBPsAttempted = new ArrayList<TargetBP>(attrsList.size());
        int i = 0;
        while (i < attrsList.size()) {
            targetBPsAttempted.add(new TargetBP(attrsList.get(i)));
            ++i;
        }
        final ArrayList targetBPsInstalled = new ArrayList(attrsList.size());
        final CountingRequestMonitor installRM = new CountingRequestMonitor(this.getExecutor(), rm){

            protected void handleCompleted() {
                if (targetBPsInstalled.size() > 0) {
                    platformBPs.put(breakpoint, targetBPsInstalled);
                }
                rm.setData(targetBPsAttempted);
                rm.done();
            }
        };
        installRM.setDoneCount(attrsList.size());
        int _i = 0;
        while (_i < attrsList.size()) {
            final int i2 = _i++;
            this.fBreakpointsService.insertBreakpoint(dmc, attrsList.get(i2), new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                @Override
                protected void handleCompleted() {
                    TargetBP targetBP = (TargetBP)targetBPsAttempted.get(i2);
                    if (this.isSuccess()) {
                        targetBP.setTargetBreakpoint((IBreakpoints.IBreakpointDMContext)this.getData());
                        targetBPsInstalled.add(targetBP);
                    }
                    targetBP.setStatus(this.getStatus());
                    installRM.done();
                }
            });
        }
    }

    private void uninstallBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final IBreakpoint breakpoint, final DataRequestMonitor<List<TargetBP>> drm) {
        final Map<IBreakpoint, List<TargetBP>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            drm.setStatus((IStatus)new Status(4, this.getPluginID(), 10002, "Invalid breakpoint", null));
            drm.done();
            return;
        }
        final List<TargetBP> bpList = platformBPs.get(breakpoint);
        assert (bpList != null);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getExecutor(), drm){

            protected void handleCompleted() {
                platformBPs.remove(breakpoint);
                drm.setData(bpList);
                drm.done();
            }
        };
        int count = 0;
        int i = 0;
        while (i < bpList.size()) {
            final TargetBP bp = bpList.get(i);
            if (bp.getTargetBreakpoint() != null) {
                this.fBreakpointsService.removeBreakpoint(bp.getTargetBreakpoint(), new RequestMonitor(this.getExecutor(), countingRm){

                    protected void handleCompleted() {
                        bp.setStatus(this.getStatus());
                        if (this.isSuccess()) {
                            bp.setTargetBreakpoint(null);
                        }
                        countingRm.done();
                    }
                });
                ++count;
            } else {
                bp.setStatus(Status.OK_STATUS);
            }
            ++i;
        }
        countingRm.setDoneCount(count);
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getExecutor()")
    public void breakpointsAdded(IBreakpoint[] bps) {
        this.doBreakpointsAdded(bps, null, null);
    }

    protected void doBreakpointsAdded(IBreakpoint[] bps, final IBreakpoints.IBreakpointsTargetDMContext bpsTargetDmc, final RequestMonitor rm) {
        final PlatformBreakpointInfo[] bpsInfo = this.collectBreakpointsInfo(bps);
        if (bpsInfo.length == 0) {
            if (rm != null) {
                rm.done();
            }
            return;
        }
        try {
            this.getExecutor().execute(new DsfRunnable(){

                public void run() {
                    ArrayList<Object> dmcs = new ArrayList<Object>();
                    if (bpsTargetDmc == null) {
                        dmcs.addAll(BreakpointsMediator2.this.fPlatformBPs.keySet());
                    } else {
                        dmcs.add(bpsTargetDmc);
                    }
                    BreakpointsMediator2.this.doBreakpointsAddedInExecutor(bpsInfo, dmcs, rm);
                }
            });
        }
        catch (RejectedExecutionException e) {
            Status status = new Status(4, this.getPluginID(), 10005, "Request for monitor: '" + this.toString() + "' resulted in a rejected execution exception.", (Throwable)e);
            if (rm != null) {
                rm.setStatus((IStatus)status);
                rm.done();
            }
            this.getPlugin().getLog().log((IStatus)status);
        }
    }

    private PlatformBreakpointInfo[] collectBreakpointsInfo(IBreakpoint[] bps) {
        ArrayList<PlatformBreakpointInfo> bpsInfo = new ArrayList<PlatformBreakpointInfo>(bps.length);
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp.getMarker() != null && this.fAttributeTranslator2.supportsBreakpoint(bp)) {
                try {
                    Map<String, Object> attrs = this.fAttributeTranslator2.getAllBreakpointAttributes(bp, this.fBreakpointManager.isEnabled());
                    boolean enabled = bp.isEnabled() && this.fBreakpointManager.isEnabled();
                    bpsInfo.add(new PlatformBreakpointInfo(bp, enabled, attrs));
                }
                catch (CoreException e) {
                    this.getPlugin().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        return bpsInfo.toArray(new PlatformBreakpointInfo[bpsInfo.size()]);
    }

    private void doBreakpointsAddedInExecutor(PlatformBreakpointInfo[] bpsInfo, Collection<IBreakpoints.IBreakpointsTargetDMContext> bpTargetDMCs, final RequestMonitor rm) {
        final HashMap eventBPs = new HashMap(bpsInfo.length, 1.0f);
        CountingRequestMonitor processPendingCountingRm = new CountingRequestMonitor(this.getExecutor(), rm){

            protected void handleCompleted() {
                BreakpointsMediator2.this.processPendingRequests();
                BreakpointsMediator2.this.fireUpdateBreakpointsStatus(eventBPs, BreakpointEventType.ADDED);
                if (rm != null) {
                    super.handleCompleted();
                }
            }
        };
        int processPendingCountingRmCount = 0;
        PlatformBreakpointInfo[] platformBreakpointInfoArray = bpsInfo;
        int n = bpsInfo.length;
        int n2 = 0;
        while (n2 < n) {
            final PlatformBreakpointInfo bpinfo = platformBreakpointInfoArray[n2];
            final HashMap targetBPs = new HashMap(this.fPlatformBPs.size(), 1.0f);
            eventBPs.put(bpinfo.breakpoint, targetBPs);
            this.fBreakpointAttributes.put(bpinfo.breakpoint, bpinfo.attributes);
            if (this.fRunningEvents.contains(bpinfo.breakpoint)) {
                PendingEventInfo pendingEvent = new PendingEventInfo(BreakpointEventType.ADDED, bpinfo, bpTargetDMCs, processPendingCountingRm);
                ++processPendingCountingRmCount;
                this.updatePendingRequest(bpinfo.breakpoint, pendingEvent);
            } else {
                ++processPendingCountingRmCount;
                this.fRunningEvents.add(bpinfo.breakpoint);
                final CountingRequestMonitor bpTargetsCountingRm = new CountingRequestMonitor(this.getExecutor(), processPendingCountingRm){

                    protected void handleCompleted() {
                        BreakpointsMediator2.this.fRunningEvents.remove(bpinfo.breakpoint);
                        super.handleCompleted();
                    }
                };
                int bpTargetsCountingRmCount = 0;
                for (final IBreakpoints.IBreakpointsTargetDMContext dmc : bpTargetDMCs) {
                    if (!bpinfo.enabled) {
                        HashMap<String, Object> attr = new HashMap<String, Object>(1);
                        attr.put("org.eclipse.debug.core.enabled", Boolean.FALSE);
                        Map<String, Object> targetEnablementAttr = this.fAttributeTranslator2.convertAttributes(attr);
                        if (!this.fAttributeTranslator2.canUpdateAttributes(bpinfo.breakpoint, dmc, targetEnablementAttr)) continue;
                    }
                    this.fAttributeTranslator2.resolveBreakpoint(dmc, bpinfo.breakpoint, bpinfo.attributes, new DataRequestMonitor<List<Map<String, Object>>>((Executor)this.getExecutor(), (RequestMonitor)bpTargetsCountingRm){

                        @Override
                        protected void handleSuccess() {
                            BreakpointsMediator2.this.installBreakpoint(dmc, bpinfo.breakpoint, (List)this.getData(), new DataRequestMonitor<List<TargetBP>>((Executor)BreakpointsMediator2.this.getExecutor(), (RequestMonitor)bpTargetsCountingRm){

                                @Override
                                protected void handleSuccess() {
                                    targetBPs.put(dmc, ((List)this.getData()).toArray(new ITargetBreakpointInfo[((List)this.getData()).size()]));
                                    super.handleSuccess();
                                }
                            });
                        }
                    });
                    ++bpTargetsCountingRmCount;
                }
                bpTargetsCountingRm.setDoneCount(bpTargetsCountingRmCount);
            }
            ++n2;
        }
        processPendingCountingRm.setDoneCount(processPendingCountingRmCount);
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getExecutor()")
    public void breakpointsChanged(IBreakpoint[] bps, IMarkerDelta[] deltas) {
        if (this.fAttributeTranslator2 == null) {
            return;
        }
        final PlatformBreakpointInfo[] bpsInfo = this.collectBreakpointsInfo(bps);
        if (bpsInfo.length == 0) {
            return;
        }
        try {
            this.getExecutor().execute(new DsfRunnable(){

                public void run() {
                    HashMap<String, Object> tmp = new HashMap<String, Object>(1);
                    tmp.put("org.eclipse.debug.core.enabled", true);
                    String targetEnablementKey = BreakpointsMediator2.this.fAttributeTranslator2.convertAttributes(tmp).keySet().iterator().next();
                    PlatformBreakpointInfo[] platformBreakpointInfoArray = bpsInfo;
                    int n = bpsInfo.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Map attrDelta;
                        PlatformBreakpointInfo bpinfo = platformBreakpointInfoArray[n2];
                        Map<String, Object> newAttrs = bpinfo.attributes;
                        Map oldAttrs = (Map)BreakpointsMediator2.this.fBreakpointAttributes.get(bpinfo.breakpoint);
                        BreakpointsMediator2.this.fBreakpointAttributes.put(bpinfo.breakpoint, newAttrs);
                        if (oldAttrs != null && (attrDelta = BreakpointsMediator2.this.getAttributesDelta(oldAttrs, newAttrs)).size() != 0) {
                            final ArrayList<IBreakpoints.IBreakpointsTargetDMContext> reinstallContexts = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>();
                            ArrayList<IBreakpoints.IBreakpointsTargetDMContext> updateContexts = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>();
                            for (IBreakpoints.IBreakpointsTargetDMContext btContext : BreakpointsMediator2.this.fPlatformBPs.keySet()) {
                                if (!BreakpointsMediator2.this.fAttributeTranslator2.canUpdateAttributes(bpinfo.breakpoint, btContext, attrDelta)) {
                                    reinstallContexts.add(btContext);
                                    continue;
                                }
                                updateContexts.add(btContext);
                            }
                            final PlatformBreakpointInfo[] oneBPInfo = new PlatformBreakpointInfo[]{bpinfo};
                            IBreakpoint[] oneBP = new IBreakpoint[]{bpinfo.breakpoint};
                            if (reinstallContexts.size() > 0) {
                                if (attrDelta.size() == 1 && attrDelta.containsKey(targetEnablementKey)) {
                                    if (bpinfo.enabled) {
                                        BreakpointsMediator2.this.doBreakpointsAddedInExecutor(oneBPInfo, reinstallContexts, null);
                                    } else {
                                        BreakpointsMediator2.this.doBreakpointsRemovedInExecutor(oneBP, reinstallContexts, null);
                                    }
                                } else {
                                    BreakpointsMediator2.this.doBreakpointsRemovedInExecutor(oneBP, reinstallContexts, new RequestMonitor(BreakpointsMediator2.this.getExecutor(), null){

                                        protected void handleCompleted() {
                                            BreakpointsMediator2.this.doBreakpointsAddedInExecutor(oneBPInfo, reinstallContexts, null);
                                        }
                                    });
                                }
                            }
                            if (updateContexts.size() > 0) {
                                BreakpointsMediator2.this.modifyTargetBreakpoints(bpinfo.breakpoint, updateContexts, attrDelta);
                            }
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.getPlugin().getLog().log((IStatus)new Status(4, this.getPluginID(), 10005, "Request for monitor: '" + this.toString() + "' resulted in a rejected execution exception.", (Throwable)e));
        }
    }

    private void modifyTargetBreakpoints(final IBreakpoint bp, Collection<IBreakpoints.IBreakpointsTargetDMContext> updateContexts, Map<String, Object> targetAttrDelta) {
        if (this.fRunningEvents.contains(bp)) {
            PendingEventInfo pendingEvent = new PendingEventInfo(BreakpointEventType.MODIFIED, updateContexts, targetAttrDelta);
            this.updatePendingRequest(bp, pendingEvent);
            return;
        }
        CountingRequestMonitor modifyTargetBPCRM = new CountingRequestMonitor(this.getExecutor(), null){

            protected void handleCompleted() {
                BreakpointsMediator2.this.fRunningEvents.remove(bp);
            }
        };
        int targetBPCount = 0;
        this.fRunningEvents.add(bp);
        for (IBreakpoints.IBreakpointsTargetDMContext context : updateContexts) {
            List<TargetBP> targetBPs = this.fPlatformBPs.get(context).get(bp);
            if (targetBPs == null) continue;
            for (TargetBP tbp : targetBPs) {
                assert (tbp.getTargetBreakpoint() != null);
                ++targetBPCount;
                this.fBreakpointsService.updateBreakpoint(tbp.getTargetBreakpoint(), targetAttrDelta, modifyTargetBPCRM);
            }
        }
        modifyTargetBPCRM.setDoneCount(targetBPCount);
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getExecutor()")
    public void breakpointsRemoved(final IBreakpoint[] bps, IMarkerDelta[] delta) {
        this.getExecutor().execute(new DsfRunnable(){

            public void run() {
                IBreakpoint[] iBreakpointArray = bps;
                int n = bps.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    BreakpointsMediator2.this.fBreakpointAttributes.remove(bp);
                    ++n2;
                }
            }
        });
        this.doBreakpointsRemoved(bps, null, null);
    }

    private void doBreakpointsRemoved(IBreakpoint[] bps, final IBreakpoints.IBreakpointsTargetDMContext bpsTargetDmc, final RequestMonitor rm) {
        final ArrayList<IBreakpoint> bpCandidates = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < bps.length) {
            IBreakpoint bp = bps[i];
            if (this.fAttributeTranslator2.supportsBreakpoint(bp)) {
                bpCandidates.add(bp);
            }
            ++i;
        }
        if (bpCandidates.isEmpty()) {
            if (rm != null) {
                rm.done();
            }
            return;
        }
        try {
            this.getExecutor().execute(new DsfRunnable(){

                public void run() {
                    ArrayList<Object> contexts = new ArrayList<Object>();
                    if (bpsTargetDmc == null) {
                        contexts.addAll(BreakpointsMediator2.this.fPlatformBPs.keySet());
                    } else {
                        contexts.add(bpsTargetDmc);
                    }
                    BreakpointsMediator2.this.doBreakpointsRemovedInExecutor(bpCandidates.toArray(new IBreakpoint[bpCandidates.size()]), contexts, rm);
                }
            });
        }
        catch (RejectedExecutionException e) {
            Status status = new Status(4, this.getPluginID(), 10005, "Request for monitor: '" + this.toString() + "' resulted in a rejected execution exception.", (Throwable)e);
            if (rm != null) {
                rm.setStatus((IStatus)status);
                rm.done();
            }
            this.getPlugin().getLog().log((IStatus)status);
        }
    }

    private void doBreakpointsRemovedInExecutor(IBreakpoint[] bpCandidates, Collection<IBreakpoints.IBreakpointsTargetDMContext> targetContexts, final RequestMonitor rm) {
        final HashMap eventBPs = new HashMap(bpCandidates.length, 1.0f);
        CountingRequestMonitor processPendingCountingRm = new CountingRequestMonitor(this.getExecutor(), rm){

            protected void handleCompleted() {
                BreakpointsMediator2.this.processPendingRequests();
                BreakpointsMediator2.this.fireUpdateBreakpointsStatus(eventBPs, BreakpointEventType.REMOVED);
                if (rm != null) {
                    super.handleCompleted();
                }
            }
        };
        int processPendingCountingRmCount = 0;
        IBreakpoint[] iBreakpointArray = bpCandidates;
        int n = bpCandidates.length;
        int n2 = 0;
        while (n2 < n) {
            final IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.fRunningEvents.contains(breakpoint)) {
                PendingEventInfo pendingEvent = new PendingEventInfo(BreakpointEventType.REMOVED, null, targetContexts, processPendingCountingRm);
                ++processPendingCountingRmCount;
                this.updatePendingRequest(breakpoint, pendingEvent);
            } else {
                ++processPendingCountingRmCount;
                final HashMap targetBPs = new HashMap(this.fPlatformBPs.size(), 1.0f);
                eventBPs.put(breakpoint, targetBPs);
                CountingRequestMonitor bpTargetsCountingRM = new CountingRequestMonitor(this.getExecutor(), processPendingCountingRm){

                    protected void handleCompleted() {
                        BreakpointsMediator2.this.fRunningEvents.remove(breakpoint);
                        super.handleCompleted();
                    }
                };
                int bpTargetsCoutingRMCount = 0;
                this.fRunningEvents.add(breakpoint);
                for (final IBreakpoints.IBreakpointsTargetDMContext dmc : targetContexts) {
                    if (!this.fPlatformBPs.get(dmc).containsKey(breakpoint)) continue;
                    this.uninstallBreakpoint(dmc, breakpoint, new DataRequestMonitor<List<TargetBP>>((Executor)this.getExecutor(), (RequestMonitor)bpTargetsCountingRM){

                        @Override
                        protected void handleSuccess() {
                            targetBPs.put(dmc, ((List)this.getData()).toArray(new ITargetBreakpointInfo[((List)this.getData()).size()]));
                            super.handleSuccess();
                        }
                    });
                    ++bpTargetsCoutingRMCount;
                }
                bpTargetsCountingRM.setDoneCount(bpTargetsCoutingRMCount);
            }
            ++n2;
        }
        processPendingCountingRm.setDoneCount(processPendingCountingRmCount);
    }

    private void updatePendingRequest(IBreakpoint breakpoint, PendingEventInfo pendingEvent) {
        LinkedList<PendingEventInfo> pendingEventsList = this.fPendingEvents.get(breakpoint);
        if (pendingEventsList == null) {
            pendingEventsList = new LinkedList();
            this.fPendingEvents.put(breakpoint, pendingEventsList);
        }
        if (pendingEventsList.size() > 0 && pendingEventsList.getLast().fEventType == BreakpointEventType.MODIFIED) {
            pendingEventsList.removeLast();
        }
        pendingEventsList.add(pendingEvent);
    }

    private void processPendingRequests() {
        if (this.fPendingEvents.isEmpty()) {
            return;
        }
        HashSet<IBreakpoint> bpsInPendingEvents = new HashSet<IBreakpoint>(this.fPendingEvents.keySet());
        for (IBreakpoint bp : bpsInPendingEvents) {
            if (this.fRunningEvents.contains(bp)) continue;
            LinkedList<PendingEventInfo> eventInfoList = this.fPendingEvents.get(bp);
            PendingEventInfo eventInfo = eventInfoList.removeFirst();
            if (eventInfoList.isEmpty()) {
                this.fPendingEvents.remove(bp);
            }
            switch (eventInfo.fEventType) {
                case ADDED: {
                    this.doBreakpointsAddedInExecutor(new PlatformBreakpointInfo[]{eventInfo.fBPInfo}, eventInfo.fBPTargetContexts, eventInfo.fRequestMonitor);
                    break;
                }
                case MODIFIED: {
                    this.modifyTargetBreakpoints(bp, eventInfo.fBPTargetContexts, eventInfo.fAttributeDelta);
                    break;
                }
                case REMOVED: {
                    this.doBreakpointsRemovedInExecutor(new IBreakpoint[]{bp}, eventInfo.fBPTargetContexts, eventInfo.fRequestMonitor);
                }
            }
        }
    }

    private void fireUpdateBreakpointsStatus(final Map<IBreakpoint, Map<IBreakpoints.IBreakpointsTargetDMContext, ITargetBreakpointInfo[]>> eventBPs, final BreakpointEventType eventType) {
        new Job("Breakpoint status update"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                BreakpointsMediator2.this.fAttributeTranslator2.updateBreakpointsStatus(eventBPs, eventType);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private Map<String, Object> getAttributesDelta(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        HashMap<String, Object> delta = new HashMap<String, Object>();
        Set<String> oldKeySet = oldAttributes.keySet();
        Set<String> newKeySet = newAttributes.keySet();
        HashSet<String> commonKeys = new HashSet<String>(newKeySet);
        commonKeys.retainAll(oldKeySet);
        HashSet<String> addedKeys = new HashSet<String>(newKeySet);
        addedKeys.removeAll(oldKeySet);
        HashSet<String> removedKeys = new HashSet<String>(oldKeySet);
        removedKeys.removeAll(newKeySet);
        for (String key : commonKeys) {
            if (oldAttributes.get(key).equals(newAttributes.get(key))) continue;
            delta.put(key, newAttributes.get(key));
        }
        for (String key : addedKeys) {
            delta.put(key, newAttributes.get(key));
        }
        for (String key : removedKeys) {
            delta.put(key, null);
        }
        return delta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakpointEventType {
        ADDED,
        REMOVED,
        MODIFIED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITargetBreakpointInfo {
        public Map<String, Object> getAttributes();

        public IBreakpoints.IBreakpointDMContext getTargetBreakpoint();

        public IStatus getStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingEventInfo {
        PlatformBreakpointInfo fBPInfo;
        RequestMonitor fRequestMonitor;
        BreakpointEventType fEventType;
        Collection<IBreakpoints.IBreakpointsTargetDMContext> fBPTargetContexts;
        Map<String, Object> fAttributeDelta;

        PendingEventInfo(BreakpointEventType eventType, PlatformBreakpointInfo bpInfo, Collection<IBreakpoints.IBreakpointsTargetDMContext> bpsTargetDmc, RequestMonitor rm) {
            this.fEventType = eventType;
            this.fBPInfo = bpInfo;
            this.fBPTargetContexts = bpsTargetDmc;
            this.fRequestMonitor = rm;
            this.fAttributeDelta = null;
        }

        PendingEventInfo(BreakpointEventType eventType, Collection<IBreakpoints.IBreakpointsTargetDMContext> updateContexts, Map<String, Object> attrDelta) {
            this.fEventType = eventType;
            this.fBPTargetContexts = updateContexts;
            this.fAttributeDelta = attrDelta;
            this.fRequestMonitor = null;
            this.fBPInfo = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlatformBreakpointInfo {
        IBreakpoint breakpoint;
        boolean enabled;
        Map<String, Object> attributes;

        public PlatformBreakpointInfo(IBreakpoint bp, boolean enabled, Map<String, Object> attributes) {
            this.breakpoint = bp;
            this.enabled = enabled;
            this.attributes = attributes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TargetBP
    implements ITargetBreakpointInfo {
        private Map<String, Object> fAttributes;
        private IBreakpoints.IBreakpointDMContext fTargetBPContext;
        private IStatus fStatus;

        public TargetBP(Map<String, Object> attrs) {
            this.fAttributes = attrs;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.fAttributes;
        }

        @Override
        public IBreakpoints.IBreakpointDMContext getTargetBreakpoint() {
            return this.fTargetBPContext;
        }

        @Override
        public IStatus getStatus() {
            return this.fStatus;
        }

        public void setTargetBreakpoint(IBreakpoints.IBreakpointDMContext fTargetBPContext) {
            this.fTargetBPContext = fTargetBPContext;
        }

        public void setStatus(IStatus status) {
            this.fStatus = status;
        }
    }
}

