/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.launch.internal.MultiLaunchConfigurationDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.ui.ComboControlledStackComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationFilteredTree;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class MultiLaunchConfigurationSelectionDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private ViewerFilter[] fFilters = null;
    private ISelection fSelection;
    private ILaunchGroup[] launchGroups;
    private String mode;
    private MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction action = MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction.NONE;
    private Object actionParam;
    private boolean isDefaultMode;
    private ViewerFilter emptyTypeFilter;
    private IStructuredSelection fInitialSelection;
    private ComboControlledStackComposite fStackComposite;
    private Label fDelayAmountLabel;
    private Text fDelayAmountWidget;
    private boolean fForEditing;

    public MultiLaunchConfigurationSelectionDialog(Shell shell, String initMode, boolean forEditing) {
        super(shell);
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        this.launchGroups = manager.getLaunchGroups();
        this.mode = initMode;
        this.fForEditing = forEditing;
        this.fFilters = null;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.emptyTypeFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ILaunchConfigurationType) {
                    try {
                        ILaunchConfigurationType type = (ILaunchConfigurationType)element;
                        return MultiLaunchConfigurationSelectionDialog.this.getLaunchManager().getLaunchConfigurations(type).length > 0;
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                if (element instanceof ILaunchConfiguration) {
                    return MultiLaunchConfigurationDelegate.isValidLaunchReference((ILaunchConfiguration)element);
                }
                return true;
            }
        };
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Control createContents(Composite parent) {
        Control x = super.createContents(parent);
        this.validate();
        this.setErrorMessage(null);
        return x;
    }

    protected Control createDialogArea(Composite parent2) {
        HashMap<String, ILaunchGroup> modes;
        Composite comp;
        block11: {
            comp = (Composite)super.createDialogArea(parent2);
            this.getShell().setText(this.fForEditing ? LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.13") : LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.12"));
            this.setTitle(this.fForEditing ? LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.15") : LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.14"));
            this.fStackComposite = new ComboControlledStackComposite(comp, 0);
            modes = new HashMap<String, ILaunchGroup>();
            ILaunchGroup[] iLaunchGroupArray = this.launchGroups;
            int n = this.launchGroups.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchGroup launchGroup = iLaunchGroupArray[n2];
                if (!modes.containsKey(launchGroup.getMode())) {
                    modes.put(launchGroup.getMode(), launchGroup);
                }
                ++n2;
            }
            if (this.mode.equals("default")) {
                try {
                    this.mode = "run";
                    ILaunchConfiguration[] configs = this.getSelectedLaunchConfigurations();
                    if (configs.length <= 0) break block11;
                    for (String mode : modes.keySet()) {
                        if (!configs[0].supportsMode(mode)) continue;
                        this.mode = mode;
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        }
        for (String mode : modes.keySet()) {
            ViewerFilter[] filters;
            ILaunchGroup launchGroup = (ILaunchGroup)modes.get(mode);
            LaunchConfigurationFilteredTree fTree = new LaunchConfigurationFilteredTree(this.fStackComposite.getStackParent(), 2818, new PatternFilter(), launchGroup, this.fFilters);
            String label = mode;
            this.fStackComposite.addItem(label, (Composite)fTree);
            fTree.createViewControl();
            ViewerFilter[] viewerFilterArray = filters = fTree.getViewer().getFilters();
            int n = filters.length;
            int n3 = 0;
            while (n3 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n3];
                if (viewerFilter instanceof LaunchGroupFilter) {
                    fTree.getViewer().removeFilter(viewerFilter);
                }
                ++n3;
            }
            fTree.getViewer().addFilter(this.emptyTypeFilter);
            fTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            if (launchGroup.getMode().equals(this.mode)) {
                this.fStackComposite.setSelection(label);
            }
            if (this.fInitialSelection == null) continue;
            fTree.getViewer().setSelection((ISelection)this.fInitialSelection, true);
        }
        this.fStackComposite.setLabelText(LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.4"));
        this.fStackComposite.pack();
        Rectangle bounds = this.fStackComposite.getBounds();
        GridData data = (GridData)this.fStackComposite.getLayoutData();
        if (data == null) {
            data = new GridData(1808);
            this.fStackComposite.setLayoutData(data);
        }
        data.heightHint = Math.max(this.convertHeightInCharsToPixels(15), bounds.height);
        data.widthHint = Math.max(this.convertWidthInCharsToPixels(40), bounds.width);
        this.fStackComposite.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiLaunchConfigurationSelectionDialog.this.mode = ((Combo)e.widget).getText();
            }
        });
        Composite checkboxComp = new Composite(comp, 0);
        checkboxComp.setLayout((Layout)new GridLayout(1, false));
        checkboxComp.setLayoutData((Object)new GridData(768));
        Button checkBox = new Button(checkboxComp, 32);
        checkBox.setText(LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.5"));
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiLaunchConfigurationSelectionDialog.this.isDefaultMode = ((Button)e.widget).getSelection();
            }
        });
        checkBox.setSelection(this.isDefaultMode);
        this.createPostLaunchControl(comp);
        return comp;
    }

    private void createPostLaunchControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(4, false));
        comp.setLayoutData((Object)new GridData(768));
        Label label = new Label(comp, 0);
        label.setText(LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.8"));
        Combo combo = new Combo(comp, 8);
        combo.add(MultiLaunchConfigurationDelegate.LaunchElement.actionEnumToStr(MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction.NONE));
        combo.add(MultiLaunchConfigurationDelegate.LaunchElement.actionEnumToStr(MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction.WAIT_FOR_TERMINATION));
        combo.add(MultiLaunchConfigurationDelegate.LaunchElement.actionEnumToStr(MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction.DELAY));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionStr = ((Combo)e.widget).getText();
                MultiLaunchConfigurationSelectionDialog.this.action = MultiLaunchConfigurationDelegate.LaunchElement.strToActionEnum(actionStr);
                MultiLaunchConfigurationSelectionDialog.this.showHideDelayAmountWidgets();
                MultiLaunchConfigurationSelectionDialog.this.validate();
            }
        });
        combo.setText(MultiLaunchConfigurationDelegate.LaunchElement.actionEnumToStr(this.action));
        this.fDelayAmountLabel = new Label(comp, 0);
        this.fDelayAmountLabel.setText(LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.9"));
        this.fDelayAmountWidget = new Text(comp, 2052);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(8);
        this.fDelayAmountWidget.setLayoutData((Object)gridData);
        this.fDelayAmountWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                try {
                    MultiLaunchConfigurationSelectionDialog.this.actionParam = new Integer(Integer.parseInt(text));
                }
                catch (NumberFormatException numberFormatException) {
                    MultiLaunchConfigurationSelectionDialog.this.actionParam = null;
                }
                MultiLaunchConfigurationSelectionDialog.this.validate();
            }
        });
        if (this.actionParam instanceof Integer) {
            this.fDelayAmountWidget.setText(((Integer)this.actionParam).toString());
        }
        this.showHideDelayAmountWidgets();
    }

    private void showHideDelayAmountWidgets() {
        boolean visible = this.action == MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction.DELAY;
        this.fDelayAmountLabel.setVisible(visible);
        this.fDelayAmountWidget.setVisible(visible);
    }

    public ILaunchConfiguration[] getSelectedLaunchConfigurations() {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        if (this.fSelection != null && !this.fSelection.isEmpty()) {
            for (Object selection : (IStructuredSelection)this.fSelection) {
                if (!(selection instanceof ILaunchConfiguration)) continue;
                configs.add((ILaunchConfiguration)selection);
            }
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    public String getMode() {
        return this.isDefaultMode ? "default" : this.mode;
    }

    public MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction getAction() {
        return this.action;
    }

    public Object getActionParam() {
        return this.actionParam;
    }

    public static MultiLaunchConfigurationSelectionDialog createDialog(Shell shell, String groupId, boolean forEditing) {
        return new MultiLaunchConfigurationSelectionDialog(shell, groupId, forEditing);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Control viewerControl;
        TreeViewer viewer;
        Tree topTree = null;
        Control topControl = this.fStackComposite.getTopControl();
        if (topControl instanceof FilteredTree && (viewer = ((FilteredTree)topControl).getViewer()) != null) {
            topTree = viewer.getTree();
        }
        if (topTree == null) {
            return;
        }
        boolean selectionIsForVisibleViewer = false;
        Object src = event.getSource();
        if (src instanceof Viewer && (viewerControl = ((Viewer)src).getControl()) == topTree) {
            selectionIsForVisibleViewer = true;
        }
        if (!selectionIsForVisibleViewer) {
            return;
        }
        this.fSelection = event.getSelection();
        this.validate();
    }

    protected void validate() {
        Button ok_button = this.getButton(0);
        boolean isValid = true;
        if (this.getSelectedLaunchConfigurations().length < 1) {
            this.setErrorMessage(LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.7"));
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        if (isValid && this.fForEditing && this.getSelectedLaunchConfigurations().length > 1) {
            this.setErrorMessage(LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.11"));
            isValid = false;
        }
        if (isValid && this.action == MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction.DELAY) {
            isValid = this.actionParam instanceof Integer && (Integer)this.actionParam > 0;
            this.setErrorMessage(isValid ? null : LaunchMessages.getString("MultiLaunchConfigurationSelectionDialog.10"));
        }
        if (ok_button != null) {
            ok_button.setEnabled(isValid);
        }
    }

    public void setInitialSelection(MultiLaunchConfigurationDelegate.LaunchElement el) {
        this.action = el.action;
        this.actionParam = el.actionParam;
        this.isDefaultMode = el.mode.equals("default");
        this.fInitialSelection = new StructuredSelection((Object)el.data);
        this.fSelection = this.fInitialSelection;
    }
}

