/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractSelectionDragAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class TextTransferDragSourceListener
extends AbstractSelectionDragAdapter {
    public TextTransferDragSourceListener(ISelectionProvider provider) {
        super(provider);
    }

    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    protected boolean isDragable(ISelection selection) {
        return MakeTargetDndUtil.isDragable(selection);
    }

    protected void dragInit(ISelection selection) {
    }

    protected Object prepareDataForTransfer(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return TextTransferDragSourceListener.convertSelectedMakeTargetsToText((IStructuredSelection)selection);
        }
        return null;
    }

    protected void dragDone() {
    }

    public static String convertSelectedMakeTargetsToText(IStructuredSelection selection) {
        String targetsText = "";
        for (Object selectionItem : selection.toList()) {
            String buildTarget;
            if (!(selectionItem instanceof IMakeTarget)) continue;
            IMakeTarget makeTarget = (IMakeTarget)selectionItem;
            String buildCommand = makeTarget.isDefaultBuildCmd() ? MakeTargetDndUtil.getProjectBuildCommand(makeTarget.getProject()) : makeTarget.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make");
            String buildCommandArguments = makeTarget.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, "").trim();
            if (buildCommandArguments.length() > 0) {
                buildCommandArguments = String.valueOf(' ') + buildCommandArguments;
            }
            if ((buildTarget = makeTarget.getBuildAttribute(IMakeTarget.BUILD_TARGET, "").trim()).length() > 0) {
                buildTarget = String.valueOf(' ') + buildTarget;
            }
            targetsText = String.valueOf(targetsText) + buildCommand + buildCommandArguments + buildTarget + System.getProperty("line.separator");
        }
        return targetsText;
    }
}

