/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.scannerconfig;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;

public class DiscoveredElement {
    public static final int CONTAINER = 1;
    public static final int INCLUDE_PATH = 2;
    public static final int SYMBOL_DEFINITION = 3;
    public static final int INCLUDE_FILE = 4;
    public static final int MACROS_FILE = 5;
    public static final int PATHS_GROUP = 10;
    public static final int SYMBOLS_GROUP = 11;
    public static final int INCLUDE_FILE_GROUP = 12;
    public static final int MACROS_FILE_GROUP = 13;
    private IProject fProject;
    private String fEntry;
    private int fEntryKind;
    private boolean fRemoved;
    private ArrayList<DiscoveredElement> fChildren = new ArrayList();
    private DiscoveredElement fParent;

    public DiscoveredElement(IProject project, String entry, int kind, boolean removed, boolean system) {
        this.fProject = project;
        this.fEntry = entry;
        this.fEntryKind = kind;
        this.fRemoved = removed;
    }

    public static DiscoveredElement createNew(DiscoveredElement parent, IProject project, String entry, int kind, boolean removed, boolean system) {
        DiscoveredElement rv = null;
        int parentKind = 0;
        switch (kind) {
            case 1: {
                rv = new DiscoveredElement(project, entry, kind, removed, system);
                DiscoveredElement group = new DiscoveredElement(project, null, 10, false, false);
                rv.fChildren.add(group);
                group.setParent(rv);
                group = new DiscoveredElement(project, null, 11, false, false);
                rv.fChildren.add(group);
                group.setParent(rv);
                group = new DiscoveredElement(project, null, 12, false, false);
                rv.fChildren.add(group);
                group.setParent(rv);
                group = new DiscoveredElement(project, null, 13, false, false);
                rv.fChildren.add(group);
                group.setParent(rv);
                return rv;
            }
            case 2: {
                parentKind = 10;
                break;
            }
            case 3: {
                parentKind = 11;
                break;
            }
            case 4: {
                parentKind = 12;
                break;
            }
            case 5: {
                parentKind = 13;
            }
        }
        if (parentKind != 0 && parent != null) {
            DiscoveredElement group = null;
            if (parent.getEntryKind() == parentKind) {
                group = parent;
            } else if (parent.getEntryKind() == 1) {
                for (DiscoveredElement child : parent.fChildren) {
                    if (child.getEntryKind() != parentKind) continue;
                    group = child;
                    break;
                }
            }
            if (group != null) {
                rv = new DiscoveredElement(project, entry, kind, removed, system);
                group.fChildren.add(rv);
                rv.setParent(group);
            }
        }
        return rv;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getEntry() {
        return this.fEntry;
    }

    public void setEntry(String entry) {
        this.fEntry = entry;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public void setEntryKind(int entryKind) {
        this.fEntryKind = entryKind;
    }

    public boolean isRemoved() {
        return this.fRemoved;
    }

    public void setRemoved(boolean removed) {
        this.fRemoved = removed;
    }

    public DiscoveredElement getParent() {
        return this.fParent;
    }

    private void setParent(DiscoveredElement parent) {
        this.fParent = parent;
    }

    public DiscoveredElement[] getChildren() {
        switch (this.fEntryKind) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new DiscoveredElement[0];
            }
        }
        return this.fChildren.toArray(new DiscoveredElement[this.fChildren.size()]);
    }

    public boolean hasChildren() {
        switch (this.fEntryKind) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        return this.fChildren.size() > 0;
    }

    public void setChildren(DiscoveredElement[] children) {
        this.fChildren = new ArrayList<DiscoveredElement>(Arrays.asList(children));
    }

    public boolean delete() {
        boolean rc = false;
        DiscoveredElement parent = this.getParent();
        if (parent != null) {
            rc = parent.fChildren.remove(this);
            for (DiscoveredElement child : this.fChildren) {
                child.setParent(null);
                rc |= true;
            }
        }
        return rc;
    }
}

