/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements ISharedTextColors {
    public static final String MAKE_COMMENT_COLOR = "org.eclipse.cdt.make.ui.editor.comment";
    public static final String MAKE_KEYWORD_COLOR = "org.eclipse.cdt.make.ui.editor.keyword";
    public static final String MAKE_FUNCTION_COLOR = "org.eclipse.cdt.make.ui.editor.function";
    public static final String MAKE_MACRO_REF_COLOR = "org.eclipse.cdt.make.ui.editor.macro_ref";
    public static final String MAKE_MACRO_DEF_COLOR = "org.eclipse.cdt.make.ui.editor.macro_def";
    public static final String MAKE_DEFAULT_COLOR = "org.eclipse.cdt.make.ui.editor.default";
    public static final RGB MAKE_COMMENT_RGB = new RGB(128, 0, 0);
    public static final RGB MAKE_KEYWORD_RGB = new RGB(128, 255, 0);
    public static final RGB MAKE_FUNCTION_RGB = new RGB(128, 0, 128);
    public static final RGB MAKE_MACRO_DEF_RGB = new RGB(0, 0, 128);
    public static final RGB MAKE_MACRO_REF_RGB = new RGB(0, 128, 0);
    public static final RGB MAKE_DEFAULT_RGB = new RGB(0, 0, 0);
    private static ColorManager fgColorManager;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    private ColorManager() {
    }

    public static ColorManager getDefault() {
        if (fgColorManager == null) {
            fgColorManager = new ColorManager();
        }
        return fgColorManager;
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }
}

