/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.p2.touchpoint.natives.actions.UntarAction;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class CleanupUntarAction
extends ProvisioningAction {
    private static final String ACTION_NAME = "cleanupuntar";

    public IStatus execute(Map parameters) {
        try {
            return CleanupUntarAction.cleanup(parameters);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.cdt.p2", e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public IStatus undo(Map parameters) {
        try {
            return UntarAction.untar(parameters);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.cdt.p2", e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static IStatus cleanup(Map parameters) {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError((String)NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_NAME));
        }
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError((String)NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_NAME));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        String fileList = profile.getInstallableUnitProperty(iu, "unzipped|" + source + "|" + target);
        StringTokenizer tokenizer = new StringTokenizer(fileList, "|");
        while (tokenizer.hasMoreTokens()) {
            String filename = tokenizer.nextToken();
            File file = new File(filename);
            while (file.delete()) {
                file = file.getParentFile();
            }
        }
        return Status.OK_STATUS;
    }
}

