/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateParserLogAction
implements IObjectActionDelegate {
    private static final Comparator<String> COMP_INSENSITIVE = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toUpperCase().compareTo(o2.toUpperCase());
        }
    };
    private ISelection fSelection;
    private IWorkbenchPartSite fSite;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public void run(IAction action) {
        if (!(this.fSelection instanceof IStructuredSelection)) {
            return;
        }
        String title = action.getText().replace("&", "");
        IStructuredSelection cElements = SelectionConverter.convertSelectionToCElements(this.fSelection);
        Iterator i = cElements.iterator();
        ArrayList<ITranslationUnit> tuSelection = new ArrayList<ITranslationUnit>();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ITranslationUnit)) continue;
            tuSelection.add((ITranslationUnit)o);
        }
        ITranslationUnit[] tuArray = tuSelection.toArray(new ITranslationUnit[tuSelection.size()]);
        if (tuArray.length == 0) {
            return;
        }
        FileDialog dlg = new FileDialog(this.fSite.getShell(), 8192);
        dlg.setText(title);
        dlg.setFilterExtensions(new String[]{"*.log"});
        String path = null;
        while (path == null) {
            String msg;
            path = dlg.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            if (!file.exists()) continue;
            if (!file.canWrite()) {
                msg = NLS.bind((String)ActionMessages.CreateParserLogAction_readOnlyFile, (Object)path);
                MessageDialog.openError((Shell)this.fSite.getShell(), (String)title, (String)msg);
                path = null;
                continue;
            }
            msg = NLS.bind((String)ActionMessages.CreateParserLogAction_existingFile, (Object)path);
            if (MessageDialog.openQuestion((Shell)this.fSite.getShell(), (String)title, (String)msg)) continue;
            path = null;
        }
        try {
            PrintStream out = new PrintStream(path);
            try {
                boolean needsep = false;
                ITranslationUnit[] iTranslationUnitArray = tuArray;
                int n = tuArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITranslationUnit tu = iTranslationUnitArray[n2];
                    if (needsep) {
                        out.println();
                        out.println();
                    }
                    this.createLog(out, tu, (IProgressMonitor)new NullProgressMonitor());
                    needsep = true;
                    ++n2;
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.fSite.getShell(), (String)action.getText(), (String)e.getMessage());
        }
    }

    private void createLog(final PrintStream out, final ITranslationUnit tu, IProgressMonitor pm) {
        try {
            tu.open(pm);
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
        ASTProvider.getASTProvider().runOnAST((ICElement)tu, ASTProvider.WAIT_IF_OPEN, pm, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                if (ast != null) {
                    return CreateParserLogAction.this.createLog(out, tu, lang, ast);
                }
                return Status.CANCEL_STATUS;
            }
        });
    }

    protected IStatus createLog(PrintStream out, ITranslationUnit tu, ILanguage lang, IASTTranslationUnit ast) {
        IScannerInfoProvider provider;
        IStatus status = Status.OK_STATUS;
        ICProject cproject = tu.getCProject();
        String projectName = cproject == null ? null : cproject.getElementName();
        String scannerInfoProvider = "null";
        if (cproject != null && (provider = CCorePlugin.getDefault().getScannerInfoProvider(cproject.getProject())) != null) {
            scannerInfoProvider = provider.getClass().getName();
        }
        ITranslationUnit ctx = tu;
        if (tu instanceof TranslationUnit) {
            TranslationUnit itu = (TranslationUnit)tu;
            ctx = itu.getSourceContextTU(ast.getIndex(), 32);
        }
        ExtendedScannerInfo scfg = new ExtendedScannerInfo(ctx.getScannerInfo(true));
        MyVisitor visitor = new MyVisitor();
        ast.accept((ASTVisitor)visitor);
        out.println("Project:               " + projectName);
        out.println("Index Version:         " + PDOM.versionString((int)PDOM.getDefaultVersion()));
        out.println("Scanner Info Provider: " + scannerInfoProvider);
        out.println("Build Configuration:   " + this.getBuildConfig(cproject));
        out.println("File:      " + tu.getLocationURI());
        out.println("Context:   " + ctx.getLocationURI());
        out.println("Language:  " + lang.getName());
        out.println();
        out.println("Include Search Path (option -I):");
        this.output(out, "   ", scfg.getIncludePaths());
        out.println();
        out.println("Local Include Search Path (option -iquote):");
        this.output(out, "   ", scfg.getLocalIncludePath());
        out.println();
        out.println("Preincluded files (option -include):");
        this.output(out, "   ", scfg.getIncludeFiles());
        out.println();
        out.println("Preincluded macro files (option -imacros):");
        this.output(out, "   ", scfg.getMacroFiles());
        out.println();
        out.println("Macro definitions (option -D):");
        HashSet<String> reported = new HashSet<String>();
        this.output(out, "   ", scfg.getDefinedSymbols(), reported);
        out.println();
        out.println("Macro definitions (from configuration + headers in index):");
        this.output(out, "   ", ast.getBuiltinMacroDefinitions(), reported);
        out.println();
        out.println("Macro definitions (from files actually parsed):");
        this.output(out, "   ", ast.getMacroDefinitions(), reported);
        out.println();
        out.println("Unresolved includes (from headers in index):");
        try {
            this.outputUnresolvedIncludes(cproject, ast.getIndex(), out, "   ", ast.getIncludeDirectives(), ast.getLinkage().getLinkageID());
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        out.println();
        out.println("Scanner problems:");
        this.output(out, "   ", ast.getPreprocessorProblems());
        out.println();
        out.println("Parser problems:");
        this.output(out, "   ", visitor.fProblems.toArray(new IASTProblem[visitor.fProblems.size()]));
        out.println();
        out.println("Unresolved names:");
        this.output(out, "   ", visitor.fProblemBindings);
        out.println();
        out.println("Exceptions in name resolution:");
        this.output(out, visitor.fExceptions);
        return status;
    }

    private String getBuildConfig(ICProject cproject) {
        ICConfigurationDescription cfg;
        ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
        ICProjectDescription prefs = prjDescMgr.getProjectDescription(cproject.getProject(), false);
        if (prefs != null && (cfg = prefs.getDefaultSettingConfiguration()) != null) {
            return cfg.getName();
        }
        return "unknown";
    }

    private void outputUnresolvedIncludes(ICProject prj, IIndex index, PrintStream out, String indent, IASTPreprocessorIncludeStatement[] includeDirectives, int linkageID) throws CoreException {
        ProjectIndexerInputAdapter resolver = new ProjectIndexerInputAdapter(prj);
        HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = includeDirectives;
        int n = includeDirectives.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorIncludeStatement include = iASTPreprocessorIncludeStatementArray[n2];
            if (include.isActive() && include.isResolved()) {
                this.outputUnresolvedIncludes(index, out, indent, resolver.resolveASTPath(include.getPath()), linkageID, handled);
            }
            ++n2;
        }
    }

    private void outputUnresolvedIncludes(IIndex index, PrintStream out, String indent, IIndexFileLocation ifl, int linkageID, HashSet<IIndexFileLocation> handled) throws CoreException {
        if (!handled.add(ifl)) {
            return;
        }
        IIndexFile ifile = index.getFile(linkageID, ifl);
        if (ifile == null) {
            out.println(String.valueOf(indent) + ifl.getURI() + " is not indexed");
        } else {
            IIndexInclude[] includes;
            IIndexInclude[] iIndexIncludeArray = includes = ifile.getIncludes();
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude inc = iIndexIncludeArray[n2];
                if (inc.isActive()) {
                    if (inc.isResolved()) {
                        this.outputUnresolvedIncludes(index, out, indent, inc.getIncludesLocation(), linkageID, handled);
                    } else {
                        out.println(String.valueOf(indent) + "Unresolved inclusion: " + inc.getFullName() + " in file " + inc.getIncludedByLocation().getURI());
                    }
                }
                ++n2;
            }
        }
    }

    private void output(PrintStream out, String indent, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            out.println(String.valueOf(indent) + line);
            ++n2;
        }
    }

    private void output(PrintStream out, String indent, Map<String, String> definedSymbols, HashSet<String> reported) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(COMP_INSENSITIVE);
        sorted.putAll(definedSymbols);
        for (Map.Entry entry : sorted.entrySet()) {
            String macro = String.valueOf((String)entry.getKey()) + '=' + (String)entry.getValue();
            if (!reported.add(macro)) continue;
            out.println(String.valueOf(indent) + macro);
        }
    }

    private void output(PrintStream out, String indent, IASTPreprocessorMacroDefinition[] defs, HashSet<String> reported) {
        TreeSet<String> macros = new TreeSet<String>(COMP_INSENSITIVE);
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroDefinition def = iASTPreprocessorMacroDefinitionArray[n2];
            macros.add(def.toString());
            ++n2;
        }
        for (String macro : macros) {
            if (!reported.add(macro)) continue;
            out.println(String.valueOf(indent) + macro);
        }
    }

    private void output(PrintStream out, String indent, IASTProblem[] preprocessorProblems) {
        IASTProblem[] iASTProblemArray = preprocessorProblems;
        int n = preprocessorProblems.length;
        int n2 = 0;
        while (n2 < n) {
            IASTProblem problem = iASTProblemArray[n2];
            out.println(String.valueOf(indent) + problem.getMessageWithLocation());
            ++n2;
        }
    }

    private void output(PrintStream out, String indent, List<IProblemBinding> list) {
        for (IProblemBinding problem : list) {
            String file = problem.getFileName();
            int line = problem.getLineNumber();
            out.println(String.valueOf(indent) + problem.getMessage() + " in file " + file + ':' + line);
        }
    }

    private void output(PrintStream out, List<Exception> list) {
        for (Exception problem : list) {
            problem.printStackTrace(out);
        }
    }

    private static final class MyVisitor
    extends ASTVisitor {
        List<IASTProblem> fProblems = new ArrayList<IASTProblem>();
        List<IProblemBinding> fProblemBindings = new ArrayList<IProblemBinding>();
        List<Exception> fExceptions = new ArrayList<Exception>();

        MyVisitor() {
            this.shouldVisitProblems = true;
            this.shouldVisitNames = true;
        }

        public int visit(IASTProblem problem) {
            this.fProblems.add(problem);
            return 1;
        }

        public int visit(IASTName name) {
            if (name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            try {
                IBinding binding = name.resolveBinding();
                if (binding instanceof IProblemBinding) {
                    this.fProblemBindings.add((IProblemBinding)binding);
                }
            }
            catch (RuntimeException e) {
                this.fExceptions.add(e);
            }
            return 3;
        }
    }
}

