/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GotoNextBookmarkAction
extends TextEditorAction {
    public static final String NEXT_BOOKMARK = "GotoNextBookmark";

    public GotoNextBookmarkAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        ISelectionProvider provider = editor.getSelectionProvider();
        if (provider == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource == null || !(resource instanceof IFile)) {
            return;
        }
        try {
            IMarker[] bookmarks = resource.findMarkers("org.eclipse.core.resources.bookmark", true, 1);
            if (bookmarks.length == 0) {
                return;
            }
            CompareMarker comparator = new CompareMarker();
            Arrays.sort(bookmarks, comparator);
            int line = selection.getStartLine() + 1;
            IMarker lastBookmark = bookmarks[bookmarks.length - 1];
            if (line >= MarkerUtilities.getLineNumber((IMarker)lastBookmark)) {
                line = 1;
            }
            int i = 0;
            while (i < bookmarks.length) {
                IMarker bookmark = bookmarks[i];
                if (MarkerUtilities.getLineNumber((IMarker)bookmark) > line) {
                    IDE.openEditor((IWorkbenchPage)this.getTextEditor().getSite().getPage(), (IMarker)bookmark, (boolean)OpenStrategy.activateOnOpen());
                    break;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareMarker
    implements Comparator<IMarker> {
        private CompareMarker() {
        }

        @Override
        public int compare(IMarker m1, IMarker m2) {
            int l2;
            int l1 = MarkerUtilities.getLineNumber((IMarker)m1);
            if (l1 > (l2 = MarkerUtilities.getLineNumber((IMarker)m2))) {
                return 1;
            }
            if (l1 < l2) {
                return -1;
            }
            return 0;
        }
    }
}

