/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.buildconsole.BuildOutputStream;
import org.eclipse.cdt.internal.ui.buildconsole.DocumentMarkerManager;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.osgi.service.prefs.Preferences;

public class BuildConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IConsole,
IPropertyChangeListener {
    private IProject fProject;
    List<ITypedRegion> fPartitions = new ArrayList<ITypedRegion>(5);
    private int fMaxLines;
    BuildConsoleStreamDecorator fLastStream = null;
    BuildConsoleDocument fDocument;
    DocumentMarkerManager fDocumentMarkerManager;
    boolean killed;
    BuildConsoleManager fManager;
    Vector<StreamEntry> fQueue = new Vector(5);
    private URI fLogURI;
    private OutputStream fLogStream;

    public BuildConsolePartitioner(IProject project, BuildConsoleManager manager) {
        this.fProject = project;
        this.fManager = manager;
        this.fMaxLines = BuildConsolePreferencePage.buildConsoleLines();
        this.fDocument = new BuildConsoleDocument();
        this.fDocument.setDocumentPartitioner(this);
        this.fDocumentMarkerManager = new DocumentMarkerManager(this.fDocument, this);
        this.connect((IDocument)this.fDocument);
        this.fLogURI = null;
        this.fLogStream = null;
    }

    public void setStreamOpened() {
        this.fQueue.add(new StreamEntry(1));
        this.asyncProcessQueue();
    }

    public void setStreamClosed() {
        this.fQueue.add(new StreamEntry(2));
        this.asyncProcessQueue();
    }

    private static URI getLogURI(IProject project) {
        URI logURI = null;
        Preferences prefs = BuildConsoleManager.getBuildLogPreferences(project);
        boolean keepLog = prefs.getBoolean("keepLog", true);
        if (keepLog) {
            String strLocation = prefs.get("logLocation", BuildConsoleManager.getDefaultConsoleLogLocation(project));
            if (strLocation.trim().length() > 0) {
                logURI = URIUtil.toURI((String)strLocation);
            }
            if (logURI == null) {
                Status status = new Status(4, "org.eclipse.cdt.ui", "Can't determine URI for location=[" + strLocation + "]");
                CUIPlugin.log((IStatus)status);
            }
        }
        return logURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToDocument(String text, BuildConsoleStreamDecorator stream, ProblemMarkerInfo marker) {
        boolean addToQueue = true;
        Vector<StreamEntry> vector = this.fQueue;
        synchronized (vector) {
            StreamEntry entry;
            int i = this.fQueue.size();
            if (i > 0 && (entry = this.fQueue.get(i - 1)).getStream() == stream && entry.getEventType() == 0 && entry.getMarker() == marker && entry.size() < 10000) {
                entry.appendText(text);
                addToQueue = false;
            }
            if (addToQueue) {
                this.fQueue.add(new StreamEntry(text, stream, marker));
            }
        }
        if (addToQueue) {
            this.asyncProcessQueue();
        }
    }

    private void asyncProcessQueue() {
        Runnable r = new Runnable(){

            public void run() {
                StreamEntry entry;
                try {
                    entry = BuildConsolePartitioner.this.fQueue.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return;
                }
                switch (entry.getEventType()) {
                    case 1: {
                        this.logOpen();
                        break;
                    }
                    case 0: {
                        BuildConsolePartitioner.this.fLastStream = entry.getStream();
                        try {
                            BuildConsolePartitioner.this.warnOfContentChange(BuildConsolePartitioner.this.fLastStream);
                            if (BuildConsolePartitioner.this.fLastStream == null) {
                                BuildConsolePartitioner.this.fPartitions.clear();
                                BuildConsolePartitioner.this.fDocumentMarkerManager.clear();
                                BuildConsolePartitioner.this.fDocument.set("");
                            }
                            BuildConsolePartitioner.this.addStreamEntryToDocument(entry);
                            this.log(entry.getText());
                            BuildConsolePartitioner.this.checkOverflow();
                        }
                        catch (BadLocationException badLocationException) {}
                        break;
                    }
                    case 2: {
                        this.logClose();
                    }
                }
            }

            private void logOpen() {
                BuildConsolePartitioner.this.fLogURI = BuildConsolePartitioner.getLogURI(BuildConsolePartitioner.this.fProject);
                if (BuildConsolePartitioner.this.fLogURI != null) {
                    try {
                        try {
                            IFileStore logStore = EFS.getStore((URI)BuildConsolePartitioner.this.fLogURI);
                            BuildConsolePartitioner.this.fLogStream = logStore.openOutputStream(0, null);
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                            BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                        }
                    }
                    finally {
                        BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                    }
                }
            }

            private void log(String text) {
                if (BuildConsolePartitioner.this.fLogStream != null) {
                    try {
                        try {
                            BuildConsolePartitioner.this.fLogStream.write(text.getBytes());
                            if (BuildConsolePartitioner.this.fQueue.isEmpty()) {
                                BuildConsolePartitioner.this.fLogStream.flush();
                            }
                        }
                        catch (IOException e) {
                            CUIPlugin.log(e);
                            BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                        }
                    }
                    finally {
                        BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                    }
                }
            }

            private void logClose() {
                if (BuildConsolePartitioner.this.fLogStream != null) {
                    block6: {
                        try {
                            try {
                                BuildConsolePartitioner.this.fLogStream.close();
                            }
                            catch (IOException e) {
                                CUIPlugin.log(e);
                                BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                            throw throwable;
                        }
                        BuildConsoleManager.refreshWorkspaceFiles(BuildConsolePartitioner.this.fLogURI);
                    }
                    BuildConsolePartitioner.this.fLogStream = null;
                }
            }
        };
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(r);
        }
    }

    private void addStreamEntryToDocument(StreamEntry entry) throws BadLocationException {
        if (entry.getMarker() == null) {
            this.addPartition(new BuildConsolePartition(this.fLastStream, this.fDocument.getLength(), entry.getText().length(), BuildConsolePartition.CONSOLE_PARTITION_TYPE));
        } else {
            this.addPartition(new BuildConsolePartition(this.fLastStream, this.fDocument.getLength(), entry.getText().length(), BuildConsolePartition.ERROR_PARTITION_TYPE, entry.getMarker()));
        }
        this.fDocument.replace(this.fDocument.getLength(), 0, entry.getText());
    }

    void warnOfContentChange(BuildConsoleStreamDecorator stream) {
        if (stream != null) {
            ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange((org.eclipse.ui.console.IConsole)stream.getConsole());
        }
        this.fManager.showConsole();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocumentSize(int nLines) {
        this.fMaxLines = nLines;
        nLines = this.fDocument.getNumberOfLines();
        this.checkOverflow();
    }

    public void connect(IDocument document) {
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.killed = true;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{BuildConsolePartition.CONSOLE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        ITypedRegion[] affectedRegions = this.computePartitioning(event.getOffset(), text.length());
        if (affectedRegions.length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    protected void checkOverflow() {
        int nLines;
        if (this.fMaxLines >= 0 && (nLines = this.fDocument.getNumberOfLines()) > this.fMaxLines + 1) {
            int overflow = 0;
            try {
                overflow = this.fDocument.getLineOffset(nLines - this.fMaxLines);
            }
            catch (BadLocationException badLocationException) {}
            ArrayList<ITypedRegion> newParitions = new ArrayList<ITypedRegion>(this.fPartitions.size());
            for (ITypedRegion region : this.fPartitions) {
                if (!(region instanceof BuildConsolePartition)) continue;
                BuildConsolePartition messageConsolePartition = (BuildConsolePartition)region;
                BuildConsolePartition newPartition = null;
                int offset = region.getOffset();
                if (offset < overflow) {
                    int endOffset = offset + region.getLength();
                    if (endOffset >= overflow && messageConsolePartition.getType() != BuildConsolePartition.ERROR_PARTITION_TYPE) {
                        int length = endOffset - overflow;
                        newPartition = messageConsolePartition.createNewPartition(0, length, messageConsolePartition.getType());
                    }
                } else {
                    newPartition = messageConsolePartition.createNewPartition(messageConsolePartition.getOffset() - overflow, messageConsolePartition.getLength(), messageConsolePartition.getType());
                }
                if (newPartition == null) continue;
                newParitions.add((ITypedRegion)newPartition);
            }
            this.fPartitions = newParitions;
            this.fDocumentMarkerManager.moveToFirstError();
            try {
                this.fDocument.replace(0, overflow, "");
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private BuildConsolePartition addPartition(BuildConsolePartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add((ITypedRegion)partition);
        } else {
            int index = this.fPartitions.size() - 1;
            BuildConsolePartition last = (BuildConsolePartition)this.fPartitions.get(index);
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, (ITypedRegion)partition);
            } else {
                this.fPartitions.add((ITypedRegion)partition);
            }
        }
        return partition;
    }

    public IConsole getConsole() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "buildConsoleLines") {
            this.setDocumentSize(BuildConsolePreferencePage.buildConsoleLines());
        }
    }

    public void start(final IProject project) {
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    BuildConsolePartitioner.this.fManager.startConsoleActivity(project);
                }
            });
        }
        this.fLogURI = null;
        this.fLogStream = null;
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            this.appendToDocument("", null, null);
        }
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(1));
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(0));
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(2));
    }

    private void printDocumentPartitioning() {
        System.out.println("Document partitioning: ");
        for (ITypedRegion tr : this.fPartitions) {
            String text;
            BuildConsolePartition p = (BuildConsolePartition)tr;
            int start = p.getOffset();
            int end = p.getOffset() + p.getLength();
            String isError = "U";
            if (p.getType() == BuildConsolePartition.ERROR_PARTITION_TYPE) {
                isError = "E";
            } else if (p.getType() == BuildConsolePartition.CONSOLE_PARTITION_TYPE) {
                isError = "C";
            }
            try {
                text = this.fDocument.get(p.getOffset(), p.getLength());
            }
            catch (BadLocationException badLocationException) {
                text = "N/A";
            }
            if (text.endsWith("\n")) {
                text = text.substring(0, text.length() - 1);
            }
            System.out.println("    " + isError + " " + start + "-" + end + ":[" + text + "]");
        }
    }

    public URI getLogURI() {
        return this.fLogURI;
    }

    private class StreamEntry {
        public static final int EVENT_APPEND = 0;
        public static final int EVENT_OPEN_LOG = 1;
        public static final int EVENT_CLOSE_LOG = 2;
        private BuildConsoleStreamDecorator fStream;
        private StringBuffer fText = null;
        private ProblemMarkerInfo fMarker;
        private int eventType;

        public StreamEntry(String text, BuildConsoleStreamDecorator stream, ProblemMarkerInfo marker) {
            this.fText = new StringBuffer(text);
            this.fStream = stream;
            this.fMarker = marker;
            this.eventType = 0;
        }

        public StreamEntry(int event) {
            this.fText = null;
            this.fStream = null;
            this.fMarker = null;
            this.eventType = event;
        }

        public BuildConsoleStreamDecorator getStream() {
            return this.fStream;
        }

        public void appendText(String text) {
            this.fText.append(text);
        }

        public int size() {
            return this.fText.length();
        }

        public String getText() {
            return this.fText.toString();
        }

        public ProblemMarkerInfo getMarker() {
            return this.fMarker;
        }

        public int getEventType() {
            return this.eventType;
        }
    }
}

